/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.mapping.LambdaFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.common.SolrException;

public class NegateFunction {
    public static final String name = "neg";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The neg function requires 1 paramaters, " + params.length + " found.");
        }
        AnalyticsValueStream param = params[0];
        if (param instanceof BooleanValueStream) {
            return LambdaFunction.createBooleanLambdaFunction(name, x -> !x, (BooleanValueStream)param);
        }
        if (param instanceof IntValueStream) {
            return LambdaFunction.createIntLambdaFunction(name, x -> x * -1, (IntValueStream)param);
        }
        if (param instanceof LongValueStream) {
            return LambdaFunction.createLongLambdaFunction(name, x -> x * -1L, (LongValueStream)param);
        }
        if (param instanceof FloatValueStream) {
            return LambdaFunction.createFloatLambdaFunction(name, x -> x * -1.0f, (FloatValueStream)param);
        }
        if (param instanceof DoubleValueStream) {
            return LambdaFunction.createDoubleLambdaFunction(name, x -> x * -1.0, (DoubleValueStream)param);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The neg function requires a boolean or numeric parameter, " + param.getExpressionStr() + " found.");
    };
}

