/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.security.AccessController;

public class JsonUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static <T> T fromJson(String json, Class<T> clazz) throws IOException {
        if (json == null || json.isEmpty() || clazz == null) {
            return null;
        }
        try {
            return (T)AccessController.doPrivileged(() -> {
                try {
                    return objectMapper.readValue(json, clazz);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException("Error deserializing JSON: " + e.getMessage(), e);
        }
    }

    public static String toJson(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        try {
            return AccessController.doPrivileged(() -> {
                try {
                    return objectMapper.writeValueAsString(object);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException("Error serializing object to JSON: " + e.getMessage(), e);
        }
    }
}

