/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.memorycontainer.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.transport.memorycontainer.memory.MessageInput;

public class MLAddMemoriesInput
implements ToXContentObject,
Writeable {
    private String memoryContainerId;
    private List<MessageInput> messages;
    private String sessionId;
    private String agentId;
    private Boolean infer;
    private Map<String, String> tags;

    public MLAddMemoriesInput(String memoryContainerId, List<MessageInput> messages, String sessionId, String agentId, Boolean infer, Map<String, String> tags) {
        if (messages == null || messages.isEmpty()) {
            throw new IllegalArgumentException("Messages list cannot be empty");
        }
        this.memoryContainerId = memoryContainerId;
        this.messages = messages;
        this.sessionId = sessionId;
        this.agentId = agentId;
        this.infer = infer;
        this.tags = tags;
    }

    public MLAddMemoriesInput(StreamInput in) throws IOException {
        this.memoryContainerId = in.readOptionalString();
        int messagesSize = in.readVInt();
        this.messages = new ArrayList<MessageInput>(messagesSize);
        for (int i = 0; i < messagesSize; ++i) {
            this.messages.add(new MessageInput(in));
        }
        this.sessionId = in.readOptionalString();
        this.agentId = in.readOptionalString();
        this.infer = in.readOptionalBoolean();
        if (in.readBoolean()) {
            this.tags = in.readMap(StreamInput::readString, StreamInput::readString);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.memoryContainerId);
        out.writeVInt(this.messages.size());
        for (MessageInput message : this.messages) {
            message.writeTo(out);
        }
        out.writeOptionalString(this.sessionId);
        out.writeOptionalString(this.agentId);
        out.writeOptionalBoolean(this.infer);
        if (this.tags != null && !this.tags.isEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.tags, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.memoryContainerId != null) {
            builder.field("memory_container_id", this.memoryContainerId);
        }
        builder.startArray("messages");
        for (MessageInput message : this.messages) {
            message.toXContent(builder, params);
        }
        builder.endArray();
        if (this.sessionId != null) {
            builder.field("session_id", this.sessionId);
        }
        if (this.agentId != null) {
            builder.field("agent_id", this.agentId);
        }
        if (this.infer != null) {
            builder.field("infer", this.infer);
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            builder.field("tags", this.tags);
        }
        builder.endObject();
        return builder;
    }

    public static MLAddMemoriesInput parse(XContentParser parser) throws IOException {
        String memoryContainerId = null;
        ArrayList<MessageInput> messages = null;
        String sessionId = null;
        String agentId = null;
        Boolean infer = null;
        HashMap<String, String> tags = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block16: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "memory_container_id": {
                    memoryContainerId = parser.text();
                    continue block16;
                }
                case "messages": {
                    messages = new ArrayList<MessageInput>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        messages.add(MessageInput.parse(parser));
                    }
                    continue block16;
                }
                case "session_id": {
                    sessionId = parser.text();
                    continue block16;
                }
                case "agent_id": {
                    agentId = parser.text();
                    continue block16;
                }
                case "infer": {
                    infer = parser.booleanValue();
                    continue block16;
                }
                case "tags": {
                    tags = new HashMap<String, String>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String tagKey = parser.currentName();
                        parser.nextToken();
                        String tagValue = parser.text();
                        tags.put(tagKey, tagValue);
                    }
                    continue block16;
                }
            }
            parser.skipChildren();
        }
        return MLAddMemoriesInput.builder().memoryContainerId(memoryContainerId).messages(messages).sessionId(sessionId).agentId(agentId).infer(infer).tags(tags).build();
    }

    @Generated
    public static MLAddMemoriesInputBuilder builder() {
        return new MLAddMemoriesInputBuilder();
    }

    @Generated
    public String getMemoryContainerId() {
        return this.memoryContainerId;
    }

    @Generated
    public List<MessageInput> getMessages() {
        return this.messages;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public String getAgentId() {
        return this.agentId;
    }

    @Generated
    public Boolean getInfer() {
        return this.infer;
    }

    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Generated
    public void setMemoryContainerId(String memoryContainerId) {
        this.memoryContainerId = memoryContainerId;
    }

    @Generated
    public void setMessages(List<MessageInput> messages) {
        this.messages = messages;
    }

    @Generated
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Generated
    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    @Generated
    public void setInfer(Boolean infer) {
        this.infer = infer;
    }

    @Generated
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Generated
    public static class MLAddMemoriesInputBuilder {
        @Generated
        private String memoryContainerId;
        @Generated
        private List<MessageInput> messages;
        @Generated
        private String sessionId;
        @Generated
        private String agentId;
        @Generated
        private Boolean infer;
        @Generated
        private Map<String, String> tags;

        @Generated
        MLAddMemoriesInputBuilder() {
        }

        @Generated
        public MLAddMemoriesInputBuilder memoryContainerId(String memoryContainerId) {
            this.memoryContainerId = memoryContainerId;
            return this;
        }

        @Generated
        public MLAddMemoriesInputBuilder messages(List<MessageInput> messages) {
            this.messages = messages;
            return this;
        }

        @Generated
        public MLAddMemoriesInputBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Generated
        public MLAddMemoriesInputBuilder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        @Generated
        public MLAddMemoriesInputBuilder infer(Boolean infer) {
            this.infer = infer;
            return this;
        }

        @Generated
        public MLAddMemoriesInputBuilder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        @Generated
        public MLAddMemoriesInput build() {
            return new MLAddMemoriesInput(this.memoryContainerId, this.messages, this.sessionId, this.agentId, this.infer, this.tags);
        }

        @Generated
        public String toString() {
            return "MLAddMemoriesInput.MLAddMemoriesInputBuilder(memoryContainerId=" + this.memoryContainerId + ", messages=" + String.valueOf(this.messages) + ", sessionId=" + this.sessionId + ", agentId=" + this.agentId + ", infer=" + this.infer + ", tags=" + String.valueOf(this.tags) + ")";
        }
    }
}

