/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.rules.action.live_queries;

import java.io.IOException;
import java.util.List;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.plugin.insights.rules.model.SearchQueryRecord;

public class LiveQueriesResponse
extends ActionResponse
implements ToXContentObject {
    private static final String CLUSTER_LEVEL_RESULTS_KEY = "live_queries";
    private final List<SearchQueryRecord> liveQueries;

    public LiveQueriesResponse(StreamInput in) throws IOException {
        this.liveQueries = in.readList(SearchQueryRecord::new);
    }

    public LiveQueriesResponse(List<SearchQueryRecord> liveQueries) {
        this.liveQueries = liveQueries;
    }

    public List<SearchQueryRecord> getLiveQueries() {
        return this.liveQueries;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.liveQueries);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(CLUSTER_LEVEL_RESULTS_KEY);
        for (SearchQueryRecord query : this.liveQueries) {
            query.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }
}

