/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.sgd.kernel;

import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.tribuo.Example;
import org.tribuo.Excuse;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Model;
import org.tribuo.Prediction;
import org.tribuo.classification.Label;
import org.tribuo.math.kernel.Kernel;
import org.tribuo.math.la.DenseMatrix;
import org.tribuo.math.la.DenseVector;
import org.tribuo.math.la.SGDVector;
import org.tribuo.math.la.SparseVector;
import org.tribuo.provenance.ModelProvenance;

public class KernelSVMModel
extends Model<Label> {
    private static final long serialVersionUID = 2L;
    private final Kernel kernel;
    private final SparseVector[] supportVectors;
    private final DenseMatrix weights;

    KernelSVMModel(String name, ModelProvenance description, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<Label> labelIDMap, Kernel kernel, SparseVector[] supportVectors, DenseMatrix weights) {
        super(name, description, featureIDMap, labelIDMap, false);
        this.kernel = kernel;
        this.supportVectors = supportVectors;
        this.weights = weights;
    }

    public int getNumberOfSupportVectors() {
        return this.supportVectors.length;
    }

    public Prediction<Label> predict(Example<Label> example) {
        SparseVector features = SparseVector.createSparseVector(example, (ImmutableFeatureMap)this.featureIDMap, (boolean)true);
        if (features.numActiveElements() == 1) {
            throw new IllegalArgumentException("No features found in Example " + example.toString());
        }
        double[] scores = new double[this.supportVectors.length];
        for (int i = 0; i < scores.length; ++i) {
            scores[i] = this.kernel.similarity(features, this.supportVectors[i]);
        }
        DenseVector scoreVector = DenseVector.createDenseVector((double[])scores);
        DenseVector prediction = this.weights.leftMultiply((SGDVector)scoreVector);
        double maxScore = Double.NEGATIVE_INFINITY;
        Label maxLabel = null;
        LinkedHashMap<String, Label> predMap = new LinkedHashMap<String, Label>();
        for (int i = 0; i < prediction.size(); ++i) {
            String labelName = ((Label)this.outputIDInfo.getOutput(i)).getLabel();
            Label label = new Label(labelName, prediction.get(i));
            predMap.put(labelName, label);
            if (!(label.getScore() > maxScore)) continue;
            maxScore = label.getScore();
            maxLabel = label;
        }
        return new Prediction(maxLabel, predMap, features.numActiveElements(), example, this.generatesProbabilities);
    }

    public Map<String, List<Pair<String, Double>>> getTopFeatures(int n) {
        return Collections.emptyMap();
    }

    public Optional<Excuse<Label>> getExcuse(Example<Label> example) {
        return Optional.empty();
    }

    protected KernelSVMModel copy(String newName, ModelProvenance newProvenance) {
        SparseVector[] vectorCopies = new SparseVector[this.supportVectors.length];
        for (int i = 0; i < vectorCopies.length; ++i) {
            vectorCopies[i] = this.supportVectors[i].copy();
        }
        return new KernelSVMModel(newName, newProvenance, this.featureIDMap, (ImmutableOutputInfo<Label>)this.outputIDInfo, this.kernel, vectorCopies, new DenseMatrix(this.weights));
    }
}

