/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.physical;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.OpenSearchFunctions;
import org.opensearch.sql.opensearch.planner.physical.OpenSearchEvalProcessor;
import org.opensearch.sql.planner.physical.EvalOperator;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.transport.client.node.NodeClient;

public class OpenSearchEvalOperator
extends EvalOperator {
    private final NodeClient nodeClient;

    public OpenSearchEvalOperator(PhysicalPlan input, List<Pair<ReferenceExpression, Expression>> expressionList, NodeClient nodeClient) {
        super(input, expressionList);
        this.nodeClient = nodeClient;
    }

    @Override
    protected Map<String, ExprValue> eval(Environment<Expression, ExprValue> env) {
        LinkedHashMap<String, ExprValue> evalResultMap = new LinkedHashMap<String, ExprValue>();
        for (Pair<ReferenceExpression, Expression> pair : this.getExpressionList()) {
            ExprValue value;
            Object object = pair.getValue();
            if (object instanceof OpenSearchFunctions.OpenSearchExecutableFunction) {
                OpenSearchFunctions.OpenSearchExecutableFunction openSearchExpr = (OpenSearchFunctions.OpenSearchExecutableFunction)object;
                value = OpenSearchEvalProcessor.process(openSearchExpr, env, this.nodeClient);
            } else {
                value = ((Expression)pair.getValue()).valueOf(env);
            }
            ReferenceExpression var = (ReferenceExpression)pair.getKey();
            env = Environment.extendEnv(env, var, value);
            evalResultMap.put(var.toString(), value);
        }
        return evalResultMap;
    }

    @Generated
    public NodeClient getNodeClient() {
        return this.nodeClient;
    }
}

