/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.jsonUDF;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.runtime.JsonFunctions;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.PPLReturnTypes;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;
import org.opensearch.sql.expression.function.jsonUDF.JsonUtils;

public class JsonSetFunctionImpl
extends ImplementorUDF {
    public JsonSetFunctionImpl() {
        super(new JsonSetImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return PPLReturnTypes.STRING_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return null;
    }

    public static Object eval(Object ... args) {
        String jsonStr = (String)args[0];
        List<Object> keys = Arrays.asList(args).subList(1, args.length);
        JsonNode root = JsonUtils.convertInputToJsonNode(args[0]);
        ArrayList<Object> expands = new ArrayList<Object>();
        for (int i = 0; i < keys.size(); i += 2) {
            List<String> expandedPaths = JsonUtils.expandJsonPath(root, JsonUtils.convertToJsonPath(keys.get(i).toString()));
            for (String expandedPath : expandedPaths) {
                expands.add(expandedPath);
                expands.add(keys.get(i + 1));
            }
        }
        return JsonFunctions.jsonSet((String)jsonStr, (Object[])expands.toArray());
    }

    public static class JsonSetImplementor
    implements NotNullImplementor {
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            ScalarFunctionImpl function = (ScalarFunctionImpl)ScalarFunctionImpl.create((Method)Types.lookupMethod(JsonSetFunctionImpl.class, (String)"eval", (Class[])new Class[]{Object[].class}));
            return function.getImplementor().implement(translator, call, RexImpTable.NullAs.NULL);
        }
    }
}

