/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.clustering;

import com.amazon.randomcutforest.returntypes.SampleSummary;
import java.io.Serializable;
import java.util.Arrays;
import lombok.Generated;

public class SerializableSummary
implements Serializable {
    private float[][] summaryPoints;
    private float[] mean;
    private float[] median;
    private float[] deviation;
    private float[] lower;
    private float[] upper;
    private float[] relativeWeight;
    private double weightOfSamples;

    public SerializableSummary() {
    }

    public SerializableSummary(SampleSummary s) {
        this.summaryPoints = s.summaryPoints;
        this.mean = s.mean;
        this.deviation = s.deviation;
        this.lower = s.lower;
        this.upper = s.upper;
        this.relativeWeight = s.relativeWeight;
        this.weightOfSamples = s.weightOfSamples;
        this.median = s.median;
    }

    public SampleSummary getSummary() {
        SampleSummary summary = new SampleSummary(0);
        summary.summaryPoints = this.summaryPoints;
        summary.deviation = this.deviation;
        summary.lower = this.lower;
        summary.upper = this.upper;
        summary.mean = this.mean;
        summary.median = this.median;
        summary.relativeWeight = this.relativeWeight;
        summary.weightOfSamples = this.weightOfSamples;
        return summary;
    }

    @Generated
    public float[][] getSummaryPoints() {
        return this.summaryPoints;
    }

    @Generated
    public float[] getMean() {
        return this.mean;
    }

    @Generated
    public float[] getMedian() {
        return this.median;
    }

    @Generated
    public float[] getDeviation() {
        return this.deviation;
    }

    @Generated
    public float[] getLower() {
        return this.lower;
    }

    @Generated
    public float[] getUpper() {
        return this.upper;
    }

    @Generated
    public float[] getRelativeWeight() {
        return this.relativeWeight;
    }

    @Generated
    public double getWeightOfSamples() {
        return this.weightOfSamples;
    }

    @Generated
    public void setSummaryPoints(float[][] summaryPoints) {
        this.summaryPoints = summaryPoints;
    }

    @Generated
    public void setMean(float[] mean) {
        this.mean = mean;
    }

    @Generated
    public void setMedian(float[] median) {
        this.median = median;
    }

    @Generated
    public void setDeviation(float[] deviation) {
        this.deviation = deviation;
    }

    @Generated
    public void setLower(float[] lower) {
        this.lower = lower;
    }

    @Generated
    public void setUpper(float[] upper) {
        this.upper = upper;
    }

    @Generated
    public void setRelativeWeight(float[] relativeWeight) {
        this.relativeWeight = relativeWeight;
    }

    @Generated
    public void setWeightOfSamples(double weightOfSamples) {
        this.weightOfSamples = weightOfSamples;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializableSummary)) {
            return false;
        }
        SerializableSummary other = (SerializableSummary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getWeightOfSamples(), other.getWeightOfSamples()) != 0) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.getSummaryPoints(), (Object[])other.getSummaryPoints())) {
            return false;
        }
        if (!Arrays.equals(this.getMean(), other.getMean())) {
            return false;
        }
        if (!Arrays.equals(this.getMedian(), other.getMedian())) {
            return false;
        }
        if (!Arrays.equals(this.getDeviation(), other.getDeviation())) {
            return false;
        }
        if (!Arrays.equals(this.getLower(), other.getLower())) {
            return false;
        }
        if (!Arrays.equals(this.getUpper(), other.getUpper())) {
            return false;
        }
        return Arrays.equals(this.getRelativeWeight(), other.getRelativeWeight());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SerializableSummary;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $weightOfSamples = Double.doubleToLongBits(this.getWeightOfSamples());
        result = result * 59 + (int)($weightOfSamples >>> 32 ^ $weightOfSamples);
        result = result * 59 + Arrays.deepHashCode((Object[])this.getSummaryPoints());
        result = result * 59 + Arrays.hashCode(this.getMean());
        result = result * 59 + Arrays.hashCode(this.getMedian());
        result = result * 59 + Arrays.hashCode(this.getDeviation());
        result = result * 59 + Arrays.hashCode(this.getLower());
        result = result * 59 + Arrays.hashCode(this.getUpper());
        result = result * 59 + Arrays.hashCode(this.getRelativeWeight());
        return result;
    }

    @Generated
    public String toString() {
        return "SerializableSummary(summaryPoints=" + Arrays.deepToString((Object[])this.getSummaryPoints()) + ", mean=" + Arrays.toString(this.getMean()) + ", median=" + Arrays.toString(this.getMedian()) + ", deviation=" + Arrays.toString(this.getDeviation()) + ", lower=" + Arrays.toString(this.getLower()) + ", upper=" + Arrays.toString(this.getUpper()) + ", relativeWeight=" + Arrays.toString(this.getRelativeWeight()) + ", weightOfSamples=" + this.getWeightOfSamples() + ")";
    }
}

