/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.cluster;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.ml.autoredeploy.MLModelAutoReDeployer;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.model.MLModelCacheHelper;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.task.MLTaskManager;
import org.opensearch.transport.client.Client;

public class MLCommonsClusterEventListener
implements ClusterStateListener {
    @Generated
    private static final Logger log = LogManager.getLogger(MLCommonsClusterEventListener.class);
    private final ClusterService clusterService;
    private final MLModelManager mlModelManager;
    private final MLTaskManager mlTaskManager;
    private final MLModelCacheHelper modelCacheHelper;
    private final MLModelAutoReDeployer mlModelAutoReDeployer;
    private final Client client;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public MLCommonsClusterEventListener(ClusterService clusterService, MLModelManager mlModelManager, MLTaskManager mlTaskManager, MLModelCacheHelper modelCacheHelper, MLModelAutoReDeployer mlModelAutoReDeployer, Client client, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.clusterService = clusterService;
        this.clusterService.addListener((ClusterStateListener)this);
        this.mlModelManager = mlModelManager;
        this.mlTaskManager = mlTaskManager;
        this.modelCacheHelper = modelCacheHelper;
        this.mlModelAutoReDeployer = mlModelAutoReDeployer;
        this.client = client;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public void clusterChanged(ClusterChangedEvent event) {
        DiscoveryNodes.Delta delta;
        long monitoringReqCount;
        ClusterState previousState = event.previousState();
        ClusterState state = event.state();
        Settings previousSettings = previousState.getMetadata().settings();
        Settings settings = state.getMetadata().settings();
        long previousMonitoringReqCount = (Long)MLCommonsSettings.ML_COMMONS_MONITORING_REQUEST_COUNT.get(previousSettings);
        if (previousMonitoringReqCount > (monitoringReqCount = ((Long)MLCommonsSettings.ML_COMMONS_MONITORING_REQUEST_COUNT.get(settings)).longValue())) {
            this.modelCacheHelper.resizeMonitoringQueue(monitoringReqCount);
        }
        if ((delta = event.nodesDelta()).removed()) {
            Set<String> removedNodeIds = delta.removedNodes().stream().map(DiscoveryNode::getId).collect(Collectors.toSet());
            this.mlModelManager.removeWorkerNodes(removedNodeIds, false);
        } else if (delta.added()) {
            List<String> addedNodesIds = delta.addedNodes().stream().map(DiscoveryNode::getId).collect(Collectors.toList());
            this.mlModelAutoReDeployer.buildAutoReloadArrangement(addedNodesIds, state.getNodes().getClusterManagerNodeId());
        }
        for (DiscoveryNode node : state.nodes()) {
            if (!node.isDataNode() || !Version.V_3_1_0.onOrAfter(node.getVersion())) continue;
            if (this.mlFeatureEnabledSetting.isMetricCollectionEnabled() && this.mlFeatureEnabledSetting.isStaticMetricCollectionEnabled()) {
                this.mlTaskManager.indexStatsCollectorJob(true);
            }
            if (!this.clusterService.state().getMetadata().hasIndex(".ml_commons_task_polling_job")) break;
            this.mlTaskManager.startTaskPollingJob();
            break;
        }
    }
}

