/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUaccessPolicyWindow;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUkernelNodeAttrValue
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ACCESSPOLICYWINDOW;
    public static final int COOPERATIVE;

    public CUkernelNodeAttrValue(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUkernelNodeAttrValue.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public CUaccessPolicyWindow accessPolicyWindow() {
        return CUkernelNodeAttrValue.naccessPolicyWindow(this.address());
    }

    public int cooperative() {
        return CUkernelNodeAttrValue.ncooperative(this.address());
    }

    public CUkernelNodeAttrValue accessPolicyWindow(CUaccessPolicyWindow value) {
        CUkernelNodeAttrValue.naccessPolicyWindow(this.address(), value);
        return this;
    }

    public CUkernelNodeAttrValue accessPolicyWindow(Consumer<CUaccessPolicyWindow> consumer) {
        consumer.accept(this.accessPolicyWindow());
        return this;
    }

    public CUkernelNodeAttrValue cooperative(int value) {
        CUkernelNodeAttrValue.ncooperative(this.address(), value);
        return this;
    }

    public CUkernelNodeAttrValue set(CUkernelNodeAttrValue src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUkernelNodeAttrValue malloc() {
        return (CUkernelNodeAttrValue)CUkernelNodeAttrValue.wrap(CUkernelNodeAttrValue.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CUkernelNodeAttrValue calloc() {
        return (CUkernelNodeAttrValue)CUkernelNodeAttrValue.wrap(CUkernelNodeAttrValue.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CUkernelNodeAttrValue create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CUkernelNodeAttrValue)CUkernelNodeAttrValue.wrap(CUkernelNodeAttrValue.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CUkernelNodeAttrValue create(long address) {
        return (CUkernelNodeAttrValue)CUkernelNodeAttrValue.wrap(CUkernelNodeAttrValue.class, (long)address);
    }

    @Nullable
    public static CUkernelNodeAttrValue createSafe(long address) {
        return address == 0L ? null : (CUkernelNodeAttrValue)CUkernelNodeAttrValue.wrap(CUkernelNodeAttrValue.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CUkernelNodeAttrValue.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CUkernelNodeAttrValue.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CUkernelNodeAttrValue.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUkernelNodeAttrValue.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CUkernelNodeAttrValue.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CUkernelNodeAttrValue.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CUkernelNodeAttrValue.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CUkernelNodeAttrValue malloc(MemoryStack stack) {
        return (CUkernelNodeAttrValue)CUkernelNodeAttrValue.wrap(CUkernelNodeAttrValue.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUkernelNodeAttrValue calloc(MemoryStack stack) {
        return (CUkernelNodeAttrValue)CUkernelNodeAttrValue.wrap(CUkernelNodeAttrValue.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)CUkernelNodeAttrValue.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)CUkernelNodeAttrValue.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static CUaccessPolicyWindow naccessPolicyWindow(long struct) {
        return CUaccessPolicyWindow.create(struct + (long)ACCESSPOLICYWINDOW);
    }

    public static int ncooperative(long struct) {
        return UNSAFE.getInt(null, struct + (long)COOPERATIVE);
    }

    public static void naccessPolicyWindow(long struct, CUaccessPolicyWindow value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ACCESSPOLICYWINDOW), (long)CUaccessPolicyWindow.SIZEOF);
    }

    public static void ncooperative(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COOPERATIVE, value);
    }

    static {
        Struct.Layout layout = CUkernelNodeAttrValue.__union((Struct.Member[])new Struct.Member[]{CUkernelNodeAttrValue.__member((int)CUaccessPolicyWindow.SIZEOF, (int)CUaccessPolicyWindow.ALIGNOF), CUkernelNodeAttrValue.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ACCESSPOLICYWINDOW = layout.offsetof(0);
        COOPERATIVE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CUkernelNodeAttrValue, Buffer>
    implements NativeResource {
        private static final CUkernelNodeAttrValue ELEMENT_FACTORY = CUkernelNodeAttrValue.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUkernelNodeAttrValue getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public CUaccessPolicyWindow accessPolicyWindow() {
            return CUkernelNodeAttrValue.naccessPolicyWindow(this.address());
        }

        public int cooperative() {
            return CUkernelNodeAttrValue.ncooperative(this.address());
        }

        public Buffer accessPolicyWindow(CUaccessPolicyWindow value) {
            CUkernelNodeAttrValue.naccessPolicyWindow(this.address(), value);
            return this;
        }

        public Buffer accessPolicyWindow(Consumer<CUaccessPolicyWindow> consumer) {
            consumer.accept(this.accessPolicyWindow());
            return this;
        }

        public Buffer cooperative(int value) {
            CUkernelNodeAttrValue.ncooperative(this.address(), value);
            return this;
        }
    }
}

