/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.docker.installation.compose;

import java.net.URL;
import java.security.cert.Certificate;
import org.keycloak.protocol.docker.installation.compose.DockerComposeCertsDirectory;
import org.keycloak.protocol.docker.installation.compose.DockerComposeYamlFile;

public class DockerComposeZipContent {
    private final DockerComposeYamlFile yamlFile;
    private final String dataDirectoryName;
    private final DockerComposeCertsDirectory certsDirectory;

    public DockerComposeZipContent(Certificate realmCert, URL realmBaseUrl, String realmName, String clientId) {
        String dataDirectoryName = "data";
        String certsDirectoryName = "certs";
        String registryCertFilename = "localhost.crt";
        String registryKeyFilename = "localhost.key";
        String idpCertTrustChainFilename = "localhost_trust_chain.pem";
        this.yamlFile = new DockerComposeYamlFile("data", "certs", "/opt/certs", "localhost.crt", "localhost.key", "localhost_trust_chain.pem", realmBaseUrl, realmName, clientId);
        this.dataDirectoryName = "data";
        this.certsDirectory = new DockerComposeCertsDirectory("certs", realmCert, "localhost.crt", "localhost.key", "localhost_trust_chain.pem", realmName);
    }

    public DockerComposeYamlFile getYamlFile() {
        return this.yamlFile;
    }

    public String getDataDirectoryName() {
        return this.dataDirectoryName;
    }

    public DockerComposeCertsDirectory getCertsDirectory() {
        return this.certsDirectory;
    }
}

