/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.type.CollectionType;
import org.hibernate.usertype.LoggableUserType;
import org.hibernate.usertype.UserCollectionType;

public class CustomCollectionType
extends CollectionType {
    private final UserCollectionType userType;
    private final boolean customLogging;

    public CustomCollectionType(ManagedBean<? extends UserCollectionType> userTypeBean, String role, String foreignKeyPropertyName) {
        super(role, foreignKeyPropertyName);
        this.userType = userTypeBean.getBeanInstance();
        this.customLogging = this.userType instanceof LoggableUserType;
    }

    @Override
    public Class<?> getReturnedClass() {
        return this.userType.instantiate(-1).getClass();
    }

    @Override
    public CollectionClassification getCollectionClassification() {
        return this.userType.getClassification();
    }

    @Override
    public PersistentCollection<?> instantiate(SharedSessionContractImplementor session, CollectionPersister persister, Object key) throws HibernateException {
        return this.userType.instantiate(session, persister);
    }

    @Override
    public PersistentCollection<?> wrap(SharedSessionContractImplementor session, Object collection) {
        return this.userType.wrap(session, collection);
    }

    @Override
    public Object instantiate(int anticipatedType) {
        return this.userType.instantiate(anticipatedType);
    }

    @Override
    public Iterator<?> getElementsIterator(Object collection) {
        return this.userType.getElementsIterator(collection);
    }

    @Override
    public boolean contains(Object collection, Object entity, SharedSessionContractImplementor session) {
        return this.userType.contains(collection, entity);
    }

    @Override
    public Object indexOf(Object collection, Object entity) {
        return this.userType.indexOf(collection, entity);
    }

    public Object replaceElements(Object original, Object target, Object owner, Map copyCache, SharedSessionContractImplementor session) throws HibernateException {
        CollectionPersister cp = session.getFactory().getRuntimeMetamodels().getMappingMetamodel().getCollectionDescriptor(this.getRole());
        return this.userType.replaceElements(original, target, cp, owner, copyCache, session);
    }

    @Override
    protected String renderLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        if (this.customLogging) {
            return ((LoggableUserType)((Object)this.userType)).toLoggableString(value, factory);
        }
        return super.renderLoggableString(value, factory);
    }

    public UserCollectionType getUserType() {
        return this.userType;
    }
}

