/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.websocket;

import java.nio.ByteBuffer;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.jitsi.utils.logging2.LogContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.videobridge.util.TaskPools;
import org.jitsi.videobridge.websocket.config.WebsocketServiceConfig;

public class ColibriWebSocket
extends WebSocketAdapter {
    private final Logger logger;
    private final EventHandler eventHandler;
    private final Clock clock = Clock.systemUTC();
    private Instant lastSendTime = Instant.MIN;
    private ScheduledFuture<?> pinger = null;

    public ColibriWebSocket(String id, EventHandler eventHandler) {
        this.logger = new LoggerImpl(this.getClass().getName(), new LogContext(Map.of("id", id)));
        this.eventHandler = Objects.requireNonNull(eventHandler, "eventHandler");
    }

    @Override
    public void onWebSocketText(String message) {
        this.logger.debug(() -> "Received text: " + message);
        this.eventHandler.webSocketTextReceived(this, message);
    }

    @Override
    public void onWebSocketConnect(Session sess) {
        super.onWebSocketConnect(sess);
        if (WebsocketServiceConfig.config.getSendKeepalivePings()) {
            this.pinger = TaskPools.SCHEDULED_POOL.scheduleAtFixedRate(this::maybeSendPing, WebsocketServiceConfig.config.getKeepalivePingInterval().toMillis(), WebsocketServiceConfig.config.getKeepalivePingInterval().toMillis(), TimeUnit.MILLISECONDS);
        }
        this.eventHandler.webSocketConnected(this);
    }

    @Override
    public void onWebSocketClose(int statusCode, String reason) {
        this.eventHandler.webSocketClosed(this, statusCode, reason);
        if (this.pinger != null) {
            this.pinger.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendString(String message) {
        RemoteEndpoint remote = this.getRemote();
        if (remote != null) {
            remote.sendString(message, WriteCallback.NOOP);
            ColibriWebSocket colibriWebSocket = this;
            synchronized (colibriWebSocket) {
                this.lastSendTime = this.clock.instant();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeSendPing() {
        try {
            Instant now = this.clock.instant();
            ColibriWebSocket colibriWebSocket = this;
            synchronized (colibriWebSocket) {
                RemoteEndpoint remote;
                if (Duration.between(this.lastSendTime, now).compareTo(WebsocketServiceConfig.config.getKeepalivePingInterval()) < 0 && (remote = this.getRemote()) != null) {
                    remote.sendPing(ByteBuffer.allocate(0), WriteCallback.NOOP);
                    this.lastSendTime = this.clock.instant();
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error sending websocket ping", e);
        }
    }

    @Override
    public void onWebSocketError(Throwable cause) {
        this.eventHandler.webSocketError(this, cause);
        if (this.pinger != null) {
            this.pinger.cancel(true);
        }
    }

    public static interface EventHandler {
        public void webSocketClosed(ColibriWebSocket var1, int var2, String var3);

        public void webSocketConnected(ColibriWebSocket var1);

        public void webSocketTextReceived(ColibriWebSocket var1, String var2);

        public void webSocketError(ColibriWebSocket var1, Throwable var2);
    }
}

