/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject;

import ca.sqlpower.object.AbstractPoolingSPListener;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLCheckConstraint;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLEnumeration;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTypePhysicalProperties;
import ca.sqlpower.sqlobject.SQLTypePhysicalPropertiesProvider;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import ca.sqlpower.util.SQLPowerUtils;
import java.beans.PropertyChangeEvent;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

class ForeignKeyColumnUpdaterPoolingSPListener
extends AbstractPoolingSPListener {
    private static final Logger logger = Logger.getLogger(ForeignKeyColumnUpdaterPoolingSPListener.class);
    private final SQLRelationship relationship;

    ForeignKeyColumnUpdaterPoolingSPListener(@Nonnull SQLRelationship relationship) {
        super(false);
        this.relationship = relationship;
    }

    @Override
    protected void propertyChangeImpl(PropertyChangeEvent e) {
        block62: {
            String prop;
            block61: {
                block64: {
                    SQLRelationship.ColumnMapping m;
                    block63: {
                        if (!((SQLObject)e.getSource()).isMagicEnabled()) {
                            logger.debug((Object)("Magic disabled; ignoring sqlobject changed event " + e));
                            return;
                        }
                        prop = e.getPropertyName();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Property changed!\n source=" + e.getSource() + "\n property=" + prop + "\n old=" + e.getOldValue() + "\n new=" + e.getNewValue()));
                        }
                        if (!(e.getSource() instanceof SQLColumn)) break block61;
                        SQLColumn col = (SQLColumn)e.getSource();
                        if (col.getParent() == null || !col.getParent().equals(this.relationship.getParent())) break block62;
                        m = this.relationship.getMappingByPkCol(col);
                        if (m == null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Ignoring change for column " + col + " parent " + col.getParent()));
                            }
                            return;
                        }
                        if (m.getPkColumn() == null) {
                            throw new NullPointerException("Missing pk column in mapping");
                        }
                        if (m.getFkColumn() == null) {
                            if (m.getFkColName() == null) {
                                throw new NullPointerException("Missing pk column name in mapping");
                            }
                            if (m.getFkTable() == null) {
                                throw new NullPointerException("Missing pk table in mapping");
                            }
                            return;
                        }
                        if (prop == null || prop.equals("parent") || prop.equals("remarks") || prop.equals("autoIncrement")) break block62;
                        if (!prop.equals("sourceColumn")) break block63;
                        m.getFkColumn().setSourceColumn(m.getPkColumn().getSourceColumn());
                        break block62;
                    }
                    if (!prop.equals("name")) break block64;
                    if (!m.getFkColumn().getName().equalsIgnoreCase((String)e.getOldValue())) break block62;
                    m.getFkColumn().setName(m.getPkColumn().getName());
                    break block62;
                }
                logger.warn((Object)("Warning: unknown column property " + prop + " changed while monitoring pkTable"));
                break block62;
            }
            if (e.getSource() instanceof UserDefinedSQLType) {
                UserDefinedSQLType sourceType = (UserDefinedSQLType)e.getSource();
                SPObject parent = sourceType.getParent();
                if (!(parent instanceof SQLColumn)) {
                    throw new IllegalStateException("UserDefinedSQLType " + sourceType.getPhysicalName() + " must have a SQLColumn parent.");
                }
                SQLColumn sourceColumn = (SQLColumn)parent;
                SQLRelationship.ColumnMapping m = this.relationship.getMappingByPkCol(sourceColumn);
                if (m == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Ignoring change for UserDefinedSQLType " + sourceType.getName()));
                    }
                    return;
                }
                SQLColumn fkCol = m.getFkColumn();
                if (fkCol == null) {
                    throw new NullPointerException("Missing fk column in mapping");
                }
                UserDefinedSQLType fkType = fkCol.getUserDefinedSQLType();
                if (prop.equals("type")) {
                    fkType.setType((Integer)e.getNewValue());
                } else if (prop.equals("name")) {
                    fkType.setName((String)e.getNewValue());
                } else if (prop.equals("myNullability")) {
                    fkType.setMyNullability((Integer)e.getNewValue());
                } else if (prop.equals("upstreamType")) {
                    fkType.setUpstreamType((UserDefinedSQLType)e.getNewValue());
                } else if (prop.equals("basicType")) {
                    fkType.setBasicType((SQLTypePhysicalPropertiesProvider.BasicSQLType)((Object)e.getNewValue()));
                } else {
                    logger.warn((Object)("Warning: unknown UserDefinedSQLType property " + prop + " changed while monitoring pkTable"));
                }
            } else if (e.getSource() instanceof SQLTypePhysicalProperties) {
                SQLTypePhysicalProperties sourceProperties = (SQLTypePhysicalProperties)e.getSource();
                SPObject parent = sourceProperties.getParent();
                if (!(parent instanceof UserDefinedSQLType)) {
                    throw new IllegalStateException("SQLTypePhysicalProperties " + sourceProperties.getPhysicalName() + " must have a UserDefinedSQLType parent.");
                }
                UserDefinedSQLType sourceType = (UserDefinedSQLType)parent;
                if (!((parent = sourceType.getParent()) instanceof SQLColumn)) {
                    throw new IllegalStateException("UserDefinedSQLType " + sourceType.getPhysicalName() + " must have a SQLColumn parent.");
                }
                SQLColumn sourceColumn = (SQLColumn)parent;
                SQLRelationship.ColumnMapping m = this.relationship.getMappingByPkCol(sourceColumn);
                if (m == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Ignoring change for SQLTypePhysicalProperties " + sourceProperties.getName()));
                    }
                    return;
                }
                SQLColumn fkCol = m.getFkColumn();
                if (fkCol == null) {
                    throw new NullPointerException("Missing fk column in mapping");
                }
                UserDefinedSQLType fkType = fkCol.getUserDefinedSQLType();
                String fkPlatform = fkCol.getPlatform();
                if (prop.equals("scale") && (e.getNewValue() == null || fkType.getScale(fkPlatform) > (Integer)e.getNewValue())) {
                    fkType.setScale(fkPlatform, (Integer)e.getNewValue());
                } else if (prop.equals("scaleType")) {
                    fkType.setScaleType(fkPlatform, (SQLTypePhysicalPropertiesProvider.PropertyType)((Object)e.getNewValue()));
                } else if (prop.equals("precision") && (e.getNewValue() == null || fkType.getPrecision(fkPlatform) > (Integer)e.getNewValue())) {
                    fkType.setPrecision(fkPlatform, (Integer)e.getNewValue());
                } else if (prop.equals("precisionType")) {
                    fkType.setPrecisionType(fkPlatform, (SQLTypePhysicalPropertiesProvider.PropertyType)((Object)e.getNewValue()));
                } else if (prop.equals("constraintType")) {
                    fkType.setConstraintType(fkPlatform, (SQLTypePhysicalProperties.SQLTypeConstraint)((Object)e.getNewValue()));
                } else if (prop.equals("defaultValue")) {
                    fkType.setDefaultValue(fkPlatform, (String)e.getNewValue());
                } else {
                    logger.warn((Object)("Warning: unknown SQLTypePhysicalProperties property " + prop + " changed while monitoring pkTable"));
                }
            } else if (e.getSource() instanceof SQLCheckConstraint) {
                SQLCheckConstraint sourceConstraint = (SQLCheckConstraint)e.getSource();
                SPObject parent = sourceConstraint.getParent();
                if (!(parent instanceof SQLTypePhysicalProperties)) {
                    throw new IllegalStateException("SQLCheckConstraint " + sourceConstraint.getPhysicalName() + " must have a SQLTypePhysicalProperties parent.");
                }
                SQLTypePhysicalProperties sourceProperties = (SQLTypePhysicalProperties)parent;
                if (!((parent = sourceProperties.getParent()) instanceof UserDefinedSQLType)) {
                    throw new IllegalStateException("SQLTypePhysicalProperties " + sourceProperties.getPhysicalName() + " must have a UserDefinedSQLType parent.");
                }
                UserDefinedSQLType sourceType = (UserDefinedSQLType)parent;
                if (!((parent = sourceType.getParent()) instanceof SQLColumn)) {
                    throw new IllegalStateException("UserDefinedSQLType " + sourceType.getPhysicalName() + " must have a SQLColumn parent.");
                }
                SQLColumn sourceColumn = (SQLColumn)parent;
                SQLRelationship.ColumnMapping m = this.relationship.getMappingByPkCol(sourceColumn);
                if (m == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Ignoring change for SQLCheckConstraint " + sourceConstraint.getName()));
                    }
                    return;
                }
                SQLColumn fkCol = m.getFkColumn();
                if (fkCol == null) {
                    throw new NullPointerException("Missing fk column in mapping");
                }
                String fkPlatform = fkCol.getPlatform();
                SQLTypePhysicalProperties fkProperties = fkCol.getUserDefinedSQLType().getPhysicalProperties(fkPlatform);
                for (SQLCheckConstraint constraint : fkProperties.getChildren(SQLCheckConstraint.class)) {
                    if (prop.equals("name") && constraint.getName().equals((String)e.getOldValue()) && constraint.getConstraint().equals(sourceConstraint.getConstraint())) {
                        constraint.setName((String)e.getNewValue());
                        continue;
                    }
                    if (!prop.equals("constraint") || !constraint.getName().equals(sourceConstraint) || !constraint.getConstraint().equals((String)e.getOldValue())) continue;
                    constraint.setConstraint((String)e.getNewValue());
                }
            } else if (e.getSource() instanceof SQLEnumeration) {
                SQLEnumeration sourceEnumeration = (SQLEnumeration)e.getSource();
                SPObject parent = sourceEnumeration.getParent();
                if (!(parent instanceof SQLTypePhysicalProperties)) {
                    throw new IllegalStateException("SQLEnumeration " + sourceEnumeration.getPhysicalName() + " must have a SQLTypePhysicalProperties parent.");
                }
                SQLTypePhysicalProperties sourceProperties = parent;
                if (!((parent = sourceProperties.getParent()) instanceof UserDefinedSQLType)) {
                    throw new IllegalStateException("SQLTypePhysicalProperties " + sourceProperties.getPhysicalName() + " must have a UserDefinedSQLType parent.");
                }
                UserDefinedSQLType sourceType = (UserDefinedSQLType)parent;
                if (!((parent = sourceType.getParent()) instanceof SQLColumn)) {
                    throw new IllegalStateException("UserDefinedSQLType " + sourceType.getPhysicalName() + " must have a SQLColumn parent.");
                }
                SQLColumn sourceColumn = (SQLColumn)parent;
                SQLRelationship.ColumnMapping m = this.relationship.getMappingByPkCol(sourceColumn);
                if (m == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Ignoring change for SQLEnumeration " + sourceEnumeration.getName()));
                    }
                    return;
                }
                SQLColumn fkCol = m.getFkColumn();
                if (fkCol == null) {
                    throw new NullPointerException("Missing fk column in mapping");
                }
                String fkPlatform = fkCol.getPlatform();
                SQLTypePhysicalProperties fkProperties = fkCol.getUserDefinedSQLType().getPhysicalProperties(fkPlatform);
                for (SQLEnumeration constraint : fkProperties.getChildren(SQLEnumeration.class)) {
                    if (!prop.equals("name") || !constraint.getName().equals((String)e.getOldValue())) continue;
                    constraint.setName((String)e.getNewValue());
                }
            }
        }
    }

    @Override
    protected void childAddedImpl(SPChildEvent e) {
        SQLPowerUtils.listenToHierarchy(e.getChild(), this);
    }

    @Override
    protected void childRemovedImpl(SPChildEvent e) {
        SQLPowerUtils.unlistenToHierarchy(e.getChild(), this);
    }
}

