/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.math.BigDecimal;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css3.CssFlexBasis;
import org.w3c.css.properties.css3.CssFlexGrow;
import org.w3c.css.properties.css3.CssFlexShrink;
import org.w3c.css.properties.css3.CssWidth;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssFlex
extends org.w3c.css.properties.css.CssFlex {
    public CssIdent auto = CssIdent.getIdent("auto");
    private CssFlexGrow flexGrow;
    private CssFlexShrink flexShrink;
    private CssFlexBasis flexBasis;

    public CssFlex() {
        this.value = initial;
        this.flexGrow = new CssFlexGrow();
        this.flexShrink = new CssFlexShrink();
        this.flexBasis = new CssFlexBasis();
    }

    public CssFlex(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        CssNumber one;
        if (check2 && expression.getCount() > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssValue growVal = null;
        CssValue shrinkVal = null;
        CssValue basisVal = null;
        boolean gotNumber = false;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 0: {
                    CssIdent ident = (CssIdent)val;
                    if (inherit.equals(ident)) {
                        this.value = inherit;
                        if (expression.getCount() <= 1) break;
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                    if (none.equals(ident)) {
                        this.value = none;
                        if (expression.getCount() <= 1) break;
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                    if (basisVal == null) {
                        basisVal = CssFlexBasis.getAllowedIdent(ident);
                        if (basisVal == null) {
                            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                        }
                        gotNumber = false;
                        break;
                    }
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                case 5: {
                    CssCheckableValue num;
                    if (growVal == null) {
                        num = val.getCheckableValue();
                        num.checkPositiveness(ac, this);
                        growVal = val;
                        gotNumber = true;
                        break;
                    }
                    if (gotNumber && shrinkVal == null) {
                        num = val.getCheckableValue();
                        num.checkPositiveness(ac, this);
                        shrinkVal = val;
                        break;
                    }
                }
                default: {
                    if (basisVal == null) {
                        CssExpression e = new CssExpression();
                        e.addValue(val);
                        try {
                            CssFlexBasis b = new CssFlexBasis(ac, e, check2);
                            basisVal = val;
                        }
                        catch (InvalidParamException ex) {
                            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                        }
                        gotNumber = false;
                        break;
                    }
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", new Character(op).toString(), ac);
            }
            expression.next();
        }
        this.flexBasis = new CssFlexBasis();
        this.flexGrow = new CssFlexGrow();
        this.flexShrink = new CssFlexShrink();
        if (this.value == inherit) {
            this.flexBasis.value = inherit;
            this.flexGrow.value = inherit;
            this.flexShrink.value = inherit;
        } else if (this.value == none) {
            this.flexBasis.value = CssWidth.auto;
            CssNumber z = new CssNumber();
            z.setValue(BigDecimal.ZERO);
            this.flexGrow.value = z;
            this.flexShrink.value = z;
        } else if (basisVal == this.auto && growVal == null && shrinkVal == null) {
            this.flexBasis.value = CssWidth.auto;
            one = new CssNumber();
            one.setValue(BigDecimal.ONE);
            this.flexGrow.value = one;
            this.flexShrink.value = one;
            this.value = this.auto;
        } else if (basisVal == null && shrinkVal == null) {
            one = new CssNumber();
            one.setValue(BigDecimal.ONE);
            this.flexShrink.value = one;
            CssNumber z = new CssNumber();
            z.setValue(BigDecimal.ZERO);
            this.flexBasis.value = z;
            this.value = growVal;
        } else {
            CssValueList v = new CssValueList();
            if (growVal != null) {
                v.add(growVal);
                this.flexGrow.value = growVal;
                if (shrinkVal != null) {
                    v.add(shrinkVal);
                    this.flexShrink.value = shrinkVal;
                }
            }
            if (basisVal != null) {
                v.add(basisVal);
                this.flexBasis.value = basisVal;
            }
            this.value = v;
        }
    }

    public CssFlex(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public void addToStyle(ApplContext ac, CssStyle style) {
        super.addToStyle(ac, style);
        this.flexBasis.addToStyle(ac, style);
        this.flexGrow.addToStyle(ac, style);
        this.flexShrink.addToStyle(ac, style);
    }
}

