/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public abstract class AbstractFallbackTransactionAttributeSource
implements TransactionAttributeSource {
    private static final TransactionAttribute NULL_TRANSACTION_ATTRIBUTE = new DefaultTransactionAttribute();
    protected final Log logger = LogFactory.getLog(this.getClass());
    final Map<Object, TransactionAttribute> attributeCache = new ConcurrentHashMap<Object, TransactionAttribute>(1024);

    @Override
    public TransactionAttribute getTransactionAttribute(Method method, Class<?> targetClass) {
        Object cacheKey = this.getCacheKey(method, targetClass);
        TransactionAttribute cached = this.attributeCache.get(cacheKey);
        if (cached != null) {
            if (cached == NULL_TRANSACTION_ATTRIBUTE) {
                return null;
            }
            return cached;
        }
        TransactionAttribute txAtt = this.computeTransactionAttribute(method, targetClass);
        if (txAtt == null) {
            this.attributeCache.put(cacheKey, NULL_TRANSACTION_ATTRIBUTE);
        } else {
            if (this.logger.isDebugEnabled()) {
                Class<?> classToLog = targetClass != null ? targetClass : method.getDeclaringClass();
                this.logger.debug("Adding transactional method '" + classToLog.getSimpleName() + "." + method.getName() + "' with attribute: " + txAtt);
            }
            this.attributeCache.put(cacheKey, txAtt);
        }
        return txAtt;
    }

    protected Object getCacheKey(Method method, Class<?> targetClass) {
        return new DefaultCacheKey(method, targetClass);
    }

    protected TransactionAttribute computeTransactionAttribute(Method method, Class<?> targetClass) {
        if (this.allowPublicMethodsOnly() && !Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Class<?> userClass = ClassUtils.getUserClass(targetClass);
        Method specificMethod = ClassUtils.getMostSpecificMethod(method, userClass);
        TransactionAttribute txAtt = this.findTransactionAttribute(specificMethod = BridgeMethodResolver.findBridgedMethod(specificMethod));
        if (txAtt != null) {
            return txAtt;
        }
        txAtt = this.findTransactionAttribute(specificMethod.getDeclaringClass());
        if (txAtt != null) {
            return txAtt;
        }
        if (specificMethod != method) {
            txAtt = this.findTransactionAttribute(method);
            if (txAtt != null) {
                return txAtt;
            }
            return this.findTransactionAttribute(method.getDeclaringClass());
        }
        return null;
    }

    protected abstract TransactionAttribute findTransactionAttribute(Method var1);

    protected abstract TransactionAttribute findTransactionAttribute(Class<?> var1);

    protected boolean allowPublicMethodsOnly() {
        return false;
    }

    private static class DefaultCacheKey {
        private final Method method;
        private final Class<?> targetClass;

        public DefaultCacheKey(Method method, Class<?> targetClass) {
            this.method = method;
            this.targetClass = targetClass;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DefaultCacheKey)) {
                return false;
            }
            DefaultCacheKey otherKey = (DefaultCacheKey)other;
            return this.method.equals(otherKey.method) && ObjectUtils.nullSafeEquals(this.targetClass, otherKey.targetClass);
        }

        public int hashCode() {
            return this.method.hashCode() + (this.targetClass != null ? this.targetClass.hashCode() * 29 : 0);
        }
    }
}

