/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.exceptionpolicy;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.camel.Exchange;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyKey;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExceptionPolicyStrategy
implements ExceptionPolicyStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExceptionPolicyStrategy.class);

    @Override
    public OnExceptionDefinition getExceptionPolicy(Map<ExceptionPolicyKey, OnExceptionDefinition> exceptionPolicies, Exchange exchange, Throwable exception) {
        TreeMap<Integer, OnExceptionDefinition> candidates = new TreeMap<Integer, OnExceptionDefinition>();
        LinkedHashMap<ExceptionPolicyKey, OnExceptionDefinition> routeScoped = new LinkedHashMap<ExceptionPolicyKey, OnExceptionDefinition>();
        LinkedHashMap<ExceptionPolicyKey, OnExceptionDefinition> contextScoped = new LinkedHashMap<ExceptionPolicyKey, OnExceptionDefinition>();
        this.initRouteAndContextScopedExceptionPolicies(exceptionPolicies, routeScoped, contextScoped);
        boolean exactMatch = false;
        Iterator<Throwable> it = this.createExceptionIterator(exception);
        while (!exactMatch && it.hasNext()) {
            exactMatch = this.findMatchedExceptionPolicy(routeScoped, exchange, it.next(), candidates);
        }
        it = this.createExceptionIterator(exception);
        while (!exactMatch && it.hasNext()) {
            exactMatch = this.findMatchedExceptionPolicy(contextScoped, exchange, it.next(), candidates);
        }
        LOG.trace("Found {} candidates", (Object)candidates.size());
        if (candidates.isEmpty()) {
            return null;
        }
        return (OnExceptionDefinition)candidates.values().iterator().next();
    }

    private void initRouteAndContextScopedExceptionPolicies(Map<ExceptionPolicyKey, OnExceptionDefinition> exceptionPolicies, Map<ExceptionPolicyKey, OnExceptionDefinition> routeScoped, Map<ExceptionPolicyKey, OnExceptionDefinition> contextScoped) {
        Set<Map.Entry<ExceptionPolicyKey, OnExceptionDefinition>> entries = exceptionPolicies.entrySet();
        for (Map.Entry<ExceptionPolicyKey, OnExceptionDefinition> entry : entries) {
            if (entry.getKey().getRouteId() != null) {
                routeScoped.put(entry.getKey(), entry.getValue());
                continue;
            }
            contextScoped.put(entry.getKey(), entry.getValue());
        }
    }

    private boolean findMatchedExceptionPolicy(Map<ExceptionPolicyKey, OnExceptionDefinition> exceptionPolicies, Exchange exchange, Throwable exception, Map<Integer, OnExceptionDefinition> candidates) {
        boolean exactMatch;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Finding best suited exception policy for thrown exception {}", (Object)exception.getClass().getName());
        }
        int targetLevel = DefaultExceptionPolicyStrategy.getInheritanceLevel(exception.getClass());
        OnExceptionDefinition candidate = null;
        int candidateDiff = Integer.MAX_VALUE;
        Set<Map.Entry<ExceptionPolicyKey, OnExceptionDefinition>> entries = exceptionPolicies.entrySet();
        for (Map.Entry<ExceptionPolicyKey, OnExceptionDefinition> entry : entries) {
            Class<?> clazz = entry.getKey().getExceptionClass();
            OnExceptionDefinition type = entry.getValue();
            if (exchange != null && exchange.getUnitOfWork() != null && type.isRouteScoped()) {
                RouteDefinition route = exchange.getUnitOfWork().getRouteContext() != null ? exchange.getUnitOfWork().getRouteContext().getRoute() : null;
                RouteDefinition typeRoute = ProcessorDefinitionHelper.getRoute(type);
                if (route != null && typeRoute != null && route != typeRoute) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("The type is scoped for route: {} however Exchange is at route: {}", (Object)typeRoute.getId(), (Object)route.getId());
                    continue;
                }
            }
            if (!this.filter(type, clazz, exception)) continue;
            if (!this.matchesWhen(type, exchange)) {
                LOG.trace("The type did not match when: {}", (Object)type);
                continue;
            }
            if (clazz.equals(exception.getClass())) {
                candidate = type;
                candidateDiff = 0;
                break;
            }
            int level = DefaultExceptionPolicyStrategy.getInheritanceLevel(clazz);
            int diff = targetLevel - level;
            if (diff >= candidateDiff) continue;
            candidate = type;
            candidateDiff = diff;
        }
        if (candidate != null) {
            if (!candidates.containsKey(candidateDiff)) {
                LOG.trace("Adding {} as candidate at level {}", (Object)candidate, (Object)candidateDiff);
                candidates.put(candidateDiff, candidate);
            } else if (LOG.isTraceEnabled()) {
                LOG.trace("Existing candidate {} takes precedence over{} at level {}", candidates.get(candidateDiff), candidate, candidateDiff);
            }
        }
        boolean bl = exactMatch = candidateDiff == 0;
        if (LOG.isTraceEnabled() && exactMatch) {
            LOG.trace("Exact match found for candidate: {}", (Object)candidate);
        }
        return exactMatch;
    }

    protected boolean filter(OnExceptionDefinition type, Class<?> exceptionClass, Throwable exception) {
        return exceptionClass.isInstance(exception);
    }

    protected boolean matchesWhen(OnExceptionDefinition definition, Exchange exchange) {
        if (definition.getOnWhen() == null || definition.getOnWhen().getExpression() == null) {
            return true;
        }
        return definition.getOnWhen().getExpression().matches(exchange);
    }

    protected Iterator<Throwable> createExceptionIterator(Throwable exception) {
        return ObjectHelper.createExceptionIterator(exception);
    }

    private static int getInheritanceLevel(Class<?> clazz) {
        if (clazz == null || "java.lang.Object".equals(clazz.getName())) {
            return 0;
        }
        return 1 + DefaultExceptionPolicyStrategy.getInheritanceLevel(clazz.getSuperclass());
    }
}

