/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.activemq.ActiveMQMessageAudit;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.Locker;
import org.apache.activemq.broker.scheduler.JobSchedulerStore;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.TransactionStore;
import org.apache.activemq.store.jdbc.DataSourceServiceSupport;
import org.apache.activemq.store.jdbc.DefaultDatabaseLocker;
import org.apache.activemq.store.jdbc.JDBCAdapter;
import org.apache.activemq.store.jdbc.JDBCMessageIdScanListener;
import org.apache.activemq.store.jdbc.JDBCMessageStore;
import org.apache.activemq.store.jdbc.JDBCTopicMessageStore;
import org.apache.activemq.store.jdbc.JdbcMemoryTransactionStore;
import org.apache.activemq.store.jdbc.Statements;
import org.apache.activemq.store.jdbc.TransactionContext;
import org.apache.activemq.store.jdbc.adapter.DefaultJDBCAdapter;
import org.apache.activemq.store.memory.MemoryTransactionStore;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.FactoryFinder;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.LongSequenceGenerator;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCPersistenceAdapter
extends DataSourceServiceSupport
implements PersistenceAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCPersistenceAdapter.class);
    private static FactoryFinder adapterFactoryFinder = new FactoryFinder("META-INF/services/org/apache/activemq/store/jdbc/");
    private static FactoryFinder lockFactoryFinder = new FactoryFinder("META-INF/services/org/apache/activemq/store/jdbc/lock/");
    public static final long DEFAULT_LOCK_KEEP_ALIVE_PERIOD = 30000L;
    private WireFormat wireFormat = new OpenWireFormat();
    private Statements statements;
    private JDBCAdapter adapter;
    private MemoryTransactionStore transactionStore;
    private ScheduledFuture<?> cleanupTicket;
    private int cleanupPeriod = 300000;
    private boolean useExternalMessageReferences;
    private boolean createTablesOnStartup = true;
    private DataSource lockDataSource;
    private int transactionIsolation;
    private File directory;
    private boolean changeAutoCommitAllowed = true;
    protected int maxProducersToAudit = 1024;
    protected int maxAuditDepth = 1000;
    protected boolean enableAudit = false;
    protected int auditRecoveryDepth = 1024;
    protected ActiveMQMessageAudit audit;
    protected LongSequenceGenerator sequenceGenerator = new LongSequenceGenerator();
    protected int maxRows = Short.MAX_VALUE;

    public JDBCPersistenceAdapter() {
        this.setLockKeepAlivePeriod(30000L);
    }

    public JDBCPersistenceAdapter(DataSource ds, WireFormat wireFormat) {
        super(ds);
        this.setLockKeepAlivePeriod(30000L);
        this.wireFormat = wireFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ActiveMQDestination> getDestinations() {
        TransactionContext c = null;
        try {
            c = this.getTransactionContext();
            Set<ActiveMQDestination> set = this.getAdapter().doGetDestinations(c);
            return set;
        }
        catch (IOException e) {
            Set<ActiveMQDestination> set = this.emptyDestinationSet();
            return set;
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            Set<ActiveMQDestination> set = this.emptyDestinationSet();
            return set;
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private Set<ActiveMQDestination> emptyDestinationSet() {
        return Collections.EMPTY_SET;
    }

    protected void createMessageAudit() {
        if (this.enableAudit && this.audit == null) {
            this.audit = new ActiveMQMessageAudit(this.maxAuditDepth, this.maxProducersToAudit);
            TransactionContext c = null;
            try {
                c = this.getTransactionContext();
                this.getAdapter().doMessageIdScan(c, this.auditRecoveryDepth, new JDBCMessageIdScanListener(){

                    @Override
                    public void messageId(MessageId id) {
                        JDBCPersistenceAdapter.this.audit.isDuplicate(id);
                    }
                });
            }
            catch (Exception e) {
                LOG.error("Failed to reload store message audit for JDBC persistence adapter", (Throwable)e);
            }
            finally {
                if (c != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    public void initSequenceIdGenerator() {
        TransactionContext c = null;
        try {
            c = this.getTransactionContext();
            this.getAdapter().doMessageIdScan(c, this.auditRecoveryDepth, new JDBCMessageIdScanListener(){

                @Override
                public void messageId(MessageId id) {
                    JDBCPersistenceAdapter.this.audit.isDuplicate(id);
                }
            });
        }
        catch (Exception e) {
            LOG.error("Failed to reload store message audit for JDBC persistence adapter", (Throwable)e);
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public MessageStore createQueueMessageStore(ActiveMQQueue destination) throws IOException {
        JDBCMessageStore rc = new JDBCMessageStore(this, this.getAdapter(), this.wireFormat, (ActiveMQDestination)destination, this.audit);
        if (this.transactionStore != null) {
            rc = this.transactionStore.proxy((MessageStore)rc);
        }
        return rc;
    }

    public TopicMessageStore createTopicMessageStore(ActiveMQTopic destination) throws IOException {
        JDBCTopicMessageStore rc = new JDBCTopicMessageStore(this, this.getAdapter(), this.wireFormat, destination, this.audit);
        if (this.transactionStore != null) {
            rc = this.transactionStore.proxy((TopicMessageStore)rc);
        }
        return rc;
    }

    public void removeQueueMessageStore(ActiveMQQueue destination) {
        if (destination.isQueue() && this.getBrokerService().shouldRecordVirtualDestination((ActiveMQDestination)destination)) {
            try {
                this.removeConsumerDestination(destination);
            }
            catch (IOException ioe) {
                LOG.error("Failed to remove consumer destination: " + destination, (Throwable)ioe);
            }
        }
    }

    private void removeConsumerDestination(ActiveMQQueue destination) throws IOException {
        try (TransactionContext c = this.getTransactionContext();){
            String id = destination.getQualifiedName();
            this.getAdapter().doDeleteSubscription(c, (ActiveMQDestination)destination, id, id);
        }
    }

    public void removeTopicMessageStore(ActiveMQTopic destination) {
    }

    public TransactionStore createTransactionStore() throws IOException {
        if (this.transactionStore == null) {
            this.transactionStore = new JdbcMemoryTransactionStore(this);
        }
        return this.transactionStore;
    }

    public long getLastMessageBrokerSequenceId() throws IOException {
        try (TransactionContext c = this.getTransactionContext();){
            long seq = this.getAdapter().doGetLastMessageStoreSequenceId(c);
            this.sequenceGenerator.setLastSequenceId(seq);
            long brokerSeq = 0L;
            if (seq != 0L) {
                byte[] msg = this.getAdapter().doGetMessageById(c, seq);
                if (msg != null) {
                    Message last = (Message)this.wireFormat.unmarshal(new ByteSequence(msg));
                    brokerSeq = last.getMessageId().getBrokerSequenceId();
                } else {
                    LOG.warn("Broker sequence id wasn't recovered properly, possible duplicates!");
                }
            }
            long l = brokerSeq;
            return l;
        }
    }

    public long getLastProducerSequenceId(ProducerId id) throws IOException {
        try (TransactionContext c = this.getTransactionContext();){
            long l = this.getAdapter().doGetLastProducerSequenceId(c, id);
            return l;
        }
    }

    public void init() throws Exception {
        this.getAdapter().setUseExternalMessageReferences(this.isUseExternalMessageReferences());
        if (this.isCreateTablesOnStartup()) {
            TransactionContext transactionContext = this.getTransactionContext();
            transactionContext.getExclusiveConnection();
            transactionContext.begin();
            try {
                try {
                    this.getAdapter().doCreateTables(transactionContext);
                }
                catch (SQLException e) {
                    LOG.warn("Cannot create tables due to: " + e);
                    JDBCPersistenceAdapter.log("Failure Details: ", e);
                }
            }
            finally {
                transactionContext.commit();
            }
        }
    }

    public void doStart() throws Exception {
        if (this.brokerService != null) {
            this.wireFormat.setVersion(this.brokerService.getStoreOpenWireVersion());
        }
        if (this.cleanupPeriod > 0) {
            this.cleanupTicket = this.getScheduledThreadPoolExecutor().scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    JDBCPersistenceAdapter.this.cleanup();
                }
            }, 0L, this.cleanupPeriod, TimeUnit.MILLISECONDS);
        }
        this.createMessageAudit();
    }

    public synchronized void doStop(ServiceStopper stopper) throws Exception {
        if (this.cleanupTicket != null) {
            this.cleanupTicket.cancel(true);
            this.cleanupTicket = null;
        }
        this.closeDataSource(this.getDataSource());
    }

    public void cleanup() {
        TransactionContext c = null;
        try {
            LOG.debug("Cleaning up old messages.");
            c = this.getTransactionContext();
            c.getExclusiveConnection();
            this.getAdapter().doDeleteOldMessages(c);
        }
        catch (IOException e) {
            LOG.warn("Old message cleanup failed due to: " + e, (Throwable)e);
        }
        catch (SQLException e) {
            LOG.warn("Old message cleanup failed due to: " + e);
            JDBCPersistenceAdapter.log("Failure Details: ", e);
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (Throwable e) {}
            }
            LOG.debug("Cleanup done.");
        }
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        if (this.clockDaemon == null) {
            this.clockDaemon = new ScheduledThreadPoolExecutor(5, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, "ActiveMQ JDBC PA Scheduled Task");
                    thread.setDaemon(true);
                    return thread;
                }
            });
        }
        return this.clockDaemon;
    }

    public JDBCAdapter getAdapter() throws IOException {
        if (this.adapter == null) {
            this.setAdapter(this.createAdapter());
        }
        return this.adapter;
    }

    @Deprecated
    public Locker getDatabaseLocker() throws IOException {
        return this.getLocker();
    }

    @Deprecated
    public void setDatabaseLocker(Locker locker) throws IOException {
        this.setLocker(locker);
    }

    public DataSource getLockDataSource() throws IOException {
        if (this.lockDataSource == null) {
            this.lockDataSource = this.getDataSource();
            if (this.lockDataSource == null) {
                throw new IllegalArgumentException("No dataSource property has been configured");
            }
        }
        return this.lockDataSource;
    }

    public void setLockDataSource(DataSource dataSource) {
        this.lockDataSource = dataSource;
        LOG.info("Using a separate dataSource for locking: " + this.lockDataSource);
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    protected JDBCAdapter createAdapter() throws IOException {
        this.adapter = (JDBCAdapter)this.loadAdapter(adapterFactoryFinder, "adapter");
        if (this.adapter == null) {
            this.adapter = new DefaultJDBCAdapter();
            LOG.debug("Using default JDBC Adapter: " + this.adapter);
        }
        return this.adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object loadAdapter(FactoryFinder finder, String kind) throws IOException {
        Object adapter = null;
        try (TransactionContext c = this.getTransactionContext();){
            try {
                String dirverName = c.getConnection().getMetaData().getDriverName();
                dirverName = dirverName.replaceAll("[^a-zA-Z0-9\\-]", "_").toLowerCase(Locale.ENGLISH);
                try {
                    adapter = finder.newInstance(dirverName);
                    LOG.info("Database " + kind + " driver override recognized for : [" + dirverName + "] - adapter: " + adapter.getClass());
                }
                catch (Throwable e) {
                    LOG.info("Database " + kind + " driver override not found for : [" + dirverName + "].  Will use default implementation.");
                }
            }
            catch (SQLException e) {
                LOG.warn("JDBC error occurred while trying to detect database type for overrides. Will use default implementations: " + e.getMessage());
                JDBCPersistenceAdapter.log("Failure Details: ", e);
            }
        }
        return adapter;
    }

    public void setAdapter(JDBCAdapter adapter) {
        this.adapter = adapter;
        this.adapter.setStatements(this.getStatements());
        this.adapter.setMaxRows(this.getMaxRows());
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public TransactionContext getTransactionContext(ConnectionContext context) throws IOException {
        if (context == null) {
            return this.getTransactionContext();
        }
        TransactionContext answer = (TransactionContext)context.getLongTermStoreContext();
        if (answer == null) {
            answer = this.getTransactionContext();
            context.setLongTermStoreContext((Object)answer);
        }
        return answer;
    }

    public TransactionContext getTransactionContext() throws IOException {
        TransactionContext answer = new TransactionContext(this);
        if (this.transactionIsolation > 0) {
            answer.setTransactionIsolation(this.transactionIsolation);
        }
        return answer;
    }

    public void beginTransaction(ConnectionContext context) throws IOException {
        TransactionContext transactionContext = this.getTransactionContext(context);
        transactionContext.begin();
    }

    public void commitTransaction(ConnectionContext context) throws IOException {
        TransactionContext transactionContext = this.getTransactionContext(context);
        transactionContext.commit();
    }

    public void rollbackTransaction(ConnectionContext context) throws IOException {
        TransactionContext transactionContext = this.getTransactionContext(context);
        transactionContext.rollback();
    }

    public int getCleanupPeriod() {
        return this.cleanupPeriod;
    }

    public void setCleanupPeriod(int cleanupPeriod) {
        this.cleanupPeriod = cleanupPeriod;
    }

    public boolean isChangeAutoCommitAllowed() {
        return this.changeAutoCommitAllowed;
    }

    public void setChangeAutoCommitAllowed(boolean changeAutoCommitAllowed) {
        this.changeAutoCommitAllowed = changeAutoCommitAllowed;
    }

    public void deleteAllMessages() throws IOException {
        TransactionContext c = this.getTransactionContext();
        c.getExclusiveConnection();
        try {
            this.getAdapter().doDropTables(c);
            this.getAdapter().setUseExternalMessageReferences(this.isUseExternalMessageReferences());
            this.getAdapter().doCreateTables(c);
            LOG.info("Persistence store purged.");
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create((Exception)e);
        }
        finally {
            c.close();
        }
    }

    public boolean isUseExternalMessageReferences() {
        return this.useExternalMessageReferences;
    }

    public void setUseExternalMessageReferences(boolean useExternalMessageReferences) {
        this.useExternalMessageReferences = useExternalMessageReferences;
    }

    public boolean isCreateTablesOnStartup() {
        return this.createTablesOnStartup;
    }

    public void setCreateTablesOnStartup(boolean createTablesOnStartup) {
        this.createTablesOnStartup = createTablesOnStartup;
    }

    @Deprecated
    public void setUseDatabaseLock(boolean useDatabaseLock) {
        this.setUseLock(useDatabaseLock);
    }

    public static void log(String msg, SQLException e) {
        String s = msg + e.getMessage();
        while (e.getNextException() != null) {
            e = e.getNextException();
            s = s + ", due to: " + e.getMessage();
        }
        LOG.warn(s, (Throwable)e);
    }

    public Statements getStatements() {
        if (this.statements == null) {
            this.statements = new Statements();
        }
        return this.statements;
    }

    public void setStatements(Statements statements) {
        this.statements = statements;
        if (this.adapter != null) {
            this.adapter.setStatements(this.getStatements());
        }
    }

    public void setUsageManager(SystemUsage usageManager) {
    }

    public Locker createDefaultLocker() throws IOException {
        Object locker = (Locker)this.loadAdapter(lockFactoryFinder, "lock");
        if (locker == null) {
            locker = new DefaultDatabaseLocker();
            LOG.debug("Using default JDBC Locker: " + locker);
        }
        locker.configure((PersistenceAdapter)this);
        return locker;
    }

    public void setBrokerName(String brokerName) {
    }

    @Override
    public String toString() {
        return "JDBCPersistenceAdapter(" + super.toString() + ")";
    }

    public void setDirectory(File dir) {
        this.directory = dir;
    }

    public File getDirectory() {
        if (this.directory == null && this.brokerService != null) {
            this.directory = this.brokerService.getBrokerDataDirectory();
        }
        return this.directory;
    }

    public void checkpoint(boolean sync) throws IOException {
        Connection connection = null;
        try {
            connection = this.getDataSource().getConnection();
            if (!connection.isValid(10)) {
                throw new IOException("isValid(10) failed for: " + connection);
            }
        }
        catch (SQLException e) {
            LOG.debug("Could not get JDBC connection for checkpoint: " + e);
            throw IOExceptionSupport.create((Exception)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public long size() {
        return 0L;
    }

    @Deprecated
    public void setLockAcquireSleepInterval(long lockAcquireSleepInterval) throws IOException {
        this.getLocker().setLockAcquireSleepInterval(lockAcquireSleepInterval);
    }

    public void setTransactionIsolation(int transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    public int getMaxProducersToAudit() {
        return this.maxProducersToAudit;
    }

    public void setMaxProducersToAudit(int maxProducersToAudit) {
        this.maxProducersToAudit = maxProducersToAudit;
    }

    public int getMaxAuditDepth() {
        return this.maxAuditDepth;
    }

    public void setMaxAuditDepth(int maxAuditDepth) {
        this.maxAuditDepth = maxAuditDepth;
    }

    public boolean isEnableAudit() {
        return this.enableAudit;
    }

    public void setEnableAudit(boolean enableAudit) {
        this.enableAudit = enableAudit;
    }

    public int getAuditRecoveryDepth() {
        return this.auditRecoveryDepth;
    }

    public void setAuditRecoveryDepth(int auditRecoveryDepth) {
        this.auditRecoveryDepth = auditRecoveryDepth;
    }

    public long getNextSequenceId() {
        return this.sequenceGenerator.getNextSequenceId();
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void recover(JdbcMemoryTransactionStore jdbcMemoryTransactionStore) throws IOException {
        try (TransactionContext c = this.getTransactionContext();){
            this.getAdapter().doRecoverPreparedOps(c, jdbcMemoryTransactionStore);
        }
    }

    public void commitAdd(ConnectionContext context, MessageId messageId, long preparedSequenceId) throws IOException {
        try (TransactionContext c = this.getTransactionContext(context);){
            long sequence = (Long)messageId.getEntryLocator();
            this.getAdapter().doCommitAddOp(c, preparedSequenceId, sequence);
        }
    }

    public void commitRemove(ConnectionContext context, MessageAck ack) throws IOException {
        try (TransactionContext c = this.getTransactionContext(context);){
            this.getAdapter().doRemoveMessage(c, (Long)ack.getLastMessageId().getFutureOrSequenceLong(), null);
        }
    }

    public void commitLastAck(ConnectionContext context, long xidLastAck, long priority, ActiveMQDestination destination, String subName, String clientId) throws IOException {
        try (TransactionContext c = this.getTransactionContext(context);){
            this.getAdapter().doSetLastAck(c, destination, null, clientId, subName, xidLastAck, priority);
        }
    }

    public void rollbackLastAck(ConnectionContext context, JDBCTopicMessageStore store, MessageAck ack, String subName, String clientId) throws IOException {
        try (TransactionContext c = this.getTransactionContext(context);){
            byte priority = (byte)store.getCachedStoreSequenceId(c, store.getDestination(), ack.getLastMessageId())[1];
            this.getAdapter().doClearLastAck(c, store.getDestination(), priority, clientId, subName);
        }
    }

    public void rollbackLastAck(ConnectionContext context, byte priority, ActiveMQDestination destination, String subName, String clientId) throws IOException {
        try (TransactionContext c = this.getTransactionContext(context);){
            this.getAdapter().doClearLastAck(c, destination, priority, clientId, subName);
        }
    }

    long[] getStoreSequenceIdForMessageId(ConnectionContext context, MessageId messageId, ActiveMQDestination destination) throws IOException {
        long[] result = new long[]{-1L, 126L};
        try (TransactionContext c = this.getTransactionContext(context);){
            result = this.adapter.getStoreSequenceId(c, destination, messageId);
        }
        return result;
    }

    public JobSchedulerStore createJobSchedulerStore() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

