/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server.proxy;

import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.spdy.api.ByteBufferDataInfo;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.GoAwayInfo;
import org.eclipse.jetty.spdy.api.GoAwayResultInfo;
import org.eclipse.jetty.spdy.api.HeadersInfo;
import org.eclipse.jetty.spdy.api.Info;
import org.eclipse.jetty.spdy.api.PushInfo;
import org.eclipse.jetty.spdy.api.ReplyInfo;
import org.eclipse.jetty.spdy.api.RstInfo;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.api.SessionFrameListener;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamFrameListener;
import org.eclipse.jetty.spdy.api.StreamStatus;
import org.eclipse.jetty.spdy.api.SynInfo;
import org.eclipse.jetty.spdy.client.SPDYClient;
import org.eclipse.jetty.spdy.http.HTTPSPDYHeader;
import org.eclipse.jetty.spdy.server.proxy.ProxyEngine;
import org.eclipse.jetty.spdy.server.proxy.ProxyEngineSelector;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SPDYProxyEngine
extends ProxyEngine
implements StreamFrameListener {
    private static final Logger LOG = Log.getLogger(SPDYProxyEngine.class);
    private static final String STREAM_PROMISE_ATTRIBUTE = "org.eclipse.jetty.spdy.server.http.proxy.streamPromise";
    private static final String CLIENT_STREAM_ATTRIBUTE = "org.eclipse.jetty.spdy.server.http.proxy.clientStream";
    private final ConcurrentMap<String, Session> serverSessions = new ConcurrentHashMap<String, Session>();
    private final SessionFrameListener sessionListener = new ProxySessionFrameListener();
    private final SPDYClient.Factory factory;
    private volatile long connectTimeout = 15000L;
    private volatile long timeout = 60000L;

    public SPDYProxyEngine(SPDYClient.Factory factory) {
        this.factory = factory;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public StreamFrameListener proxy(Stream clientStream, SynInfo clientSynInfo, ProxyEngineSelector.ProxyServerInfo proxyServerInfo) {
        Fields headers = new Fields(clientSynInfo.getHeaders(), false);
        short serverVersion = SPDYProxyEngine.getVersion(proxyServerInfo.getProtocol());
        InetSocketAddress address = proxyServerInfo.getAddress();
        Session serverSession = this.produceSession(proxyServerInfo.getHost(), serverVersion, address);
        if (serverSession == null) {
            this.rst(clientStream);
            return null;
        }
        Session clientSession = clientStream.getSession();
        this.addRequestProxyHeaders(clientStream, headers);
        this.customizeRequestHeaders(clientStream, headers);
        this.convert(clientSession.getVersion(), serverVersion, headers);
        SynInfo serverSynInfo = new SynInfo(headers, clientSynInfo.isClose());
        ProxyStreamFrameListener listener = new ProxyStreamFrameListener(clientStream);
        StreamPromise promise = new StreamPromise(clientStream, serverSynInfo);
        clientStream.setAttribute(STREAM_PROMISE_ATTRIBUTE, promise);
        serverSession.syn(serverSynInfo, listener, promise);
        return this;
    }

    private static short getVersion(String protocol) {
        switch (protocol) {
            case "spdy/2": {
                return 2;
            }
            case "spdy/3": {
                return 3;
            }
        }
        throw new IllegalArgumentException("Procotol: " + protocol + " is not a known SPDY protocol");
    }

    @Override
    public StreamFrameListener onPush(Stream stream, PushInfo pushInfo) {
        throw new IllegalStateException("We shouldn't receive pushes from clients");
    }

    @Override
    public void onReply(Stream stream, ReplyInfo replyInfo) {
        throw new IllegalStateException("Servers do not receive replies");
    }

    @Override
    public void onHeaders(Stream stream, HeadersInfo headersInfo) {
        throw new UnsupportedOperationException("Not Yet Implemented");
    }

    @Override
    public void onData(Stream clientStream, final DataInfo clientDataInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("C -> P {} on {}", clientDataInfo, clientStream);
        }
        ByteBufferDataInfo serverDataInfo = new ByteBufferDataInfo(clientDataInfo.asByteBuffer(false), clientDataInfo.isClose()){

            @Override
            public void consume(int delta) {
                super.consume(delta);
                clientDataInfo.consume(delta);
            }
        };
        StreamPromise streamPromise = (StreamPromise)clientStream.getAttribute(STREAM_PROMISE_ATTRIBUTE);
        streamPromise.data(serverDataInfo);
    }

    @Override
    public void onFailure(Stream stream, Throwable x) {
        LOG.debug(x);
    }

    private Session produceSession(String host, short version, InetSocketAddress address) {
        try {
            Session session = (Session)this.serverSessions.get(host);
            if (session == null) {
                Session existing;
                SPDYClient client = this.factory.newSPDYClient(version);
                session = client.connect(address, this.sessionListener);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy session connected to {}", address);
                }
                if ((existing = this.serverSessions.putIfAbsent(host, session)) != null) {
                    session.goAway(new GoAwayInfo(), Callback.Adapter.INSTANCE);
                    session = existing;
                }
            }
            return session;
        }
        catch (Exception x) {
            LOG.debug(x);
            return null;
        }
    }

    private void convert(short fromVersion, short toVersion, Fields headers) {
        if (fromVersion != toVersion) {
            for (HTTPSPDYHeader httpHeader : HTTPSPDYHeader.values()) {
                Fields.Field header = headers.remove(httpHeader.name(fromVersion));
                if (header == null) continue;
                String toName = httpHeader.name(toVersion);
                for (String value : header.getValues()) {
                    headers.add(toName, value);
                }
            }
        }
    }

    private void rst(Stream stream) {
        RstInfo rstInfo = new RstInfo(stream.getId(), StreamStatus.REFUSED_STREAM);
        stream.getSession().rst(rstInfo, Callback.Adapter.INSTANCE);
    }

    private PushInfo convertPushInfo(PushInfo pushInfo, Stream from, Stream to) {
        Fields headersToConvert = pushInfo.getHeaders();
        Fields headers = this.convertHeaders(from, to, headersToConvert);
        return new PushInfo(this.getTimeout(), TimeUnit.MILLISECONDS, headers, pushInfo.isClose());
    }

    private Fields convertHeaders(Stream from, Stream to, Fields headersToConvert) {
        Fields headers = new Fields(headersToConvert, false);
        this.addResponseProxyHeaders(from, headers);
        this.customizeResponseHeaders(from, headers);
        this.convert(from.getSession().getVersion(), to.getSession().getVersion(), headers);
        return headers;
    }

    private class ProxySessionFrameListener
    extends SessionFrameListener.Adapter {
        private ProxySessionFrameListener() {
        }

        @Override
        public void onRst(Session serverSession, RstInfo serverRstInfo) {
            Stream clientStream;
            Stream serverStream = serverSession.getStream(serverRstInfo.getStreamId());
            if (serverStream != null && (clientStream = (Stream)serverStream.getAttribute(SPDYProxyEngine.CLIENT_STREAM_ATTRIBUTE)) != null) {
                Session clientSession = clientStream.getSession();
                RstInfo clientRstInfo = new RstInfo(clientStream.getId(), serverRstInfo.getStreamStatus());
                clientSession.rst(clientRstInfo, Callback.Adapter.INSTANCE);
            }
        }

        @Override
        public void onGoAway(Session serverSession, GoAwayResultInfo goAwayResultInfo) {
            SPDYProxyEngine.this.serverSessions.values().remove(serverSession);
        }
    }

    private class PushStreamPromise
    extends StreamPromise {
        private volatile PushStreamPromise pushStreamPromise;

        private PushStreamPromise(Stream senderStream, PushInfo pushInfo) {
            super(senderStream, pushInfo);
        }

        @Override
        public void succeeded(Stream receiverStream) {
            PushStreamPromise promise;
            super.succeeded(receiverStream);
            if (LOG.isDebugEnabled()) {
                LOG.debug("P -> C PushStreamPromise.succeeded() called with pushStreamPromise: {}", this.pushStreamPromise);
            }
            if ((promise = this.pushStreamPromise) != null) {
                receiverStream.push(SPDYProxyEngine.this.convertPushInfo((PushInfo)this.getInfo(), this.getSenderStream(), receiverStream), this.pushStreamPromise);
            }
        }

        public void push(PushStreamPromise pushStreamPromise) {
            Stream receiverStream = this.getReceiverStream();
            if (receiverStream != null) {
                receiverStream.push(SPDYProxyEngine.this.convertPushInfo((PushInfo)this.getInfo(), this.getSenderStream(), receiverStream), pushStreamPromise);
            } else {
                this.pushStreamPromise = pushStreamPromise;
            }
        }
    }

    private class StreamPromise
    implements Promise<Stream> {
        private final Queue<DataInfoCallback> queue = new LinkedList<DataInfoCallback>();
        private final Stream senderStream;
        private final Info info;
        private Stream receiverStream;

        private StreamPromise(Stream senderStream, Info info) {
            this.senderStream = senderStream;
            this.info = info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void succeeded(Stream stream) {
            DataInfoCallback dataInfoCallback;
            if (LOG.isDebugEnabled()) {
                LOG.debug("P -> S {} from {} to {}", this.info, this.senderStream, stream);
            }
            stream.setAttribute(SPDYProxyEngine.CLIENT_STREAM_ATTRIBUTE, this.senderStream);
            Queue<DataInfoCallback> queue = this.queue;
            synchronized (queue) {
                this.receiverStream = stream;
                dataInfoCallback = this.queue.peek();
                if (dataInfoCallback != null) {
                    if (dataInfoCallback.flushing) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("SYN completed, flushing {}, queue size {}", dataInfoCallback.dataInfo, this.queue.size());
                        }
                        dataInfoCallback = null;
                    } else {
                        dataInfoCallback.flushing = true;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("SYN completed, queue size {}", this.queue.size());
                        }
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("SYN completed, queue empty", new Object[0]);
                }
            }
            if (dataInfoCallback != null) {
                this.flush(stream, dataInfoCallback);
            }
        }

        @Override
        public void failed(Throwable x) {
            LOG.debug(x);
            SPDYProxyEngine.this.rst(this.senderStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void data(DataInfo dataInfo) {
            Stream receiverStream;
            DataInfoCallback dataInfoCallbackToFlush = null;
            DataInfoCallback dataInfoCallBackToQueue = new DataInfoCallback(dataInfo);
            Queue<DataInfoCallback> queue = this.queue;
            synchronized (queue) {
                this.queue.offer(dataInfoCallBackToQueue);
                receiverStream = this.receiverStream;
                if (receiverStream != null) {
                    dataInfoCallbackToFlush = this.queue.peek();
                    if (dataInfoCallbackToFlush.flushing) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Queued {}, flushing {}, queue size {}", dataInfo, dataInfoCallbackToFlush.dataInfo, this.queue.size());
                        }
                        receiverStream = null;
                    } else {
                        dataInfoCallbackToFlush.flushing = true;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Queued {}, queue size {}", dataInfo, this.queue.size());
                        }
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Queued {}, SYN incomplete, queue size {}", dataInfo, this.queue.size());
                }
            }
            if (receiverStream != null) {
                this.flush(receiverStream, dataInfoCallbackToFlush);
            }
        }

        private void flush(Stream receiverStream, DataInfoCallback dataInfoCallback) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("P -> S {} on {}", dataInfoCallback.dataInfo, receiverStream);
            }
            receiverStream.data(dataInfoCallback.dataInfo, dataInfoCallback);
        }

        public Stream getSenderStream() {
            return this.senderStream;
        }

        public Info getInfo() {
            return this.info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Stream getReceiverStream() {
            Queue<DataInfoCallback> queue = this.queue;
            synchronized (queue) {
                return this.receiverStream;
            }
        }

        private class DataInfoCallback
        implements Callback {
            private final DataInfo dataInfo;
            private boolean flushing;

            private DataInfoCallback(DataInfo dataInfo) {
                this.dataInfo = dataInfo;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void succeeded() {
                DataInfoCallback dataInfoCallback;
                Stream serverStream;
                Queue queue = StreamPromise.this.queue;
                synchronized (queue) {
                    serverStream = StreamPromise.this.receiverStream;
                    assert (serverStream != null);
                    dataInfoCallback = (DataInfoCallback)StreamPromise.this.queue.poll();
                    assert (dataInfoCallback == this);
                    dataInfoCallback = (DataInfoCallback)StreamPromise.this.queue.peek();
                    if (dataInfoCallback != null) {
                        assert (!dataInfoCallback.flushing);
                        dataInfoCallback.flushing = true;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Completed {}, queue size {}", this.dataInfo, StreamPromise.this.queue.size());
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Completed {}, queue empty", this.dataInfo);
                    }
                }
                if (dataInfoCallback != null) {
                    StreamPromise.this.flush(serverStream, dataInfoCallback);
                }
            }

            @Override
            public void failed(Throwable x) {
                LOG.debug(x);
                SPDYProxyEngine.this.rst(StreamPromise.this.senderStream);
            }
        }
    }

    private class ProxyStreamFrameListener
    extends StreamFrameListener.Adapter {
        private final Stream receiverStream;

        public ProxyStreamFrameListener(Stream receiverStream) {
            this.receiverStream = receiverStream;
        }

        @Override
        public StreamFrameListener onPush(Stream senderStream, PushInfo pushInfo) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("S -> P {} on {}", new Object[0]);
            }
            PushInfo newPushInfo = SPDYProxyEngine.this.convertPushInfo(pushInfo, senderStream, this.receiverStream);
            PushStreamPromise pushStreamPromise = new PushStreamPromise(senderStream, newPushInfo);
            this.receiverStream.push(newPushInfo, pushStreamPromise);
            return new ProxyPushStreamFrameListener(pushStreamPromise);
        }

        @Override
        public void onReply(Stream stream, ReplyInfo replyInfo) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("S -> P {} on {}", replyInfo, stream);
            }
            ReplyInfo clientReplyInfo = new ReplyInfo(SPDYProxyEngine.this.convertHeaders(stream, this.receiverStream, replyInfo.getHeaders()), replyInfo.isClose());
            this.reply(stream, clientReplyInfo);
        }

        private void reply(final Stream stream, final ReplyInfo clientReplyInfo) {
            this.receiverStream.reply(clientReplyInfo, new Callback(){

                @Override
                public void succeeded() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("P -> C {} from {} to {}", clientReplyInfo, stream, ProxyStreamFrameListener.this.receiverStream);
                    }
                }

                @Override
                public void failed(Throwable x) {
                    LOG.debug(x);
                    SPDYProxyEngine.this.rst(ProxyStreamFrameListener.this.receiverStream);
                }
            });
        }

        @Override
        public void onHeaders(Stream stream, HeadersInfo headersInfo) {
            throw new UnsupportedOperationException("Not Yet Implemented");
        }

        @Override
        public void onData(Stream stream, DataInfo dataInfo) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("S -> P {} on {}", dataInfo, stream);
            }
            this.data(stream, dataInfo);
        }

        private void data(final Stream stream, final DataInfo serverDataInfo) {
            final ByteBufferDataInfo clientDataInfo = new ByteBufferDataInfo(serverDataInfo.asByteBuffer(false), serverDataInfo.isClose()){

                @Override
                public void consume(int delta) {
                    super.consume(delta);
                    serverDataInfo.consume(delta);
                }
            };
            this.receiverStream.data(clientDataInfo, new Callback(){

                @Override
                public void succeeded() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("P -> C {} from {} to {}", clientDataInfo, stream, ProxyStreamFrameListener.this.receiverStream);
                    }
                }

                @Override
                public void failed(Throwable x) {
                    LOG.debug(x);
                    SPDYProxyEngine.this.rst(ProxyStreamFrameListener.this.receiverStream);
                }
            });
        }
    }

    private class ProxyPushStreamFrameListener
    implements StreamFrameListener {
        private PushStreamPromise pushStreamPromise;

        private ProxyPushStreamFrameListener(PushStreamPromise pushStreamPromise) {
            this.pushStreamPromise = pushStreamPromise;
        }

        @Override
        public StreamFrameListener onPush(Stream stream, PushInfo pushInfo) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("S -> P pushed {} on {}. Opening new PushStream P -> C now.", pushInfo, stream);
            }
            PushStreamPromise newPushStreamPromise = new PushStreamPromise(stream, pushInfo);
            this.pushStreamPromise.push(newPushStreamPromise);
            return new ProxyPushStreamFrameListener(newPushStreamPromise);
        }

        @Override
        public void onReply(Stream stream, ReplyInfo replyInfo) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onHeaders(Stream stream, HeadersInfo headersInfo) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onData(Stream serverStream, final DataInfo serverDataInfo) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("S -> P pushed {} on {}", serverDataInfo, serverStream);
            }
            ByteBufferDataInfo clientDataInfo = new ByteBufferDataInfo(serverDataInfo.asByteBuffer(false), serverDataInfo.isClose()){

                @Override
                public void consume(int delta) {
                    super.consume(delta);
                    serverDataInfo.consume(delta);
                }
            };
            this.pushStreamPromise.data(clientDataInfo);
        }

        @Override
        public void onFailure(Stream stream, Throwable x) {
            LOG.debug(x);
        }
    }
}

