/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.extended;

import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.LanguageCodeStylePropertyMapper;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import org.editorconfig.configmanagement.extended.EditorConfigPropertyKind;
import org.editorconfig.configmanagement.extended.IntellijPropertyKindMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorConfigIntellijNameUtil {
    public static final String IDE_PREFIX = "ij_";
    static final String GENERIC_PROPERTY_PREFIX = "any_";
    static final String GENERIC_OPTION_KEY_PREFIX = "ij_any_";

    private EditorConfigIntellijNameUtil() {
    }

    @NotNull
    public static List<String> toEditorConfigNames(@NotNull AbstractCodeStylePropertyMapper mapper, @NotNull String propertyName) {
        if (mapper == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(0);
        }
        if (propertyName == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(1);
        }
        if (EditorConfigIntellijNameUtil.isIgnored(propertyName)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                EditorConfigIntellijNameUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<Object> list = switch (IntellijPropertyKindMap.getPropertyKind(propertyName)) {
            default -> throw new IncompatibleClassChangeError();
            case EditorConfigPropertyKind.EDITOR_CONFIG_STANDARD -> List.of(propertyName);
            case EditorConfigPropertyKind.LANGUAGE -> {
                if (mapper instanceof LanguageCodeStylePropertyMapper) {
                    yield List.of(EditorConfigIntellijNameUtil.getLanguageProperty(mapper, propertyName));
                }
                yield List.of();
            }
            case EditorConfigPropertyKind.COMMON -> List.of(GENERIC_OPTION_KEY_PREFIX + propertyName, EditorConfigIntellijNameUtil.getLanguageProperty(mapper, propertyName));
            case EditorConfigPropertyKind.GENERIC -> List.of(IDE_PREFIX + propertyName);
            case EditorConfigPropertyKind.UNSUPPORTED, EditorConfigPropertyKind.JB_STANDARD -> List.of();
        };
        if (list == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public static String getLanguageProperty(@NotNull AbstractCodeStylePropertyMapper mapper, @NotNull String propertyName) {
        if (mapper == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(4);
        }
        if (propertyName == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(5);
        }
        String string = IDE_PREFIX + mapper.getLanguageDomainId() + "_" + propertyName;
        if (string == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String toIntellijName(@NotNull String editorConfigName) {
        if (editorConfigName == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(7);
        }
        String string = StringUtil.trimStart((String)StringUtil.trimStart((String)editorConfigName, (String)IDE_PREFIX), (String)GENERIC_PROPERTY_PREFIX);
        if (string == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public static String extractLanguageDomainId(@NotNull String propertyName) {
        String id;
        int separatorPos;
        if (propertyName == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(9);
        }
        if (propertyName.startsWith(IDE_PREFIX) && (separatorPos = (id = StringUtil.trimStart((String)propertyName, (String)IDE_PREFIX)).indexOf("_")) > 0) {
            id = id.substring(0, separatorPos);
            return id;
        }
        return null;
    }

    public static boolean isIndentProperty(@NotNull String propertyName) {
        if (propertyName == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(10);
        }
        return "indent_size".equals(propertyName = StringUtil.trimStart((String)propertyName, (String)IDE_PREFIX)) || "indent_style".equals(propertyName) || "tab_width".equals(propertyName) || "continuation_indent_size".equals(propertyName);
    }

    public static boolean isIgnored(@NotNull String propertyName) {
        if (propertyName == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(11);
        }
        return "uniform_indent".equals(propertyName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/extended/EditorConfigIntellijNameUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorConfigName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/extended/EditorConfigIntellijNameUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toEditorConfigNames";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageProperty";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toIntellijName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toEditorConfigNames";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageProperty";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toIntellijName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extractLanguageDomainId";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isIndentProperty";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 8 -> new IllegalStateException(string);
        };
    }
}

