/*
 * Decompiled with CFR 0.152.
 */
package com.aayushatharva.brotli4j.decoder;

import com.aayushatharva.brotli4j.decoder.DecoderJNI;
import com.aayushatharva.brotli4j.decoder.DirectDecompress;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;

public class Decoder {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final ReadableByteChannel source;
    private final DecoderJNI.Wrapper decoder;
    ByteBuffer buffer;
    boolean closed;
    boolean eager;

    public Decoder(ReadableByteChannel source, int inputBufferSize) throws IOException {
        if (inputBufferSize <= 0) {
            throw new IllegalArgumentException("buffer size must be positive");
        }
        if (source == null) {
            throw new NullPointerException("source can not be null");
        }
        this.source = source;
        this.decoder = new DecoderJNI.Wrapper(inputBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DirectDecompress decompress(byte[] data) throws IOException {
        DecoderJNI.Wrapper decoder = new DecoderJNI.Wrapper(data.length);
        ArrayList<byte[]> output = new ArrayList<byte[]>();
        int totalOutputSize = 0;
        try {
            decoder.getInputBuffer().put(data);
            decoder.push(data.length);
            block9: while (decoder.getStatus() != DecoderJNI.Status.DONE) {
                switch (decoder.getStatus()) {
                    case OK: {
                        decoder.push(0);
                        continue block9;
                    }
                    case NEEDS_MORE_OUTPUT: {
                        ByteBuffer buffer = decoder.pull();
                        byte[] chunk = new byte[buffer.remaining()];
                        buffer.get(chunk);
                        output.add(chunk);
                        totalOutputSize += chunk.length;
                        continue block9;
                    }
                    case NEEDS_MORE_INPUT: {
                        decoder.push(0);
                        if (decoder.getStatus() != DecoderJNI.Status.NEEDS_MORE_INPUT) continue block9;
                        DirectDecompress directDecompress = new DirectDecompress(decoder.getStatus(), null, null);
                        return directDecompress;
                    }
                }
                DirectDecompress directDecompress = new DirectDecompress(decoder.getStatus(), null, null);
                return directDecompress;
            }
        }
        finally {
            decoder.destroy();
        }
        if (output.size() == 1) {
            return new DirectDecompress(decoder.getStatus(), (byte[])output.get(0), null);
        }
        byte[] result = new byte[totalOutputSize];
        int offset = 0;
        for (byte[] chunk : output) {
            System.arraycopy(chunk, 0, result, offset, chunk.length);
            offset += chunk.length;
        }
        return new DirectDecompress(decoder.getStatus(), result, null);
    }

    private void fail(String message) throws IOException {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new IOException(message);
    }

    void attachDictionary(ByteBuffer dictionary) throws IOException {
        if (!this.decoder.attachDictionary(dictionary)) {
            this.fail("failed to attach dictionary");
        }
    }

    public void enableEagerOutput() {
        this.eager = true;
    }

    int decode() throws IOException {
        block6: while (true) {
            if (this.buffer != null) {
                if (!this.buffer.hasRemaining()) {
                    this.buffer = null;
                } else {
                    return this.buffer.remaining();
                }
            }
            switch (this.decoder.getStatus()) {
                case DONE: {
                    return -1;
                }
                case OK: {
                    this.decoder.push(0);
                    continue block6;
                }
                case NEEDS_MORE_INPUT: {
                    if (this.eager && this.decoder.hasOutput()) {
                        this.buffer = this.decoder.pull();
                        continue block6;
                    }
                    ByteBuffer inputBuffer = this.decoder.getInputBuffer();
                    ((Buffer)inputBuffer).clear();
                    int bytesRead = this.source.read(inputBuffer);
                    if (bytesRead == -1) {
                        this.fail("unexpected end of input");
                    }
                    if (bytesRead == 0) {
                        this.buffer = EMPTY_BUFFER;
                        return 0;
                    }
                    this.decoder.push(bytesRead);
                    continue block6;
                }
                case NEEDS_MORE_OUTPUT: {
                    this.buffer = this.decoder.pull();
                    continue block6;
                }
            }
            this.fail("corrupted input");
        }
    }

    void discard(int length) {
        ((Buffer)this.buffer).position(this.buffer.position() + length);
        if (!this.buffer.hasRemaining()) {
            this.buffer = null;
        }
    }

    int consume(ByteBuffer dst) {
        ByteBuffer slice = this.buffer.slice();
        int limit = Math.min(slice.remaining(), dst.remaining());
        ((Buffer)slice).limit(limit);
        dst.put(slice);
        this.discard(limit);
        return limit;
    }

    void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.decoder.destroy();
        this.source.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] data, int offset, int length) throws IOException {
        DecoderJNI.Wrapper decoder = new DecoderJNI.Wrapper(length);
        ArrayList<byte[]> output = new ArrayList<byte[]>();
        int totalOutputSize = 0;
        try {
            decoder.getInputBuffer().put(data, offset, length);
            decoder.push(length);
            block8: while (decoder.getStatus() != DecoderJNI.Status.DONE) {
                switch (decoder.getStatus()) {
                    case OK: {
                        decoder.push(0);
                        continue block8;
                    }
                    case NEEDS_MORE_OUTPUT: {
                        ByteBuffer buffer = decoder.pull();
                        byte[] chunk = new byte[buffer.remaining()];
                        buffer.get(chunk);
                        output.add(chunk);
                        totalOutputSize += chunk.length;
                        continue block8;
                    }
                    case NEEDS_MORE_INPUT: {
                        decoder.push(0);
                        if (decoder.getStatus() != DecoderJNI.Status.NEEDS_MORE_INPUT) continue block8;
                        throw new IOException("corrupted input");
                    }
                }
                throw new IOException("corrupted input");
            }
        }
        finally {
            decoder.destroy();
        }
        if (output.size() == 1) {
            return (byte[])output.get(0);
        }
        byte[] result = new byte[totalOutputSize];
        int resultOffset = 0;
        for (byte[] chunk : output) {
            System.arraycopy(chunk, 0, result, resultOffset, chunk.length);
            resultOffset += chunk.length;
        }
        return result;
    }
}

