/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker;

import nu.validator.checker.Checker;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RdfaLiteChecker
extends Checker {
    private static final String GUIDANCE = " Consider checking against the HTML5 + RDFa 1.1 schema instead.";

    private void warnNonRDFaLite(String localName, String att) throws SAXException {
        this.warn("RDFa Core attribute \u201c" + att + "\u201d is not allowed on the \u201c" + localName + "\u201d element in HTML5 + RDFa 1.1 Lite documents." + GUIDANCE);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("http://www.w3.org/1999/xhtml" != uri) {
            return;
        }
        int len = atts.getLength();
        for (int i = 0; i < len; ++i) {
            String att = atts.getLocalName(i);
            if ("datatype" == att || "about" == att || "inlist" == att || "rev" == att) {
                this.warn("RDFa Core attribute \u201c" + att + "\u201d is not allowed in HTML5 + RDFa 1.1 Lite documents." + GUIDANCE);
                continue;
            }
            if ("content" == att && "meta" != localName) {
                this.warnNonRDFaLite(localName, att);
                continue;
            }
            if ("rel" != att || "a" == localName || "area" == localName || "link" == localName) continue;
            this.warnNonRDFaLite(localName, att);
        }
    }
}

