/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.hash;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.auth.UserImportHash;
import java.util.Map;

abstract class RepeatableHash
extends UserImportHash {
    private final int rounds;

    RepeatableHash(String name, int min, int max, Builder builder) {
        super(name);
        Preconditions.checkArgument((builder.rounds >= min && builder.rounds <= max ? 1 : 0) != 0, (String)"Rounds value must be between %s and %s (inclusive).", (int)min, (int)max);
        this.rounds = builder.rounds;
    }

    @Override
    protected Map<String, Object> getOptions() {
        return ImmutableMap.of((Object)"rounds", (Object)this.rounds);
    }

    static abstract class Builder<T extends Builder, U extends UserImportHash> {
        private int rounds;

        Builder() {
        }

        protected abstract T getInstance();

        public T setRounds(int rounds) {
            this.rounds = rounds;
            return this.getInstance();
        }

        public abstract U build();
    }
}

