// SPDX-FileCopyrightText: Copyright 2022 yuzu Emulator Project
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include <string>

#include "audio_core/renderer/command/icommand.h"
#include "common/common_types.h"

namespace AudioCore::AudioRenderer {
namespace ADSP {
class CommandListProcessor;
}

/**
 * AudioRenderer command for preparing depop.
 * Adds the previusly output last samples to the depop buffer.
 */
struct DepopPrepareCommand : ICommand {
    /**
     * Print this command's information to a string.
     *
     * @param processor - The CommandListProcessor processing this command.
     * @param string    - The string to print into.
     */
    void Dump(const ADSP::CommandListProcessor& processor, std::string& string) override;

    /**
     * Process this command.
     *
     * @param processor - The CommandListProcessor processing this command.
     */
    void Process(const ADSP::CommandListProcessor& processor) override;

    /**
     * Verify this command's data is valid.
     *
     * @param processor - The CommandListProcessor processing this command.
     * @return True if the command is valid, otherwise false.
     */
    bool Verify(const ADSP::CommandListProcessor& processor) override;

    /// Depop buffer offset for each mix buffer
    std::array<s16, MaxMixBuffers> inputs;
    /// Pointer to the previous mix buffer samples
    CpuAddr previous_samples;
    /// Number of mix buffers to use
    u32 buffer_count;
    /// Pointer to the current depop values
    CpuAddr depop_buffer;
};

} // namespace AudioCore::AudioRenderer
