/*
 * sact.c: SACT
 *
 * Copyright (C) 1997-1998 Masaki Chikama (Wren) <chikama@kasumi.ipl.mech.nagoya-u.ac.jp>
 *               1998-                           <masaki-c@is.aist-nara.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/
/* $Id: SACT.c,v 1.10 2004/10/31 04:18:02 chikama Exp $ */

#include "config.h"

#include <stdio.h>
#include <string.h>
#include <glib.h>

#include "portab.h"
#include "system.h"
#include "imput.h"
#include "xsystem35.h"
#include "gametitle.h"
#include "message.h"
#include "nact.h"
#include "sact.h"
#include "sprite.h"
#include "sactcg.h"
#include "sactstring.h"
#include "sactsound.h"
#include "sactbgm.h"
#include "sactcrypto.h"
#include "sactchart.h"
#include "ngraph.h"
#include "surface.h"
#include "sactamask.h"

/*
  MTޥɤꤵ줿ʸˤäơС֤ΰ㤤ۼ

  Version 1.0 : 쥤䡼
          1.1 : Rance5D
          1.2(): ʤߤ
          1.2(): SACTȯå, 롦쥤, NightDemon
*/ 

/*
  ʤߤ

  åå(ɡ̤ɴطʤå) -> Ctrl
  ưå -> A
    A򲡤ȤǡưŪ˥åǹԤޤ(ưå
    ꤬ONˤʤȡåɤαˤԤ(>>>>)
    äޤϡդ⤷ϲλޤǡA򲡤³
    AΥȤˡԤ뤬ɽв줿
    Ȥˤʤޤ
  Хå -> ۥ
*/


/*
   wNum ϰϤʤɡΥåϳƥ֥ƥǤ롣


ǧ
  SACT.CreateSprite ϤθƤФ줿ִ֤CGѤ
    ->SACT.DrawޤǤCGѹƤ⡢CreateCG
  OutputMessageϥåɽޤǤɤäƤʤ
  QuakeScreenϽλޤǤɤäƤʤ(ȴ)
  ưԤϤʤ
  OutputMessage ƻϤƣʸŤԤNewLineǤϽ񤫤ʤ
  ~KEY 2: ľƤSP_MOVEλޤǥåץ饤ȿʤ
  drag˥åץ饤Ȥȿʤ
  ˥᡼󥹥ץ饤ȤϤĤͤư
  åץ饤Ȥϡܥ󤬲֤ǥץ饤ä褿Ȥ⡢
  cg3Ѳ롣ΤȤܥΥƤ SpriteKeyWaitȴʤ
  ޤܥ򲡤ޤޥץ饤ȳ˽ФƤ⡢Фcg1Ѳ
  GETA/BեCG2˥ܥ󲡲CG3
  SWPUTϥܥ󲡲ȴ
*/


// SACT Ϣξ
sact_t sactprv;
extern char *xsys35_sact01;

/**
 * SACT.Init (1.0~)
 *   SACTΤν
 */
void Init() {
	int p1 = getCaliValue(); /* ISys3x */
	
	// ॿȥˤС
	if (0 == strcmp(nact->game_title_name, GT_ESUKA)) {
		sact.version = 100;
	} else if (0 == strcmp(nact->game_title_name, GT_RANCE5D)){
		sact.version = 110;
	} else {
		sact.version = 120;
	}
	
	NOTICE("SACT version = %d\n", sact.version);
	
	// ɸ
	sact.origin.x = 0;
	sact.origin.y = 0;
	
	// ƥ֥ƥ
	sp_init();
	sstr_init();
	ssel_init();
	stimer_init();
	ssnd_init();
	
	if (nact->files.sact01) {
		smask_init(nact->files.sact01);
	}
	
	// create depth map
	sact.dmap = sf_create_pixel(sf0->width, sf0->height, 16);
	
	// ¾ System35 Υǥեưѹ
	nact->ags.font->antialiase_on = TRUE;
	sys_setHankakuMode(2); // ȾѴ̵
	ags_autorepeat(FALSE); // key auto repeat off
	
	if (sact.version >= 120) {
		sact.logging = TRUE;
	} else {
		sact.logging = FALSE;
	}
	
	DEBUG_COMMAND("SACT.Init %d:\n", p1);
}

/**
 * SACT.CreateSprite (1.0~)
 *   ץ饤Ⱥ
 *   @param wNum: ץ饤ֹ
 *   @param wNumCG1: ̾ɽãֹ
 *   @param wNumCG2: ޥŤͤȤΣãֹ
 *   @param wNumCG3: åȤΣãֹ
 *   @param wType: ץ饤ȤΥ
 */
void CreateSprite() {
	int wNum    = getCaliValue();
	int wNumCG1 = getCaliValue();
	int wNumCG2 = getCaliValue();
	int wNumCG3 = getCaliValue();
	int wType   = getCaliValue();
	
	sp_new(wNum, wNumCG1, wNumCG2, wNumCG3, wType);
	
	DEBUG_COMMAND_YET("SACT.CreateSprite %d,%d,%d,%d,%d:\n", wNum, wNumCG1, wNumCG2, wNumCG3, wType);
}

/**
 * SACT.CreateTextSprite (1.0~)
 *   åɽ륹ץ饤Ȥκ
 *   @param wNum: ץ饤ֹ
 *   @param wX: ɽ֤Σغɸ
 *   @param wY: ɽ֤Σٺɸ
 *   @param wWidth: ץ饤Ȥ
 *   @param wHeight: ץ饤Ȥι⤵
 */
void CreateTextSprite() {
	int wNum = getCaliValue();
	int wX   = getCaliValue();
	int wY   = getCaliValue();
	int wWidth  = getCaliValue();
	int wHeight = getCaliValue();
	
	sp_new_msg(wNum, wX, wY, wWidth, wHeight);
	
	DEBUG_COMMAND_YET("SACT.CreateTextSprite %d,%d,%d,%d,%d:\n", wNum, wX, wY, wWidth, wHeight);
}

/**
 * SACT.SetWallPaper (1.0~)
 *   ɻ(ط)ȤɽãǤ
 *   @param wNum: ɻ(ط)ȤɽãǤֹ
 */
void SetWallPaper() {
	int wNum = getCaliValue();
	
	sp_set_wall_paper(wNum);
	
	DEBUG_COMMAND_YET("SACT.SetWallPaper %d:\n", wNum);
}

/**
 * SACT.Clear (1.0~)
 *   ץ饤Ⱥ(~SP_CLR)
 */
void Clear() {
	sp_free_all();
	
	DEBUG_COMMAND_YET("SACT.Clear:\n");
}

/**
 * SACT.Delete (1.0~)
 *   ץ饤Ȥκ
 *   @param wNum: 륹ץ饤ֹ
 */
void Delete() {
	int wNum = getCaliValue();
	
	sp_free(wNum);
	
	DEBUG_COMMAND_YET("SACT.Delete %d:\n", wNum);
}

/**
 * SACT.SpriteDeleteCount (1.0~)
 *   wNum֤wCountĤϰϤΥץ饤Ȥκ
 *   @param wNum: Ƭץ饤ֹ
 *   @param wCount: ϰ
 */
void SpriteDeleteCount() {
	int wNum   = getCaliValue();
	int wCount = getCaliValue();
	int i;
	
	for (i = wNum; i < (wNum + wCount); i++) {
		sp_free(i);
	}
	
	DEBUG_COMMAND_YET("SACT.SpriteDeleteCount %d,%d:\n", wNum, wCount);
}

/**
 * SACT.Draw (1.0~)
 *   ꤵƤ륹ץ饤Ⱦ֤̤ȿ(~SP_UPDATE)
 */
void Draw() {
	sp_update_all(TRUE);

	DEBUG_COMMAND_YET("SACT.Draw:\n");
}

/**
 * SCAT.DrawEffect (1.0~)
 *   ̻դ̹
 *   @param wType: եȥ
 *   @param wEffectTime: եȤλ(1/100ñ)
 *   @param wEffectKey: ȴ (1.1~) (1ͭ)
 */
void DrawEffect() {
	int wType       = getCaliValue();
	int wEffectTime = getCaliValue();
	int wEffectkey = 1;
	
	if (sact.version >= 110) {
		wEffectkey = getCaliValue();
	}
	
	sp_eupdate(wType, wEffectTime, wEffectkey);
	
	DEBUG_COMMAND_YET("SACT.DrawEffect %d,%d,%d:\n", wType, wEffectTime, wEffectkey);
}

/**
 * SCAT.DrawEffectAlphaMap (1.1~)
 *   ޥĤ̹
 *   @param nIndexAlphaMap: ޥֹ
 *   @param wEffectTime: եȤλ(1/100ñ)
 *   @param wEffectKey: ȴ
 */
void DrawEffectAlphaMap() {
	int nIndexAlphaMap = getCaliValue();
	int wEffectTime = getCaliValue();
	int wEffectKey  = getCaliValue();
	
	sp_eupdate_amap(nIndexAlphaMap, wEffectTime, wEffectKey);
	
	DEBUG_COMMAND_YET("SACT.DrawEffectAlphaMap %d,%d,%d:\n", nIndexAlphaMap, wEffectTime, wEffectKey);
}

/**
 * SCAT.QuakeScreen (1.0~)
 *   ɤ餷
 *   @param wType: 0=Ĳ, 1:ž
 *   @param wParam1: wType=0ΤȤxο
 *                   wType=1ΤȤ
 *   @param wParam2: wType=0ΤȤyο
 *                   wType=1ΤȤž
 *   @param wCount: (1/100)
 *   @param nfKeyEnable: ȴ (1ͭ) (1.1~) 
 */
void QuakeScreen() {
	int wType   = getCaliValue();
	int wParam1 = getCaliValue();
	int wParam2 = getCaliValue();
	int wCount  = getCaliValue();
	int nfKeyEnable = 1;
	
	if (sact.version >= 110) {
		nfKeyEnable = getCaliValue();
	}
	
	sp_quake_screen(wType, wParam1, wParam2, wCount, nfKeyEnable);
	
	DEBUG_COMMAND_YET("SACT.QuakeScreen %d,%d,%d,%d,%d:\n", wType, wParam1, wParam2, wCount, nfKeyEnable);
}

/**
 * SACT.SetOrigin (1.0~)
 *   ɸѹ
 *   @param wX: ˤغɸΰ
 *   @param wY: ˤٺɸΰ
 */
void SetOrigin() {
	int wX = getCaliValue();
	int wY = getCaliValue();
	
	sact.origin.x = wX;
	sact.origin.y = wY;
	
	DEBUG_COMMAND_YET("SACT.SetOrigin %d,%d:\n", wX, wY);
}

/**
 * SACT.SetShow (1.0~)
 *   ץ饤Ȥɽ֤ѹ
 *   @param wNum: ƬΥץ饤ֹ
 *   @param wCount: ɽĿ
 *   @param wShow: 0:ɽ, 1:ɽ
 */
void SetShow() {
	int wNum   = getCaliValue();
	int wCount = getCaliValue();
	int wShow  = getCaliValue();
	
	sp_set_show(wNum, wCount, wShow);

	DEBUG_COMMAND_YET("SACT.SetShow %d,%d,%d:\n", wNum, wCount, wShow);
}

/**
 * SACT.SetBlendRate (1.1~)
 *   ץ饤Ȥɽ֤ѹ
 *   @param wNum: ƬΥץ饤ֹ
 *   @param wCount: ɽĿ
 *   @param nBlendRate: ֥Ψ
 */
void SetBlendRate() {
	int wNum   = getCaliValue();
	int wCount = getCaliValue();
	int nBlendRate  = getCaliValue();
	
	sp_set_blendrate(wNum, wCount, nBlendRate);
	
	DEBUG_COMMAND_YET("SACT.SetBlendRate %d,%d,%d:\n", wNum, wCount, nBlendRate);
}

/**
 * SACT.SetPos (1.0~)
 *   ץ饤Ȥɽ֤(ѹ)
 *   @param wNum: ץ饤ֹ
 *   @param wX: ɽغɸ
 *   @param wY: ɽٺɸ
 */
void SetPos() {
	int wNum = getCaliValue();
	int wX  = getCaliValue();
	int wY  = getCaliValue();
	
	sp_set_pos(wNum, wX, wY);
	
	DEBUG_COMMAND_YET("SACT.SetPos %d,%d,%d:\n", wNum, wX, wY);
}

/**
 * SACT.SetMove (1.0~)
 *   ץ饤Ȥΰư (˽᤹)
 *   @param wNum: ץ饤ֹ
 *   @param wX: ɽغɸ
 *   @param wY: ɽٺɸ
 */
void SetMove() {
	int wNum = getCaliValue();
	int wX   = getCaliValue();
	int wY   = getCaliValue();
	
	sp_set_move(wNum, wX, wY);
	
	DEBUG_COMMAND_YET("SACT.SetMove %d,%d,%d:\n", wNum, wX, wY);
}

/**
 * SACT.SetMoveTime (1.0~)
 *   SetMoveˤ륹ץ饤Ȱưλ֤
 *   @param wNum: ץ饤ֹ
 *   @param wTime: ưλޤǤλ(1/100ñ)
 */
void SetMoveTime() {
	int wNum  = getCaliValue();
	int wTime = getCaliValue();
	
	sp_set_movetime(wNum, wTime);
	
	DEBUG_COMMAND_YET("SACT.SetMoveTime %d,%d:\n", wNum, wTime);
}

/**
 * SACT.SetMoveSpeed (1.0~)
 *   SetMoveˤ륹ץ饤Ȱư®٤
 *   @param wNum: ץ饤ֹ
 *   @param wSpeed: ư®(ǥեȤ100%Ȥ%)
 */
void SetMoveSpeed() {
	int wNum   = getCaliValue();
	int wSpeed = getCaliValue();
	
	sp_set_movespeed(wNum, wSpeed);
	
	DEBUG_COMMAND_YET("SACT.SetMoveSpeed %d,%d:\n", wNum, wSpeed);
}

/**
 * SACT.SetMoveSpeedCount (1.0~)
 *   ʣΥץ饤ȤФ륹ץ饤Ȱư®٤
 *   @param wNum: Ƭץ饤ֹ
 *   @param wCount: ϰ
 *   @param wSpeed: ư®(ǥեȤ100%Ȥ%)
 */
void SetMoveSpeedCount() {
	int wNum   = getCaliValue();
	int wCount = getCaliValue();
	int wSpeed = getCaliValue();
	int i;
	
	for (i = wNum; i < (wNum + wCount); i++) {
		sp_set_movespeed(i, wSpeed);
	}
	
	DEBUG_COMMAND_YET("SACT.SetMoveSpeedCount %d,%d,%d:\n", wNum, wCount, wSpeed);
}

/**
 * SACT.SetSpriteAnimeTimeInterval (1.1~)
 *   ʣΥץ饤ȤФ륢˥᡼󥹥ץ饤Ȥδֳ
 *   @param wNum: Ƭץ饤ֹ
 *   @param wCount: ϰ
 *   @param nTime: ֳ 
 */
void SetSpriteAnimeTimeInterval() {
	int wNum   = getCaliValue();
	int wCount = getCaliValue();
	int nTime  = getCaliValue();
	int i;
	
	for (i = wNum; i < (wNum + wCount); i++) {
		sp_set_animeinterval(i, nTime);
	}
	
	DEBUG_COMMAND_YET("SACT.SetSpriteAnimeTimeInterval %d,%d,%d:\n", wNum, wCount, nTime);
}

/**
 * SACT.AddZKeyHideSprite (1.0~)
 *   ԤZ줿ȤɽOFFˤʤ륹ץ饤ȤϿ
 *   @param wNum: ץ饤ֹ
 */
void AddZKeyHideSprite() {
	int wNum = getCaliValue();
	
	sp_add_zkey_hidesprite(wNum);
	
	DEBUG_COMMAND_YET("SACT.AddZKeyHideSprite %d:\n", wNum);
}

/**
 * SACT.ClearZKeyHideSprite (1.0~)
 *   AddZKeyHideSpriteϿץ饤ֹƥꥢ
 */
void ClearZKeyHideSprite() {
	sp_clear_zkey_hidesprite_all();
	
	DEBUG_COMMAND_YET("SACT.ClearZKeyHideSprite:\n");
}

/**
 * SACT.SpriteFreeze (1.0~)
 *   ץ饤ȥåwIndexξ֤Ǹꤷ~KEY 2:ʤɤȿʤ
 *   褦ˤ
 *   @param wNum: ץ饤ֹ
 *   @param wIndex: ꤹֹ(1-3)
 */
void SpriteFreeze() {
	int wNum   = getCaliValue();
	int wIndex = getCaliValue();
	
	sp_freeze_sprite(wNum, wIndex);
	
	DEBUG_COMMAND_YET("SACT.SpriteFreeze %d,%d:\n", wNum, wIndex);
}

/**
 * SACT.SpriteThaw (1.0~)
 *   Freezeץ饤Ⱦ֤
 *   @param wNum: ץ饤ֹ
 */
void SpriteThaw() {
	int wNum = getCaliValue();
	
	sp_thaw_sprite(wNum);

	DEBUG_COMMAND_YET("SACT.SpriteThaw %d:\n", wNum);
}

/**
 * SACT.SpriteFreezeCount (1.0~)
 *   ʣΥץ饤ȤFreeze
 *   @param wNum: Ƭץ饤ֹ
 *   @param wCount: ϰ
 *   @param wIndex: ꤹֹ
 */
void SpriteFreezeCount() {
	int wNum   = getCaliValue();
	int wCount = getCaliValue();
	int wIndex = getCaliValue();
	int i;

	for (i = wNum; i < (wNum + wCount); i++) {
		sp_freeze_sprite(i, wIndex);
	}
	
	DEBUG_COMMAND_YET("SACT.SpriteFreezeCount %d,%d,%d:\n", wNum, wCount, wIndex);
}

/**
 * SACT.SpriteThawCount (1.0~)
 *    ʣFreezeץ饤Ⱦ֤β
 *    @param wNum: Ƭץ饤ֹ
 *    @param wCount: ϰ
 */
void SpriteThawCount() {
	int wNum   = getCaliValue();
	int wCount = getCaliValue();
	int i;
	
	for (i = wNum; i < (wNum + wCount); i++) {
		sp_thaw_sprite(i);
	}
	
	DEBUG_COMMAND_YET("SACT.SpriteThawCount %d,%d:\n", wNum, wCount);
}

/**
 * SACT.QuakeSpriteAdd (1.0~)
 *   QuakeSpriteɤ餹ץ饤Ȥɲ
 *   @param wNum: ץ饤ֹ
 */
void QuakeSpriteAdd() {
	int wNum = getCaliValue();
	
	sp_add_quakesprite(wNum);
	
	DEBUG_COMMAND_YET("SACT.QuakeSpriteAdd %d:\n", wNum);
}

/**
 * SACT.QuakeSpriteReset (1.0~)
 *   QuakeSpriteAddƲ
 */
void QuakeSpriteReset() {
	sp_clear_quakesprite_all();
	DEBUG_COMMAND_YET("SACT.QuakeSpriteReset:\n");
}

/**
 * SACT.QuakeSprite (1.0~)
 *   QuakeSpriteAddꤷץ饤Ȥɤ餹
 *   @param wType: 0:Ĳ(ƤΥץ饤ȤƱ褦ɤ餹)
 *                 1:Ĳ(ƤΥץ饤ȤХХɤ餹)
 *   @param wAmplitudeX: ο
 *   @param wAmplitudeY: ο
 *   @param wCount: (1/100)
 *   @param nfKeyEnable: (1.1~): 󥻥뤢(=1)
 */
void QuakeSprite() {
	int wType       = getCaliValue();
	int wAmplitudeX = getCaliValue();
	int wAmplitudeY = getCaliValue();
	int wCount      = getCaliValue();
	int nfKeyEnable = 0;

	if (sact.version >= 110) {
		nfKeyEnable = getCaliValue();
	}
	
	sp_quake_sprite(wType, wAmplitudeX, wAmplitudeY, wCount, nfKeyEnable);
	
	DEBUG_COMMAND_YET("SACT.QuakeSprite %d,%d,%d,%d:\n", wType, wAmplitudeX, wAmplitudeY, wCount);
}

/**
 * SACT.QuerySpriteIsExist (1.0~)
 *  Υץ饤ȤϿƤ뤫ɤ
 *  @param wNum: ץ饤ֹ
 *  @param var: Ͽ֤֤ѿ 0: ̤Ͽ, 1:Ͽ
 */
void QuerySpriteIsExist() {
	int wNum = getCaliValue();
	int *var = getCaliVariable();

	sp_query_isexist(wNum, var);
	
	DEBUG_COMMAND_YET("SACT.QuerySpriteIsExist %d,%p:\n", wNum, var);
}

/**
 * SACT.QuerySpriteInfo (1.0~)
 *   ץ饤Ȥξ
 *   @param wNum: ץ饤ֹ
 *   @param vType: ץ饤ȥסƥȥץ饤Ȥξ100
 *   @param vCG1: ãǣ(ʤϣ)
 *   @param vCG2: ãǣ(ʤϣ)
 *   @param vCG3: ãǣ(ʤϣ)
 */
void QuerySpriteInfo() {
	int wNum   = getCaliValue();
	int *vType = getCaliVariable();
	int *vCG1  = getCaliVariable();
	int *vCG2  = getCaliVariable();
	int *vCG3  = getCaliVariable();
	
	sp_query_info(wNum, vType, vCG1, vCG2, vCG3);
	
	DEBUG_COMMAND_YET("SACT.QuerySpriteInfo %d,%p,%p,%p,%p:\n", wNum, vType, vCG1, vCG2, vCG3);
}

/**
 * SACT.QuerySpriteShow (1.0~)
 *   ץ饤Ȥɽ(SP_SHOW)
 *   @param wNum: ץ饤ֹ
 *   @param vShow: 0:ɽ, 1:ɽ
 */
void QuerySpriteShow() {
	int wNum = getCaliValue();
	int *vShow = getCaliVariable();

	sp_query_show(wNum, vShow);
	
	DEBUG_COMMAND_YET("SACT.QuerySpriteShow %d,%p:\n", wNum, vShow);
}

/**
 * SACT.QuerySpritePos (1.0~)
 *   ץ饤Ȥɽ֤μ
 *   @param wNum: ץ饤ֹ
 *   @param vX: غɸ
 *   @param vY: ٺɸ
 */
void QuerySpritePos() {
	int wNum = getCaliValue();
	int *vX  = getCaliVariable();
	int *vY  = getCaliVariable();
	
	sp_query_pos(wNum, vX, vY);
	
	DEBUG_COMMAND_YET("SACT.QuerySpritePos %d,%p,%p:\n", wNum, vX, vY);
}

/**
 * SACT.QuerySpriteSize (1.0~)
 *   ץ饤Ȥ礭μ
 *   @param wNum: ץ饤ֹ
 *   @param vWidth: ץ饤Ȥ
 *   @param vHeight: ץ饤Ȥι⤵
 */
void QuerySpriteSize() {
	int wNum     = getCaliValue();
	int *vWidth  = getCaliVariable();
	int *vHeight = getCaliVariable();
	
	sp_query_size(wNum, vWidth, vHeight);
	
	DEBUG_COMMAND_YET("SACT.QuerySpriteSize %d,%p,%p:\n", wNum, vWidth, vHeight);
}

/**
 * SACT.QueryTextPos (1.2~)
 *   åץ饤Ȥʸ
 *   @param nMesSpID:
 *   @param pwX:
 *   @param pwY:
 */
void QueryTextPos() {
	int wNum = getCaliValue();
	int *vX  = getCaliVariable();
	int *vY  = getCaliVariable();
	
	sp_query_textpos(wNum, vX, vY);
	
	DEBUG_COMMAND_YET("SACT.QueryTextPos %d,%p,%p:\n", wNum, vX, vY);
}

/**
 * SCAT.CG_Clear (1.0~)
 *   CG_CreateǺCGƺ
 */
void CG_Clear() {
	scg_freeall();
	
	DEBUG_COMMAND_YET("SACT.CG_Clear:\n");
}

/**
 * SACT.CG_Reset (1.0~)
 *   CG_CreateǺCG
 *   @param wNumCG: CGֹ
 */
void CG_Reset() {
	int wNumCG = getCaliValue();
	
	scg_free(wNumCG);
	
	DEBUG_COMMAND_YET("SACT.CG_Reset %d:\n", wNumCG);
}

/**
 * SACT.CG_QueryType (1.0~)
 *   CGξ(CGΥ)
 *   @param wNumCG: CGֹ
 *   @param vType: CGμ, 0: ̤, 1:󥯤Ƥ, 2: CG_SETǺ
 *                 3: CG_REVERSEǺ, 4: CG_STRETCHǺ
 */
void CG_QueryType() {
	int wNumCG = getCaliValue();
	int *vType = getCaliVariable();
	
	scg_querytype(wNumCG, vType);
	
	DEBUG_COMMAND_YET("SACT.CG_QueryType %d,%p:\n", wNumCG, vType);
}

/**
 * SACT.CG_QuerySize (1.0~)
 *   CG礭
 *   @param wNumCG: CGֹ
 *   @param vWidth: 
 *   @param vHeight: ⤵
 */
void CG_QuerySize() {
	int wNumCG   = getCaliValue();
	int *vWidth  = getCaliVariable();
	int *vHeight = getCaliVariable();
	
	scg_querysize(wNumCG, vWidth, vHeight);
	
	DEBUG_COMMAND_YET("SACT.CG_QuerySize %d,%p,%p:\n", wNumCG, vWidth, vHeight);
}

/**
 * SACT.CG_QueryBpp (1.0~)
 *   CGbpp
 *   @param wNumCG: CGֹ
 *   @param vBpp: CGbpp
 */
void CG_QueryBpp() {
	int wNumCG = getCaliValue();
	int *vBpp  = getCaliVariable();
	
	scg_querybpp(wNumCG, vBpp);
	
	DEBUG_COMMAND_YET("SACT.CG_QueryBpp %d,%p:\n", wNumCG, vBpp);
}

/**
 * SACT.CG_ExistAlphaMap (1.0~)
 *   CGΦޥå(ޥ)УʤУ
 *   @param wNumCG: CGֹ
 *   @param vMask: 0/1
 */
void CG_ExistAlphaMap() {
	int wNumCG = getCaliValue();
	int *vMask = getCaliVariable();
	
	scg_existalphamap(wNumCG, vMask);
	
	DEBUG_COMMAND_YET("SACT.CG_ExistAlphaMap %d,%p:\n", wNumCG, vMask);
}

/**
 * SACT.CG_Create (1.0~)
 *   ꥵ֥ΨλͳѤɽ
 *   @param wNumCG: CGֹ
 *   @param wWidth: 
 *   @param wHeight: ⤵
 *   @param wR: RGBͤ(0-255)
 *   @param wG: RGBͤ(0-255)
 *   @param wB: RGBͤ(0-255)
 *   @param wBlendRate: ֥Ψ(0-255)
 */
void CG_Create() {
	int wNumCG     = getCaliValue();
	int wWidth     = getCaliValue();
	int wHeight    = getCaliValue();
	int wR         = getCaliValue();
	int wG         = getCaliValue();
	int wB         = getCaliValue();
	int wBlendRate = getCaliValue();
	
	scg_create(wNumCG, wWidth, wHeight, wR, wG, wB, wBlendRate);
	
	DEBUG_COMMAND_YET("SACT.CG_Create %d,%d,%d,%d,%d,%d,%d:\n", wNumCG, wWidth, wHeight, wR, wG, wB, wBlendRate);
}

/**
 * SACT,CG_CreateReverse (1.0~)
 *   ˤʤCGȿžCG
 *   @param wNumCG: CGֹ
 *   @param wNumSrcCG: ԡθˤʤCGֹ
 *   @param wReverseX: Xȿžå(0:ȿžʤ1:ȿž)
 *   @param wReverseY: Yȿžå(0:ȿžʤ1:ȿž)
 */
void CG_CreateReverse() {
	int wNumCG = getCaliValue();
	int wNumSrcCG = getCaliValue();
	int wReverseX = getCaliValue();
	int wReverseY = getCaliValue();

	scg_create_reverse(wNumCG, wNumSrcCG, wReverseX, wReverseY);
	
	DEBUG_COMMAND_YET("SACT.CG_CreateReverse %d,%d,%d,%d:\n", wNumCG, wNumSrcCG, wReverseX, wReverseY);
}

/**
 * SACT.CG_CreateStretch (1.0~)
 *   ˤʤCG⤷Ͻ̾CG
 *   @param wNumCG: CGֹ
 *   @param wWidth: CG
 *   @param wHeight: CGι⤵
 *   @param wNumSrcCG: ˤʤCGֹ
 */
void CG_CreateStretch() {
	int wNumCG    = getCaliValue();
	int wWidth    = getCaliValue();
	int wHeight   = getCaliValue();
	int wNumSrcCG = getCaliValue();

	scg_create_stretch(wNumCG, wWidth, wHeight, wNumSrcCG);
	
	DEBUG_COMMAND_YET("SACT.CG_CreateStretch %d,%d,%d,%d:\n", wNumCG, wWidth, wHeight, wNumSrcCG);
}

/**
 * SACT.CG_CreateBlend (1.0~)
 *   CG򤫤ͤ碌CG
 *   @param wNumDstCG: CGֹ()
 *   @param wNumBaseCG: Ť͹碌ΤȤȤʤCG
 *   @param wX: Ť͹碌֤Σغɸ
 *   @param wY: Ť͹碌֤Σٺɸ
 *   @param wNumBlendCG: ˽Ť͹碌CG
 *   @param wAlphaMapMode: ޥåפκ⡼
 */
void CG_CreateBlend() {
	int wNumDstCG  = getCaliValue();
	int wNumBaseCG = getCaliValue();
	int wX = getCaliValue();
	int wY = getCaliValue();
	int wNumBlendCG   = getCaliValue();
	int wAlphaMapMode = getCaliValue();
	
	DEBUG_COMMAND_YET("SACT.CG_CreateBlend %d,%d,%d,%d,%d,%d:\n", wNumDstCG, wNumBaseCG, wX, wY, wNumBlendCG, wAlphaMapMode);
	scg_create_blend(wNumDstCG, wNumBaseCG, wX, wY, wNumBlendCG, wAlphaMapMode);
	
}

/**
 * SACT.CG_CreateText (1.0~)
 *   ʸ󤫤CG
 *   @param wNumCG: CGֹ
 *   @param wSize: ʸι⤵(pixel)
 *   @param wR: ʸR(0-255)
 *   @param wG: ʸG(0-255)
 *   @param wB: ʸB(0-255)
 *   @param wText: 褹ʸѿֹ
 */
void CG_CreateText() {
	int wNumCG = getCaliValue();
	int wSize  = getCaliValue();
	int wR     = getCaliValue();
	int wG     = getCaliValue();
	int wB     = getCaliValue();
	int wText  = getCaliValue();
	
	scg_create_text(wNumCG, wSize, wR, wG, wB, wText);
	
	DEBUG_COMMAND_YET("SACT.CG_CreateText %d,%d,%d,%d,%d,%d:\n", wNumCG, wSize, wR, wG, wB, wText);
}

/**
 * SACT.CG_CreateTextNum (1.0~)
 *   ͤ饷ƥƥȤCG
 *   @param wNumCG: CGֹ
 *   @param wSize: ʸι⤵(pixel)
 *   @param wR: ʸR(0-255)
 *   @param wG: ʸG(0-255)
 *   @param wB: ʸB(0-255)
 *   @param wFigs: 
 *   @param wZeroPadding: ʤʬ뤫ɤΥե饰
 *                        0:ᤷʤ 1:᤹
 *   @param wValue: 褹
 */
void CG_CreateTextNum() {
	int wNumCG       = getCaliValue();
	int wSize        = getCaliValue();
	int wR           = getCaliValue();
	int wG           = getCaliValue();
	int wB           = getCaliValue();
	int wFigs        = getCaliValue();
	int wZeroPadding = getCaliValue();
	int wValue       = getCaliValue();
	
	scg_create_textnum(wNumCG, wSize, wR, wG, wB, wFigs, wZeroPadding, wValue);
	
	DEBUG_COMMAND_YET("SACT.CG_CreateTextNum %d,%d,%d,%d,%d,%d,%d,%d:\n", wNumCG, wSize, wR, wG, wB, wFigs, wZeroPadding, wValue);
}

/**
 * SACT.CG_Copy (1.0~)
 *   CGʣ
 *   @param wNumDst: ʣCGֹ
 *   @param wNumSrc: ʣ̸CGֹ
 */
void CG_Copy() {
	int wNumDst = getCaliValue();
	int wNumSrc = getCaliValue();
	
	scg_copy(wNumDst, wNumSrc);

	DEBUG_COMMAND_YET("SACT.CG_Copy %d,%d:\n", wNumDst, wNumSrc);
}

/**
 * SACT.CG_Cut (1.0~)
 *   CGΰڤ̤CG
 *   @param wNumDstCG: CGֹ()
 *   @param wNumSrcCG: CGֹ(åȸ)
 *   @param wX: åȳϣغɸ
 *   @param wY: åȳϣٺɸ
 *   @param wWidth: å
 *   @param wHeight: åȹ⤵
 */
void CG_Cut() {
	int wNumDstCG = getCaliValue();
	int wNumSrcCG = getCaliValue();
	int wX = getCaliValue();
	int wY = getCaliValue();
	int wWidth  = getCaliValue();
	int wHeight = getCaliValue();
	
	scg_cut(wNumDstCG, wNumSrcCG, wX, wY, wWidth, wHeight);
	
	DEBUG_COMMAND_YET("SACT.CG_Cut %d,%d,%d,%d,%d,%d:\n", wNumDstCG, wNumSrcCG, wX, wY, wWidth, wHeight);
}

/**
 * SACT.CG_PartCopy (1.0~)
 *   CGΰڤ̤CGCGΥΤϤȤΤޤޤǡ
 *   ޥǡΤߤƸݤΥѲ
 *   @param wNumDstCG: CGֹ()
 *   @param wNumSrcCG: CGֹ()
 *   @param wX: ϣغɸ
 *   @param wY: ϣٺɸ
 *   @param wWidth: å
 *   @param wHeight: åȹ⤵
 */
void CG_PartCopy() {
	int wNumDstCG = getCaliValue();
	int wNumSrcCG = getCaliValue();
	int wX = getCaliValue();
	int wY = getCaliValue();
	int wWidth  = getCaliValue();
	int wHeight = getCaliValue();
	
	scg_partcopy(wNumDstCG, wNumSrcCG, wX, wY, wWidth, wHeight);
	
	DEBUG_COMMAND_YET("SACT.PartCopy %d,%d,%d,%d,%d,%d:\n", wNumDstCG, wNumSrcCG, wX, wY, wWidth, wHeight);
}

/**
 * SACT.WiatKeySimple (1.0~)
 *   ̾省Ԥ
 *   @param vKey: Ϥ줿
 */
void WaitKeySimple() {
	int *vKey = getCaliVariable();

	DEBUG_COMMAND_YET("SACT.WaitKeySimple %d:\n", vKey);

	// Ȥꤢ
	sp_update_all(TRUE);
	
	sact.waittype = KEYWAIT_SIMPLE;
	sact.waitkey = -1;
	
	while(sact.waitkey == -1) {
		sys_keywait(25, TRUE);
	}
	
	sact.waittype = KEYWAIT_NONE;
	
	*vKey = sact.waitkey;
	
}

/**
 * SACT.WaitKeyMessgae (1.0~)
 *   åԤ
 *   @param wMessageMark1: ץ饤ֹ1(˥᡼󥹥ץ饤)
 *   @param wMessageMark2: ץ饤ֹ2(˥᡼󥹥ץ饤)
 *   @param wMessageLength: (1.2~)
 */
void WaitKeyMessage() {
	int wMessageMark1 = getCaliValue();
	int wMessageMark2 = getCaliValue();
	int wMessageLength = 0;
	
	if (sact.version >= 120) {
		wMessageLength = getCaliValue();
	}
	
	smsg_keywait(wMessageMark1, wMessageMark2, wMessageLength);
	
	DEBUG_COMMAND_YET("SACT.WaitKeyMessage %d,%d,%d:\n", wMessageMark1, wMessageMark2, wMessageLength);
}

/**
 * SACT.WaitKeySprite (1.0~)
 *   ץ饤ȽԤ
 *   @param vOK: 0ʤбå 
 *   @param vRND: Ϸ
 *   @param vRsv1: ͽ
 *   @param vRsv2: ͽ
 */
void WaitKeySprite() {
	int *vOK = getCaliVariable();
	int *vRND = getCaliVariable();
	int *vRsv1 = getCaliVariable();
	int *vRsv2 = getCaliVariable();
	
	DEBUG_COMMAND("SACT.WaitKeySprite %p,%p,%p,%p:\n", vOK, vRND, vRsv1, vRsv2);
	
	sp_keywait(vOK, vRND, vRsv1, vRsv2, NULL, -1);
	
	DEBUG_COMMAND_YET("SACT.WaitKeySprite %d,%d,%d,%d:\n", *vOK, *vRND, *vRsv1, *vRsv2);
}

/**
 * SACT.PeekKey (1.2~)
 *   ?????
 *   @param nKeyCode:
 *   @param vResult:
 */
void PeekKey() {
	int nKeyCode = getCaliValue();
	int *vResult = getCaliVariable();
	
	WARNING("NOT IMPLEMENTED\n");
	DEBUG_COMMAND_YET("SACT.PeekKey %d,%p:\n", nKeyCode, vResult);
}

/**
 * SACT.WaitKeySKipKeyUp (1.0~)
 *   ʸꥭäѤʤλΥޤԤ
 */
void WaitMsgSkipKeyUp() {
	WARNING("NOT IMPLEMENTED\n");
	DEBUG_COMMAND_YET("SACT.WaitMsgSkipKeyUp:\n");
}

/**
 * SACT.WaiKeySimpleTimeOut (1.0~)
 *   ॢȤĤ
 *   @param vRND: Ϥ줿
 *   @param vD03: ॢȤ=1, ʤ=0
 *   @param wTime: ॢȻ (1/100sec)
 */
void WaitKeySimpleTimeOut() {
	int *vRND = getCaliVariable();
	int *vD03 = getCaliVariable();
	int wTime = getCaliValue();

	sact.waittype = KEYWAIT_SIMPLE;
	sact.waitkey = -1;
	
	sys_keywait(wTime * 10, TRUE);
	if (sact.waitkey == -1) {
		*vD03 = 1;
		*vRND = 0;
	} else {
		*vD03 = 0;
		*vRND = sact.waitkey;
	}
	
	sact.waittype = KEYWAIT_NONE;
	
	DEBUG_COMMAND_YET("SACT.WaitKeySimpleTimeOut %p,%p,%d:\n", vRND, vD03, wTime);
}

/**
 * SACT.WaiKeySpriteTimeOut (1.0~)
 *   ॢȤĤץ饤ȥ 
 *   @param vOK: 0 λå
 *   @param vRND: åץ饤Ȥֹ
 *   @param vD01: åȥץ饤Ȥֹ
 *   @param vD02: ץåȥץ饤Ȥֹ
 *   @param vD03: ॢȤ=1, ʤ=0
 *   @param wTime: ॢȻ (1/100sec)
 */
void WaitKeySpriteTimeOut() {
	int *vOK = getCaliVariable();
	int *vRND = getCaliVariable();
	int *vD01 = getCaliVariable();
	int *vD02 = getCaliVariable();
	int *vD03 = getCaliVariable();
	int wTime = getCaliValue();
	
	sp_keywait(vOK, vRND, vD01, vD02, vD03, wTime);
	
	DEBUG_COMMAND_YET("SACT.WaitKeySpriteTimeOut %p,%p,%p,%p,%p,%d:\n", vOK, vRND, vD01, vD02, vD03, wTime);
}

/**
 * SACT.QueryMessageSkip (1.0~)
 *   ??????
 *   @param vSkip:
 */
void QueryMessageSkip() {
	int *vSkip = getCaliVariable();

	*vSkip = get_skipMode() ? 1 : 0;
	
	DEBUG_COMMAND_YET("SACT.QueryMessageSkip %p:\n", vSkip);
}

/**
 * SACT.RegistReplaceString (1.0~)
 *   åʸ֤
 *   @param sstr: Ѵʸֹ
 *   @param dstr: Ѵʸֹ
 */
void RegistReplaceString() {
	int sstr = getCaliValue();
	int dstr = getCaliValue();
	
	sstr_regist_replace(sstr, dstr);
	
	DEBUG_COMMAND_YET("SACT.RegistReplaceString %d,%d:\n", sstr, dstr);
}

/**
 * SACT.MessageOutput (1.0~)
 *   @param wMessageSpriteNumber: åɽåץ饤ֹ
 *                                (~MES)
 *   @param wMessageSize: եȤ礭 (~MES_SIZE|~MES_SET)
 *   @param wMessageColorR: åο(Red) (~MES_SET|~MES_COLOR)
 *   @param wMessageColorG: åο(Green) (~MES_SET|~MES_COLOR)
 *   @param wMessageColorB: åο(Blue) (~MES_SET|~MES_COLOR)
 *   @param wMessageFont: åΥե(0:å, 1:ī)
 *                         (~MES_FONT)
 *   @param wMessageSpeed: åɽ®(0:̵, 1:®,
 *                          2:椯餤, 3: ٤) (~MES_SPEED) (msec)
 *   @param wMessageLineSpace: Դ֥ڡ (~MES_SPC_Y)
 *   @param wMessageAlign: Ԥ (1.1~)
 *   @param vMessageLength: ???     (1.2~)
 */
void MessageOutput() {
	int wMessageSpriteNumber = getCaliValue();
	int wMessageSize   = getCaliValue();
	int wMessageColorR = getCaliValue();
	int wMessageColorG = getCaliValue();
	int wMessageColorB = getCaliValue();
	int wMessageFont   = getCaliValue();
	int wMessageSpeed  = getCaliValue();
	int wMessageLineSpace = getCaliValue();
	int wMessageAlign   = 0;
	int *vMessageLength  = NULL;
	
	if (sact.version >= 110) {
		wMessageAlign  = getCaliValue();
	}
	if (sact.version >= 120) {
		vMessageLength  = getCaliVariable();
	}
	
	smsg_out(wMessageSpriteNumber, wMessageSize, wMessageColorR, wMessageColorG, wMessageColorB, wMessageFont, wMessageSpeed, wMessageLineSpace, wMessageAlign, 0, 0, 0, vMessageLength);
	
	DEBUG_COMMAND_YET("SACT.MessageOutput %d,%d,%d,%d,%d,%d,%d,%d,%d,%p:\n", wMessageSpriteNumber, wMessageSize, wMessageColorR, wMessageColorG, wMessageColorB, wMessageFont, wMessageSpeed, wMessageLineSpace, wMessageAlign, vMessageLength);
}

/**
 * SACT.MessageOutputEx (1.1~)
 *   ӤĤå
 *   @param wMessageSpriteNumber: åɽåץ饤ֹ
 *                                (~MES)
 *   @param wMessageSize: եȤ礭 (~MES_SIZE|~MES_SET)
 *   @param wMessageColorR: åο(Red) (~MES_SET|~MES_COLOR)
 *   @param wMessageColorG: åο(Green) (~MES_SET|~MES_COLOR)
 *   @param wMessageColorB: åο(Blue) (~MES_SET|~MES_COLOR)
 *   @param wMessageFont: åΥե(0:å, 1:ī)
 *                         (~MES_FONT)
 *   @param wMessageSpeed: åɽ®(0:̵, 1:®,
 *                          2:椯餤, 3: ٤) (~MES_SPEED)
 *   @param wMessageLineSpace: Դ֥ڡ (~MES_SPC_Y)
 *   @param wMessageAlign: Ԥ
 *   @param wRubySize:     ʸ礭
 *   @param wRubyFont:     ʸΥեȤμ((0:å, 1:ī)
 *   @param wRubyLineSpace: ʸȥåιԴ֥ڡ
 *   @param vLength: ???    (1.2~)
 */
void MessageOutputEx() {
	int wMessageSpriteNumber = getCaliValue();
	int wMessageSize   = getCaliValue();
	int wMessageColorR = getCaliValue();
	int wMessageColorG = getCaliValue();
	int wMessageColorB = getCaliValue();
	int wMessageFont   = getCaliValue();
	int wMessageSpeed  = getCaliValue();
	int wMessageLineSpace = getCaliValue();
	int wMessageAlign  = getCaliValue();
	int wRubySize      = getCaliValue();
	int wRubyFont      = getCaliValue();
	int wRubyLineSpace = getCaliValue();
	int *vLength = NULL;
	
	if (sact.version >= 120) {
		vLength = getCaliVariable();
	}
	
	smsg_out(wMessageSpriteNumber, wMessageSize, wMessageColorR, wMessageColorG, wMessageColorB, wMessageFont, wMessageSpeed, wMessageLineSpace, wMessageAlign, wRubySize, wRubyFont, wRubyLineSpace, vLength);
	
	DEBUG_COMMAND_YET("SACT.MessageOutputEx %d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%p:\n", wMessageSpriteNumber, wMessageSize, wMessageColorR, wMessageColorG, wMessageColorB, wMessageFont, wMessageSpeed, wMessageLineSpace,wMessageAlign, wRubySize, wRubyFont, wRubyLineSpace, vLength);
}

/**
 * SACT.MessageNewLine (1.0~)
 *   (ҥޥ) (~MES_NEW_LINE)
 *   @param wMessageSpriteNumber: åץ饤ֹ
 *   @param wMessageSize: եȤ礭 (~MES_SIZE|~MES_SET)
 */
void MessageNewLine() {
	int wMessageSpriteNumber = getCaliValue();
	int wMessageSize = getCaliValue();
	
	smsg_newline(wMessageSpriteNumber, wMessageSize);
	
	DEBUG_COMMAND_YET("SACT.MessageNewLine %d,%d:\n", wMessageSpriteNumber, wMessageSize);
}

/**
 * SACT.MessageClear (1.0~)
 *   åΰξõ(Aޥ)
 *   @param wMessageSpriteNumber: åץ饤ֹ
 */ 
void MessageClear() {
	int wMessageSpriteNumber = getCaliValue();
	
	smsg_clear(wMessageSpriteNumber);
	
	DEBUG_COMMAND_YET("SACT.MessageClear %d:\n", wMessageSpriteNumber);
}

/**
 * SACT.MessageIsEmpty  (1.0~)
 *   åĤäƤ wResult  0 ֤?
 *   @param wResult: ̤֤ѿ
 */
void MessageIsEmpty() {
	int *wResult = getCaliVariable();

	*wResult = smsg_is_empty();
	
	DEBUG_COMMAND_YET("SACT.MessageIsEmpty %p:\n", wResult);
}

/**
 * SACT.MessagePeek  (1.2+~) (ʤߤˤϤʤ)
 *   åХåեƤ
 *   @param vCount: Կ
 *   @param nTopStringNum: Хåեʸѿκǽ
 */
void MessagePeek() {
	int *vCount = getCaliVariable();
	int nTopStringNum = getCaliValue();

	WARNING("NOT IMPLEMENTED\n");
	
	DEBUG_COMMAND_YET("SACT.MessagePeek %p,%d:\n", vCount, nTopStringNum);
}

/**
 * SACT.Log_Stop (1.2~)
 *   μ
 */
void Log_Stop() {
	sact.logging = FALSE;
	DEBUG_COMMAND_YET("SACT.Log_Stop:\n");
}

/**
 * SACT.Log_Start (1.2~)
 *   μ賫
 */
void Log_Start() {
	sact.logging = TRUE;
	DEBUG_COMMAND_YET("SACT.Log_Start:\n");
}

/**
 * SACT.MenuClear (1.0~)
 *   SACT򥯥ꥢ
 */
void MenuClear() {
	ssel_clear();
	
	DEBUG_COMMAND_YET("SACT.MenuClear:\n");
}

/**
 * SACT.MenuAdd (1.0~)
 *   ϿʸSACTɲ
 *   @param nString: Ͽʸѿֹ
 *   @param wI: Ͽ (1-)
 */
void MenuAdd() {
	int nString = getCaliValue();
	int wI = getCaliValue();

	ssel_add(nString, wI);
	
	DEBUG_COMMAND_YET("SACT.MenuAdd %d,%d:\n", nString, wI);
}

/**
 * SACT.MenuOpen (1.0~)
 *   SACT롼
 *   @param wMenuResult: (ֹ) 󥻥뤷0
 *   @param wNum: ,طʤȤ륹ץ饤ֹ (~SP_SEL)
 *   @param wChoiceSize: ʸ (~SEL_SIZE)
 *   @param wMenuOutSpc: ȥץ饤Ȥγ¦Υԥ(~SP_SETSELSPC)
 *   @param wChoiceLineSpace: ιԴ(1˸?)
 *   @param wChoiceAutoMoveCursor: ץ˼ưŪ˰ưֹ
 *   @param nAlign: Ԥ (0:, 1:, 2: ) (1.1~)
 */
void MenuOpen() {
	int *wMenuResult = getCaliVariable();
	int wNum         = getCaliValue();
	int wChoiceSize  = getCaliValue();
	int wMenuOutSpc  = getCaliValue();
	int wChoiceLineSpace = getCaliValue();
	int wChoiceAutoMoveCursor = getCaliValue();
	int nAlign = 0;
	
	if (sact.version >= 110) {
		nAlign = getCaliValue();
	}
	
	*wMenuResult = ssel_select(wNum, wChoiceSize, wMenuOutSpc, wChoiceLineSpace, wChoiceAutoMoveCursor, nAlign);
	
	DEBUG_COMMAND_YET("SACT.MenuOpen %p,%d,%d,%d,%d,%d,%d:\n", wMenuResult, wNum, wChoiceSize, wMenuOutSpc, wChoiceLineSpace, wChoiceAutoMoveCursor, nAlign);
}

/**
 * SACT.PushString (1.0~)
 *   SACTʸѿץå
 *   @param nString: ʸѿֹ
 */
void PushString() {
	int nString = getCaliValue();
	
	sstr_push(nString);
	
	DEBUG_COMMAND_YET("SACT.PushString %d:\n", nString);
}

/**
 * SACT.PopString (1.0~)
 *   SACT˥ץå夷ʸѿݥå
 *   @param nString: ʸѿֹ
 */
void PopString() {
	int nString = getCaliValue();

	sstr_pop(nString);
	
	DEBUG_COMMAND_YET("SACT.PopString %d:\n", nString);
}

/**
 * SACT.Numeral_XXXX
 *   ץ饤ˡο(09)ФбCGֹ
 *   ɽֳ֤֡ʤɤǼФԤ
 */

/**
 * SACT.Numeral_SetCG (1.0~)
 *   οͤФCGֹ
 *   @param nNum: ץ饤ֹ
 *   @param nIndex: (0-9)
 *   @param nCG: бCGֹ
 */
void Numeral_SetCG() {
	int nNum = getCaliValue();
	int nIndex = getCaliValue();
	int nCG = getCaliValue();
	
	sp_num_setcg(nNum, nIndex, nCG);
	
	DEBUG_COMMAND_YET("SACT.Numeral_SetCG %d,%d,%d:\n", nNum, nIndex, nCG);
}

/**
 * SACT.Numeral_GetCG (1.0~)
 *   οͤФCGֹ
 *   @param nNum: ץ饤ֹ
 *   @param nIndex: (0-9)
 *   @param vCG: ꤵƤCGֹ֤ѿ
 */
void Numeral_GetCG() {
	int nNum = getCaliValue();
	int nIndex = getCaliValue();
	int *vCG = getCaliVariable();
	
	sp_num_getcg(nNum, nIndex, vCG);
	
	DEBUG_COMMAND_YET("SACT.Numeral_GetCG %d,%d,%p:\n", nNum, nIndex, vCG);
}

/**
 * SACT.Numeral_SetPos (1.0~)
 *   Numeralɽ֤
 *   @param nNum: ץ饤ֹ
 *   @param nX: ɽغɸ
 *   @param ny: ɽٺɸ
 */
void Numeral_SetPos() {
	int nNum = getCaliValue();
	int nX = getCaliValue();
	int nY = getCaliValue();
	
	sp_num_setpos(nNum, nX, nY);
	
	DEBUG_COMMAND_YET("SACT.Numeral_SetPos %d,%d,%d:\n", nNum, nX, nY);
}

/**
 * SACT.Numeral_GetPos (1.0~)
 *   Numeral_SetPosꤷɸμФ
 *   @param nNum: ץ饤ֹ
 *   @param vX: غɸǼѿ
 *   @param vY: ٺɸǼѿ
 */
void Numeral_GetPos() {
	int nNum = getCaliValue();
	int *vX = getCaliVariable();
	int *vY = getCaliVariable();
	
	sp_num_getpos(nNum, vX, vY);
	
	DEBUG_COMMAND_YET("SACT.Numeral_GetPos %d,%p,%p:\n", nNum, vX, vY);
}

/**
 * SACT.Numeral_SetSpan (1.0~)
 *   Numeralδֳ(Span)
 *   @param nNum: ץ饤ֹ
 *   @param nSpan: ֳ
 */
void Numeral_SetSpan() {
	int nNum = getCaliValue();
	int nSpan = getCaliValue();
	
	sp_num_setspan(nNum, nSpan);
	
	DEBUG_COMMAND_YET("SACT.Numeral_SetSpan %d,%d:\n", nNum, nSpan);
}

/**
 * SACT.Numeral_GetSpan (1.0~)
 *   Numeral_SetSpanꤷͤμФ
 *   @param nNum: ץ饤ֹ
 *   @param vSpan: ͤǼѿ
 */
void Numeral_GetSpan() {
	int nNum = getCaliValue();
	int *vSpan = getCaliVariable();

	sp_num_getspan(nNum, vSpan);
	
	DEBUG_COMMAND_YET("SACT.Numeral_GetSpan %d,%p:\n", nNum, vSpan);
}

/**
 * SACT.ExpSp_Clear (1.0~)
 *   ץ饤ꥯꥢ
 */
void ExpSp_Clear() {
	DEBUG_COMMAND_YET("SACT.ExpSp_Clear:\n");

	sp_exp_clear();
}

/**
 * SACT.ExpSp_Add (1.0~)
 *   ץ饤ɲ
 *   @param wNumSP1: åץ饤
 *   @param wNumSP2: ץ饤
 */
void ExpSp_Add() {
	int wNumSP1 = getCaliValue();
	int wNumSP2 = getCaliValue();
	
	sp_exp_add(wNumSP1, wNumSP2);
	
	DEBUG_COMMAND_YET("SACT.ExpSp_Add %d,%d:\n", wNumSP1, wNumSP2);
}

/**
 * SACT.ExpSp_Del (1.0~)
 *   ץ饤Ⱥ
 *   @param wNum: ץ饤ֹ
 */
void ExpSp_Del() {
	int wNum = getCaliValue();
	
	sp_exp_del(wNum);
	
	DEBUG_COMMAND_YET("SACT.ExpSp_Del %d:\n", wNum);
}

/**
 * SACT.TimerSet (1.0~)
 *   IDΥޡwCountͤǥꥻå
 *   @param wTimerID: ޡID
 *   @param wCount: ꥻåȤ
 */
void TimerSet() {
	int wTimerID = getCaliValue();
	int wCount = getCaliValue();
	
	stimer_reset(wTimerID, wCount);
	
	DEBUG_COMMAND("SACT.TimerSet %d,%d:\n", wTimerID, wCount);
}

/**
 * SACT.TimerGet (1.0~)
 *   IDΥޡRND˼
 *   @param wTimerID: ޡID
 *   @param vRND: ѿ
 */
void TimerGet() {
	int wTimerID = getCaliValue();
	int *vRND = getCaliVariable();

	*vRND = stimer_get(wTimerID);
	
	DEBUG_COMMAND("SACT.TimerGet %d,%p:\n", wTimerID, vRND);
}

/**
 * SACT.TimerWait (1.0~)
 *   IDΥޡꥫȤˤʤޤԤ
 *   @param wTimerID: ޡID
 *   @param wCount: ꥫ
 */
void TimerWait() {
	int wTimerID = getCaliValue();
	int wCount = getCaliValue();

	while(wCount > stimer_get(wTimerID)) {
		sys_keywait(10, FALSE);
	}
	
	DEBUG_COMMAND("SACT.TimerWait %d,%d:\n", wTimerID, wCount);
}

/**
 * SACT.Wait (1.1~)
 *   ֡٤Ƥư
 *   @param nCount: (1/100ñ)
 */
void Wait() {
	int wCount = getCaliValue();
	
	sys_keywait(wCount*10, FALSE);
	
	DEBUG_COMMAND_YET("SACT.Wait %d:\n", wCount);
}

/**
 * SACT.SoundPlay (1.0~)
 *   ľܺ  (~SOUND_PLAY)
 *   @param wNum: ֹ
 */
void SoundPlay() {
	int wNum = getCaliValue();
	
	ssnd_play(wNum);
	
	DEBUG_COMMAND_YET("SACT.SoundPlay %d:\n", wNum);
}

/**
 * SACT.SoundStop (1.0~)
 *   ɺ (~SOUND_STOP)
 *   @param wNum: ߤֹ
 *   @param wFadeTime: ߤޤǤλ (1/100sec)
 */
void SoundStop() {
	int wNum = getCaliValue();
	int wFadeTime = getCaliValue();
	
	ssnd_stop(wNum, wFadeTime);
	
	DEBUG_COMMAND_YET("SACT.SoundStop %d,%d:\n", wNum, wFadeTime);
}

/**
 * SACT.SoundStopAll (1.1~)
 *   ɺ (~SOUND_STOP)
 *   @param wNum: ߤֹ
 *   @param wFadeTime: ߤޤǤλ (1/100sec)
 */
void SoundStopAll() {
	int wFadeTime = getCaliValue();
	
	ssnd_stopall(wFadeTime);
	
	DEBUG_COMMAND_YET("SACT.SoundStopAll %d:\n", wFadeTime);
}

/**
 * SACT.SoundWait (1.0~)
 *   إåǻꤵ줿orλޤԤ  (~SOUND_WAIT)
 *   @param wNum: ֹ
 */
void SoundWait() {
	int wNum = getCaliValue();
	
	ssnd_wait(wNum);
	
	DEBUG_COMMAND_YET("SACT.SoundWait %d:\n", wNum);
}

/**
 * SACT.SoundWaitKey (1.0~)
 *   ꤵ줿ɤλ뤫ޤԤ
 *   @param wNum: ֹ
 *   @param vKey: 󥻥륭
 */
void SoundWaitKey() {
	int wNum = getCaliValue();
	int *vKey = getCaliVariable();
	
	ssnd_waitkey(wNum, vKey);
	
	DEBUG_COMMAND_YET("SACT.SoundWaitKey %d,%p:\n", wNum, vKey);
}

/**
 * SACT.SoundPrepare (1.0~)
 *   ν򤹤(~SOUND_PREPARE)
 *   @param wNum: ֹ
 */
void SoundPrepare() {
	int wNum = getCaliValue();
	
	ssnd_prepare(wNum);
	
	DEBUG_COMMAND_YET("SACT.SoundPrepare %d:\n", wNum);
}

/**
 * SACT.SoundPrepareLR (1.0~)
 *   ν򤹤(ȿž) (~SOUND_PREPARE_LR)
 *   @param wNum: ֹ
 */
void SoundPrepareLR() {
	int wNum = getCaliValue();

	ssnd_prepareLRrev(wNum);
	
	DEBUG_COMMAND_YET("SACT.SoundPrepareLR %d:\n", wNum);
}

/**
 * SACT.SoundPlayLR (1.0~)
 *   ȿžƺ (~SOUND_PLAY_LR)
 *   @param wNum: ֹ
 */
void SoundPlayLR() {
	int wNum = getCaliValue();
	
	ssnd_playLRrev(wNum);
	
	DEBUG_COMMAND_YET("SACT.SoundPlayLR %d:\n", wNum);
}

/**
 * SACT.SpriteSound (1.0~)
 * (ץ饤Ȼ) (~SP_SOUND)
 *   @param wNumSP: ꤹ륹ץ饤ֹ
 *   @param nCount: ꤹĿ
 *   @param wNumWave1: Sound1
 *   @param wNumWave2: Sound2
 *   @param wNumWave3: Sound3
 */
void SpriteSound() {
	int wNumSP = getCaliValue();
	int nCount = getCaliValue();
	int wNumWave1 = getCaliValue();
	int wNumWave2 = getCaliValue();
	int wNumWave3 = getCaliValue();
	int i;
	
	for (i = wNumSP; i < (wNumSP + nCount); i++) {
		sp_sound_set(i, wNumWave1, wNumWave2, wNumWave3);
	}
	
	DEBUG_COMMAND_YET("SACT.SpriteSound %d,%d,%d,%d,%d:\n", wNumSP, nCount, wNumWave1, wNumWave2, wNumWave3);
}

/**
 * SACT.SpriteSoundWait (1.0~)
 *   SpriteSoundꤷ٤ƤβκλޤԤ (~SP_SOUND_WAIT)
 */
void SpriteSoundWait() {
	DEBUG_COMMAND_YET("SACT.SpriteSoundWait:\n");

	sp_sound_wait();
}

/**
 * SACT.SpriteSoundOB (1.0~)
 *   ϰϳ򥯥åȤβ  (~SPRITE_SOUND_OB)
 *   @param wNumWave: ֹ桢ǥꥢ
 */
void SpriteSoundOB() {
	int wNumWave = getCaliValue();
	
	sp_sound_ob(wNumWave);
	
	DEBUG_COMMAND_YET("SACT.SpriteSoundOB %d:\n", wNumWave);
}

/**
 * SACT.MusicCheck (1.0~)
 *   ڥǡ뤫ɤ (~MUSIC_CHECK)
 *   @param wNum: ֹ
 *   @param vRND: 0:ʤ1:
 */
void MusicCheck() {
	int wNum = getCaliValue();
	int *vRND = getCaliVariable();
	
	*vRND = smus_check(wNum);
	
	DEBUG_COMMAND_YET("SACT.MusicCheck %d,%p:\n", wNum, vRND);
}

/**
 * SACT.MusicGetLength (1.0~)
 *   ڥǡĹ1/100ñ̤Ǽ (~MUSIC_GET_LENGTH)
 *   @param wNum: ֹ
 *   @param vRND: ĹǼѿ
 */
void MusicGetLength() {
	int wNum = getCaliValue();
	int *vRND = getCaliVariable();
	
	*vRND = smus_getlength(wNum);
	
	DEBUG_COMMAND_YET("SACT.MusicGetLength %d,%d:\n", wNum, *vRND);
}

/**
 * SACT.MusicGetPos (1.0~)
 *   ڥǡκ֤1/100ñ̤Ǽ (~MUSIC_GET_POS)
 *   @param wNum: ֹ
 *   @param vRND: ֤Ǽѿ
 */
void MusicGetPos() {
	int wNum = getCaliValue();
	int *vRND = getCaliVariable();
	
	*vRND = smus_getpos(wNum);
	
	DEBUG_COMMAND_YET("SACT.MusicGetPos %d,%d:\n", wNum, *vRND);
}

/**
 * SACT.MusicPlay (1.0~)
 *    (~MUSIC_PLAY)
 *   @param wNum: ֹ
 *   @param wFadeTime: եɥ(1/100)
 *   @param wVolume: (0-100)
 */
void MusicPlay() {
	int wNum = getCaliValue();
	int wFadeTime = getCaliValue();
	int wVolume = getCaliValue();
	
	smus_play(wNum, wFadeTime, wVolume);
	
	DEBUG_COMMAND_YET("SACT.MusicPlay %d,%d,%d:\n", wNum, wFadeTime, wVolume);
}

/**
 * SACT.MusicStop (1.0~)
 *    (~MUSIC_STOP)
 *   @param wNum: ֹ
 *   @param wFadeTime: λޤǤλ(1/100)
 */
void MusicStop() {
	int wNum = getCaliValue();
	int wFadeTime = getCaliValue();
	
	smus_stop(wNum, wFadeTime);
	
	DEBUG_COMMAND_YET("SACT.MusicStop %d,%d:\n", wNum, wFadeTime);
}

/**
 * SACT.MusicStopAll (1.2~)
 *   ٤Ƥβڤ
 *   @param wFadeTime: λޤǤλ(1/100)
 */
void MusicStopAll() {
	int wFadeTime = getCaliValue();
	
	smus_stopall(wFadeTime);
	
	DEBUG_COMMAND_YET("SACT.MusicStopAll %d:\n", wFadeTime);
}

/**
 * SACT.MusicFade (1.0~)
 *   Υܥ塼ޤǥե (~MUSIC_FADE)
 *   @param wNum: ֹ
 *   @param wFadeTime: եɻ(1/100)
 *   @param wVolume:  (1-100)
 */
void MusicFade() {
	int wNum = getCaliValue();
	int wFadeTime = getCaliValue();
	int wVolume = getCaliValue();
	
	smus_fade(wNum, wFadeTime, wVolume);
	
	DEBUG_COMMAND_YET("SACT.MusicFade %d,%d,%d:\n", wNum, wFadeTime, wVolume);
}

/**
 * SACT.MusicWait (1.0~)
 *   λޤԤ (~MUSIC_WAIT)
 *   @param wNum: ֹ
 *   @param nTimeOut: (1.1~)
 */
void MusicWait() {
	int wNum = getCaliValue();
	int nTimeOut = 0;
	
	if (sact.version >= 110) {
		nTimeOut = getCaliValue();
	}
	
	smus_wait(wNum, nTimeOut);
	
	DEBUG_COMMAND_YET("SACT.MusicWait %d,%d:\n", wNum, nTimeOut);
}

/**
 * SACT.MusicWatiPos (1.0~)
 *   βڤwIndex֤Υޡǻꤵ줿֤ޤԤ 
 *   (~MUSIC_WAIT_POS)
 *   @param wNum: ֹ
 *   @param wIndex: ֥ޡֹ
 */
void MusicWaitPos() {
	int wNum = getCaliValue();
	int wIndex = getCaliValue();
	
	smus_waitpos(wNum, wIndex);
	
	DEBUG_COMMAND_YET("SACT.MusicWaitPos %d,%d:\n", wNum, wIndex);
}

/**
 * SACT.SoundGetLinkNum (1.0~)
 *   ͥΥֹ (~SOUND_GET_LINK_NUM)
 *   @param wNum: ֹͥ
 *   @param vRND: ֹ(̤ѡᣰ)
 */
void SoundGetLinkNum() {
	int wNum = getCaliValue();
	int *vRND = getCaliVariable();

	*vRND = ssnd_getlinknum(wNum);
	
	DEBUG_COMMAND_YET("SACT.SoundGetLinkNum %d,%p:\n", wNum, vRND);
}

/**
 * SACT.ChartPos (1.0~)
 *   ѥ㡼Ⱥ
 *   @param pos : ̽ѿ
 *   @param pos1: Ǿ
 *   @param pos2: 
 *   @param val1: ʬΨǾ
 *   @param val2: ʬΨ
 *   @param val : ʬΨ
 *
 *     pos = ((pos2-pos1) / (val2-val1)) * (val-val1) + pos1
 */
void ChartPos() {
	int *pos = getCaliVariable();
	int pos1 = getCaliValue();
	int pos2 = getCaliValue();
	int val1 = getCaliValue();
	int val2 = getCaliValue();
	int val  = getCaliValue();
	
	schart_pos(pos, pos1, pos2, val1, val2, val);
	
	DEBUG_COMMAND_YET("SACT.ChartPos %p,%d,%d,%d,%d,%d:\n", pos, pos1, pos2, val1, val2, val);
}

/**
 * SACT.NumToStr (1.0~)
 *    -> ʸѴ
 *   @param strno: ѴѤʸѿֹ
 *   @param fig:   
 *   @param zeropad: 0: ᤷʤ, 1: ᤹
 *   @param num: Ѵ
 */
void NumToStr() {
	int strno   = getCaliValue();
	int fig     = getCaliValue();
	int zeropad = getCaliValue();
	int num     = getCaliValue();
	
	sstr_num2str(strno, fig, zeropad, num);
	
	DEBUG_COMMAND_YET("SACT.NumToStr %d,%d,%d,%d:\n", strno, fig, zeropad, num);
}

/**
 * SACT.Maze_Create (1.0~)
 */
void Maze_Create() {
	int p1 = getCaliValue();
	int p2 = getCaliValue();

	WARNING("NOT IMPLEMENTED\n");
	
	DEBUG_COMMAND_YET("SACT.Maze_Create %d,%d:\n", p1,p2);
}

/**
 * SACT.Maze_Get (1.0~)
 */
void Maze_Get() {
	int *p1 = getCaliVariable();
	int p2 = getCaliValue();
	int p3 = getCaliValue();
	
	WARNING("NOT IMPLEMENTED\n");
	
	DEBUG_COMMAND_YET("SACT.Maze_Get %p,%d,%d:\n", p1,p2,p3);
}

/**
 * SACT.EncryptWORD (1.0~)
 */
void EncryptWORD() {
	int *array = getCaliVariable();
	int num = getCaliValue();
	int key = getCaliValue();

	scryp_encrypt_word(array, num, key);
	
	DEBUG_COMMAND_YET("SACT.EncryptWORD %p,%d,%d:\n", array, num, key);
}

/**
 * SACT.DecryptWORD (1.0~)
 */
void DecryptWORD() {
	int *array = getCaliVariable();
	int num = getCaliValue();
	int key = getCaliValue();

	scryp_encrypt_word(array, num, key);
	
	DEBUG_COMMAND_YET("SACT.DecryptWORD %p,%d,%d:\n", array, num, key);
}

/**
 * SACT.EncryptString (1.0~)
 */
void EncryptString() {
	int p1 = getCaliValue();
	int p2 = getCaliValue();

	scryp_encrypt_str(p1, p2);
	
	DEBUG_COMMAND_YET("SACT.EncryptString %d,%d:\n", p1,p2);
}

/**
 * SACT.DecryptString (1.0~)
 */
void DecryptString() {
	int p1 = getCaliValue();
	int p2 = getCaliValue();

	scryp_decrypt_str(p1, p2);
	
	DEBUG_COMMAND_YET("SACT.DecryptString %d,%d:\n", p1,p2);
}

/**
 * SACT.XMenuClear (1.0~)
 *   ĥ˥塼
 */
void XMenuClear() {
	spxm_clear();
	
	DEBUG_COMMAND_YET("SACT.XMenuClear:\n");
}

/**
 * SACT.XMenuRegister (1.0~)
 *   ߥХåեˤʸĥ˥塼ΥƥȤϿ
 *   @param nRegiNum: ĥ˥塼ǥåֹ
 *   @param nMenuID: 򤵤줿Ȥֹ֤(ID)
 */
void XMenuRegister() {
	int nRegiNum = getCaliValue();
	int nMenuID  = getCaliValue();
	
	spxm_register(nRegiNum, nMenuID);
	
	DEBUG_COMMAND_YET("SACT.XMenuRegister %d,%d:\n", nRegiNum, nMenuID);
}

/**
 * SACT.XMenuGetNum (1.0~)
 *   XMenuRegisterϿ줿ID֤
 *   @param nRegiNum: ǥåֹ
 *   @param vMenuID: ϿƤIDǼѿ
 */
void XMenuGetNum() {
	int nRegiNum = getCaliValue();
	int *vMenuID = getCaliVariable();
	
	*vMenuID = spxm_getnum(nRegiNum);
	
	DEBUG_COMMAND_YET("SACT.XMenuGetNum %d,%p:\n", nRegiNum, vMenuID);
}

/**
 * SACT.XMenuGetText (1.0~)
 *   XMenuRegisterϿƥʸѿ˥ԡ
 *   @param nRegiNum: ǥåֹ
 *   @param strno: ԡʸѿֹ
 */
void XMenuGetText() {
	int nRegiNum = getCaliValue();
	int strno    = getCaliValue();
	
	spxm_gettext(nRegiNum, strno);
	
	DEBUG_COMMAND_YET("SACT.XMenuGetText %d,%d:\n", nRegiNum, strno);
}

/**
 * SACT.XMenuTitleRegister (1.0~)
 *   ߥХåեˤʸĥ˥塼ΥȥȤϿ
 */
void XMenuTitleRegister() {
	spxm_titlereg();
	
	DEBUG_COMMAND_YET("SACT.XMenuTitleRegister:\n");
}

/**
 * SACT.XMenuTitleGet (1.0~)
 *   ĥ˥塼Υȥʸѿ˥ԡ
 *   @param strno: ԡʸѿֹ
 */
void XMenuTitleGet() {
	int strno = getCaliValue();
	
	spxm_titleget(strno);
	
	DEBUG_COMMAND_YET("SACT.XMenuTitleGet %d:\n", strno);
}
