/*
   This file is copied from the xawtv sources, which are released
   under the terms of the GNU GPL. This licence header added for clarity
   by Malte Starotik <malte@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110, USA
*/

#include <stdlib.h>

#include "frequencies.h"

#define CHAN_COUNT(x) (sizeof(x)/sizeof(struct CHANLIST))

/* --------------------------------------------------------------------- */

/* US broadcast */
static const struct CHANLIST ntsc_bcast[] = {
    {  "2",  55250 / 50 },
    {  "3",  61250 / 50 },
    {  "4",  67250 / 50 },
    {  "5",  77250 / 50 },
    {  "6",  83250 / 50 },
    {  "7", 175250 / 50 },
    {  "8", 181250 / 50 },
    {  "9", 187250 / 50 },
    { "10", 193250 / 50 },
    { "11", 199250 / 50 },
    { "12", 205250 / 50 },
    { "13", 211250 / 50 },
    { "14", 471250 / 50 },
    { "15", 477250 / 50 },
    { "16", 483250 / 50 },
    { "17", 489250 / 50 },
    { "18", 495250 / 50 },
    { "19", 501250 / 50 },
    { "20", 507250 / 50 },
    { "21", 513250 / 50 },
    { "22", 519250 / 50 },
    { "23", 525250 / 50 },
    { "24", 531250 / 50 },
    { "25", 537250 / 50 },
    { "26", 543250 / 50 },
    { "27", 549250 / 50 },
    { "28", 555250 / 50 },
    { "29", 561250 / 50 },
    { "30", 567250 / 50 },
    { "31", 573250 / 50 },
    { "32", 579250 / 50 },
    { "33", 585250 / 50 },
    { "34", 591250 / 50 },
    { "35", 597250 / 50 },
    { "36", 603250 / 50 },
    { "37", 609250 / 50 },
    { "38", 615250 / 50 },
    { "39", 621250 / 50 },
    { "40", 627250 / 50 },
    { "41", 633250 / 50 },
    { "42", 639250 / 50 },
    { "43", 645250 / 50 },
    { "44", 651250 / 50 },
    { "45", 657250 / 50 },
    { "46", 663250 / 50 },
    { "47", 669250 / 50 },
    { "48", 675250 / 50 },
    { "49", 681250 / 50 },
    { "50", 687250 / 50 },
    { "51", 693250 / 50 },
    { "52", 699250 / 50 },
    { "53", 705250 / 50 },
    { "54", 711250 / 50 },
    { "55", 717250 / 50 },
    { "56", 723250 / 50 },
    { "57", 729250 / 50 },
    { "58", 735250 / 50 },
    { "59", 741250 / 50 },
    { "60", 747250 / 50 },
    { "61", 753250 / 50 },
    { "62", 759250 / 50 },
    { "63", 765250 / 50 },
    { "64", 771250 / 50 },
    { "65", 777250 / 50 },
    { "66", 783250 / 50 },
    { "67", 789250 / 50 },
    { "68", 795250 / 50 },
    { "69", 801250 / 50 },
    { "70", 807250 / 50 },
    { "71", 813250 / 50 },
    { "72", 819250 / 50 },
    { "73", 825250 / 50 },
    { "74", 831250 / 50 },
    { "75", 837250 / 50 },
    { "76", 843250 / 50 },
    { "77", 849250 / 50 },
    { "78", 855250 / 50 },
    { "79", 861250 / 50 },
    { "80", 867250 / 50 },
    { "81", 873250 / 50 },
    { "82", 879250 / 50 },
    { "83", 885250 / 50 },
};

/* US cable */
static const struct CHANLIST ntsc_cable[] = {
    {   "1",  73250 / 50 },
    {   "2",  55250 / 50 },
    {   "3",  61250 / 50 },
    {   "4",  67250 / 50 },
    {   "5",  77250 / 50 },
    {   "6",  83250 / 50 },
    {   "7", 175250 / 50 },
    {   "8", 181250 / 50 },
    {   "9", 187250 / 50 },
    {  "10", 193250 / 50 },
    {  "11", 199250 / 50 },
    {  "12", 205250 / 50 },

    {  "13", 211250 / 50 },
    {  "14", 121250 / 50 },
    {  "15", 127250 / 50 },
    {  "16", 133250 / 50 },
    {  "17", 139250 / 50 },
    {  "18", 145250 / 50 },
    {  "19", 151250 / 50 },
    {  "20", 157250 / 50 },

    {  "21", 163250 / 50 },
    {  "22", 169250 / 50 },
    {  "23", 217250 / 50 },
    {  "24", 223250 / 50 },
    {  "25", 229250 / 50 },
    {  "26", 235250 / 50 },
    {  "27", 241250 / 50 },
    {  "28", 247250 / 50 },
    {  "29", 253250 / 50 },
    {  "30", 259250 / 50 },
    {  "31", 265250 / 50 },
    {  "32", 271250 / 50 },
    {  "33", 277250 / 50 },
    {  "34", 283250 / 50 },
    {  "35", 289250 / 50 },
    {  "36", 295250 / 50 },
    {  "37", 301250 / 50 },
    {  "38", 307250 / 50 },
    {  "39", 313250 / 50 },
    {  "40", 319250 / 50 },
    {  "41", 325250 / 50 },
    {  "42", 331250 / 50 },
    {  "43", 337250 / 50 },
    {  "44", 343250 / 50 },
    {  "45", 349250 / 50 },
    {  "46", 355250 / 50 },
    {  "47", 361250 / 50 },
    {  "48", 367250 / 50 },
    {  "49", 373250 / 50 },
    {  "50", 379250 / 50 },
    {  "51", 385250 / 50 },
    {  "52", 391250 / 50 },
    {  "53", 397250 / 50 },
    {  "54", 403250 / 50 },
    {  "55", 409250 / 50 },
    {  "56", 415250 / 50 },
    {  "57", 421250 / 50 },
    {  "58", 427250 / 50 },
    {  "59", 433250 / 50 },
    {  "60", 439250 / 50 },
    {  "61", 445250 / 50 },
    {  "62", 451250 / 50 },
    {  "63", 457250 / 50 },
    {  "64", 463250 / 50 },
    {  "65", 469250 / 50 },
    {  "66", 475250 / 50 },
    {  "67", 481250 / 50 },
    {  "68", 487250 / 50 },
    {  "69", 493250 / 50 },

    {  "70", 499250 / 50 },
    {  "71", 505250 / 50 },
    {  "72", 511250 / 50 },
    {  "73", 517250 / 50 },
    {  "74", 523250 / 50 },
    {  "75", 529250 / 50 },
    {  "76", 535250 / 50 },
    {  "77", 541250 / 50 },
    {  "78", 547250 / 50 },
    {  "79", 553250 / 50 },
    {  "80", 559250 / 50 },
    {  "81", 565250 / 50 },
    {  "82", 571250 / 50 },
    {  "83", 577250 / 50 },
    {  "84", 583250 / 50 },
    {  "85", 589250 / 50 },
    {  "86", 595250 / 50 },
    {  "87", 601250 / 50 },
    {  "88", 607250 / 50 },
    {  "89", 613250 / 50 },
    {  "90", 619250 / 50 },
    {  "91", 625250 / 50 },
    {  "92", 631250 / 50 },
    {  "93", 637250 / 50 },
    {  "94", 643250 / 50 },
    {  "95",  91250 / 50 },
    {  "96",  97250 / 50 },
    {  "97", 103250 / 50 },
    {  "98", 109250 / 50 },
    {  "99", 115250 / 50 },
    { "100", 649250 / 50 },
    { "101", 655250 / 50 },
    { "102", 661250 / 50 },
    { "103", 667250 / 50 },
    { "104", 673250 / 50 },
    { "105", 679250 / 50 },
    { "106", 685250 / 50 },
    { "107", 691250 / 50 },
    { "108", 697250 / 50 },
    { "109", 703250 / 50 },
    { "110", 709250 / 50 },
    { "111", 715250 / 50 },
    { "112", 721250 / 50 },
    { "113", 727250 / 50 },
    { "114", 733250 / 50 },
    { "115", 739250 / 50 },
    { "116", 745250 / 50 },
    { "117", 751250 / 50 },
    { "118", 757250 / 50 },
    { "119", 763250 / 50 },
    { "120", 769250 / 50 },
    { "121", 775250 / 50 },
    { "122", 781250 / 50 },
    { "123", 787250 / 50 },
    { "124", 793250 / 50 },
    { "125", 799250 / 50 },

    {  "T7",   8250 / 50 },
    {  "T8",  14250 / 50 },
    {  "T9",  20250 / 50 },
    { "T10",  26250 / 50 },
    { "T11",  32250 / 50 },
    { "T12",  38250 / 50 },
    { "T13",  44250 / 50 },
    { "T14",  50250 / 50 }
};

/* US HRC */
static const struct CHANLIST ntsc_hrc[] = {
    {   "1",  72000 / 50 },
    {   "2",  54000 / 50 },
    {   "3",  60000 / 50 },
    {   "4",  66000 / 50 },
    {   "5",  78000 / 50 },
    {   "6",  84000 / 50 },
    {   "7", 174000 / 50 },
    {   "8", 180000 / 50 },
    {   "9", 186000 / 50 },
    {  "10", 192000 / 50 },
    {  "11", 198000 / 50 },
    {  "12", 204000 / 50 },

    {  "13", 210000 / 50 },
    {  "14", 120000 / 50 },
    {  "15", 126000 / 50 },
    {  "16", 132000 / 50 },
    {  "17", 138000 / 50 },
    {  "18", 144000 / 50 },
    {  "19", 150000 / 50 },
    {  "20", 156000 / 50 },

    {  "21", 162000 / 50 },
    {  "22", 168000 / 50 },
    {  "23", 216000 / 50 },
    {  "24", 222000 / 50 },
    {  "25", 228000 / 50 },
    {  "26", 234000 / 50 },
    {  "27", 240000 / 50 },
    {  "28", 246000 / 50 },
    {  "29", 252000 / 50 },
    {  "30", 258000 / 50 },
    {  "31", 264000 / 50 },
    {  "32", 270000 / 50 },
    {  "33", 276000 / 50 },
    {  "34", 282000 / 50 },
    {  "35", 288000 / 50 },
    {  "36", 294000 / 50 },
    {  "37", 300000 / 50 },
    {  "38", 306000 / 50 },
    {  "39", 312000 / 50 },
    {  "40", 318000 / 50 },
    {  "41", 324000 / 50 },
    {  "42", 330000 / 50 },
    {  "43", 336000 / 50 },
    {  "44", 342000 / 50 },
    {  "45", 348000 / 50 },
    {  "46", 354000 / 50 },
    {  "47", 360000 / 50 },
    {  "48", 366000 / 50 },
    {  "49", 372000 / 50 },
    {  "50", 378000 / 50 },
    {  "51", 384000 / 50 },
    {  "52", 390000 / 50 },
    {  "53", 396000 / 50 },
    {  "54", 402000 / 50 },
    {  "55", 408000 / 50 },
    {  "56", 414000 / 50 },
    {  "57", 420000 / 50 },
    {  "58", 426000 / 50 },
    {  "59", 432000 / 50 },
    {  "60", 438000 / 50 },
    {  "61", 444000 / 50 },
    {  "62", 450000 / 50 },
    {  "63", 456000 / 50 },
    {  "64", 462000 / 50 },
    {  "65", 468000 / 50 },
    {  "66", 474000 / 50 },
    {  "67", 480000 / 50 },
    {  "68", 486000 / 50 },
    {  "69", 492000 / 50 },

    {  "70", 498000 / 50 },
    {  "71", 504000 / 50 },
    {  "72", 510000 / 50 },
    {  "73", 516000 / 50 },
    {  "74", 522000 / 50 },
    {  "75", 528000 / 50 },
    {  "76", 534000 / 50 },
    {  "77", 540000 / 50 },
    {  "78", 546000 / 50 },
    {  "79", 552000 / 50 },
    {  "80", 558000 / 50 },
    {  "81", 564000 / 50 },
    {  "82", 570000 / 50 },
    {  "83", 576000 / 50 },
    {  "84", 582000 / 50 },
    {  "85", 588000 / 50 },
    {  "86", 594000 / 50 },
    {  "87", 600000 / 50 },
    {  "88", 606000 / 50 },
    {  "89", 612000 / 50 },
    {  "90", 618000 / 50 },
    {  "91", 624000 / 50 },
    {  "92", 630000 / 50 },
    {  "93", 636000 / 50 },
    {  "94", 642000 / 50 },
    {  "95", 900000 / 50 },
    {  "96", 960000 / 50 },
    {  "97", 102000 / 50 },
    {  "98", 108000 / 50 },
    {  "99", 114000 / 50 },
    { "100", 648000 / 50 },
    { "101", 654000 / 50 },
    { "102", 660000 / 50 },
    { "103", 666000 / 50 },
    { "104", 672000 / 50 },
    { "105", 678000 / 50 },
    { "106", 684000 / 50 },
    { "107", 690000 / 50 },
    { "108", 696000 / 50 },
    { "109", 702000 / 50 },
    { "110", 708000 / 50 },
    { "111", 714000 / 50 },
    { "112", 720000 / 50 },
    { "113", 726000 / 50 },
    { "114", 732000 / 50 },
    { "115", 738000 / 50 },
    { "116", 744000 / 50 },
    { "117", 750000 / 50 },
    { "118", 756000 / 50 },
    { "119", 762000 / 50 },
    { "120", 768000 / 50 },
    { "121", 774000 / 50 },
    { "122", 780000 / 50 },
    { "123", 786000 / 50 },
    { "124", 792000 / 50 },
    { "125", 798000 / 50 },

    {  "T7",   7000 / 50 },
    {  "T8",  13000 / 50 },
    {  "T9",  19000 / 50 },
    { "T10",  25000 / 50 },
    { "T11",  31000 / 50 },
    { "T12",  37000 / 50 },
    { "T13",  43000 / 50 },
    { "T14",  49000 / 50 },
};

/* --------------------------------------------------------------------- */

/* Canada cable */
static const struct CHANLIST ntsc_cable_ca[] = {
    {   "2",  61750 / 50 },
    {   "3",  67750 / 50 },
    {   "4",  73750 / 50 },
    {   "5",  83750 / 50 },
    {   "6",  89750 / 50 },
    {   "7", 181750 / 50 },
    {   "8", 187750 / 50 },
    {   "9", 193750 / 50 },
    {  "10", 199750 / 50 },
    {  "11", 205750 / 50 },
    {  "12", 211750 / 50 },

    {  "13", 217750 / 50 },
    {  "14", 127750 / 50 },
    {  "15", 133750 / 50 },
    {  "16", 139750 / 50 },
    {  "17", 145750 / 50 },
    {  "18", 151750 / 50 },
    {  "19", 157750 / 50 },
    {  "20", 163750 / 50 },

    {  "21", 169750 / 50 },
    {  "22", 175750 / 50 },
    {  "23", 223750 / 50 },
    {  "24", 229750 / 50 },
    {  "25", 235750 / 50 },
    {  "26", 241750 / 50 },
    {  "27", 247750 / 50 },
    {  "28", 253750 / 50 },
    {  "29", 259750 / 50 },
    {  "30", 265750 / 50 },
    {  "31", 271750 / 50 },
    {  "32", 277750 / 50 },
    {  "33", 283750 / 50 },
    {  "34", 289750 / 50 },
    {  "35", 295750 / 50 },
    {  "36", 301750 / 50 },
    {  "37", 307750 / 50 },
    {  "38", 313750 / 50 },
    {  "39", 319750 / 50 },
    {  "40", 325750 / 50 },
    {  "41", 331750 / 50 },
    {  "42", 337750 / 50 },
    {  "43", 343750 / 50 },
    {  "44", 349750 / 50 },
    {  "45", 355750 / 50 },
    {  "46", 361750 / 50 },
    {  "47", 367750 / 50 },
    {  "48", 373750 / 50 },
    {  "49", 379750 / 50 },
    {  "50", 385750 / 50 },
    {  "51", 391750 / 50 },
    {  "52", 397750 / 50 },
    {  "53", 403750 / 50 },
    {  "54", 409750 / 50 },
    {  "55", 415750 / 50 },
    {  "56", 421750 / 50 },
    {  "57", 427750 / 50 },
    {  "58", 433750 / 50 },
    {  "59", 439750 / 50 },
    {  "60", 445750 / 50 },
    {  "61", 451750 / 50 },
    {  "62", 457750 / 50 },
    {  "63", 463750 / 50 },
    {  "64", 469750 / 50 },
    {  "65", 475750 / 50 },
    {  "66", 481750 / 50 },
    {  "67", 487750 / 50 },
    {  "68", 493750 / 50 },
    {  "69", 499750 / 50 },

    {  "70", 505750 / 50 },
    {  "71", 511750 / 50 },
    {  "72", 517750 / 50 },
    {  "73", 523750 / 50 },
    {  "74", 529750 / 50 },
    {  "75", 535750 / 50 },
    {  "76", 541750 / 50 },
    {  "77", 547750 / 50 },
    {  "78", 553750 / 50 },
    {  "79", 559750 / 50 },
    {  "80", 565750 / 50 },
    {  "81", 571750 / 50 },
    {  "82", 577750 / 50 },
    {  "83", 583750 / 50 },
    {  "84", 589750 / 50 },
    {  "85", 595750 / 50 },
    {  "86", 601750 / 50 },
    {  "87", 607750 / 50 },
    {  "88", 613750 / 50 },
    {  "89", 619750 / 50 },
    {  "90", 625750 / 50 },
    {  "91", 631750 / 50 },
    {  "92", 637750 / 50 },
    {  "93", 643750 / 50 },
    {  "94", 649750 / 50 },
    {  "95",  97750 / 50 },
    {  "96", 103750 / 50 },
    {  "97", 109750 / 50 },
    {  "98", 115750 / 50 },
    {  "99", 121750 / 50 },
    { "100", 655750 / 50 },
    { "101", 661750 / 50 },
    { "102", 667750 / 50 },
    { "103", 673750 / 50 },
    { "104", 679750 / 50 },
    { "105", 685750 / 50 },
    { "106", 691750 / 50 },
    { "107", 697750 / 50 },
    { "108", 703750 / 50 },
    { "109", 709750 / 50 },
    { "110", 715750 / 50 },
    { "111", 721750 / 50 },
    { "112", 727750 / 50 },
    { "113", 733750 / 50 },
    { "114", 739750 / 50 },
    { "115", 745750 / 50 },
    { "116", 751750 / 50 },
    { "117", 757750 / 50 },
    { "118", 763750 / 50 },
    { "119", 769750 / 50 },
    { "120", 775750 / 50 },
    { "121", 781750 / 50 },
    { "122", 787750 / 50 },
    { "123", 793750 / 50 },
    { "124", 799750 / 50 },
    { "125", 805750 / 50 }
};

/* --------------------------------------------------------------------- */

/* JP broadcast */
static const struct CHANLIST ntsc_bcast_jp[] = {
    {   "1",  91250 / 50 },
    {   "2",  97250 / 50 },
    {   "3", 103250 / 50 },
    {   "4", 171250 / 50 },
    {   "5", 177250 / 50 },
    {   "6", 183250 / 50 },
    {   "7", 189250 / 50 },
    {   "8", 193250 / 50 },
    {   "9", 199250 / 50 },
    {  "10", 205250 / 50 },
    {  "11", 211250 / 50 },
    {  "12", 217250 / 50 },

    {  "13", 471250 / 50 },
    {  "14", 477250 / 50 },
    {  "15", 483250 / 50 },
    {  "16", 489250 / 50 },
    {  "17", 495250 / 50 },
    {  "18", 501250 / 50 },
    {  "19", 507250 / 50 },
    {  "20", 513250 / 50 },
    {  "21", 519250 / 50 },
    {  "22", 525250 / 50 },
    {  "23", 531250 / 50 },
    {  "24", 537250 / 50 },
    {  "25", 543250 / 50 },
    {  "26", 549250 / 50 },
    {  "27", 555250 / 50 },
    {  "28", 561250 / 50 },
    {  "29", 567250 / 50 },
    {  "30", 573250 / 50 },
    {  "31", 579250 / 50 },
    {  "32", 585250 / 50 },
    {  "33", 591250 / 50 },
    {  "34", 597250 / 50 },
    {  "35", 603250 / 50 },
    {  "36", 609250 / 50 },
    {  "37", 615250 / 50 },
    {  "38", 621250 / 50 },
    {  "39", 627250 / 50 },
    {  "40", 633250 / 50 },
    {  "41", 639250 / 50 },
    {  "42", 645250 / 50 },
    {  "43", 651250 / 50 },
    {  "44", 657250 / 50 },

    {  "45", 663250 / 50 },
    {  "46", 669250 / 50 },
    {  "47", 675250 / 50 },
    {  "48", 681250 / 50 },
    {  "49", 687250 / 50 },
    {  "50", 693250 / 50 },
    {  "51", 699250 / 50 },
    {  "52", 705250 / 50 },
    {  "53", 711250 / 50 },
    {  "54", 717250 / 50 },
    {  "55", 723250 / 50 },
    {  "56", 729250 / 50 },
    {  "57", 735250 / 50 },
    {  "58", 741250 / 50 },
    {  "59", 747250 / 50 },
    {  "60", 753250 / 50 },
    {  "61", 759250 / 50 },
    {  "62", 765250 / 50 },
};

/* JP cable */
static const struct CHANLIST ntsc_cable_jp[] = {
    {  "13", 109250 / 50 },
    {  "14", 115250 / 50 },
    {  "15", 121250 / 50 },
    {  "16", 127250 / 50 },
    {  "17", 133250 / 50 },
    {  "18", 139250 / 50 },
    {  "19", 145250 / 50 },
    {  "20", 151250 / 50 },

    {  "21", 157250 / 50 },
    {  "22", 165250 / 50 },
    {  "23", 223250 / 50 },
    {  "24", 231250 / 50 },
    {  "25", 237250 / 50 },
    {  "26", 243250 / 50 },
    {  "27", 249250 / 50 },
    {  "28", 253250 / 50 },
    {  "29", 259250 / 50 },
    {  "30", 265250 / 50 },
    {  "31", 271250 / 50 },
    {  "32", 277250 / 50 },
    {  "33", 283250 / 50 },
    {  "34", 289250 / 50 },
    {  "35", 295250 / 50 },
    {  "36", 301250 / 50 },
    {  "37", 307250 / 50 },
    {  "38", 313250 / 50 },
    {  "39", 319250 / 50 },
    {  "40", 325250 / 50 },
    {  "41", 331250 / 50 },
    {  "42", 337250 / 50 },
    {  "43", 343250 / 50 },
    {  "44", 349250 / 50 },
    {  "45", 355250 / 50 },
    {  "46", 361250 / 50 },
    {  "47", 367250 / 50 },
    {  "48", 373250 / 50 },
    {  "49", 379250 / 50 },
    {  "50", 385250 / 50 },
    {  "51", 391250 / 50 },
    {  "52", 397250 / 50 },
    {  "53", 403250 / 50 },
    {  "54", 409250 / 50 },
    {  "55", 415250 / 50 },
    {  "56", 421250 / 50 },
    {  "57", 427250 / 50 },
    {  "58", 433250 / 50 },
    {  "59", 439250 / 50 },
    {  "60", 445250 / 50 },
    {  "61", 451250 / 50 },
    {  "62", 457250 / 50 },
    {  "63", 463250 / 50 },
};

/* --------------------------------------------------------------------- */

/* australia */
static const struct CHANLIST pal_australia[] = {
    {   "0",  46250 / 50 },
    {   "1",  57250 / 50 },
    {   "2",  64250 / 50 },
    {   "3",  86250 / 50 },
    {   "4",  95250 / 50 },
    {   "5", 102250 / 50 },
    {  "5A", 138250 / 50 },
    {   "6", 175250 / 50 },
    {   "7", 182250 / 50 },
    {   "8", 189250 / 50 },
    {   "9", 196250 / 50 },
    {  "10", 209250 / 50 },
    {  "11", 216250 / 50 },
    {  "28", 527250 / 50 },
    {  "29", 534250 / 50 },
    {  "30", 541250 / 50 },
    {  "31", 548250 / 50 },
    {  "32", 555250 / 50 },
    {  "33", 562250 / 50 },
    {  "34", 569250 / 50 },
    {  "35", 576250 / 50 },
    {  "36", 591250 / 50 },
    {  "39", 604250 / 50 },
    {  "40", 611250 / 50 },
    {  "41", 618250 / 50 },
    {  "42", 625250 / 50 },
    {  "43", 632250 / 50 },
    {  "44", 639250 / 50 },
    {  "45", 646250 / 50 },
    {  "46", 653250 / 50 },
    {  "47", 660250 / 50 },
    {  "48", 667250 / 50 },
    {  "49", 674250 / 50 },
    {  "50", 681250 / 50 },
    {  "51", 688250 / 50 },
    {  "52", 695250 / 50 },
    {  "53", 702250 / 50 },
    {  "54", 709250 / 50 },
    {  "55", 716250 / 50 },
    {  "56", 723250 / 50 },
    {  "57", 730250 / 50 },
    {  "58", 737250 / 50 },
    {  "59", 744250 / 50 },
    {  "60", 751250 / 50 },
    {  "61", 758250 / 50 },
    {  "62", 765250 / 50 },
    {  "63", 772250 / 50 },
    {  "64", 779250 / 50 },
    {  "65", 786250 / 50 },
    {  "66", 793250 / 50 },
    {  "67", 800250 / 50 },
    {  "68", 807250 / 50 },
    {  "69", 814250 / 50 },
};

static const struct CHANLIST pal_australia_optus[] = {
    {   "1", 138250 / 50 },
    {   "2", 147250 / 50 },
    {   "3", 154250 / 50 },
    {   "4", 161250 / 50 },
    {   "5", 168250 / 50 },
    {   "6", 175250 / 50 },
    {   "7", 182250 / 50 },
    {   "8", 189250 / 50 },
    {   "9", 196250 / 50 },
    {  "10", 209250 / 50 },
    {  "11", 216250 / 50 },
    {  "12", 224250 / 50 },
    {  "13", 231250 / 50 },
    {  "14", 238250 / 50 },
    {  "15", 245250 / 50 },
    {  "16", 252250 / 50 },
    {  "17", 259250 / 50 },
    {  "18", 266250 / 50 },
    {  "19", 273250 / 50 },
    {  "20", 280250 / 50 },
    {  "21", 287250 / 50 },
    {  "22", 294250 / 50 },
    {  "23", 303250 / 50 },
    {  "24", 310250 / 50 },
    {  "25", 317250 / 50 },
    {  "26", 324250 / 50 },
    {  "27", 338250 / 50 },
    {  "28", 345250 / 50 },
    {  "29", 352250 / 50 },
    {  "30", 359250 / 50 },
    {  "31", 366250 / 50 },
    {  "32", 373250 / 50 },
    {  "33", 380250 / 50 },
    {  "34", 387250 / 50 },
    {  "35", 394250 / 50 },
    {  "36", 401250 / 50 },
    {  "37", 408250 / 50 },
    {  "38", 415250 / 50 },
    {  "39", 422250 / 50 },
    {  "40", 429250 / 50 },
    {  "41", 436250 / 50 },
    {  "42", 443250 / 50 },
    {  "43", 450250 / 50 },
    {  "44", 457250 / 50 },
    {  "45", 464250 / 50 },
    {  "46", 471250 / 50 },
    {  "47", 478250 / 50 },
    {  "48", 485250 / 50 },
 };

/* --------------------------------------------------------------------- */
/* europe                                                                */

/* CCIR frequencies */

#define FREQ_CCIR_I_III		\
    {   "E2",  48250 / 50 },	\
    {   "E3",  55250 / 50 },	\
    {   "E4",  62250 / 50 },	\
				\
    {  "S01",  69250 / 50 },	\
    {  "S02",  76250 / 50 },	\
    {  "S03",  83250 / 50 },	\
				\
    {   "E5", 175250 / 50 },	\
    {   "E6", 182250 / 50 },	\
    {   "E7", 189250 / 50 },	\
    {   "E8", 196250 / 50 },	\
    {   "E9", 203250 / 50 },	\
    {  "E10", 210250 / 50 },	\
    {  "E11", 217250 / 50 },	\
    {  "E12", 224250 / 50 }

#define FREQ_CCIR_SL_SH		\
    {  "SE1", 105250 / 50 },	\
    {  "SE2", 112250 / 50 },	\
    {  "SE3", 119250 / 50 },	\
    {  "SE4", 126250 / 50 },	\
    {  "SE5", 133250 / 50 },	\
    {  "SE6", 140250 / 50 },	\
    {  "SE7", 147250 / 50 },	\
    {  "SE8", 154250 / 50 },	\
    {  "SE9", 161250 / 50 },	\
    { "SE10", 168250 / 50 },	\
				\
    { "SE11", 231250 / 50 },	\
    { "SE12", 238250 / 50 },	\
    { "SE13", 245250 / 50 },	\
    { "SE14", 252250 / 50 },	\
    { "SE15", 259250 / 50 },	\
    { "SE16", 266250 / 50 },	\
    { "SE17", 273250 / 50 },	\
    { "SE18", 280250 / 50 },	\
    { "SE19", 287250 / 50 },	\
    { "SE20", 294250 / 50 }

#define FREQ_CCIR_H	\
    {  "S21", 303250 / 50 },	\
    {  "S22", 311250 / 50 },	\
    {  "S23", 319250 / 50 },	\
    {  "S24", 327250 / 50 },	\
    {  "S25", 335250 / 50 },	\
    {  "S26", 343250 / 50 },	\
    {  "S27", 351250 / 50 },	\
    {  "S28", 359250 / 50 },	\
    {  "S29", 367250 / 50 },	\
    {  "S30", 375250 / 50 },	\
    {  "S31", 383250 / 50 },	\
    {  "S32", 391250 / 50 },	\
    {  "S33", 399250 / 50 },	\
    {  "S34", 407250 / 50 },	\
    {  "S35", 415250 / 50 },	\
    {  "S36", 423250 / 50 },	\
    {  "S37", 431250 / 50 },	\
    {  "S38", 439250 / 50 },	\
    {  "S39", 447250 / 50 },	\
    {  "S40", 455250 / 50 },	\
    {  "S41", 463250 / 50 }

/* OIRT frequencies */

#define FREQ_OIRT_I_III		\
    {   "R1",  49750 / 50 },	\
    {   "R2",  59250 / 50 },	\
				\
    {   "R3",  77250 / 50 },	\
    {   "R4",  85250 / 50 },	\
    {   "R5",  93250 / 50 },	\
				\
    {   "R6", 175250 / 50 },	\
    {   "R7", 183250 / 50 },	\
    {   "R8", 191250 / 50 },	\
    {   "R9", 199250 / 50 },	\
    {  "R10", 207250 / 50 },	\
    {  "R11", 215250 / 50 },	\
    {  "R12", 223250 / 50 }

#define FREQ_OIRT_SL_SH		\
    {  "SR1", 111250 / 50 },	\
    {  "SR2", 119250 / 50 },	\
    {  "SR3", 127250 / 50 },	\
    {  "SR4", 135250 / 50 },	\
    {  "SR5", 143250 / 50 },	\
    {  "SR6", 151250 / 50 },	\
    {  "SR7", 159250 / 50 },	\
    {  "SR8", 167250 / 50 },	\
				\
    { "SR11", 231250 / 50 },	\
    { "SR12", 239250 / 50 },	\
    { "SR13", 247250 / 50 },	\
    { "SR14", 255250 / 50 },	\
    { "SR15", 263250 / 50 },	\
    { "SR16", 271250 / 50 },	\
    { "SR17", 279250 / 50 },	\
    { "SR18", 287250 / 50 },	\
    { "SR19", 295250 / 50 }

#define FREQ_UHF	\
    {   "21", 471250 / 50 },	\
    {   "22", 479250 / 50 },	\
    {   "23", 487250 / 50 },	\
    {   "24", 495250 / 50 },	\
    {   "25", 503250 / 50 },	\
    {   "26", 511250 / 50 },	\
    {   "27", 519250 / 50 },	\
    {   "28", 527250 / 50 },	\
    {   "29", 535250 / 50 },	\
    {   "30", 543250 / 50 },	\
    {   "31", 551250 / 50 },	\
    {   "32", 559250 / 50 },	\
    {   "33", 567250 / 50 },	\
    {   "34", 575250 / 50 },	\
    {   "35", 583250 / 50 },	\
    {   "36", 591250 / 50 },	\
    {   "37", 599250 / 50 },	\
    {   "38", 607250 / 50 },	\
    {   "39", 615250 / 50 },	\
    {   "40", 623250 / 50 },	\
    {   "41", 631250 / 50 },	\
    {   "42", 639250 / 50 },	\
    {   "43", 647250 / 50 },	\
    {   "44", 655250 / 50 },	\
    {   "45", 663250 / 50 },	\
    {   "46", 671250 / 50 },	\
    {   "47", 679250 / 50 },	\
    {   "48", 687250 / 50 },	\
    {   "49", 695250 / 50 },	\
    {   "50", 703250 / 50 },	\
    {   "51", 711250 / 50 },	\
    {   "52", 719250 / 50 },	\
    {   "53", 727250 / 50 },	\
    {   "54", 735250 / 50 },	\
    {   "55", 743250 / 50 },	\
    {   "56", 751250 / 50 },	\
    {   "57", 759250 / 50 },	\
    {   "58", 767250 / 50 },	\
    {   "59", 775250 / 50 },	\
    {   "60", 783250 / 50 },	\
    {   "61", 791250 / 50 },	\
    {   "62", 799250 / 50 },	\
    {   "63", 807250 / 50 },	\
    {   "64", 815250 / 50 },	\
    {   "65", 823250 / 50 },	\
    {   "66", 831250 / 50 },	\
    {   "67", 839250 / 50 },	\
    {   "68", 847250 / 50 },	\
    {   "69", 855250 / 50 }

static const struct CHANLIST europe_west[] = {
    FREQ_CCIR_I_III,
    FREQ_CCIR_SL_SH,
    FREQ_CCIR_H,
    FREQ_UHF
};

static const struct CHANLIST europe_east[] = {
    FREQ_OIRT_I_III,
    FREQ_OIRT_SL_SH,
    FREQ_CCIR_I_III,
    FREQ_CCIR_SL_SH,
    FREQ_CCIR_H,
    FREQ_UHF
};

static const struct CHANLIST pal_italy[] = {
    {   "A",  53750 / 50 },
    {   "B",  62250 / 50 },
    {   "C",  82250 / 50 },
    {   "D", 175250 / 50 },
    {   "E", 183750 / 50 },
    {   "F", 192250 / 50 },
    {   "G", 201250 / 50 },
    {   "H", 210250 / 50 },
    {  "H1", 217250 / 50 },
    {  "H2", 224250 / 50 },
    FREQ_UHF
};

static const struct CHANLIST pal_ireland[] = {
    {  "A0",  45750 / 50 },
    {  "A1",  48000 / 50 },
    {  "A2",  53750 / 50 },
    {  "A3",  56000 / 50 },
    {  "A4",  61750 / 50 },
    {  "A5",  64000 / 50 },
    {  "A6", 175250 / 50 },
    {  "A7", 176000 / 50 },
    {  "A8", 183250 / 50 },
    {  "A9", 184000 / 50 },
    { "A10", 191250 / 50 },
    { "A11", 192000 / 50 },
    { "A12", 199250 / 50 },
    { "A13", 200000 / 50 },
    { "A14", 207250 / 50 },
    { "A15", 208000 / 50 },
    { "A16", 215250 / 50 },
    { "A17", 216000 / 50 },
    { "A18", 224000 / 50 },
    { "A19", 232000 / 50 },
    { "A20", 248000 / 50 },
    { "A21", 256000 / 50 },
    { "A22", 264000 / 50 },
    { "A23", 272000 / 50 },
    { "A24", 280000 / 50 },
    { "A25", 288000 / 50 },
    { "A26", 296000 / 50 },
    { "A27", 304000 / 50 },
    { "A28", 312000 / 50 },
    { "A29", 320000 / 50 },
    { "A30", 344000 / 50 },
    { "A31", 352000 / 50 },
    { "A32", 408000 / 50 },
    { "A33", 416000 / 50 },
    { "A34", 448000 / 50 },
    { "A35", 480000 / 50 },
    { "A36", 520000 / 50 },
    FREQ_UHF,
};

static const struct CHANLIST secam_france[] = {
    { "K01",  47750 / 50 },
    { "K02",  55750 / 50 },
    { "K03",  60500 / 50 },
    { "K04",  63750 / 50 },
    { "K05", 176000 / 50 },
    { "K06", 184000 / 50 },
    { "K07", 192000 / 50 },
    { "K08", 200000 / 50 },
    { "K09", 208000 / 50 },
    { "K10", 216000 / 50 },
    {  "KB", 116750 / 50 },
    {  "KC", 128750 / 50 },
    {  "KD", 140750 / 50 },
    {  "KE", 159750 / 50 },
    {  "KF", 164750 / 50 },
    {  "KG", 176750 / 50 },
    {  "KH", 188750 / 50 },
    {  "KI", 200750 / 50 },
    {  "KJ", 212750 / 50 },
    {  "KK", 224750 / 50 },
    {  "KL", 236750 / 50 },
    {  "KM", 248750 / 50 },
    {  "KN", 260750 / 50 },
    {  "KO", 272750 / 50 },
    {  "KP", 284750 / 50 },
    {  "KQ", 296750 / 50 },
    { "H01", 303250 / 50 },
    { "H02", 311250 / 50 },
    { "H03", 319250 / 50 },
    { "H04", 327250 / 50 },
    { "H05", 335250 / 50 },
    { "H06", 343250 / 50 },
    { "H07", 351250 / 50 },
    { "H08", 359250 / 50 },
    { "H09", 367250 / 50 },
    { "H10", 375250 / 50 },
    { "H11", 383250 / 50 },
    { "H12", 391250 / 50 },
    { "H13", 399250 / 50 },
    { "H14", 407250 / 50 },
    { "H15", 415250 / 50 },
    { "H16", 423250 / 50 },
    { "H17", 431250 / 50 },
    { "H18", 439250 / 50 },
    { "H19", 447250 / 50 },
    FREQ_UHF,
};

/* --------------------------------------------------------------------- */

static const struct CHANLIST pal_newzealand[] = {
    {   "1",  45250 / 50 },
    {   "2",  55250 / 50 },
    {   "3",  62250 / 50 },
    {   "4", 175250 / 50 },
    {   "5", 182250 / 50 },
    {   "6", 189250 / 50 },
    {   "7", 196250 / 50 },
    {   "8", 203250 / 50 },
    {   "9", 210250 / 50 },
    {  "10", 217250 / 50 },
    {  "11", 224250 / 50 },
    FREQ_UHF,
};

/* --------------------------------------------------------------------- */

/* China broadcast */
static const struct CHANLIST pal_bcast_cn[] = {
    {   "1",  49750 / 50 },
    {   "2",  57750 / 50 },
    {   "3",  65750 / 50 },
    {   "4",  77250 / 50 },
    {   "5",  85250 / 50 },
    {   "6", 112250 / 50 },
    {   "7", 120250 / 50 },
    {   "8", 128250 / 50 },
    {   "9", 136250 / 50 },
    {  "10", 144250 / 50 },
    {  "11", 152250 / 50 },
    {  "12", 160250 / 50 },
    {  "13", 168250 / 50 },
    {  "14", 176250 / 50 },
    {  "15", 184250 / 50 },
    {  "16", 192250 / 50 },
    {  "17", 200250 / 50 },
    {  "18", 208250 / 50 },
    {  "19", 216250 / 50 },
    {  "20", 224250 / 50 },
    {  "21", 232250 / 50 },
    {  "22", 240250 / 50 },
    {  "23", 248250 / 50 },
    {  "24", 256250 / 50 },
    {  "25", 264250 / 50 },
    {  "26", 272250 / 50 },
    {  "27", 280250 / 50 },
    {  "28", 288250 / 50 },
    {  "29", 296250 / 50 },
    {  "30", 304250 / 50 },
    {  "31", 312250 / 50 },
    {  "32", 320250 / 50 },
    {  "33", 328250 / 50 },
    {  "34", 336250 / 50 },
    {  "35", 344250 / 50 },
    {  "36", 352250 / 50 },
    {  "37", 360250 / 50 },
    {  "38", 368250 / 50 },
    {  "39", 376250 / 50 },
    {  "40", 384250 / 50 },
    {  "41", 392250 / 50 },
    {  "42", 400250 / 50 },
    {  "43", 408250 / 50 },
    {  "44", 416250 / 50 },
    {  "45", 424250 / 50 },
    {  "46", 432250 / 50 },
    {  "47", 440250 / 50 },
    {  "48", 448250 / 50 },
    {  "49", 456250 / 50 },
    {  "50", 463250 / 50 },
    {  "51", 471250 / 50 },
    {  "52", 479250 / 50 },
    {  "53", 487250 / 50 },
    {  "54", 495250 / 50 },
    {  "55", 503250 / 50 },
    {  "56", 511250 / 50 },
    {  "57", 519250 / 50 },
    {  "58", 527250 / 50 },
    {  "59", 535250 / 50 },
    {  "60", 543250 / 50 },
    {  "61", 551250 / 50 },
    {  "62", 559250 / 50 },
    {  "63", 607250 / 50 },
    {  "64", 615250 / 50 },
    {  "65", 623250 / 50 },
    {  "66", 631250 / 50 },
    {  "67", 639250 / 50 },
    {  "68", 647250 / 50 },
    {  "69", 655250 / 50 },
    {  "70", 663250 / 50 },
    {  "71", 671250 / 50 },
    {  "72", 679250 / 50 },
    {  "73", 687250 / 50 },
    {  "74", 695250 / 50 },
    {  "75", 703250 / 50 },
    {  "76", 711250 / 50 },
    {  "77", 719250 / 50 },
    {  "78", 727250 / 50 },
    {  "79", 735250 / 50 },
    {  "80", 743250 / 50 },
    {  "81", 751250 / 50 },
    {  "82", 759250 / 50 },
    {  "83", 767250 / 50 },
    {  "84", 775250 / 50 },
    {  "85", 783250 / 50 },
    {  "86", 791250 / 50 },
    {  "87", 799250 / 50 },
    {  "88", 807250 / 50 },
    {  "89", 815250 / 50 },
    {  "90", 823250 / 50 },
    {  "91", 831250 / 50 },
    {  "92", 839250 / 50 },
    {  "93", 847250 / 50 },
    {  "94", 855250 / 50 },
};

/* --------------------------------------------------------------------- */
/* South Africa Broadcast */

static const struct CHANLIST pal_bcast_za[] ={
    {   "1", 175250 / 50 },
    {   "2", 183250 / 50 },
    {   "3", 191250 / 50 },
    {   "4", 199250 / 50 },
    {   "5", 207250 / 50 },
    {   "6", 215250 / 50 },
    {   "7", 223250 / 50 },
    {   "8", 231250 / 50 },
    FREQ_UHF
};

/* --------------------------------------------------------------------- */

static const struct CHANLIST argentina[] = {
    { "001",  56250 / 50 },
    { "002",  62250 / 50 },
    { "003",  68250 / 50 },
    { "004",  78250 / 50 },
    { "005",  84250 / 50 },
    { "006", 176250 / 50 },
    { "007", 182250 / 50 },
    { "008", 188250 / 50 },
    { "009", 194250 / 50 },
    { "010", 200250 / 50 },
    { "011", 206250 / 50 },
    { "012", 212250 / 50 },
    { "013", 122250 / 50 },
    { "014", 128250 / 50 },
    { "015", 134250 / 50 },
    { "016", 140250 / 50 },
    { "017", 146250 / 50 },
    { "018", 152250 / 50 },
    { "019", 158250 / 50 },
    { "020", 164250 / 50 },
    { "021", 170250 / 50 },
    { "022", 218250 / 50 },
    { "023", 224250 / 50 },
    { "024", 230250 / 50 },
    { "025", 236250 / 50 },
    { "026", 242250 / 50 },
    { "027", 248250 / 50 },
    { "028", 254250 / 50 },
    { "029", 260250 / 50 },
    { "030", 266250 / 50 },
    { "031", 272250 / 50 },
    { "032", 278250 / 50 },
    { "033", 284250 / 50 },
    { "034", 290250 / 50 },
    { "035", 296250 / 50 },
    { "036", 302250 / 50 },
    { "037", 308250 / 50 },
    { "038", 314250 / 50 },
    { "039", 320250 / 50 },
    { "040", 326250 / 50 },
    { "041", 332250 / 50 },
    { "042", 338250 / 50 },
    { "043", 344250 / 50 },
    { "044", 350250 / 50 },
    { "045", 356250 / 50 },
    { "046", 362250 / 50 },
    { "047", 368250 / 50 },
    { "048", 374250 / 50 },
    { "049", 380250 / 50 },
    { "050", 386250 / 50 },
    { "051", 392250 / 50 },
    { "052", 398250 / 50 },
    { "053", 404250 / 50 },
    { "054", 410250 / 50 },
    { "055", 416250 / 50 },
    { "056", 422250 / 50 },
    { "057", 428250 / 50 },
    { "058", 434250 / 50 },
    { "059", 440250 / 50 },
    { "060", 446250 / 50 },
    { "061", 452250 / 50 },
    { "062", 458250 / 50 },
    { "063", 464250 / 50 },
    { "064", 470250 / 50 },
    { "065", 476250 / 50 },
    { "066", 482250 / 50 },
    { "067", 488250 / 50 },
    { "068", 494250 / 50 },
    { "069", 500250 / 50 },
    { "070", 506250 / 50 },
    { "071", 512250 / 50 },
    { "072", 518250 / 50 },
    { "073", 524250 / 50 },
    { "074", 530250 / 50 },
    { "075", 536250 / 50 },
    { "076", 542250 / 50 },
    { "077", 548250 / 50 },
    { "078", 554250 / 50 },
    { "079", 560250 / 50 },
    { "080", 566250 / 50 },
    { "081", 572250 / 50 },
    { "082", 578250 / 50 },
    { "083", 584250 / 50 },
    { "084", 590250 / 50 },
    { "085", 596250 / 50 },
    { "086", 602250 / 50 },
    { "087", 608250 / 50 },
    { "088", 614250 / 50 },
    { "089", 620250 / 50 },
    { "090", 626250 / 50 },
    { "091", 632250 / 50 },
    { "092", 638250 / 50 },
    { "093", 644250 / 50 },
};

/* --------------------------------------------------------------------- */

const struct CHANLISTS chanlists[17] = {
    { "us-bcast",         ntsc_bcast,        CHAN_COUNT(ntsc_bcast)        },
    { "us-cable",         ntsc_cable,        CHAN_COUNT(ntsc_cable)        },
    { "us-cable-hrc",     ntsc_hrc,          CHAN_COUNT(ntsc_hrc)          },
    { "japan-bcast",      ntsc_bcast_jp,     CHAN_COUNT(ntsc_bcast_jp)     },
    { "japan-cable",      ntsc_cable_jp,     CHAN_COUNT(ntsc_cable_jp)     },
    { "europe-west",      europe_west,       CHAN_COUNT(europe_west)       },
    { "europe-east",      europe_east,       CHAN_COUNT(europe_east)       },
    { "italy",	          pal_italy,         CHAN_COUNT(pal_italy)         },
    { "newzealand",       pal_newzealand,    CHAN_COUNT(pal_newzealand)    },
    { "australia",        pal_australia,     CHAN_COUNT(pal_australia)     },
    { "ireland",          pal_ireland,       CHAN_COUNT(pal_ireland)       },
    { "france",           secam_france,      CHAN_COUNT(secam_france)      },
    { "china-bcast",      pal_bcast_cn,      CHAN_COUNT(pal_bcast_cn)      },
    { "southafrica",      pal_bcast_za,      CHAN_COUNT(pal_bcast_za)      },
    { "argentina",        argentina,         CHAN_COUNT(argentina)         },
    { "canada-cable",     ntsc_cable_ca,     CHAN_COUNT(ntsc_cable_ca)     },
    { "australia-optus",  pal_australia_optus,     CHAN_COUNT(pal_australia_optus)     }
};

/* vim: ts=4 sw=4 noet
 */
