// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::ffi;
#[cfg(feature = "v1_1")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
use crate::DataSourceRequest;
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, pin::Pin};

glib::wrapper! {
    #[doc(alias = "ShumateDataSource")]
    pub struct DataSource(Object<ffi::ShumateDataSource, ffi::ShumateDataSourceClass>);

    match fn {
        type_ => || ffi::shumate_data_source_get_type(),
    }
}

impl DataSource {
    pub const NONE: Option<&'static DataSource> = None;
}

pub trait DataSourceExt: IsA<DataSource> + 'static {
    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    #[doc(alias = "shumate_data_source_get_max_zoom_level")]
    #[doc(alias = "get_max_zoom_level")]
    #[doc(alias = "max-zoom-level")]
    fn max_zoom_level(&self) -> u32 {
        unsafe { ffi::shumate_data_source_get_max_zoom_level(self.as_ref().to_glib_none().0) }
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    #[doc(alias = "shumate_data_source_get_min_zoom_level")]
    #[doc(alias = "get_min_zoom_level")]
    #[doc(alias = "min-zoom-level")]
    fn min_zoom_level(&self) -> u32 {
        unsafe { ffi::shumate_data_source_get_min_zoom_level(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "shumate_data_source_get_tile_data_async")]
    #[doc(alias = "get_tile_data_async")]
    fn tile_data_async<P: FnOnce(Result<Option<glib::Bytes>, glib::Error>) + 'static>(
        &self,
        x: i32,
        y: i32,
        zoom_level: i32,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn tile_data_async_trampoline<
            P: FnOnce(Result<Option<glib::Bytes>, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = std::ptr::null_mut();
            let ret = ffi::shumate_data_source_get_tile_data_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = tile_data_async_trampoline::<P>;
        unsafe {
            ffi::shumate_data_source_get_tile_data_async(
                self.as_ref().to_glib_none().0,
                x,
                y,
                zoom_level,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn tile_data_future(
        &self,
        x: i32,
        y: i32,
        zoom_level: i32,
    ) -> Pin<
        Box_<dyn std::future::Future<Output = Result<Option<glib::Bytes>, glib::Error>> + 'static>,
    > {
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.tile_data_async(x, y, zoom_level, Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    #[doc(alias = "shumate_data_source_set_max_zoom_level")]
    #[doc(alias = "max-zoom-level")]
    fn set_max_zoom_level(&self, zoom_level: u32) {
        unsafe {
            ffi::shumate_data_source_set_max_zoom_level(self.as_ref().to_glib_none().0, zoom_level);
        }
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    #[doc(alias = "shumate_data_source_set_min_zoom_level")]
    #[doc(alias = "min-zoom-level")]
    fn set_min_zoom_level(&self, zoom_level: u32) {
        unsafe {
            ffi::shumate_data_source_set_min_zoom_level(self.as_ref().to_glib_none().0, zoom_level);
        }
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    #[doc(alias = "shumate_data_source_start_request")]
    fn start_request(
        &self,
        x: i32,
        y: i32,
        zoom_level: i32,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Option<DataSourceRequest> {
        unsafe {
            from_glib_full(ffi::shumate_data_source_start_request(
                self.as_ref().to_glib_none().0,
                x,
                y,
                zoom_level,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
            ))
        }
    }

    #[cfg_attr(feature = "v1_1", deprecated = "Since 1.1")]
    #[doc(alias = "received-data")]
    fn connect_received_data<F: Fn(&Self, i32, i32, i32, &glib::Bytes) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn received_data_trampoline<
            P: IsA<DataSource>,
            F: Fn(&P, i32, i32, i32, &glib::Bytes) + 'static,
        >(
            this: *mut ffi::ShumateDataSource,
            x: std::ffi::c_int,
            y: std::ffi::c_int,
            zoom_level: std::ffi::c_int,
            bytes: *mut glib::ffi::GBytes,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                DataSource::from_glib_borrow(this).unsafe_cast_ref(),
                x,
                y,
                zoom_level,
                &from_glib_borrow(bytes),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"received-data".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    received_data_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    #[doc(alias = "max-zoom-level")]
    fn connect_max_zoom_level_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_zoom_level_trampoline<
            P: IsA<DataSource>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::ShumateDataSource,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(DataSource::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::max-zoom-level".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_max_zoom_level_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    #[doc(alias = "min-zoom-level")]
    fn connect_min_zoom_level_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_min_zoom_level_trampoline<
            P: IsA<DataSource>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::ShumateDataSource,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(DataSource::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::min-zoom-level".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_min_zoom_level_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<DataSource>> DataSourceExt for O {}
