/* male.c -- Male voice data
 *
 * Copyright (C) 1990, 1991 Speech Research Laboratory, Minsk
 * Copyright (C) 2005 Igor Poretsky <poretsky@mlbox.ru>
 * Copyright (C) 2021 Boris Lobanov <lobbormef@gmail.com>
 * Copyright (C) 2021 Alexander Ivanov <ivalex01@gmail.com>
 *
 * SPDX-License-Identifier: MIT
 */

#include <stdint.h>

#include "voice.h"


const voice_t male =
  {
    10000, /* Pitch factor */

    /* Sound offsets */
    {
      0, 101, 202,
      303, 404, 505,
      606, 707, 808,
      909, 1010, 1111,
      1212, 1313, 1414,
      1515, 1616, 1717,
      1818, 1919, 2020,
      2121, 2222, 2323,
      2424, 2525, 2626,
      2727, 2828, 2929,
      3030, 3131, 3232,
      3333, 3434, 3535,
      3636, 3737, 3838,
      3939, 4040, 4141,
      4242, 4343, 4444,
      4545, 4646, 4747,
      4848, 4949, 5050,
      5151, 5252, 5353,
      5454, 5555, 5656,
      5757, 5858, 5959,
      6060, 6161, 6262,
      6363, 6464, 6565,
      6666, 6767, 6868,
      6969, 7070, 7171,
      7272, 7373, 7474,
      7575, 7676, 7777,
      7878, 7979, 8080,
      8181, 8282, 8383,
      8484, 8585, 8686,
      8787, 8888, 8989,
      9090, 9191, 9292,
      9393, 9494, 9595,
      9696, 9797, 9898,
      9999, 10100, 10201,
      10302, 10403, 10504,
      10605, 10706, 10807,
      10908, 11009, 11110,
      11212, 11313, 11414,
      11515, 11616, 11717,
      11818, 11819, 11920,
      12021, 12122, 12223,
      12324, 12425, 13124,
      13720, 14522, 14623,
      14724, 15524, 16117,
      16118, 16119, 16220,
      16321, 16422, 16523,
      16624, 16725, 16922,
      17081, 17401, 17629,
      18092, 18419, 18632,
      18883, 19351, 19598,
      20098, 20527, 20713,
      20868, 21122, 21315,
      21466, 21735, 21936,
      22163, 22539, 22843,
      23084, 23484, 23585,
      23686, 23787, 23888,
      23989, 24090, 24091,
      24092, 24093, 24094,
      24095, 24096, 24097,
      24098, 24099, 24100,
      24101, 24102, 24103,
      24104, 24105, 24106,
      24107, 24108, 24109,
      24110, 24111, 24112,
      24113, 24114, 24115,
      24116, 24117, 24118,
      24119, 24120, 24121
    },

    /* Sound lengths */
    {
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 101,
      101, 101, 102,
      101, 101, 101,
      101, 101, 101,
      200, 101, 101,
      101, 101, 101,
      101, 699, 596,
      802, 101, 101,
      800, 593, 200,
      200, 101, 101,
      101, 101, 101,
      101, 197, 159,
      320, 228, 463,
      327, 213, 251,
      468, 247, 500,
      429, 186, 155,
      254, 193, 151,
      269, 201, 227,
      376, 304, 241,
      400, 101, 101,
      101, 101, 101,
      101, 200, 200,
      200, 200, 200,
      200, 200, 200,
      200, 200, 200,
      200, 200, 200,
      200, 200, 200,
      200, 200, 200,
      200, 200, 200,
      200, 200, 200,
      200, 200, 200,
      200, 200, 200
    },

    /* Samples */
    {
      0, 12, 32, 56, 78,
      91, 100, 89, 61, 34,
      11, -12, -36, -53, -58,
      -53, -42, -38, -40, -37,
      -36, -42, -53, -63, -65,
      -58, -46, -33, -17, 7,
      30, 46, 54, 56, 53,
      47, 36, 20, 6, 0,
      -3, -4, -3, -3, -1,
      1, -4, -16, -25, -33,
      -40, -45, -46, -42, -33,
      -22, -15, -8, 0, 6,
      8, 6, 1, -2, -3,
      -6, -9, -9, -8, -6,
      -6, -8, -11, -12, -16,
      -21, -25, -28, -28, -27,
      -26, -24, -18, -11, -7,
      -5, -4, -6, -7, -10,
      -16, -23, -24, -26, -30,
      -32, -26, -19, -13, -7,
      -1, 0, 18, 55, 85,
      99, 112, 110, 79, 39,
      -6, -47, -75, -93, -96,
      -86, -64, -44, -37, -32,
      -32, -35, -36, -38, -34,
      -18, 6, 34, 55, 73,
      84, 83, 71, 47, 21,
      -2, -21, -36, -44, -44,
      -39, -35, -34, -37, -39,
      -41, -43, -43, -36, -23,
      -6, 14, 33, 46, 56,
      58, 52, 40, 27, 11,
      -6, -20, -30, -37, -40,
      -42, -41, -38, -36, -33,
      -30, -26, -20, -14, -8,
      -2, 5, 10, 12, 12,
      10, 5, 0, -7, -15,
      -22, -29, -32, -36, -37,
      -37, -35, -32, -28, -25,
      -19, -13, -8, -5, -4,
      -3, 0, 0, 49, 106,
      125, 105, 77, 42, -3,
      -42, -70, -68, -44, -34,
      -38, -45, -50, -52, -51,
      -43, -19, 19, 52, 65,
      63, 53, 39, 22, 4,
      -6, -1, 5, 1, -15,
      -34, -48, -55, -57, -50,
      -31, -5, 14, 22, 23,
      22, 20, 18, 14, 16,
      21, 23, 17, 1, -17,
      -30, -39, -41, -38, -29,
      -17, -9, -7, -7, -6,
      -2, 4, 11, 17, 21,
      19, 9, -3, -16, -24,
      -27, -29, -27, -24, -21,
      -21, -22, -20, -15, -7,
      -1, 4, 8, 6, 1,
      -7, -13, -15, -16, -17,
      -18, -20, -23, -18, -14,
      -9, -5, -1, 0, 42,
      112, 108, 25, -29, 3,
      70, 103, 43, -48, -66,
      -35, -6, -8, -45, -71,
      -73, -72, -63, -37, -9,
      -6, -28, -47, -27, 29,
      64, 50, 18, 5, 27,
      56, 57, 35, 15, 3,
      -5, -13, -18, -17, -21,
      -42, -63, -59, -34, -15,
      -16, -31, -34, -13, 11,
      23, 21, 12, 12, 18,
      21, 24, 19, 11, 1,
      -12, -15, -13, -14, -22,
      -35, -41, -34, -24, -21,
      -23, -23, -17, -8, -2,
      0, 4, 5, 4, 4,
      4, 4, 2, -5, -12,
      -15, -17, -19, -25, -32,
      -34, -29, -26, -23, -18,
      -14, -9, -5, 0, 0,
      24, 62, 55, 14, -3,
      31, 86, 100, 49, -9,
      -13, 22, 50, 29, -23,
      -52, -49, -36, -36, -50,
      -61, -65, -69, -71, -59,
      -35, -23, -30, -41, -35,
      -3, 25, 25, 10, 3,
      21, 44, 49, 36, 23,
      22, 26, 24, 15, 5,
      -1, -7, -16, -24, -27,
      -28, -33, -42, -44, -37,
      -28, -25, -30, -32, -22,
      -8, -2, -3, -5, 1,
      13, 19, 18, 14, 12,
      13, 12, 7, 3, -2,
      -9, -14, -18, -20, -21,
      -25, -31, -32, -30, -27,
      -25, -26, -25, -19, -13,
      -12, -12, -10, -9, -7,
      -6, -5, -3, -2, -1,
      0, 34, 69, 51, 18,
      -5, 13, 74, 100, 79,
      44, 13, 17, 33, 30,
      20, 9, -4, -22, -47,
      -65, -59, -37, -32, -52,
      -80, -89, -67, -36, -24,
      -26, -30, -30, -21, -11,
      -3, 13, 26, 30, 24,
      12, 15, 34, 50, 53,
      40, 24, 18, 21, 19,
      13, 3, -6, -13, -27,
      -39, -43, -37, -32, -37,
      -50, -57, -51, -39, -31,
      -29, -28, -21, -12, -6,
      -1, 4, 14, 21, 19,
      13, 10, 12, 14, 8,
      -2, -11, -18, -24, -31,
      -36, -38, -35, -30, -29,
      -29, -30, -31, -29, -32,
      -39, -30, -22, -15, -8,
      -1, 0, 67, 111, 112,
      86, 49, 17, -3, -29,
      -52, -52, -35, -16, -11,
      -32, -65, -83, -74, -60,
      -43, -21, 1, 28, 46,
      44, 29, 15, 12, 22,
      36, 44, 45, 45, 38,
      20, -7, -36, -54, -51,
      -38, -27, -22, -21, -22,
      -23, -26, -27, -22, -8,
      14, 34, 44, 46, 39,
      25, 12, -2, -10, -9,
      -2, 0, -5, -17, -33,
      -42, -46, -45, -39, -28,
      -15, -3, 3, 0, -5,
      -9, -8, -4, 2, 7,
      11, 10, 1, -12, -27,
      -37, -38, -34, -29, -24,
      -19, -17, -17, -22, -29,
      -30, -25, -16, -7, -2,
      0, 0, 0, 24, 100,
      125, 94, 33, -2, -9,
      12, 17, -10, -38, -60,
      -76, -77, -62, -35, -5,
      8, -3, -15, -7, 21,
      50, 61, 53, 42, 31,
      19, 8, 3, 4, 3,
      -15, -43, -59, -54, -36,
      -22, -20, -20, -13, -5,
      2, 9, 22, 38, 46,
      34, 17, 8, 3, 2,
      -2, -17, -30, -39, -48,
      -48, -39, -29, -18, -12,
      -12, -8, 1, 11, 18,
      18, 13, 8, -1, -10,
      -16, -21, -25, -30, -37,
      -41, -39, -35, -30, -25,
      -20, -13, -7, -3, 0,
      2, 2, 1, -3, -10,
      -17, -23, -29, -32, -35,
      -24, -12, -1, 0, 19,
      90, 94, 21, -1, 58,
      112, 107, 42, -4, 9,
      25, 17, -1, -29, -61,
      -80, -74, -51, -46, -76,
      -99, -76, -36, -17, -23,
      -33, -20, 8, 27, 37,
      41, 40, 39, 44, 57,
      63, 49, 24, 11, 15,
      18, 2, -23, -38, -36,
      -34, -40, -45, -46, -43,
      -43, -37, -19, -13, -16,
      -14, -2, 17, 24, 18,
      15, 19, 24, 26, 21,
      12, 4, -2, -4, -6,
      -15, -26, -34, -35, -30,
      -28, -33, -37, -34, -26,
      -18, -15, -15, -12, -7,
      -2, 2, 2, -1, -3,
      -4, -2, -1, -6, -13,
      -17, -14, -14, 0, 0,
      36, 49, 32, 5, 36,
      93, 78, 48, 40, 38,
      61, 58, 29, 21, 0,
      -15, -7, -11, -36, -68,
      -75, -61, -56, -71, -94,
      -90, -71, -65, -60, -60,
      -58, -47, -34, -18, -8,
      -10, -6, 8, 25, 31,
      29, 27, 33, 43, 45,
      39, 33, 26, 23, 22,
      16, 6, 0, -3, -15,
      -19, -9, -19, -39, -44,
      -39, -32, -40, -53, -46,
      -33, -32, -34, -29, -24,
      -20, -15, -9, -3, -5,
      -7, 3, 10, 6, 1,
      1, 6, 5, -3, -10,
      -10, -14, -18, -20, -23,
      -29, -34, -32, -30, -34,
      -40, -38, -25, -13, -1,
      0, 11, 24, 37, 48,
      54, 56, 52, 44, 33,
      18, 2, -9, -18, -23,
      -25, -27, -28, -30, -34,
      -40, -48, -53, -56, -55,
      -50, -42, -28, -15, -1,
      11, 19, 26, 28, 27,
      24, 20, 19, 19, 20,
      22, 23, 24, 22, 17,
      8, -2, -11, -19, -25,
      -26, -25, -22, -18, -15,
      -14, -14, -16, -19, -21,
      -22, -21, -16, -11, -3,
      5, 11, 14, 14, 11,
      6, 1, -4, -9, -11,
      -11, -10, -9, -8, -9,
      -12, -16, -21, -25, -27,
      -29, -28, -24, -17, -9,
      -1, 4, 8, 9, 7,
      3, -1, -6, -9, -9,
      0, 0, 10, 25, 39,
      48, 55, 56, 47, 37,
      23, 6, -6, -15, -21,
      -24, -25, -26, -29, -32,
      -39, -47, -51, -53, -51,
      -43, -32, -19, -4, 9,
      19, 24, 26, 25, 22,
      20, 18, 18, 20, 21,
      22, 20, 15, 7, -3,
      -15, -25, -34, -37, -37,
      -33, -27, -21, -15, -11,
      -8, -7, -7, -6, -4,
      2, 10, 17, 24, 28,
      28, 25, 19, 9, 0,
      -9, -15, -18, -18, -18,
      -18, -18, -20, -23, -26,
      -29, -29, -26, -20, -13,
      -5, 2, 8, 12, 12,
      11, 9, 6, 3, 1,
      -2, -5, -4, -3, -2,
      -1, -1, 0, 3, 20,
      40, 53, 56, 54, 44,
      28, 11, -5, -13, -15,
      -14, -13, -17, -23, -31,
      -41, -49, -51, -44, -31,
      -16, -2, 9, 18, 22,
      23, 22, 20, 21, 25,
      30, 32, 31, 26, 15,
      3, -11, -23, -31, -32,
      -28, -23, -18, -15, -14,
      -14, -14, -13, -8, 1,
      12, 22, 30, 33, 31,
      27, 20, 12, 6, 4,
      4, 4, -1, -9, -18,
      -26, -31, -32, -31, -23,
      -13, -3, 4, 6, 5,
      4, 4, 4, 4, 7,
      10, 12, 10, 3, -6,
      -14, -18, -21, -20, -17,
      -13, -10, -10, -11, -13,
      -12, -8, 0, 0, 21,
      52, 56, 41, 19, 2,
      7, 13, 12, 12, 12,
      7, -6, -24, -41, -37,
      -20, -11, -9, -16, -23,
      -20, -15, -12, -6, 5,
      16, 24, 21, 11, 8,
      13, 19, 22, 20, 13,
      8, 3, -6, -13, -15,
      -12, -7, -8, -14, -18,
      -17, -13, -7, -3, 1,
      7, 9, 6, 3, 3,
      6, 12, 14, 10, 5,
      0, -4, -6, -8, -8,
      -6, -6, -9, -13, -16,
      -13, -8, -4, -2, -1,
      -1, -1, -2, -3, -1,
      2, 3, 1, -3, -6,
      -6, -5, -7, -8, -10,
      -11, -11, -11, -10, -8,
      -5, -3, -3, 0, 0,
      3, 18, 26, 37, 37,
      40, 52, 50, 51, 49,
      37, 33, 25, 11, 3,
      -7, -17, -28, -39, -50,
      -55, -53, -56, -57, -55,
      -54, -45, -36, -31, -20,
      -12, -4, 5, 11, 17,
      25, 31, 34, 36, 34,
      32, 33, 30, 26, 21,
      13, 6, 0, -7, -12,
      -16, -22, -27, -32, -34,
      -32, -29, -28, -26, -24,
      -20, -14, -7, -3, 1,
      2, 4, 9, 14, 16,
      15, 10, 7, 8, 8,
      5, 0, -8, -12, -15,
      -18, -20, -22, -25, -26,
      -27, -27, -24, -21, -19,
      -17, -16, -14, -9, -5,
      -2, 0, -1, -1, 0,
      0, 11, 24, 37, 48,
      54, 56, 52, 44, 33,
      18, 2, -9, -18, -23,
      -25, -27, -28, -30, -34,
      -40, -48, -53, -56, -55,
      -50, -42, -28, -15, -1,
      11, 19, 26, 28, 27,
      24, 20, 19, 19, 20,
      22, 23, 24, 22, 17,
      8, -2, -11, -19, -25,
      -26, -25, -22, -18, -15,
      -14, -14, -16, -19, -21,
      -22, -21, -16, -11, -3,
      5, 11, 14, 14, 11,
      6, 1, -4, -9, -11,
      -11, -10, -9, -8, -9,
      -12, -16, -21, -25, -27,
      -29, -28, -24, -17, -9,
      -1, 4, 8, 9, 7,
      3, -1, -6, -9, -9,
      0, 0, 10, 25, 39,
      48, 55, 56, 47, 37,
      23, 6, -6, -15, -21,
      -24, -25, -26, -29, -32,
      -39, -47, -51, -53, -51,
      -43, -32, -19, -4, 9,
      19, 24, 26, 25, 22,
      20, 18, 18, 20, 21,
      22, 20, 15, 7, -3,
      -15, -25, -34, -37, -37,
      -33, -27, -21, -15, -11,
      -8, -7, -7, -6, -4,
      2, 10, 17, 24, 28,
      28, 25, 19, 9, 0,
      -9, -15, -18, -18, -18,
      -18, -18, -20, -23, -26,
      -29, -29, -26, -20, -13,
      -5, 2, 8, 12, 12,
      11, 9, 6, 3, 1,
      -2, -5, -4, -3, -2,
      -1, -1, 0, 3, 20,
      40, 53, 56, 54, 44,
      28, 11, -5, -13, -15,
      -14, -13, -17, -23, -31,
      -41, -49, -51, -44, -31,
      -16, -2, 9, 18, 22,
      23, 22, 20, 21, 25,
      30, 32, 31, 26, 15,
      3, -11, -23, -31, -32,
      -28, -23, -18, -15, -14,
      -14, -14, -13, -8, 1,
      12, 22, 30, 33, 31,
      27, 20, 12, 6, 4,
      4, 4, -1, -9, -18,
      -26, -31, -32, -31, -23,
      -13, -3, 4, 6, 5,
      4, 4, 4, 4, 7,
      10, 12, 10, 3, -6,
      -14, -18, -21, -20, -17,
      -13, -10, -10, -11, -13,
      -12, -8, 0, 0, 21,
      52, 56, 41, 19, 2,
      7, 13, 12, 12, 12,
      7, -6, -24, -41, -37,
      -20, -11, -9, -16, -23,
      -20, -15, -12, -6, 5,
      16, 24, 21, 11, 8,
      13, 18, 22, 19, 13,
      8, 3, -6, -13, -15,
      -12, -7, -8, -14, -18,
      -17, -13, -7, -3, 1,
      7, 9, 6, 3, 3,
      6, 12, 14, 10, 5,
      0, -4, -6, -8, -8,
      -6, -6, -9, -13, -16,
      -13, -8, -4, -2, -1,
      -1, -1, -2, -3, -1,
      2, 3, 1, -3, -6,
      -6, -5, -7, -9, -10,
      -11, -11, -11, -10, -8,
      -5, -3, -3, 0, 0,
      3, 18, 26, 37, 37,
      40, 52, 50, 51, 49,
      37, 33, 25, 11, 3,
      -7, -17, -28, -39, -50,
      -55, -53, -56, -57, -55,
      -54, -45, -36, -31, -20,
      -12, -4, 5, 11, 17,
      25, 31, 34, 36, 34,
      32, 33, 30, 26, 21,
      13, 6, 0, -7, -12,
      -16, -22, -27, -32, -34,
      -32, -29, -28, -26, -24,
      -20, -14, -7, -3, 1,
      2, 4, 9, 14, 16,
      15, 10, 7, 8, 8,
      5, 0, -8, -12, -15,
      -18, -20, -22, -25, -26,
      -27, -27, -24, -21, -19,
      -17, -16, -14, -9, -5,
      -2, 0, -1, -1, 0,
      0, 4, 41, 56, 52,
      39, 25, 21, 17, 9,
      16, 31, 36, 25, 0,
      -26, -37, -35, -35, -33,
      -26, -22, -25, -37, -52,
      -54, -39, -21, -7, 2,
      7, 10, 9, 2, -1,
      8, 23, 34, 36, 30,
      20, 14, 7, 0, -1,
      3, 7, 6, -4, -16,
      -24, -27, -27, -24, -17,
      -10, -7, -9, -14, -16,
      -13, -9, -4, 3, 8,
      12, 11, 6, 2, 1,
      1, 2, 1, -1, -4,
      -8, -14, -19, -20, -19,
      -16, -14, -13, -11, -11,
      -13, -15, -14, -10, -6,
      -4, -4, -5, -4, -5,
      -7, -9, -8, -5, -3,
      0, 0, 18, 38, 52,
      52, 35, 28, 30, 35,
      40, 39, 31, 17, -3,
      -21, -29, -27, -24, -30,
      -38, -49, -57, -56, -51,
      -41, -28, -19, -15, -16,
      -15, -6, 5, 17, 26,
      31, 32, 28, 24, 24,
      28, 33, 32, 25, 14,
      3, -5, -11, -14, -14,
      -13, -17, -28, -34, -34,
      -27, -17, -12, -13, -11,
      -9, -10, -6, 1, 9,
      17, 16, 11, 10, 9,
      8, 7, 4, 2, -2,
      -10, -20, -22, -21, -21,
      -19, -19, -20, -21, -25,
      -25, -20, -11, -6, -5,
      -5, -4, -3, -4, -5,
      -2, -1, -3, -7, -5,
      -3, -1, 0, 15, 44,
      56, 35, 13, 14, 19,
      21, 23, 19, 13, -8,
      -34, -38, -23, -13, -17,
      -26, -32, -31, -28, -23,
      -7, 9, 11, 5, 1,
      7, 19, 26, 28, 31,
      28, 16, 5, 4, 8,
      10, 2, -9, -16, -21,
      -25, -22, -15, -9, -9,
      -14, -14, -6, 2, 7,
      12, 16, 15, 12, 11,
      13, 16, 15, 9, 3,
      -2, -6, -10, -11, -10,
      -10, -13, -17, -16, -12,
      -10, -6, -3, 0, 1,
      0, 1, 4, 5, 4,
      2, 1, -1, -3, -6,
      -7, -7, -8, -10, -13,
      -14, -12, -11, -10, -8,
      -5, -4, 0, 0, 23,
      38, 48, 35, 13, 24,
      38, 46, 44, 16, -3,
      -8, -13, -6, -7, -23,
      -43, -57, -52, -34, -24,
      -30, -37, -39, -30, -12,
      2, 9, 12, 6, 8,
      20, 32, 39, 34, 21,
      16, 17, 19, 19, 11,
      -3, -14, -20, -19, -15,
      -17, -25, -33, -34, -25,
      -15, -10, -9, -10, -8,
      0, 9, 16, 18, 14,
      11, 12, 16, 18, 13,
      5, 1, -1, -3, -5,
      -10, -16, -20, -22, -20,
      -18, -18, -20, -18, -15,
      -11, -7, -6, -4, -3,
      -2, 1, 3, 4, 3,
      -1, -4, -3, -2, -3,
      -3, -2, -1, -1, 0,
      9, 34, 33, 15, -1,
      10, 40, 45, 27, 8,
      1, 13, 19, 12, 0,
      -15, -28, -30, -23, -19,
      -28, -48, -57, -43, -26,
      -23, -32, -39, -32, -15,
      -5, -4, -5, -4, 1,
      9, 17, 21, 17, 10,
      10, 19, 26, 20, 8,
      -1, 3, 8, 6, -1,
      -12, -17, -14, -9, -7,
      -13, -25, -29, -19, -8,
      -8, -18, -25, -18, -6,
      -1, -4, -9, -9, -4,
      2, 5, 2, -3, -5,
      -2, 3, 3, -4, -11,
      -11, -6, -4, -10, -17,
      -18, -14, -10, -10, -14,
      -16, -15, -10, -6, -9,
      -12, -13, -11, -7, 0,
      0, 4, 41, 56, 52,
      39, 25, 21, 17, 9,
      16, 31, 36, 25, 0,
      -26, -37, -35, -35, -33,
      -26, -22, -25, -37, -52,
      -54, -39, -21, -7, 2,
      7, 10, 9, 2, -1,
      8, 23, 34, 36, 30,
      20, 14, 7, 0, -1,
      3, 7, 6, -4, -16,
      -24, -27, -27, -24, -17,
      -10, -7, -9, -14, -16,
      -13, -9, -4, 3, 8,
      12, 11, 6, 2, 1,
      1, 2, 1, -1, -4,
      -8, -14, -19, -20, -19,
      -16, -14, -13, -11, -11,
      -13, -15, -14, -10, -6,
      -4, -4, -5, -4, -5,
      -7, -9, -8, -5, -3,
      0, 0, 18, 38, 52,
      52, 35, 28, 30, 35,
      40, 39, 31, 17, -3,
      -21, -29, -27, -24, -30,
      -38, -49, -57, -56, -51,
      -41, -28, -19, -15, -16,
      -15, -6, 5, 17, 26,
      31, 32, 28, 24, 24,
      28, 33, 32, 25, 14,
      3, -5, -11, -14, -14,
      -13, -17, -28, -34, -34,
      -27, -17, -12, -13, -11,
      -9, -10, -6, 1, 9,
      17, 16, 11, 10, 9,
      8, 7, 4, 2, -2,
      -10, -20, -22, -21, -21,
      -19, -19, -20, -21, -25,
      -25, -20, -11, -6, -5,
      -5, -4, -3, -4, -5,
      -2, -1, -3, -7, -5,
      -3, -1, 0, 15, 44,
      56, 35, 13, 14, 19,
      21, 23, 19, 13, -8,
      -34, -38, -23, -13, -17,
      -26, -32, -31, -28, -23,
      -7, 9, 11, 5, 1,
      7, 19, 26, 28, 31,
      28, 16, 5, 4, 8,
      10, 2, -9, -16, -21,
      -25, -22, -15, -9, -9,
      -14, -14, -6, 2, 7,
      12, 16, 15, 12, 11,
      13, 16, 15, 9, 3,
      -2, -6, -10, -11, -10,
      -10, -13, -17, -16, -12,
      -10, -6, -3, 0, 1,
      0, 1, 4, 5, 4,
      2, 1, -1, -3, -6,
      -7, -7, -8, -10, -13,
      -14, -12, -11, -10, -8,
      -5, -4, 0, 0, 23,
      38, 48, 35, 13, 24,
      38, 46, 44, 16, -3,
      -8, -13, -6, -7, -23,
      -43, -57, -52, -34, -24,
      -30, -37, -39, -30, -12,
      2, 9, 12, 6, 8,
      20, 32, 39, 34, 21,
      16, 17, 19, 19, 11,
      -3, -14, -20, -19, -15,
      -17, -25, -33, -34, -25,
      -15, -10, -9, -10, -8,
      0, 9, 16, 18, 14,
      11, 12, 16, 18, 13,
      5, 1, -1, -3, -5,
      -10, -16, -20, -22, -20,
      -18, -18, -20, -18, -15,
      -11, -7, -6, -4, -3,
      -2, 1, 3, 4, 3,
      -1, -4, -3, -2, -3,
      -3, -2, -1, -1, 0,
      9, 34, 33, 15, -1,
      10, 40, 45, 27, 8,
      1, 13, 19, 12, 0,
      -15, -28, -30, -23, -19,
      -28, -48, -57, -43, -26,
      -23, -32, -39, -32, -15,
      -5, -4, -5, -4, 1,
      9, 17, 21, 17, 10,
      10, 19, 26, 20, 8,
      -1, 3, 8, 6, -1,
      -12, -17, -14, -9, -7,
      -13, -25, -29, -19, -8,
      -8, -18, -25, -18, -6,
      -1, -4, -9, -9, -4,
      2, 5, 2, -3, -5,
      -2, 3, 3, -4, -11,
      -11, -6, -4, -10, -17,
      -18, -14, -10, -10, -14,
      -16, -15, -10, -6, -9,
      -12, -13, -11, -7, 0,
      0, 2, 19, 36, 47,
      47, 51, 46, 30, 15,
      1, -2, 1, 4, 4,
      4, 4, -1, -14, -31,
      -49, -56, -57, -54, -47,
      -39, -27, -14, -7, -6,
      -8, -9, -9, -7, -4,
      2, 13, 24, 33, 36,
      34, 30, 24, 17, 8,
      3, 1, 2, 5, 5,
      3, -1, -8, -17, -28,
      -37, -41, -41, -38, -32,
      -25, -17, -10, -5, -5,
      -6, -6, -4, -1, 2,
      6, 12, 18, 22, 22,
      17, 10, 2, -8, -17,
      -23, -26, -26, -24, -21,
      -18, -15, -13, -11, -11,
      -12, -13, -13, -11, -9,
      -4, -1, 1, 1, 1,
      0, 0, 6, 35, 52,
      56, 50, 39, 31, 20,
      4, -8, -10, -3, 7,
      8, -3, -18, -30, -38,
      -45, -50, -51, -39, -22,
      -9, -2, -2, -3, -3,
      -1, 0, 1, 6, 17,
      30, 39, 39, 32, 24,
      17, 11, 5, -1, -3,
      -1, 1, -1, -7, -16,
      -23, -27, -28, -28, -24,
      -17, -10, -4, -2, -4,
      -4, -2, 1, 4, 7,
      11, 15, 18, 17, 13,
      7, 2, -1, -5, -8,
      -10, -10, -10, -11, -15,
      -18, -19, -19, -18, -16,
      -14, -11, -6, -3, -1,
      -1, -3, -4, -5, -5,
      -4, -2, 1, 2, 1,
      0, 0, 0, 31, 54,
      56, 43, 15, -3, -7,
      -4, 1, 2, -2, -4,
      -4, -11, -22, -29, -27,
      -14, 3, 13, 13, 9,
      3, 1, 5, 8, 11,
      15, 19, 21, 17, 7,
      -5, -12, -12, -6, 1,
      1, -2, -7, -10, -11,
      -9, -6, -1, 6, 12,
      14, 12, 6, 2, 1,
      2, 4, 3, 0, -3,
      -6, -8, -10, -11, -10,
      -6, -1, 2, 2, -1,
      -3, -3, -1, 1, 1,
      0, 0, -1, -3, -6,
      -9, -10, -8, -6, -4,
      -4, -6, -6, -5, -4,
      -3, -3, -3, -2, -1,
      -2, -4, -5, -6, -4,
      -3, -3, 0, 0, 7,
      38, 56, 44, 11, -14,
      -7, 24, 46, 36, -3,
      -40, -43, -17, 10, 11,
      -14, -42, -47, -28, -5,
      6, 1, -10, -14, -8,
      4, 13, 16, 16, 14,
      10, 6, 4, 5, 10,
      12, 5, -7, -17, -17,
      -9, -1, -2, -10, -18,
      -17, -7, 3, 8, 5,
      -1, -4, -1, 4, 7,
      5, 1, -2, -4, -5,
      -5, -4, -3, -4, -7,
      -10, -10, -7, -2, 0,
      -2, -6, -8, -5, -1,
      2, -1, -5, -8, -8,
      -5, -3, -5, -9, -10,
      -8, -6, -6, -7, -9,
      -9, -8, -6, -5, -4,
      -4, -3, -2, 0, 0,
      5, 22, 27, 16, 0,
      8, 37, 52, 36, 6,
      -9, 11, 40, 35, 0,
      -31, -29, -2, 10, -16,
      -50, -57, -36, -16, -21,
      -43, -53, -37, -17, -9,
      -17, -26, -19, -2, 9,
      9, 5, 5, 12, 20,
      21, 21, 20, 18, 16,
      14, 12, 13, 12, 4,
      -4, -8, -7, -5, -10,
      -19, -25, -22, -16, -16,
      -22, -26, -23, -16, -11,
      -12, -13, -10, -3, 2,
      2, 0, 2, 6, 8,
      6, 3, 2, 2, 2,
      -2, -7, -9, -9, -10,
      -14, -19, -20, -16, -15,
      -17, -20, -19, -15, -12,
      -11, -11, -9, -6, 0,
      0, 2, 19, 36, 47,
      47, 51, 46, 30, 15,
      1, -2, 1, 4, 4,
      4, 4, -1, -14, -31,
      -49, -56, -57, -54, -47,
      -39, -27, -14, -7, -6,
      -8, -9, -9, -7, -4,
      2, 13, 24, 33, 36,
      34, 30, 24, 17, 8,
      3, 1, 2, 5, 5,
      3, -1, -8, -17, -28,
      -37, -41, -41, -38, -32,
      -25, -17, -10, -5, -5,
      -6, -6, -4, -1, 2,
      6, 12, 18, 22, 22,
      17, 10, 2, -8, -17,
      -23, -26, -26, -24, -21,
      -18, -15, -13, -11, -11,
      -12, -13, -13, -11, -9,
      -4, -1, 1, 1, 1,
      0, 0, 6, 35, 52,
      56, 50, 39, 31, 20,
      4, -8, -10, -3, 7,
      8, -3, -18, -30, -38,
      -45, -50, -51, -39, -22,
      -9, -2, -2, -3, -3,
      -1, 0, 1, 6, 17,
      30, 39, 39, 32, 24,
      17, 11, 5, -1, -3,
      -1, 1, -1, -7, -16,
      -23, -27, -28, -28, -24,
      -17, -10, -4, -2, -4,
      -4, -2, 1, 4, 7,
      11, 15, 18, 17, 13,
      7, 2, -1, -5, -8,
      -10, -10, -10, -11, -15,
      -18, -19, -19, -18, -16,
      -14, -11, -6, -3, -1,
      -1, -3, -4, -5, -5,
      -4, -2, 1, 2, 1,
      0, 0, 0, 31, 54,
      56, 43, 15, -3, -7,
      -4, 1, 2, -2, -4,
      -4, -11, -22, -29, -27,
      -14, 3, 13, 13, 9,
      3, 1, 5, 8, 11,
      15, 19, 21, 17, 7,
      -5, -12, -12, -6, 1,
      1, -2, -7, -10, -11,
      -9, -6, -1, 6, 12,
      14, 12, 6, 2, 1,
      2, 4, 3, 0, -3,
      -6, -8, -10, -11, -10,
      -6, -1, 2, 2, -1,
      -3, -3, -1, 0, 1,
      0, 0, -1, -3, -6,
      -9, -10, -8, -6, -4,
      -4, -6, -6, -5, -4,
      -3, -3, -3, -2, -1,
      -2, -4, -5, -6, -4,
      -2, -3, 0, 0, 7,
      38, 56, 44, 12, -14,
      -7, 24, 46, 36, -3,
      -40, -43, -17, 10, 11,
      -14, -42, -47, -28, -5,
      7, 1, -10, -14, -8,
      4, 13, 16, 16, 14,
      10, 6, 4, 5, 10,
      12, 5, -7, -17, -17,
      -9, -1, -2, -10, -18,
      -17, -7, 3, 8, 5,
      -1, -4, -1, 4, 7,
      5, 1, -2, -4, -5,
      -5, -4, -3, -4, -7,
      -10, -10, -7, -2, 0,
      -2, -6, -8, -5, -1,
      2, -1, -5, -8, -8,
      -5, -3, -5, -9, -10,
      -9, -6, -6, -7, -9,
      -9, -7, -6, -5, -4,
      -4, -3, -2, 0, 0,
      5, 22, 27, 16, 0,
      8, 37, 52, 36, 6,
      -9, 11, 40, 35, 0,
      -31, -29, -2, 10, -16,
      -50, -57, -36, -16, -21,
      -43, -53, -37, -17, -9,
      -17, -26, -19, -2, 9,
      9, 5, 5, 12, 20,
      21, 21, 20, 18, 16,
      14, 12, 13, 12, 4,
      -4, -8, -7, -5, -10,
      -19, -25, -22, -16, -16,
      -22, -26, -23, -16, -11,
      -12, -13, -10, -3, 2,
      2, 0, 2, 6, 8,
      6, 3, 2, 2, 2,
      -2, -7, -9, -9, -10,
      -14, -19, -20, -16, -15,
      -17, -20, -19, -15, -12,
      -11, -11, -9, -6, 0,
      0, 16, 26, 37, 56,
      55, 46, 42, 16, -8,
      -10, -20, -30, -23, -17,
      -15, -10, -12, -23, -31,
      -31, -34, -35, -25, -15,
      -1, 14, 21, 26, 30,
      28, 23, 17, 12, 9,
      11, 14, 13, 13, 13,
      8, -1, -11, -21, -28,
      -29, -28, -25, -17, -8,
      -1, 5, 7, 8, 9,
      7, 5, 5, 5, 7,
      10, 10, 10, 8, 5,
      0, -6, -11, -15, -16,
      -16, -16, -14, -11, -8,
      -6, -6, -5, -4, -2,
      -1, 0, 2, 4, 5,
      5, 3, 1, 0, -1,
      -4, -6, -7, -7, -8,
      -7, -5, -4, -3, -2,
      -1, 0, 1, 15, 31,
      47, 54, 56, 55, 39,
      17, -3, -21, -31, -36,
      -36, -32, -25, -19, -22,
      -28, -30, -34, -33, -27,
      -20, -6, 10, 24, 33,
      37, 38, 34, 26, 19,
      11, 8, 8, 6, 3,
      1, -3, -11, -20, -30,
      -36, -36, -33, -28, -20,
      -10, -1, 6, 11, 12,
      13, 15, 14, 14, 17,
      19, 20, 20, 16, 9,
      1, -7, -17, -23, -25,
      -26, -23, -19, -16, -12,
      -9, -8, -7, -6, -4,
      -2, 1, 4, 7, 9,
      8, 5, 0, -5, -10,
      -14, -17, -18, -17, -16,
      -15, -13, -10, -8, -5,
      -3, -1, 0, 11, 34,
      50, 56, 48, 42, 28,
      8, -7, -17, -14, -11,
      -15, -20, -28, -33, -39,
      -45, -38, -25, -8, 6,
      13, 19, 23, 23, 20,
      17, 19, 25, 27, 24,
      17, 10, 0, -13, -25,
      -29, -26, -22, -19, -16,
      -13, -10, -9, -8, -4,
      4, 13, 19, 22, 25,
      25, 20, 13, 7, 3,
      2, -1, -6, -10, -13,
      -17, -22, -23, -19, -12,
      -5, -1, 4, 7, 7,
      5, 3, 3, 5, 5,
      2, 0, -3, -6, -11,
      -15, -16, -13, -11, -10,
      -8, -6, -5, -5, -6,
      -5, -2, 0, 0, -1,
      -2, -3, 0, 0, 11,
      35, 56, 51, 34, 24,
      14, 12, 15, 7, 3,
      -2, -17, -33, -45, -45,
      -32, -20, -17, -18, -16,
      -14, -10, -3, 4, 16,
      27, 29, 26, 19, 15,
      16, 18, 15, 10, 4,
      -3, -13, -21, -26, -23,
      -16, -14, -15, -16, -15,
      -11, -6, 1, 8, 15,
      17, 15, 13, 11, 11,
      11, 8, 4, 0, -5,
      -10, -15, -17, -15, -11,
      -9, -9, -9, -7, -5,
      -3, -1, 2, 4, 5,
      3, -1, -3, -3, -2,
      -3, -6, -8, -11, -13,
      -14, -14, -11, -8, -7,
      -7, -8, -6, -4, -2,
      -1, 0, -1, 0, 0,
      11, 40, 56, 46, 25,
      20, 28, 35, 29, 12,
      6, 4, 0, -12, -27,
      -31, -29, -33, -42, -48,
      -41, -29, -23, -25, -26,
      -18, -5, 2, 5, 8,
      16, 24, 25, 22, 22,
      26, 27, 21, 12, 5,
      5, 4, -4, -13, -19,
      -21, -22, -25, -27, -24,
      -19, -17, -18, -16, -9,
      0, 3, 2, 3, 8,
      13, 14, 12, 11, 12,
      10, 6, 2, 0, -1,
      -3, -10, -15, -16, -15,
      -15, -17, -19, -17, -15,
      -13, -12, -10, -7, -4,
      -5, -5, -2, 2, 3,
      1, -3, -3, -2, -2,
      -2, -1, -1, -1, -1,
      0, 16, 26, 37, 56,
      55, 46, 42, 16, -8,
      -10, -20, -30, -23, -17,
      -15, -10, -12, -23, -31,
      -31, -34, -35, -25, -15,
      -1, 14, 21, 26, 30,
      28, 23, 17, 12, 9,
      11, 14, 13, 13, 13,
      8, -1, -11, -21, -28,
      -29, -28, -25, -17, -8,
      -1, 5, 7, 8, 9,
      7, 5, 5, 5, 7,
      10, 10, 10, 8, 5,
      0, -6, -11, -15, -16,
      -16, -16, -14, -11, -8,
      -6, -6, -5, -4, -2,
      -1, 0, 2, 4, 5,
      5, 3, 1, 0, -1,
      -4, -6, -7, -7, -8,
      -7, -5, -4, -3, -2,
      -1, 0, 1, 15, 31,
      47, 54, 56, 55, 39,
      17, -3, -21, -31, -36,
      -36, -32, -25, -19, -22,
      -28, -30, -34, -33, -27,
      -20, -6, 10, 24, 33,
      37, 38, 34, 26, 19,
      11, 8, 8, 6, 3,
      1, -3, -11, -20, -30,
      -36, -36, -33, -28, -20,
      -10, -1, 6, 11, 12,
      13, 15, 14, 14, 17,
      19, 20, 20, 16, 9,
      1, -7, -17, -23, -25,
      -26, -23, -19, -16, -12,
      -9, -8, -7, -6, -4,
      -2, 1, 4, 7, 9,
      8, 5, 0, -5, -10,
      -14, -17, -18, -17, -16,
      -15, -13, -10, -8, -5,
      -3, -1, 0, 11, 34,
      50, 56, 48, 42, 28,
      8, -7, -17, -14, -11,
      -15, -20, -28, -33, -39,
      -45, -38, -25, -8, 6,
      13, 19, 23, 23, 20,
      17, 19, 25, 27, 24,
      17, 10, 0, -13, -25,
      -29, -26, -22, -19, -16,
      -13, -10, -9, -8, -4,
      4, 13, 19, 22, 25,
      25, 20, 13, 7, 3,
      2, -1, -6, -10, -13,
      -17, -22, -23, -19, -12,
      -5, -1, 4, 7, 7,
      5, 3, 3, 5, 5,
      2, 0, -3, -6, -11,
      -15, -16, -13, -11, -10,
      -8, -6, -5, -5, -6,
      -5, -2, 0, 0, -1,
      -2, -3, 0, 0, 11,
      35, 56, 51, 34, 24,
      14, 12, 15, 7, 3,
      -2, -17, -33, -45, -45,
      -32, -20, -17, -18, -16,
      -14, -10, -3, 4, 16,
      27, 29, 26, 19, 15,
      16, 18, 15, 10, 4,
      -3, -13, -21, -26, -23,
      -16, -14, -15, -16, -15,
      -11, -6, 1, 8, 15,
      17, 15, 13, 11, 11,
      11, 8, 4, 0, -5,
      -10, -15, -17, -15, -11,
      -9, -9, -9, -7, -5,
      -3, -1, 2, 4, 5,
      3, -1, -3, -3, -2,
      -3, -6, -8, -11, -13,
      -14, -14, -11, -8, -7,
      -7, -8, -6, -4, -2,
      -1, 0, -1, 0, 0,
      11, 40, 56, 46, 25,
      20, 28, 35, 29, 12,
      6, 4, 0, -12, -27,
      -31, -29, -33, -42, -48,
      -41, -29, -23, -25, -26,
      -18, -5, 2, 5, 8,
      16, 24, 25, 22, 22,
      26, 27, 21, 12, 5,
      5, 4, -4, -13, -19,
      -21, -22, -25, -27, -24,
      -19, -17, -18, -16, -9,
      0, 3, 2, 3, 8,
      13, 14, 12, 11, 12,
      10, 6, 2, 0, -1,
      -3, -10, -15, -16, -15,
      -15, -17, -19, -17, -15,
      -13, -12, -10, -7, -4,
      -5, -5, -2, 2, 3,
      1, -3, -3, -2, -2,
      -2, -1, -1, -1, -1,
      0, 3, 27, 43, 15,
      0, 41, 54, 45, 34,
      3, 18, 49, 27, 2,
      -6, -10, -7, -13, -27,
      -38, -37, -43, -57, -46,
      -38, -45, -46, -48, -38,
      -16, -15, -26, -21, -7,
      6, 11, 8, 7, 17,
      28, 25, 23, 25, 25,
      25, 24, 22, 24, 21,
      12, 0, 0, 6, -3,
      -18, -28, -30, -23, -23,
      -33, -39, -35, -30, -28,
      -28, -29, -26, -18, -15,
      -11, -3, -1, 2, 8,
      13, 19, 21, 14, 10,
      11, 10, 2, -9, -19,
      -22, -15, -16, -22, -22,
      -20, -21, -17, -14, -15,
      -18, -22, -21, -8, -2,
      0, 0, 0, 30, 36,
      15, 8, 21, 40, 56,
      41, 13, 10, 21, 28,
      24, 8, -7, -13, -13,
      -20, -25, -26, -36, -47,
      -50, -47, -36, -27, -35,
      -42, -35, -21, -7, -3,
      -8, -9, 2, 14, 18,
      20, 20, 20, 24, 25,
      24, 24, 21, 14, 8,
      5, 4, 2, -5, -14,
      -18, -14, -14, -21, -23,
      -24, -23, -19, -20, -20,
      -13, -12, -13, -8, -1,
      2, 4, 1, -2, 6,
      12, 10, 5, 0, -2,
      2, 1, -6, -11, -12,
      -16, -18, -21, -24, -24,
      -23, -25, -22, -17, -14,
      -13, -14, -13, -8, -5,
      -5, 0, 0, 9, 44,
      40, 16, 3, 9, 38,
      56, 33, 6, 1, 5,
      11, 12, 1, -14, -25,
      -36, -36, -21, -15, -29,
      -43, -46, -30, -9, -4,
      -12, -14, -9, 1, 12,
      17, 18, 19, 17, 15,
      22, 30, 28, 18, 8,
      5, 11, 13, 3, -7,
      -14, -16, -12, -12, -18,
      -20, -20, -19, -15, -11,
      -11, -9, -8, -6, 3,
      8, 7, 6, 5, 7,
      13, 13, 8, 4, 1,
      1, 2, -2, -8, -11,
      -13, -14, -12, -15, -18,
      -18, -18, -15, -10, -9,
      -8, -7, -7, -4, 0,
      0, -2, -1, -2, -1,
      0, -2, 0, 0, 18,
      35, 18, 11, 21, 40,
      56, 37, 23, 29, 28,
      24, 22, 18, 6, -11,
      -19, -16, -13, -27, -49,
      -52, -43, -44, -49, -50,
      -49, -42, -38, -32, -21,
      -19, -21, -14, 0, 10,
      11, 10, 12, 22, 29,
      27, 27, 26, 23, 21,
      21, 20, 13, 4, -3,
      -5, -3, -11, -23, -25,
      -22, -22, -22, -24, -21,
      -17, -23, -22, -12, -10,
      -13, -11, -5, 0, 0,
      -2, 2, 7, 2, -1,
      0, 0, -3, -6, -9,
      -9, -11, -17, -18, -17,
      -19, -20, -20, -20, -19,
      -20, -19, -15, -15, -15,
      -11, -7, -5, 0, 0,
      6, 28, 21, 14, 25,
      33, 47, 48, 32, 34,
      35, 30, 33, 29, 20,
      4, -6, -4, -9, -20,
      -36, -47, -45, -44, -52,
      -56, -57, -56, -50, -44,
      -39, -36, -37, -31, -19,
      -10, -7, -6, -1, 8,
      15, 20, 22, 21, 24,
      28, 30, 28, 23, 20,
      18, 16, 15, 14, 7,
      -6, -7, 0, -2, -12,
      -29, -33, -14, -16, -30,
      -32, -33, -27, -21, -23,
      -23, -24, -24, -17, -7,
      -5, -14, -14, -2, 5,
      5, -1, -6, 1, 5,
      1, 0, -3, -8, -8,
      -4, -4, -12, -19, -18,
      -16, -12, -8, -5, -1,
      0, 3, 27, 43, 15,
      0, 41, 54, 45, 34,
      3, 18, 49, 27, 2,
      -6, -10, -7, -13, -27,
      -38, -37, -43, -57, -46,
      -38, -45, -46, -48, -38,
      -16, -15, -26, -21, -7,
      6, 11, 8, 7, 17,
      28, 25, 23, 25, 25,
      25, 24, 22, 24, 21,
      12, 0, 0, 6, -3,
      -18, -28, -30, -23, -23,
      -33, -39, -35, -30, -28,
      -28, -29, -26, -18, -15,
      -11, -3, -1, 2, 8,
      13, 19, 21, 14, 10,
      11, 10, 2, -9, -19,
      -22, -15, -16, -22, -22,
      -20, -21, -17, -14, -15,
      -18, -22, -21, -8, -2,
      0, 0, 0, 30, 36,
      15, 8, 21, 40, 56,
      41, 13, 10, 21, 28,
      24, 8, -7, -13, -13,
      -20, -25, -26, -36, -47,
      -50, -47, -36, -27, -35,
      -42, -35, -21, -7, -3,
      -8, -9, 2, 14, 18,
      20, 20, 20, 24, 25,
      24, 24, 21, 14, 8,
      5, 4, 2, -5, -14,
      -18, -14, -14, -21, -23,
      -24, -23, -19, -20, -20,
      -13, -12, -13, -8, -1,
      2, 4, 1, -2, 6,
      12, 10, 5, 0, -2,
      2, 1, -6, -11, -12,
      -16, -18, -21, -24, -24,
      -23, -25, -22, -17, -14,
      -13, -14, -13, -8, -5,
      -5, 0, 0, 9, 44,
      40, 16, 3, 9, 38,
      56, 33, 6, 1, 5,
      11, 12, 1, -14, -25,
      -36, -36, -21, -15, -29,
      -43, -46, -30, -9, -4,
      -12, -14, -9, 1, 12,
      17, 18, 19, 17, 15,
      22, 30, 28, 18, 8,
      5, 11, 13, 3, -7,
      -14, -16, -12, -12, -18,
      -20, -20, -19, -15, -11,
      -11, -9, -8, -6, 3,
      8, 7, 6, 5, 7,
      13, 13, 8, 4, 1,
      1, 2, -2, -8, -11,
      -13, -14, -12, -15, -18,
      -18, -18, -15, -10, -9,
      -8, -7, -7, -4, 0,
      0, -2, -1, -2, -1,
      0, -2, 0, 0, 18,
      35, 18, 11, 21, 40,
      56, 37, 23, 29, 28,
      24, 22, 18, 6, -11,
      -19, -16, -13, -27, -49,
      -52, -43, -44, -49, -50,
      -49, -42, -38, -32, -21,
      -19, -21, -14, 0, 10,
      11, 10, 12, 22, 29,
      27, 27, 26, 23, 21,
      21, 20, 13, 4, -3,
      -5, -3, -11, -23, -25,
      -22, -22, -22, -24, -21,
      -17, -23, -22, -12, -10,
      -13, -11, -5, 0, 0,
      -2, 2, 7, 2, -1,
      0, 0, -3, -6, -9,
      -9, -11, -17, -18, -17,
      -19, -20, -20, -20, -19,
      -20, -19, -15, -15, -15,
      -11, -7, -5, 0, 0,
      6, 28, 21, 14, 25,
      33, 47, 48, 32, 34,
      35, 30, 33, 29, 20,
      4, -6, -4, -9, -20,
      -36, -47, -45, -44, -52,
      -56, -57, -56, -50, -44,
      -39, -36, -37, -31, -19,
      -10, -7, -6, -1, 8,
      15, 20, 22, 21, 24,
      28, 30, 28, 23, 20,
      18, 16, 15, 14, 7,
      -6, -7, 0, -2, -12,
      -29, -33, -14, -16, -30,
      -32, -33, -27, -21, -23,
      -23, -24, -24, -17, -7,
      -5, -14, -14, -2, 5,
      5, -1, -6, 1, 5,
      1, 0, -3, -8, -8,
      -4, -4, -12, -19, -18,
      -16, -12, -8, -5, -1,
      0, 4, 49, 46, -21,
      -30, 29, 56, 51, 8,
      -35, 5, 50, 33, 6,
      -13, -17, 1, 9, -5,
      -15, -18, -29, -29, -12,
      -8, -17, -29, -35, -17,
      8, 2, -18, -21, -8,
      11, 18, 3, -7, 2,
      14, 20, 17, 13, 12,
      14, 15, 15, 17, 13,
      4, 1, 3, 8, 4,
      -8, -16, -12, -6, -9,
      -18, -23, -20, -13, -12,
      -15, -16, -14, -10, -7,
      -3, -1, 0, -1, -1,
      4, 10, 8, 1, -1,
      3, 6, 3, -4, -7,
      -6, -6, -8, -11, -12,
      -12, -11, -11, -10, -8,
      -7, -6, -5, -3, -2,
      -1, 0, 6, 56, 53,
      -12, -20, 27, 51, 54,
      21, -19, 4, 29, 16,
      11, 5, -16, -25, -23,
      -14, -5, -15, -48, -56,
      -28, -9, -14, -27, -38,
      -28, -5, 1, -4, -3,
      -2, -1, 10, 17, 20,
      19, 10, 7, 18, 28,
      25, 12, 4, 8, 16,
      15, 5, -3, -6, -6,
      -7, -10, -12, -15, -19,
      -22, -19, -12, -12, -18,
      -20, -15, -6, -1, -5,
      -8, -5, 0, 4, 5,
      3, 0, 1, 3, 6,
      6, 1, -5, -6, -5,
      -4, -6, -13, -16, -15,
      -14, -12, -11, -15, -19,
      -17, -13, -9, -10, -7,
      -4, -1, 0, 25, 50,
      33, 11, 13, 40, 56,
      44, 31, 21, 10, 4,
      8, 15, 3, -29, -50,
      -44, -28, -28, -45, -55,
      -54, -47, -37, -25, -16,
      -18, -23, -15, 5, 21,
      23, 18, 18, 25, 31,
      34, 33, 28, 20, 12,
      12, 16, 13, -1, -17,
      -19, -15, -17, -22, -27,
      -31, -31, -28, -21, -15,
      -17, -22, -16, -2, 5,
      6, 4, 4, 13, 18,
      18, 19, 13, 7, 8,
      9, 7, 1, -12, -17,
      -14, -15, -18, -23, -28,
      -28, -26, -22, -17, -17,
      -19, -16, -10, -4, -1,
      -2, -4, -2, 1, 2,
      4, 3, 0, 0, 15,
      42, 34, 10, 9, 35,
      55, 42, 25, 19, 15,
      14, 16, 15, 0, -28,
      -36, -22, -17, -32, -53,
      -57, -46, -40, -39, -39,
      -39, -40, -33, -15, -4,
      -7, -12, -3, 14, 23,
      21, 19, 20, 23, 27,
      31, 30, 21, 11, 11,
      17, 13, 2, -9, -13,
      -12, -13, -17, -24, -31,
      -32, -28, -26, -24, -28,
      -30, -22, -15, -11, -7,
      -7, -3, 3, 8, 9,
      9, 10, 10, 10, 8,
      7, 5, -1, -5, -7,
      -7, -13, -20, -21, -21,
      -23, -25, -25, -23, -22,
      -23, -22, -16, -13, -14,
      -12, -8, -4, 0, 0,
      15, 9, 17, 20, 20,
      48, 43, 23, 32, 27,
      30, 39, 19, 15, 13,
      -3, 1, 0, -15, -28,
      -36, -37, -36, -44, -55,
      -57, -54, -53, -48, -44,
      -45, -43, -36, -25, -14,
      -13, -12, -3, 5, 12,
      15, 17, 19, 20, 23,
      28, 27, 22, 18, 18,
      22, 18, 10, 6, 3,
      0, -6, -12, -10, -16,
      -25, -24, -21, -24, -31,
      -35, -28, -25, -28, -24,
      -17, -19, -21, -13, -3,
      -5, -9, -6, 3, 6,
      -2, -1, 6, 6, 5,
      3, 2, -1, -11, -12,
      -7, -15, -25, -27, -19,
      -19, -15, -10, -5, -1,
      0, 13, 35, 31, 8,
      -2, 17, 48, 56, 27,
      -5, -8, 12, 28, 16,
      -13, -30, -28, -21, -21,
      -28, -34, -37, -39, -40,
      -33, -20, -13, -17, -23,
      -20, -2, 14, 14, 5,
      2, 11, 25, 27, 20,
      13, 12, 15, 13, 8,
      3, -1, -4, -9, -14,
      -16, -16, -19, -24, -25,
      -21, -16, -14, -17, -18,
      -13, -5, -1, -2, -3,
      1, 7, 11, 10, 8,
      7, 7, 6, 4, 2,
      -1, -5, -8, -10, -11,
      -12, -14, -18, -18, -17,
      -15, -14, -15, -14, -11,
      -8, -7, -7, -6, -5,
      -4, -4, -3, -2, -1,
      -1, 0, 6, 56, 53,
      -12, -20, 27, 51, 54,
      21, -19, 4, 29, 16,
      11, 5, -16, -25, -23,
      -14, -5, -15, -48, -56,
      -28, -9, -14, -27, -38,
      -28, -5, 1, -4, -3,
      -2, -1, 10, 17, 20,
      19, 10, 7, 18, 28,
      25, 12, 4, 8, 16,
      15, 5, -3, -6, -6,
      -7, -10, -12, -15, -19,
      -22, -19, -12, -12, -18,
      -20, -15, -6, -1, -5,
      -8, -5, 0, 4, 5,
      3, 0, 1, 3, 6,
      6, 1, -5, -6, -5,
      -4, -6, -13, -16, -15,
      -14, -12, -11, -15, -19,
      -17, -13, -9, -10, -7,
      -4, -1, 0, 25, 50,
      33, 11, 13, 40, 56,
      44, 31, 21, 10, 4,
      8, 15, 3, -29, -50,
      -44, -28, -28, -45, -55,
      -54, -47, -37, -25, -16,
      -18, -23, -15, 5, 21,
      23, 18, 18, 25, 31,
      34, 33, 28, 20, 12,
      12, 16, 13, -1, -17,
      -19, -15, -17, -22, -27,
      -31, -31, -28, -21, -15,
      -17, -22, -16, -2, 5,
      6, 4, 4, 13, 18,
      18, 19, 13, 7, 8,
      9, 7, 1, -12, -17,
      -14, -15, -18, -23, -28,
      -28, -26, -22, -17, -17,
      -19, -16, -10, -4, -1,
      -2, -4, -2, 1, 2,
      4, 3, 0, 0, 15,
      42, 34, 10, 9, 35,
      55, 42, 25, 19, 15,
      14, 16, 15, 0, -28,
      -36, -22, -17, -32, -53,
      -57, -46, -40, -39, -39,
      -39, -40, -33, -15, -4,
      -7, -12, -3, 14, 23,
      21, 19, 20, 23, 27,
      31, 30, 21, 11, 11,
      17, 13, 2, -9, -13,
      -12, -13, -17, -24, -31,
      -32, -28, -26, -24, -28,
      -30, -22, -15, -11, -7,
      -7, -3, 3, 8, 9,
      9, 10, 10, 10, 8,
      7, 5, -1, -5, -7,
      -7, -13, -20, -21, -21,
      -23, -25, -25, -23, -22,
      -23, -22, -16, -13, -14,
      -12, -8, -4, 0, 0,
      15, 9, 17, 20, 20,
      48, 43, 23, 32, 27,
      30, 39, 19, 15, 13,
      -3, 1, 0, -15, -28,
      -36, -37, -36, -44, -55,
      -57, -54, -53, -48, -44,
      -45, -43, -36, -25, -14,
      -13, -12, -3, 5, 12,
      15, 17, 19, 20, 23,
      28, 27, 22, 18, 18,
      22, 18, 10, 6, 3,
      0, -6, -12, -10, -16,
      -25, -24, -21, -24, -31,
      -35, -28, -25, -28, -24,
      -17, -19, -21, -13, -3,
      -5, -9, -6, 3, 6,
      -2, -1, 6, 6, 5,
      3, 2, -1, -11, -12,
      -7, -15, -25, -27, -19,
      -19, -15, -10, -5, -1,
      0, 16, 34, 3, -22,
      1, 36, 53, 38, -4,
      -5, 34, 55, 42, 6,
      -15, 2, 24, 15, -15,
      -36, -34, -17, -13, -35,
      -57, -56, -41, -31, -35,
      -47, -49, -38, -26, -20,
      -23, -28, -21, -8, 2,
      3, -2, -3, 7, 18,
      18, 14, 16, 19, 25,
      29, 23, 13, 10, 10,
      9, 2, -9, -16, -15,
      -16, -19, -27, -38, -41,
      -36, -35, -36, -41, -42,
      -32, -23, -21, -23, -21,
      -13, -4, -2, -3, -1,
      7, 12, 9, 3, -1,
      1, 4, -1, -10, -14,
      -13, -12, -11, -15, -21,
      -24, -20, -15, -15, -21,
      0, 0, 19, 43, 17,
      -10, 2, 28, 56, 47,
      -4, -20, 13, 40, 36,
      4, -27, -21, 6, 9,
      -14, -30, -35, -32, -23,
      -25, -32, -29, -29, -33,
      -24, -13, -10, -10, -16,
      -16, 1, 15, 12, 3,
      0, 8, 24, 30, 16,
      5, 9, 17, 23, 18,
      4, -2, 3, 4, 2,
      -4, -14, -19, -15, -12,
      -13, -17, -24, -25, -16,
      -11, -11, -13, -16, -14,
      -3, 1, 0, -2, -3,
      0, 8, 9, 5, 2,
      -1, 2, 7, 4, -5,
      -11, -12, -10, -8, -13,
      -20, -21, -19, -17, -14,
      -16, -20, -16, -9, -8,
      -9, 0, 0, 7, 40,
      28, -3, 0, 33, 56,
      45, 20, 10, 19, 25,
      21, 15, 2, -18, -28,
      -22, -13, -21, -45, -57,
      -45, -30, -29, -37, -40,
      -33, -21, -11, -5, -2,
      -1, 1, 11, 24, 29,
      24, 17, 19, 28, 31,
      24, 15, 10, 7, 6,
      2, -5, -13, -20, -23,
      -20, -17, -20, -27, -30,
      -25, -15, -10, -13, -15,
      -10, -1, 5, 6, 5,
      8, 10, 11, 14, 14,
      9, 2, 1, 3, 1,
      -6, -15, -17, -16, -17,
      -20, -25, -25, -23, -20,
      -18, -17, -17, -15, -11,
      -6, -3, -2, -3, -2,
      2, 6, 0, 0, 3,
      38, 27, -1, 5, 36,
      56, 46, 26, 21, 25,
      25, 27, 28, 8, -18,
      -21, -9, -8, -30, -54,
      -53, -42, -41, -47, -53,
      -54, -47, -37, -26, -22,
      -25, -25, -10, 5, 8,
      6, 8, 14, 23, 29,
      28, 25, 21, 21, 23,
      23, 15, 6, -2, -2,
      0, -6, -14, -21, -26,
      -19, -20, -25, -27, -31,
      -26, -19, -19, -19, -16,
      -13, -6, 0, 0, 1,
      4, 6, 10, 11, 7,
      4, 3, 3, 3, -3,
      -10, -11, -14, -17, -19,
      -23, -26, -25, -24, -24,
      -23, -23, -21, -18, -15,
      -12, -12, -12, 0, 0,
      20, 20, -2, 4, 40,
      44, 28, 35, 31, 24,
      40, 38, 29, 15, 1,
      12, 16, -5, -23, -27,
      -26, -30, -36, -48, -57,
      -51, -49, -45, -48, -56,
      -48, -37, -32, -29, -30,
      -25, -13, -5, -1, 0,
      2, 9, 17, 19, 14,
      14, 19, 19, 19, 21,
      20, 12, 10, 17, 10,
      -3, -3, -4, -7, -12,
      -17, -21, -25, -25, -24,
      -26, -29, -30, -25, -24,
      -22, -23, -23, -18, -14,
      -14, -13, -11, -7, -5,
      -5, -5, -5, -4, -3,
      -2, -4, -8, -7, -4,
      -7, -15, -17, -13, -11,
      -9, -7, -5, -3, -1,
      0, 16, 34, 3, -22,
      1, 36, 53, 38, -4,
      -5, 34, 55, 42, 6,
      -15, 2, 24, 15, -15,
      -36, -34, -17, -13, -35,
      -57, -56, -41, -31, -35,
      -47, -49, -38, -26, -20,
      -23, -28, -21, -8, 2,
      3, -2, -3, 7, 18,
      18, 14, 16, 19, 25,
      29, 23, 13, 10, 10,
      9, 2, -9, -16, -15,
      -16, -19, -27, -38, -41,
      -36, -35, -36, -41, -42,
      -32, -23, -21, -23, -21,
      -13, -4, -2, -3, -1,
      7, 12, 9, 3, -1,
      1, 4, -1, -10, -14,
      -13, -12, -11, -15, -21,
      -24, -20, -15, -15, -21,
      0, 0, 19, 43, 17,
      -10, 2, 28, 56, 47,
      -4, -20, 13, 40, 36,
      4, -27, -21, 6, 9,
      -14, -30, -35, -32, -23,
      -26, -32, -29, -29, -33,
      -24, -13, -10, -10, -16,
      -16, 1, 15, 12, 3,
      0, 8, 24, 30, 16,
      5, 9, 17, 23, 18,
      4, -2, 3, 5, 2,
      -4, -14, -19, -15, -12,
      -13, -17, -24, -25, -16,
      -11, -11, -13, -17, -13,
      -3, 2, 0, -2, -3,
      0, 8, 9, 5, 2,
      -1, 2, 7, 4, -5,
      -11, -12, -10, -8, -13,
      -20, -21, -20, -17, -14,
      -16, -20, -16, -9, -8,
      -9, 0, 0, -2, 27,
      25, -3, 0, 42, 56,
      29, 18, 26, 32, 30,
      22, 21, 15, -8, -14,
      -2, -7, -30, -47, -45,
      -36, -37, -48, -53, -49,
      -45, -39, -30, -27, -29,
      -26, -16, -2, 6, 3,
      3, 12, 22, 25, 24,
      23, 24, 23, 22, 24,
      22, 13, 4, 3, 4,
      -1, -9, -16, -19, -22,
      -20, -20, -26, -30, -29,
      -24, -19, -20, -21, -18,
      -12, -5, 1, 1, -2,
      3, 7, 11, 9, 2,
      1, 3, 2, 1, -3,
      -9, -12, -13, -15, -18,
      -22, -25, -25, -24, -25,
      -24, -22, -22, -20, -15,
      -12, -11, 0, 0, 8,
      35, 18, -6, 6, 36,
      56, 41, 12, 12, 25,
      27, 24, 13, -3, -16,
      -20, -13, -11, -29, -50,
      -50, -35, -29, -35, -46,
      -44, -30, -19, -16, -15,
      -14, -9, 1, 12, 18,
      16, 12, 16, 25, 30,
      26, 18, 13, 15, 17,
      11, 2, -5, -10, -10,
      -9, -13, -23, -28, -24,
      -22, -20, -20, -25, -21,
      -15, -9, -5, -7, -6,
      0, 7, 11, 10, 7,
      7, 10, 12, 8, 3,
      -2, -3, -4, -8, -12,
      -16, -20, -21, -21, -21,
      -22, -23, -22, -20, -17,
      -15, -14, -12, -10, -6,
      -4, -3, -2, 0, 0,
      20, 20, -2, 4, 40,
      44, 28, 35, 31, 24,
      40, 38, 29, 15, 1,
      12, 16, -5, -23, -27,
      -26, -30, -36, -48, -57,
      -51, -49, -45, -48, -56,
      -48, -37, -32, -29, -30,
      -25, -13, -5, -1, 0,
      2, 9, 17, 19, 14,
      14, 19, 19, 19, 21,
      20, 12, 10, 17, 10,
      -3, -3, -4, -7, -12,
      -17, -21, -25, -25, -24,
      -26, -29, -30, -25, -24,
      -22, -23, -23, -18, -14,
      -14, -13, -11, -7, -5,
      -5, -5, -5, -4, -3,
      -2, -4, -8, -7, -4,
      -7, -15, -17, -13, -11,
      -9, -7, -5, -3, -1,
      0, 13, 35, 31, 8,
      -2, 17, 48, 56, 27,
      -5, -8, 12, 28, 16,
      -13, -30, -28, -21, -21,
      -28, -34, -37, -39, -40,
      -33, -20, -13, -17, -23,
      -20, -2, 14, 14, 5,
      2, 11, 25, 27, 20,
      13, 12, 15, 13, 8,
      3, -1, -4, -9, -14,
      -16, -16, -19, -24, -25,
      -21, -16, -14, -17, -18,
      -13, -5, -1, -2, -3,
      1, 7, 11, 10, 8,
      7, 7, 6, 4, 2,
      -1, -5, -8, -10, -11,
      -12, -14, -18, -18, -17,
      -15, -14, -15, -14, -11,
      -8, -7, -7, -6, -5,
      -4, -4, -3, -2, -1,
      -1, 0, 6, 56, 53,
      -12, -20, 27, 51, 54,
      21, -19, 4, 29, 16,
      11, 5, -16, -25, -23,
      -14, -5, -15, -48, -56,
      -28, -9, -14, -27, -38,
      -28, -5, 1, -4, -3,
      -2, -1, 10, 17, 20,
      19, 10, 7, 18, 28,
      25, 12, 4, 8, 16,
      15, 5, -3, -6, -6,
      -7, -10, -12, -15, -19,
      -22, -19, -12, -12, -18,
      -20, -15, -6, -1, -5,
      -8, -5, 0, 4, 5,
      3, 0, 1, 3, 6,
      6, 1, -5, -6, -5,
      -4, -6, -13, -16, -15,
      -14, -12, -11, -15, -19,
      -17, -13, -9, -10, -7,
      -4, -1, 0, 25, 50,
      33, 11, 13, 40, 56,
      44, 31, 21, 10, 4,
      8, 15, 3, -29, -50,
      -44, -28, -28, -45, -55,
      -54, -47, -37, -25, -16,
      -18, -23, -15, 5, 21,
      23, 18, 18, 25, 31,
      34, 33, 28, 20, 12,
      12, 16, 13, -1, -17,
      -19, -15, -17, -22, -27,
      -31, -31, -28, -21, -15,
      -17, -22, -16, -2, 5,
      6, 4, 4, 13, 18,
      18, 19, 13, 7, 8,
      9, 7, 1, -12, -17,
      -14, -15, -18, -23, -28,
      -28, -26, -22, -17, -17,
      -19, -16, -10, -4, -1,
      -2, -4, -2, 1, 2,
      4, 3, 0, 0, 15,
      42, 34, 10, 9, 35,
      55, 42, 25, 19, 15,
      14, 16, 15, 0, -28,
      -36, -22, -17, -32, -53,
      -57, -46, -40, -39, -39,
      -39, -40, -33, -15, -4,
      -7, -12, -3, 14, 23,
      21, 19, 20, 23, 27,
      31, 30, 21, 11, 11,
      17, 13, 2, -9, -13,
      -12, -13, -17, -24, -31,
      -32, -28, -26, -24, -28,
      -30, -22, -15, -11, -7,
      -7, -3, 3, 8, 9,
      9, 10, 10, 10, 8,
      7, 5, -1, -5, -7,
      -7, -13, -20, -21, -21,
      -23, -25, -25, -23, -22,
      -23, -22, -16, -13, -14,
      -12, -8, -4, 0, 0,
      33, 40, 24, 14, 31,
      53, 51, 42, 35, 28,
      25, 22, 22, 20, 0,
      -23, -28, -24, -26, -39,
      -53, -57, -52, -49, -48,
      -46, -46, -45, -37, -25,
      -15, -11, -12, -4, 9,
      18, 22, 22, 23, 26,
      29, 31, 30, 26, 20,
      16, 14, 11, 4, -4,
      -9, -14, -19, -22, -25,
      -26, -27, -28, -23, -22,
      -30, -29, -17, -12, -11,
      -14, -12, -3, 1, 2,
      6, 3, 1, 2, 3,
      6, 2, -5, -6, -5,
      -6, -10, -16, -17, -16,
      -19, -21, -21, -22, -22,
      -21, -18, -16, -17, -18,
      -14, -10, -10, -10, 0,
      0, 13, 35, 31, 8,
      -2, 17, 48, 56, 27,
      -5, -8, 12, 28, 16,
      -13, -30, -28, -21, -21,
      -28, -34, -37, -39, -40,
      -33, -20, -13, -17, -23,
      -20, -2, 14, 14, 5,
      2, 11, 25, 27, 20,
      13, 12, 15, 13, 8,
      3, -1, -4, -9, -14,
      -16, -16, -19, -24, -25,
      -21, -16, -14, -17, -18,
      -13, -5, -1, -2, -3,
      1, 7, 11, 10, 8,
      7, 7, 6, 4, 2,
      -1, -5, -8, -10, -11,
      -12, -14, -18, -18, -17,
      -15, -14, -15, -14, -11,
      -8, -7, -7, -6, -5,
      -4, -4, -3, -2, -1,
      -1, 0, 6, 56, 53,
      -12, -20, 27, 51, 54,
      21, -19, 4, 29, 16,
      11, 5, -16, -25, -23,
      -14, -5, -15, -48, -56,
      -28, -9, -14, -27, -38,
      -28, -5, 1, -4, -3,
      -2, -1, 10, 17, 20,
      19, 10, 7, 18, 28,
      25, 12, 4, 8, 16,
      15, 5, -3, -6, -6,
      -7, -10, -12, -15, -19,
      -22, -19, -12, -12, -18,
      -20, -15, -6, -1, -5,
      -8, -5, 0, 4, 5,
      3, 0, 1, 3, 6,
      6, 1, -5, -6, -5,
      -4, -6, -13, -16, -15,
      -14, -12, -11, -15, -19,
      -17, -13, -9, -10, -7,
      -4, -1, 0, 25, 50,
      33, 11, 13, 40, 56,
      44, 31, 21, 10, 4,
      8, 15, 3, -29, -50,
      -44, -28, -28, -45, -55,
      -54, -47, -37, -25, -16,
      -18, -23, -15, 5, 21,
      23, 18, 18, 25, 31,
      34, 33, 28, 20, 12,
      12, 16, 13, -1, -17,
      -19, -15, -17, -22, -27,
      -31, -31, -28, -21, -15,
      -17, -22, -16, -2, 5,
      6, 4, 4, 13, 18,
      18, 19, 13, 7, 8,
      9, 7, 1, -12, -17,
      -14, -15, -18, -23, -28,
      -28, -26, -22, -17, -17,
      -19, -16, -10, -4, -1,
      -2, -4, -2, 1, 2,
      4, 3, 0, 0, 15,
      42, 34, 10, 9, 35,
      55, 42, 25, 19, 15,
      14, 16, 15, 0, -28,
      -36, -22, -17, -32, -53,
      -57, -46, -40, -39, -39,
      -39, -40, -33, -15, -4,
      -7, -12, -3, 14, 23,
      21, 19, 20, 23, 27,
      31, 30, 21, 11, 11,
      17, 13, 2, -9, -13,
      -12, -13, -17, -24, -31,
      -32, -28, -26, -24, -28,
      -30, -22, -15, -11, -7,
      -7, -3, 3, 8, 9,
      9, 10, 10, 10, 8,
      7, 5, -1, -5, -7,
      -7, -13, -20, -21, -21,
      -23, -25, -25, -23, -22,
      -23, -22, -16, -13, -14,
      -12, -8, -4, 0, 0,
      33, 40, 24, 14, 31,
      53, 51, 42, 35, 28,
      25, 22, 22, 20, 0,
      -23, -28, -24, -26, -39,
      -53, -57, -52, -49, -48,
      -46, -46, -45, -37, -25,
      -15, -11, -12, -4, 9,
      18, 22, 22, 23, 26,
      29, 31, 30, 26, 20,
      16, 14, 11, 4, -4,
      -9, -14, -19, -22, -25,
      -26, -27, -28, -23, -22,
      -30, -29, -17, -12, -11,
      -14, -12, -3, 1, 2,
      6, 3, 1, 2, 3,
      6, 2, -5, -6, -5,
      -6, -10, -16, -17, -16,
      -19, -21, -21, -22, -22,
      -21, -18, -16, -17, -18,
      -14, -10, -10, -10, 0,
      0, 4, 12, 21, 29,
      34, 37, 33, 22, 12,
      4, -5, -14, -20, -22,
      -20, -16, -14, -15, -14,
      -14, -16, -20, -24, -25,
      -22, -17, -13, -7, 2,
      11, 17, 20, 21, 20,
      17, 13, 7, 2, 0,
      -1, -2, -2, -1, -1,
      0, -2, -6, -10, -13,
      -15, -17, -18, -16, -13,
      -9, -6, -3, 0, 2,
      3, 2, 0, -1, -2,
      -2, -4, -4, -3, -3,
      -2, -3, -4, -5, -6,
      -8, -10, -11, -11, -10,
      -10, -9, -7, -5, -3,
      -2, -2, -2, -3, -4,
      -6, -9, -9, -10, -12,
      -12, -10, -8, -5, -3,
      -1, 0, 7, 23, 35,
      41, 46, 45, 33, 16,
      -3, -20, -31, -39, -40,
      -36, -27, -19, -16, -14,
      -14, -15, -15, -16, -14,
      -8, 2, 14, 22, 30,
      35, 34, 29, 19, 8,
      -1, -9, -15, -19, -19,
      -17, -15, -15, -16, -17,
      -17, -18, -18, -15, -10,
      -3, 6, 13, 19, 23,
      24, 21, 17, 11, 4,
      -3, -8, -13, -16, -17,
      -18, -17, -16, -15, -14,
      -13, -11, -9, -6, -4,
      -1, 2, 4, 5, 5,
      4, 2, 0, -3, -6,
      -9, -12, -14, -15, -16,
      -16, -15, -13, -12, -11,
      -8, -6, -3, -2, -2,
      -2, 0, 0, 11, 34,
      50, 56, 48, 42, 28,
      8, -7, -17, -14, -11,
      -15, -20, -28, -33, -39,
      -45, -38, -25, -8, 6,
      13, 19, 23, 23, 20,
      17, 19, 25, 27, 24,
      17, 10, 0, -13, -25,
      -29, -26, -22, -19, -16,
      -13, -10, -9, -8, -4,
      4, 13, 19, 22, 25,
      25, 20, 13, 7, 3,
      2, -1, -6, -10, -13,
      -17, -22, -23, -19, -12,
      -5, -1, 4, 7, 7,
      5, 3, 3, 5, 5,
      2, 0, -3, -6, -11,
      -15, -16, -13, -11, -10,
      -8, -6, -5, -5, -6,
      -5, -2, 0, 0, -1,
      -2, -3, 0, 0, 8,
      27, 43, 40, 26, 18,
      11, 9, 11, 6, 2,
      -2, -13, -25, -35, -35,
      -25, -16, -13, -14, -13,
      -11, -8, -2, 3, 12,
      21, 23, 20, 15, 12,
      13, 14, 12, 8, 3,
      -2, -10, -17, -20, -18,
      -13, -11, -12, -12, -12,
      -9, -5, 1, 6, 11,
      13, 12, 10, 9, 9,
      8, 6, 3, 0, -4,
      -8, -12, -13, -12, -9,
      -7, -7, -7, -6, -4,
      -2, -1, 1, 3, 4,
      2, -1, -3, -3, -2,
      -3, -4, -7, -9, -10,
      -11, -11, -8, -6, -5,
      -6, -6, -5, -3, -2,
      -1, 0, -1, 0, 0,
      12, 16, 10, 1, 12,
      31, 26, 16, 13, 12,
      20, 19, 10, 7, 0,
      -5, -3, -4, -12, -23,
      -25, -21, -19, -24, -32,
      -30, -24, -22, -20, -20,
      -20, -16, -12, -6, -3,
      -4, -2, 2, 8, 10,
      10, 9, 11, 14, 15,
      13, 11, 8, 7, 7,
      5, 2, 0, -1, -5,
      -7, -3, -7, -13, -15,
      -13, -11, -14, -18, -16,
      -11, -11, -12, -10, -8,
      -7, -5, -3, -1, -2,
      -3, 1, 3, 2, 0,
      0, 2, 2, -1, -4,
      -4, -5, -6, -7, -8,
      -10, -12, -11, -10, -12,
      -14, -13, -9, -5, -1,
      0, 9, 24, 42, 58,
      68, 75, 66, 45, 25,
      8, -9, -27, -40, -44,
      -40, -32, -28, -30, -28,
      -27, -31, -40, -47, -49,
      -44, -34, -25, -13, 5,
      22, 34, 41, 42, 39,
      35, 27, 15, 4, 0,
      -2, -3, -3, -2, -1,
      1, -3, -12, -19, -25,
      -30, -34, -35, -32, -25,
      -17, -11, -6, 0, 4,
      6, 4, 1, -1, -3,
      -4, -7, -7, -6, -5,
      -4, -6, -8, -9, -12,
      -16, -19, -21, -21, -20,
      -20, -18, -14, -9, -5,
      -4, -3, -4, -5, -8,
      -12, -17, -18, -20, -23,
      -24, -19, -15, -10, -5,
      -1, 0, 13, 40, 62,
      71, 81, 79, 57, 28,
      -5, -34, -54, -67, -69,
      -62, -46, -32, -27, -23,
      -23, -26, -26, -28, -24,
      -13, 4, 24, 39, 53,
      61, 60, 51, 34, 15,
      -1, -16, -26, -32, -32,
      -28, -26, -25, -27, -28,
      -30, -31, -31, -26, -17,
      -4, 10, 24, 33, 40,
      42, 37, 29, 19, 8,
      -4, -14, -22, -27, -29,
      -30, -30, -27, -26, -24,
      -22, -19, -15, -10, -6,
      -1, 3, 7, 9, 9,
      7, 4, 0, -5, -11,
      -16, -21, -23, -26, -27,
      -27, -25, -23, -21, -18,
      -14, -9, -6, -4, -3,
      -3, 0, 0, 34, 74,
      87, 73, 54, 29, -2,
      -30, -49, -47, -31, -24,
      -26, -31, -35, -37, -36,
      -30, -13, 13, 36, 45,
      44, 37, 27, 15, 3,
      -4, -1, 4, 0, -11,
      -24, -33, -39, -40, -35,
      -22, -4, 10, 15, 16,
      15, 14, 13, 10, 11,
      15, 16, 12, 1, -12,
      -21, -27, -29, -26, -20,
      -12, -7, -5, -5, -4,
      -1, 2, 7, 12, 15,
      13, 6, -3, -11, -17,
      -19, -20, -19, -17, -15,
      -15, -15, -14, -10, -5,
      -1, 3, 5, 4, 0,
      -5, -9, -10, -12, -12,
      -13, -14, -16, -13, -10,
      -7, -4, -1, 0, 30,
      81, 78, 18, -21, 2,
      51, 74, 31, -35, -48,
      -26, -5, -6, -32, -51,
      -53, -52, -46, -27, -6,
      -4, -20, -34, -20, 21,
      46, 36, 13, 3, 19,
      40, 41, 25, 11, 2,
      -4, -10, -13, -12, -15,
      -30, -45, -43, -25, -11,
      -11, -22, -25, -10, 8,
      17, 15, 9, 9, 13,
      15, 17, 14, 8, 0,
      -9, -11, -10, -10, -16,
      -25, -30, -25, -17, -15,
      -17, -17, -13, -6, -1,
      0, 3, 4, 3, 3,
      3, 2, 1, -4, -9,
      -11, -12, -14, -18, -24,
      -25, -21, -19, -17, -13,
      -10, -7, -4, 0, 0,
      18, 47, 41, 11, -3,
      23, 64, 75, 36, -7,
      -10, 17, 37, 22, -17,
      -39, -37, -27, -27, -38,
      -46, -49, -52, -53, -44,
      -26, -17, -22, -31, -27,
      -2, 18, 19, 7, 2,
      16, 33, 36, 27, 17,
      16, 20, 18, 11, 4,
      -1, -6, -12, -18, -21,
      -21, -25, -31, -33, -28,
      -21, -19, -23, -24, -17,
      -6, -1, -2, -4, 1,
      10, 14, 13, 11, 9,
      10, 9, 5, 2, -2,
      -7, -11, -14, -15, -16,
      -19, -23, -24, -23, -20,
      -19, -19, -19, -14, -10,
      -9, -9, -8, -7, -6,
      -5, -4, -3, -2, -1,
      0, 22, 39, 57, 69,
      72, 74, 67, 47, 26,
      8, -5, -10, -13, -16,
      -18, -20, -25, -37, -52,
      -67, -75, -71, -64, -54,
      -40, -26, -12, 1, 6,
      8, 7, 8, 11, 15,
      20, 25, 33, 42, 45,
      43, 38, 30, 23, 14,
      5, -2, -7, -10, -14,
      -21, -28, -36, -42, -47,
      -49, -48, -41, -32, -23,
      -15, -9, -4, -2, 0,
      1, 2, 5, 10, 15,
      18, 19, 18, 13, 5,
      -6, -19, -29, -36, -40,
      -41, -39, -35, -31, -27,
      -25, -25, -24, -24, -22,
      -18, -17, -18, -16, -14,
      -12, -9, -7, -5, -3,
      -1, 0, 13, 40, 62,
      71, 81, 79, 57, 28,
      -5, -34, -54, -67, -69,
      -62, -47, -32, -27, -23,
      -23, -26, -26, -28, -24,
      -13, 4, 24, 39, 53,
      61, 59, 51, 34, 15,
      -1, -16, -26, -32, -32,
      -28, -26, -25, -27, -28,
      -30, -31, -31, -26, -17,
      -4, 10, 24, 33, 40,
      42, 37, 29, 19, 8,
      -4, -14, -22, -27, -29,
      -30, -30, -27, -26, -24,
      -22, -19, -15, -10, -6,
      -1, 3, 7, 8, 9,
      7, 4, 0, -6, -11,
      -16, -21, -23, -26, -27,
      -27, -25, -23, -21, -18,
      -14, -9, -6, -4, -3,
      -3, 0, 0, 17, 70,
      87, 66, 23, -2, -7,
      8, 12, -7, -27, -42,
      -53, -54, -44, -24, -3,
      6, -2, -11, -5, 14,
      35, 42, 37, 29, 22,
      13, 6, 2, 3, 2,
      -10, -30, -42, -38, -25,
      -16, -14, -14, -10, -4,
      1, 6, 15, 27, 32,
      23, 12, 6, 2, 1,
      -2, -12, -21, -28, -34,
      -34, -28, -20, -13, -9,
      -9, -5, 1, 7, 13,
      13, 9, 5, -1, -7,
      -12, -15, -18, -21, -26,
      -29, -28, -25, -21, -17,
      -14, -9, -5, -2, 0,
      1, 1, 0, -3, -7,
      -12, -16, -20, -22, -25,
      -17, -9, -1, 0, 30,
      81, 78, 18, -21, 2,
      51, 74, 31, -35, -48,
      -25, -5, -6, -32, -51,
      -53, -52, -46, -27, -6,
      -4, -20, -34, -20, 21,
      46, 36, 13, 3, 19,
      40, 41, 25, 11, 2,
      -4, -10, -13, -12, -15,
      -30, -45, -43, -25, -11,
      -12, -22, -25, -10, 8,
      17, 15, 8, 9, 13,
      15, 17, 14, 8, 0,
      -9, -11, -10, -10, -16,
      -25, -30, -25, -17, -15,
      -17, -17, -13, -6, -1,
      0, 3, 4, 3, 3,
      3, 3, 1, -4, -9,
      -11, -12, -14, -18, -24,
      -25, -21, -19, -17, -13,
      -10, -7, -4, 0, 0,
      28, 39, 26, 4, 29,
      74, 62, 38, 32, 30,
      49, 46, 23, 17, 0,
      -12, -6, -9, -29, -55,
      -60, -49, -45, -57, -75,
      -72, -57, -52, -48, -48,
      -47, -38, -27, -14, -7,
      -8, -5, 7, 20, 25,
      23, 22, 26, 34, 36,
      31, 26, 21, 18, 17,
      13, 5, 0, -3, -12,
      -15, -7, -15, -32, -36,
      -31, -25, -32, -42, -37,
      -26, -25, -27, -23, -19,
      -16, -12, -7, -3, -4,
      -5, 2, 8, 5, 0,
      0, 4, 4, -3, -8,
      -8, -11, -14, -16, -18,
      -23, -27, -26, -24, -28,
      -32, -30, -20, -10, -1,
      0, 14, 29, 37, 36,
      28, 18, 8, -1, -5,
      -4, 3, 10, 10, 3,
      -9, -23, -32, -36, -34,
      -27, -17, -9, -3, -3,
      -7, -11, -11, -7, 0,
      8, 15, 20, 20, 17,
      10, 3, -1, -1, 1,
      4, 4, 2, -2, -8,
      -15, -20, -20, -17, -10,
      -3, 0, 1, 0, -3,
      -3, -3, 0, 5, 9,
      11, 9, 5, 0, -4,
      -7, -7, -6, -5, -4,
      -5, -7, -10, -12, -11,
      -9, -6, -3, -1, 0,
      0, -1, -2, -3, -3,
      -3, -3, -4, -5, -6,
      -8, -11, -12, -11, -8,
      -4, -1, -1, -1, -1,
      0, 0, 12, 33, 37,
      20, 8, 5, 12, 23,
      20, 15, 9, -4, -14,
      -23, -22, -13, -9, -16,
      -29, -38, -34, -23, -16,
      -11, -10, -9, -7, -8,
      -4, 5, 16, 22, 17,
      10, 7, 9, 13, 14,
      10, 5, -1, -8, -13,
      -14, -11, -8, -10, -17,
      -21, -21, -14, -7, -3,
      -2, -1, -1, 0, 2,
      6, 9, 10, 8, 4,
      1, 0, 1, 0, -2,
      -5, -8, -12, -15, -14,
      -12, -9, -10, -12, -12,
      -10, -6, -2, -1, -1,
      -2, -2, -2, -2, -1,
      1, -1, -4, -6, -7,
      -4, -4, -3, -3, -2,
      -1, -1, 0, 4, 31,
      50, 47, 30, 12, 4,
      5, 9, 10, 10, 7,
      2, -7, -21, -36, -41,
      -34, -21, -10, -5, -7,
      -13, -16, -16, -11, -3,
      7, 15, 20, 21, 16,
      8, 2, 1, 4, 7,
      9, 7, 0, -8, -16,
      -20, -19, -15, -11, -6,
      -2, -2, -3, -5, -5,
      -1, 3, 5, 3, -1,
      -7, -9, -10, -9, -8,
      -7, -6, -5, -6, -8,
      -11, -12, -10, -6, -2,
      3, 6, 3, -1, -4,
      -5, -3, -2, -3, -3,
      -1, -5, -11, -13, -13,
      -12, -9, -5, -1, 0,
      -1, -2, -4, -5, -5,
      -2, 1, 0, 0, 16,
      37, 27, 3, -9, -2,
      14, 23, 20, 9, -1,
      -3, -5, -13, -17, -10,
      -2, -6, -20, -33, -32,
      -19, -7, -5, -11, -15,
      -10, -3, 0, 1, 4,
      10, 14, 10, 3, 0,
      6, 12, 10, 3, -4,
      -7, -4, -3, -8, -11,
      -9, -7, -7, -10, -12,
      -9, -3, 1, -1, -5,
      -4, 0, 2, 1, -1,
      -1, 0, 0, -2, -5,
      -5, -3, -1, -5, -9,
      -9, -7, -6, -5, -5,
      -6, -6, -4, -4, -7,
      -5, 2, 2, -2, -3,
      -7, -8, 1, 3, -3,
      -5, -6, -9, -6, -2,
      -6, -6, -1, 0, 0,
      13, 33, 24, 0, -7,
      8, 34, 43, 15, -14,
      -13, 6, 22, 15, -10,
      -27, -21, -9, -7, -12,
      -19, -24, -22, -21, -18,
      -8, -2, -6, -11, -11,
      -2, 12, 17, 8, 0,
      3, 12, 19, 18, 8,
      4, 6, 8, 8, 5,
      1, -1, -4, -8, -9,
      -7, -6, -8, -13, -18,
      -14, -6, -4, -7, -10,
      -10, -5, 1, 2, 0,
      0, 1, 3, 4, 4,
      3, 3, 1, -1, -1,
      -1, -1, -3, -7, -9,
      -8, -7, -7, -8, -10,
      -10, -8, -7, -7, -5,
      -5, -5, -5, -4, -2,
      0, -1, -3, -4, 0,
      0, 7, 23, 12, -11,
      -5, 25, 37, 20, 3,
      6, 20, 24, 19, 14,
      5, -7, -6, 5, 1,
      -17, -31, -26, -13, -17,
      -32, -37, -32, -27, -24,
      -24, -25, -28, -27, -16,
      -6, -9, -17, -13, -1,
      8, 5, 1, 3, 7,
      8, 10, 13, 11, 4,
      7, 15, 14, 6, -1,
      1, 3, 0, -4, -8,
      -11, -13, -12, -11, -15,
      -21, -20, -16, -15, -18,
      -21, -19, -12, -8, -6,
      -8, -11, -6, 2, 1,
      -5, -7, -3, 1, -2,
      -5, -1, 1, -1, -2,
      -4, -7, -12, -13, -5,
      -2, -13, -21, -16, -11,
      -12, 0, 0, 8, 20,
      12, -6, -3, 22, 31,
      20, 12, 3, 10, 22,
      15, 11, 5, -10, -8,
      -4, -5, -11, -28, -36,
      -26, -21, -25, -33, -38,
      -30, -20, -16, -13, -11,
      -11, -5, 2, 7, 7,
      2, 1, 8, 13, 13,
      8, 4, 5, 7, 5,
      1, -2, -4, -6, -5,
      -3, -6, -12, -13, -10,
      -7, -10, -13, -13, -9,
      -6, -7, -9, -8, -6,
      -4, -2, -1, -3, -7,
      -4, 1, -3, -5, -5,
      -8, -7, -5, -2, -5,
      -14, -9, -5, -5, -7,
      -16, -10, -2, -9, -5,
      -2, -11, -11, -3, -2,
      -3, -8, 0, 0, 11,
      22, 16, 11, 23, 46,
      44, 19, 13, 37, 46,
      32, 14, 5, 15, 16,
      -7, -13, -15, -27, -31,
      -34, -35, -37, -50, -50,
      -36, -27, -30, -34, -27,
      -10, -2, -7, -6, 3,
      10, 13, 13, 15, 17,
      17, 16, 23, 26, 18,
      13, 13, 14, 13, 1,
      -10, -9, -4, -11, -23,
      -26, -22, -19, -23, -28,
      -27, -21, -20, -19, -16,
      -13, -10, -8, -6, -1,
      4, 4, 0, 1, 6,
      6, 0, -1, -1, 0,
      -1, -9, -10, -5, -7,
      -10, -10, -12, -13, -14,
      -10, -8, -11, -12, -10,
      -8, 0, 8, 0, 0,
      7, 20, 30, 36, 37,
      35, 28, 16, 2, -10,
      -16, -17, -15, -12, -10,
      -7, -6, -9, -17, -25,
      -30, -29, -24, -17, -9,
      -1, 9, 17, 20, 19,
      15, 10, 6, 3, 1,
      1, 3, 6, 8, 7,
      3, -2, -8, -12, -16,
      -18, -17, -13, -7, -1,
      3, 4, 5, 4, 1,
      -2, -4, -4, -1, 1,
      4, 5, 4, 2, -1,
      -5, -9, -12, -12, -10,
      -8, -6, -4, -1, 1,
      0, -2, -4, -5, -5,
      -4, -2, -2, -3, -3,
      -4, -5, -8, -10, -9,
      -8, -8, -6, -3, -2,
      -2, -1, -1, -1, -1,
      0, 2, 18, 36, 37,
      23, 15, 7, 5, 11,
      9, 12, 13, 1, -10,
      -24, -33, -27, -21, -18,
      -16, -20, -22, -21, -23,
      -19, -9, 1, 10, 12,
      8, 7, 8, 10, 13,
      15, 18, 18, 12, 3,
      -5, -9, -8, -6, -8,
      -10, -12, -16, -18, -20,
      -17, -10, -5, -1, -1,
      -2, -1, 2, 4, 9,
      14, 19, 21, 14, 5,
      -3, -7, -6, -6, -7,
      -9, -11, -14, -17, -17,
      -14, -9, -6, -6, -8,
      -9, -8, -6, -3, -1,
      2, 4, 3, 0, -3,
      -4, -4, -5, -6, -7,
      -9, -9, -8, -7, -6,
      0, 0, 16, 35, 46,
      45, 36, 24, 16, 15,
      17, 19, 17, 10, -3,
      -20, -39, -50, -50, -44,
      -35, -30, -29, -29, -30,
      -29, -25, -16, -3, 9,
      18, 22, 20, 17, 16,
      16, 18, 18, 17, 11,
      1, -8, -15, -19, -20,
      -18, -14, -11, -8, -7,
      -7, -6, -2, 1, 0,
      -1, -2, -3, -5, -7,
      -7, -5, -4, -6, -12,
      -19, -21, -19, -14, -10,
      -8, -10, -13, -12, -6,
      0, 1, 0, -2, -7,
      -13, -12, -7, -3, -3,
      -4, -9, -15, -18, -18,
      -18, -12, -5, -4, -4,
      -5, -10, -18, -20, -15,
      -10, 0, 0, 18, 37,
      36, 14, -3, -1, 13,
      21, 17, 10, 5, -1,
      -10, -20, -25, -22, -14,
      -9, -13, -25, -35, -32,
      -19, -9, -6, -5, -1,
      3, 4, 1, 1, 7,
      16, 22, 19, 11, 3,
      -1, 0, 2, 0, -4,
      -7, -9, -12, -18, -22,
      -19, -11, -5, -5, -7,
      -8, -6, -3, 2, 6,
      8, 9, 9, 5, 1,
      -1, 1, 4, 2, -3,
      -7, -9, -11, -13, -13,
      -11, -8, -7, -8, -9,
      -10, -9, -2, 3, 2,
      -1, -2, -1, -1, -3,
      -4, -5, -1, 1, -2,
      -8, -8, -4, -4, -8,
      -6, -3, 0, 0, 0,
      0, 12, 23, 32, 37,
      36, 31, 22, 9, -3,
      -13, -18, -21, -20, -16,
      -9, -4, -2, -5, -11,
      -17, -24, -29, -32, -31,
      -25, -15, -5, 5, 13,
      15, 15, 14, 10, 5,
      -1, -5, -5, -5, -4,
      -1, 3, 5, 5, 3,
      0, -4, -8, -12, -14,
      -13, -10, -7, -3, -1,
      2, 3, 2, 0, -2,
      -6, -10, -13, -12, -9,
      -5, -3, -1, 0, 0,
      0, -3, -9, -11, -10,
      -7, -4, -2, -1, -1,
      -5, -10, -11, -10, -6,
      -2, -4, -7, -6, -1,
      3, 1, -4, -9, -8,
      -4, -1, -1, -1, 0,
      0, 27, 37, 30, 29,
      23, 14, 11, 0, -4,
      11, 21, 16, 6, -5,
      -15, -21, -29, -35, -30,
      -17, -9, -11, -17, -20,
      -21, -19, -17, -13, -2,
      10, 14, 12, 8, 6,
      6, 6, 4, 7, 12,
      16, 13, 5, -3, -7,
      -9, -11, -11, -8, -4,
      -3, -6, -11, -13, -12,
      -13, -12, -9, -4, 0,
      0, -1, -2, -3, -3,
      -5, -5, -2, 1, 1,
      -1, -4, -8, -9, -8,
      -8, -6, -5, -6, -7,
      -7, -8, -7, -6, -8,
      -8, -5, -2, -2, 0,
      -2, -7, -5, -3, -6,
      -3, 2, -1, -2, -4,
      0, 0, 10, 35, 46,
      39, 22, 11, 12, 22,
      29, 26, 14, 7, 3,
      -4, -19, -36, -48, -50,
      -46, -40, -37, -35, -37,
      -43, -41, -29, -18, -8,
      3, 9, 12, 13, 11,
      6, 4, 6, 8, 11,
      9, 0, -9, -12, -12,
      -8, -5, -4, 2, 9,
      10, -2, -19, -31, -31,
      -26, -23, -20, -16, -13,
      -15, -24, -31, -30, -25,
      -17, -15, -18, -13, -7,
      -11, -15, -19, -15, 2,
      16, 14, -7, -29, -32,
      -28, -23, -14, -4, 5,
      11, 14, 9, -14, -36,
      -34, -19, -7, -3, -5,
      -5, -6, -10, -16, -20,
      -17, 0, 0, 19, 37,
      34, 13, -6, -4, 15,
      28, 21, 12, 12, 15,
      6, -12, -22, -18, -7,
      -2, -11, -25, -34, -34,
      -30, -26, -25, -21, -13,
      -6, -6, -12, -16, -9,
      5, 14, 14, 10, 9,
      11, 10, 7, 5, 6,
      10, 12, 9, -1, -9,
      -10, -6, -2, -6, -11,
      -11, -9, -12, -17, -18,
      -14, -7, -3, -3, -6,
      -6, -5, -4, -3, -3,
      -2, 3, 4, -1, -7,
      -7, -7, -7, -4, -4,
      -9, -8, -8, -14, -16,
      -11, -8, -6, 0, -3,
      -15, -12, 0, -2, -9,
      -3, 5, -1, -11, -6,
      2, -4, 0, 0, 16,
      16, -2, 3, 31, 34,
      22, 27, 24, 18, 31,
      30, 22, 12, 0, 10,
      12, -4, -18, -21, -21,
      -23, -28, -38, -44, -40,
      -38, -35, -37, -44, -38,
      -29, -25, -23, -23, -20,
      -10, -4, -1, 0, 1,
      7, 13, 15, 11, 11,
      15, 15, 14, 16, 15,
      9, 7, 13, 7, -2,
      -3, -3, -6, -10, -14,
      -16, -19, -20, -19, -20,
      -23, -24, -20, -19, -18,
      -18, -18, -14, -11, -11,
      -10, -9, -6, -4, -4,
      -4, -4, -3, -2, -1,
      -3, -7, -6, -3, -5,
      -12, -13, -10, -9, -7,
      -5, -4, -2, -1, 0,
      -1, 0, 3, 5, 6,
      6, 5, 3, 1, 0,
      -1, -1, 0, 0, 1,
      0, -1, -3, -5, -6,
      -6, -6, -5, -3, -2,
      -1, -1, -1, -1, -2,
      -2, -1, 0, 1, 1,
      1, 1, 0, -1, -1,
      -1, -2, -1, -1, 0,
      0, -1, -1, -1, -1,
      -2, -2, -1, -1, 0,
      0, 0, 0, 0, -1,
      -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -2,
      -2, -2, -2, -1, -1,
      -1, -1, -1, -1, -2,
      -1, -1, -1, -1, -1,
      -1, -1, -1, -2, -2,
      -1, 0, -2, -2, -1,
      0, 1, 0, -1, 0,
      0, -2, 13, 17, 21,
      21, 14, 14, 10, 7,
      8, 10, 11, 7, -1,
      -8, -15, -19, -22, -22,
      -20, -18, -19, -24, -23,
      -19, -14, -9, -5, -1,
      -3, -1, -2, -5, -1,
      1, 0, 1, -1, -4,
      -2, -5, -7, -5, -5,
      -3, -3, -3, -5, -6,
      -4, -7, -6, 0, -4,
      -2, 2, -6, 1, -2,
      -12, -1, -5, -6, 0,
      -7, -8, -10, -12, -7,
      -13, -6, -6, -9, -8,
      -15, -7, -7, -2, 2,
      -3, -5, -2, -4, -6,
      -5, -5, -6, -3, -8,
      -9, -11, -11, -4, -3,
      -3, -7, -2, -6, -6,
      -2, -9, -3, 1, -6,
      -2, -3, -9, -2, -3,
      -3, 1, -2, -1, -7,
      -11, -7, -5, -4, -6,
      -2, -3, -9, -5, -6,
      -8, -2, -7, -7, -5,
      -8, -5, 0, 6, 10,
      11, 9, 9, 9, 6,
      5, 4, 3, 6, 2,
      -7, -12, -12, -14, -16,
      -16, -16, -12, -12, -18,
      -16, -15, -13, -6, -7,
      -9, -7, -9, -10, -11,
      -8, -8, -1, -4, -7,
      -6, -7, 0, -2, -3,
      2, 1, 3, -2, -4,
      -1, -6, -5, -6, -7,
      -6, -5, -7, -8, 0,
      -6, -4, 0, -9, -4,
      -3, -5, -5, -3, -3,
      -10, 0, -6, -11, 3,
      -11, -11, 0, -10, -7,
      -5, -17, -12, -3, -5,
      1, -8, -9, -3, -8,
      -3, -3, -3, -8, -6,
      -4, -7, -3, -2, -7,
      -5, -2, -5, -2, -8,
      -4, -4, -10, -1, 1,
      -8, -20, -3, 1, -12,
      -2, -7, -8, 4, -6,
      -7, 9, -7, -10, -3,
      -14, -6, -4, -8, -11,
      -7, -10, -13, -3, -3,
      1, 8, 4, 3, 6,
      4, 7, 9, 9, 8,
      4, 0, -7, -12, -12,
      -12, -10, -10, -16, -15,
      -13, -22, -16, -12, -15,
      -7, -7, -10, -12, -9,
      -11, -8, -1, -2, 1,
      -2, -4, -7, -3, -3,
      -3, 3, -5, -1, -6,
      -13, -4, -3, -6, 0,
      1, -9, -4, -2, -8,
      -2, -3, 0, 1, -9,
      1, -3, -10, -1, -7,
      -6, -7, -10, -7, -8,
      -9, -9, -7, -7, -4,
      -9, -6, -8, -13, -7,
      -6, -9, -4, -7, -12,
      2, -4, -7, -6, -17,
      -10, -5, -6, -6, -8,
      -7, -15, -5, -3, -7,
      6, -2, -10, -4, -5,
      0, -1, -8, -3, -5,
      -1, -9, -7, -6, -8,
      -6, -7, -4, -12, -8,
      -6, -12, -7, -3, -12,
      -6, -1, -6, -3, -9,
      -11, -8, -1, 8, 7,
      9, 5, 0, -1, -2,
      4, 10, 10, 5, -3,
      -8, -10, -11, -10, -9,
      -7, -9, -15, -17, -22,
      -17, -12, -14, -3, -8,
      -10, -7, -18, -10, -9,
      -4, 1, -4, 3, -7,
      -5, 0, -14, 1, -1,
      -5, 5, -13, -6, -7,
      -9, 1, -7, -5, -2,
      -4, -11, -10, -4, -13,
      -1, -1, -8, 1, -12,
      -8, -4, -10, 0, -6,
      -11, -4, -7, -10, -11,
      -12, -7, -7, -9, -6,
      -12, -14, -8, -9, -5,
      -6, -9, -7, -3, -11,
      -6, 2, -6, -3, -7,
      -10, -2, -8, -7, 0,
      -10, -7, -5, -11, -1,
      -2, -12, 0, -8, -17,
      -2, -6, -8, 4, -3,
      -3, -4, -10, -7, -3,
      -2, -8, -5, -5, -12,
      -3, -7, -14, -3, -10,
      -13, -10, -15, -7, -7,
      -1, 12, 8, 7, 6,
      1, 4, 11, 12, 9,
      9, 4, -2, -9, -13,
      -11, -11, -13, -18, -21,
      -19, -24, -24, -18, -18,
      -10, -6, -12, -8, -11,
      -9, -2, -4, 0, 0,
      -5, -4, -6, -9, -8,
      -6, -3, -6, -9, -1,
      -6, -10, -1, -10, -7,
      1, -9, -3, -4, -11,
      1, -11, -10, 8, -1,
      -5, -7, -10, -8, -9,
      -3, -1, -11, -9, -6,
      -11, -10, -11, -7, -8,
      -7, -12, -7, -3, -12,
      -4, -9, -3, 5, -9,
      -3, -7, -17, -5, -10,
      -9, -3, -8, -3, -14,
      -11, -3, -9, 4, -3,
      -11, -2, -14, -7, 1,
      -10, 0, 2, -11, -7,
      -9, -8, -4, -4, -3,
      -7, -7, -9, -13, -13,
      -9, -9, -11, -8, -15,
      -17, -12, -12, -1, 12,
      15, 16, 10, 8, 11,
      15, 16, 12, 13, 10,
      3, -3, -13, -16, -17,
      -21, -24, -30, -32, -31,
      -29, -26, -23, -19, -11,
      -8, -6, -3, -3, -3,
      2, -2, -2, 4, 3,
      2, -2, -7, 0, 33,
      56, 45, 16, -5, -3,
      9, 11, 6, 0, -4,
      -9, -24, -36, -30, -12,
      2, 4, -6, -14, -10,
      0, 8, 10, 12, 17,
      19, 13, 4, -1, 3,
      10, 10, 2, -7, -13,
      -14, -13, -12, -10, -6,
      -3, -3, -7, -8, -3,
      4, 10, 11, 8, 5,
      4, 3, 1, -1, -2,
      -2, -4, -8, -13, -14,
      -12, -8, -6, -5, -4,
      -4, -3, -3, -1, 3,
      7, 7, 4, -2, -6,
      -8, -7, -5, -5, -7,
      -9, -11, -13, -13, -8,
      -3, 1, 1, -2, -3,
      -1, 1, 3, 2, -1,
      0, 0, -2, -7, -7,
      -4, -3, -4, -5, -6,
      -7, -5, -3, -4, -6,
      -7, -4, -3, -7, -9,
      -1, 12, 18, 10, -6,
      -14, -8, 3, 6, 1,
      -5, -6, -4, -5, -10,
      -13, -7, 1, 3, -2,
      -8, -10, -7, -3, -2,
      -2, -4, -6, -7, -7,
      -7, -6, -5, -5, -3,
      -2, -2, -2, -3, -2,
      -2, 0, 0, -1, -3,
      -4, -4, -4, -4, -4,
      -5, -5, -5, -5, -6,
      -6, -6, -5, -3, -3,
      -3, -3, -3, -2, -1,
      -1, -1, -1, 0, 0,
      -1, -2, -3, -2, -3,
      -4, -5, -5, -5, -5,
      -5, -5, -5, -4, -4,
      -4, -4, -3, -2, -1,
      -2, -2, -2, -2, -2,
      -2, -2, -2, -2, -3,
      -4, -4, -3, -2, -2,
      -3, -3, -3, -2, -2,
      -2, -3, -2, -2, -2,
      -2, -3, -3, -3, -3,
      -3, -3, -2, -2, -3,
      -2, -2, -1, -1, -1,
      -1, -1, 0, 0, -1,
      -1, -2, -1, -1, -1,
      -2, -2, -3, -3, -3,
      -3, -3, -3, -3, -3,
      -2, -2, -1, -1, -1,
      -1, -1, -1, -2, -3,
      -2, -2, -1, -2, -3,
      -3, -4, -4, -4, -4,
      -4, -3, -4, -4, -3,
      -3, -2, -1, -1, -1,
      0, 0, 0, 0, 0,
      0, -1, -1, -2, -2,
      -2, -2, -2, -2, -3,
      -3, -2, -2, -2, -2,
      -1, -1, -1, -1, -1,
      -2, -1, -1, -1, -2,
      -2, -2, -2, -2, -3,
      -2, -2, -2, -2, -2,
      -2, -2, -1, -1, -1,
      -1, -1, -2, -3, -3,
      -1, -1, -1, -2, -2,
      -1, -1, 0, 7, 12,
      0, -15, -15, -2, 8,
      4, -3, -6, -6, -5,
      -2, 3, 4, 0, -4,
      -6, -5, -2, 0, 0,
      1, 2, 1, -3, -5,
      -2, 2, 4, 4, 4,
      5, -1, -9, -8, -3,
      1, 1, -2, -4, -8,
      -9, -6, 1, 4, 4,
      1, -3, -3, -3, -1,
      3, 5, 4, 0, -4,
      -4, -2, -1, 1, 2,
      0, -3, -5, -5, -4,
      -1, 2, 1, -1, -2,
      -3, -3, -3, -2, 0,
      1, 0, -3, -5, -4,
      -2, -1, 0, -1, -1,
      -1, -2, -3, -3, -2,
      -1, 0, -1, -3, -4,
      -2, 0, 0, 0, 1,
      -1, -4, -4, -3, -1,
      -1, -1, -1, -3, -3,
      -3, -2, -1, -1, 0,
      1, 0, -1, -1, -1,
      -1, -1, 0, 2, 2,
      -2, -5, -4, -3, -2,
      -3, -4, -6, -6, -6,
      -5, -2, 4, 11, 13,
      10, 6, 4, 6, 8,
      8, 6, 2, -1, -5,
      -8, -8, -6, -4, -6,
      -9, -12, -12, -9, -6,
      -4, -2, -1, -1, -1,
      0, 2, 4, 6, 6,
      5, 3, 2, 1, 0,
      -1, -1, -2, -3, -4,
      -4, -4, -2, 0, 0,
      -2, -3, -4, -3, -1,
      0, 0, 0, -2, -3,
      -3, -2, -2, -2, -3,
      -3, -3, -3, -3, -4,
      -3, -3, -2, -1, -1,
      -2, -2, -3, -1, 0,
      -1, -2, -3, -3, -3,
      -3, -3, -3, -2, -3,
      -4, -4, -2, -1, 0,
      1, -1, -2, -1, -2,
      -2, -2, -2, -2, -3,
      0, 31, 19, 2, -1,
      8, 15, 12, 8, 7,
      6, 0, -11, -19, -17,
      -10, -9, -16, -26, -29,
      -25, -20, -18, -16, -9,
      -1, 2, -2, -3, 2,
      9, 10, 7, 5, 2,
      -2, -3, -2, -6, -7,
      -3, -1, -6, -12, -8,
      1, 2, 1, -1, -4,
      -4, -5, -6, -6, -7,
      -5, -2, -5, -10, -8,
      -4, -2, -4, -5, -1,
      -2, -4, -2, -2, -5,
      -2, 3, 0, -7, -7,
      -2, -5, -11, -6, 3,
      -4, -8, -1, -3, -8,
      -3, -3, 1, 7, -7,
      -15, 2, 5, -13, -7,
      9, 0, -13, -5, 2,
      -7, -4, 6, 1, -6,
      -6, -4, -2, 0, -1,
      -2, 0, 0, -6, -6,
      -2, -4, -4, -1, -3,
      -11, -14, -8, -3, -2,
      7, 19, 18, 6, 0,
      3, 8, 7, 7, 9,
      7, 1, -4, -7, -12,
      -14, -11, -10, -14, -19,
      -20, -18, -14, -10, -9,
      -8, -3, 1, -2, -5,
      -1, 2, 3, 4, 4,
      4, 3, -1, -2, 1,
      -4, -5, 2, 1, -7,
      -7, -3, -3, -4, -3,
      -5, -5, -2, -1, -5,
      -7, -1, 3, 0, 0,
      1, -4, -7, -3, -3,
      -4, -3, -8, -5, 1,
      -6, -12, -3, 4, -2,
      -7, -3, 1, -2, -5,
      -3, 0, -1, -1, -4,
      -6, -3, 0, -3, -4,
      7, 2, -14, -3, 7,
      -4, -10, -2, 5, -1,
      -10, -4, 2, -6, -5,
      5, 1, -8, -4, 4,
      -2, -11, -6, 0, -2,
      -4, -2, -5, -11, -7,
      0, -2, -3, 1, -3,
      -8, -2, 0, -1, 8,
      15, 8, 2, 2, 0,
      -1, 1, 3, 3, 0,
      -5, -7, -8, -11, -9,
      -5, -6, -8, -7, -9,
      -10, -8, -3, 0, -3,
      -2, 1, -5, -9, -2,
      3, -3, -4, 2, -5,
      -8, 0, -4, -7, 5,
      5, -6, -3, 4, -1,
      -4, 3, 6, -2, -8,
      -2, -2, -11, -5, 3,
      -3, -7, -2, -1, -7,
      -6, -2, -3, -6, -7,
      1, 3, -9, -10, 1,
      1, -8, -6, 1, 5,
      -4, -8, 4, 7, -10,
      -10, 12, 8, -15, -14,
      1, -1, -8, -6, -1,
      3, -7, -12, 1, 5,
      -12, -8, 15, 6, -24,
      -15, 13, 7, -11, -5,
      6, -3, -10, 0, 2,
      -8, -5, 4, -4, -9,
      1, 2, -7, -3, 2,
      -3, -6, -5, -3, -3,
      -1, 2, -3, -6, 3,
      0, -5, 6, 11, 1,
      -2, 5, 0, -4, 2,
      2, -1, 0, -5, -10,
      -7, -7, -8, -2, -4,
      -9, -7, -6, -8, -4,
      -2, -4, -3, -1, -2,
      -10, -10, 5, 6, -9,
      -5, 5, -4, -10, -3,
      2, 5, -1, -8, 0,
      0, -6, -1, 4, 0,
      -7, -8, -6, -4, -2,
      -6, -5, 1, -4, -13,
      -6, 3, 0, -7, -3,
      5, -3, -15, -5, 10,
      -1, -17, -5, 11, -4,
      -15, -2, 2, -5, -2,
      0, -9, -5, 0, -9,
      -9, 8, 4, -13, -5,
      5, -3, -10, 1, 7,
      -2, -3, -4, -8, 2,
      1, -14, -1, 9, -12,
      -14, 4, -2, -11, 5,
      7, -9, -8, 1, -1,
      -4, -1, 2, 0, -5,
      -7, -4, 1, 0, -1,
      0, -6, -8, -3, -3,
      -7, -2, 6, -3, -6,
      4, 4, -4, -4, 6,
      8, -4, -5, 4, 0,
      -9, -4, 0, -5, -11,
      -9, -3, -7, -15, -9,
      1, -7, -14, -2, 3,
      -9, -9, 0, -3, -6,
      1, 4, -5, -11, 0,
      4, -6, -6, 3, 1,
      -11, -8, 0, -3, 1,
      3, -8, -5, 3, -9,
      -9, 7, 0, -11, -2,
      -2, -9, -3, 0, -4,
      -2, -8, -8, 4, -8,
      -11, 5, -2, -9, -3,
      1, -3, -9, -2, 2,
      -8, -4, 5, -6, -10,
      3, 2, -11, -6, 7,
      -4, -12, -3, -3, -3,
      2, -1, -3, -8, -8,
      3, -1, -6, 3, 1,
      -7, 0, 3, -8, -8,
      3, 2, -6, -6, -4,
      -11, -7, 5, -2, -10,
      1, -1, -16, -6, 5,
      -4, -9, -3, -2, -5,
      -8, -2, 4, 1, 1,
      7, 4, 2, 1, -6,
      -1, 6, -4, -7, 1,
      -2, -12, -10, -4, -5,
      -9, -8, -5, -6, -15,
      -9, 4, -4, -16, -2,
      6, -11, -12, 7, 3,
      -14, -4, 12, -3, -14,
      6, 4, -13, -3, 5,
      -4, -6, -2, -3, -3,
      1, -2, -3, -1, -4,
      -7, -6, 1, -1, -11,
      -6, 0, -6, -5, -3,
      -5, -8, -5, 0, -1,
      -3, -1, -3, -9, -7,
      -2, -2, -2, 0, -6,
      -9, -7, -4, 3, -3,
      -10, 3, -2, -15, -1,
      6, -9, -5, 10, -8,
      -18, 6, 6, -11, -9,
      1, -2, -13, -2, 10,
      -10, -15, 3, -3, -13,
      -2, 4, -9, -10, 1,
      -3, -6, 6, 2, -9,
      -7, -4, -4, -5, -5,
      -3, -6, -2, 7, 6,
      3, 3, 2, 3, 5,
      2, -1, 3, 2, -4,
      -5, -3, -7, -10, -7,
      -8, -13, -12, -9, -10,
      -11, -9, -7, -7, -5,
      -2, 0, 0, 17, 27,
      -16, -22, 32, 36, 14,
      12, 2, 17, 37, 18,
      10, 13, 0, -3, 16,
      12, -17, -20, -9, -7,
      -7, -25, -38, -22, -15,
      -27, -27, -29, -34, -23,
      -14, -21, -26, -23, -17,
      -6, -3, -14, -12, 0,
      2, 3, 3, 1, 4,
      10, 9, 8, 8, 4,
      5, 10, 8, 1, 0,
      0, 1, 0, -5, -9,
      -8, -9, -11, -12, -15,
      -17, -15, -15, -16, -17,
      -17, -15, -12, -12, -13,
      -11, -9, -6, -5, -7,
      -7, -3, 2, 0, -5,
      -4, 0, 2, -3, -7,
      -5, 0, -1, -7, -8,
      -7, -9, 0, 0, 2,
      1, -1, -1, 0, 2,
      5, 2, 0, 1, 1,
      3, 3, 0, -1, -1,
      -1, 0, 0, -3, -5,
      -5, -4, -4, -4, -6,
      -7, -5, -4, -3, -3,
      -4, -4, -3, -2, -2,
      -2, -2, -2, -1, -1,
      0, 0, 0, -1, 0,
      1, 1, 1, 0, -1,
      1, 1, 0, 0, -1,
      -1, -1, -1, -2, -2,
      -3, -3, -3, -4, -4,
      -3, -4, -3, -2, -3,
      -3, -3, -2, -1, -1,
      -2, -2, -1, -2, -1,
      0, -1, -2, -2, -1,
      0, -2, -3, -2, -1,
      -3, -4, -2, 0, -2,
      -3, -2, -1, 0, 0,
      -10, -15, 2, 19, 16,
      5, -1, 4, 20, 25,
      13, 6, 5, 3, 7,
      7, 2, -3, -18, -25,
      -18, -14, -17, -26, -32,
      -27, -23, -20, -13, -15,
      -16, -11, -12, -2, 3,
      -7, -5, -7, -7, 6,
      -1, -2, 0, -8, 1,
      2, 0, 3, -7, -6,
      -3, -3, 2, -6, -9,
      -2, -6, -4, 0, -4,
      -7, -10, -9, -5, -4,
      -7, -12, -9, -9, -4,
      -9, -12, -3, -11, -8,
      -8, -13, -3, -10, -8,
      -1, -6, -7, -9, -7,
      -5, -8, -7, -10, -4,
      -2, -17, -6, -3, -16,
      -3, -4, -11, 1, -6,
      -10, 0, -3, -10, 0,
      -5, -5, 0, -6, -3,
      -3, -7, -5, -5, -8,
      -5, -7, -5, -1, -8,
      -12, -6, -7, -7, -3,
      -7, -9, -6, -7, -9,
      -10, -9, 0, 11, 15,
      8, -5, 0, 10, 14,
      13, 3, -1, 1, 2,
      4, 4, -2, -12, -18,
      -16, -10, -11, -16, -23,
      -25, -17, -11, -12, -12,
      -13, -15, -14, -10, -5,
      -9, -10, -14, -14, 0,
      -1, -5, -2, -6, -4,
      1, -4, -3, 3, -6,
      -7, -2, -5, 1, -4,
      -13, -3, -2, -6, -4,
      -7, -4, -4, -12, -6,
      0, -7, -6, -10, -7,
      -4, -8, -6, -11, -8,
      -6, -13, -8, -3, -10,
      -12, -5, -8, -7, -2,
      -9, -11, -6, -12, -7,
      1, -7, -4, -7, -7,
      3, -7, -10, -1, -7,
      -3, -3, -7, -1, -12,
      -9, -1, -7, -1, -4,
      -11, 0, -2, -7, -1,
      -8, -7, -9, -4, -2,
      -10, -6, -9, -3, 2,
      -11, -5, -6, -13, -5,
      -14, -16, -7, -7, 5,
      9, 1, 1, -1, 7,
      14, 8, 7, 3, -2,
      2, 3, 0, -2, -10,
      -17, -14, -11, -13, -17,
      -21, -24, -17, -13, -13,
      -9, -17, -16, -8, -12,
      -7, -3, -9, -8, -1,
      -5, -2, 2, -7, -8,
      0, -2, -1, -5, -7,
      -3, -3, -4, -4, -5,
      -5, -4, -6, -3, -1,
      -8, -7, -1, 0, -2,
      -2, -8, -8, -2, -9,
      -11, -3, -8, -11, -8,
      -7, -7, -5, -13, -11,
      0, -10, -10, -6, -12,
      -7, -5, -8, -7, -2,
      -8, -9, -1, -3, -9,
      -7, -4, -10, -8, -3,
      -9, -9, -3, -6, -3,
      1, -4, -3, -10, -10,
      -2, -5, -8, -7, -6,
      -6, 3, -6, -11, -4,
      -12, -2, -1, -14, -8,
      -10, -8, -4, -11, -7,
      -12, -12, -5, -10, -2,
      5, 0, 2, 1, 3,
      12, 6, 3, 6, 2,
      2, 0, 0, 3, -3,
      -8, -9, -11, -9, -13,
      -19, -17, -12, -16, -15,
      -12, -12, -13, -13, -10,
      -8, -7, -10, -11, -8,
      1, -5, -8, 2, -6,
      -5, -1, -6, -2, 0,
      -6, -7, -2, -2, -4,
      -9, -4, -2, -4, -2,
      -2, -6, -4, -7, -11,
      -2, -3, -11, -8, -8,
      -3, -6, -10, -1, -8,
      -8, -9, -12, -2, -14,
      -9, -4, -9, -1, -13,
      -10, 0, -17, -16, -7,
      -8, -2, -5, -18, 1,
      0, -16, -1, -4, -9,
      -5, -12, -3, 5, -13,
      -10, -1, -9, 0, -4,
      -15, 1, -4, -15, 2,
      -2, -10, -6, -9, -2,
      -1, -8, -10, -7, -3,
      -6, -9, -7, -5, -10,
      -9, -9, -8, -8, -10,
      -2, 2, 7, 1, -2,
      10, 9, 8, 6, 3,
      8, 2, -1, 4, -1,
      -3, -8, -13, -7, -10,
      -14, -17, -18, -16, -17,
      -13, -19, -15, -10, -19,
      -6, -6, -16, -1, -11,
      -10, 6, -10, -9, 0,
      -10, -2, 0, -12, -4,
      -3, -9, -3, -5, -11,
      -3, -6, -9, 0, -4,
      -7, -2, -6, -4, -2,
      -7, -4, -4, -7, -4,
      -10, -6, -3, -9, -5,
      -7, -9, -13, -8, -1,
      -9, -13, -8, -10, -8,
      -8, -12, -5, -6, -12,
      -13, -2, -2, -13, -4,
      -9, -2, 3, -18, -4,
      2, -9, -8, -9, -2,
      -5, -9, -5, -6, -2,
      -7, -15, -2, 2, -8,
      -5, -1, -3, -3, -12,
      -13, 4, -2, -13, -4,
      -6, -6, -9, -12, -8,
      -11, -10, -16, -13, 12,
      3, -8, 5, 0, 12,
      20, 2, 9, 11, 3,
      5, 4, 4, -2, -11,
      -13, -11, -8, -13, -23,
      -23, -18, -18, -18, -18,
      -16, -16, -17, -15, -9,
      -7, -9, -10, -9, -3,
      -2, -5, -4, -6, -4,
      -1, -6, -3, -1, -7,
      -3, -6, -1, -1, -10,
      -4, -8, 0, 6, -13,
      -1, 3, -12, 2, -1,
      -9, -1, -11, -12, 1,
      -12, -11, -6, -15, -2,
      -9, -12, -2, -14, -4,
      -8, -16, -2, -13, -14,
      3, -10, -9, 1, -8,
      -7, -6, -11, -4, -2,
      -8, -8, -2, -9, -11,
      -3, -11, -11, -4, -9,
      2, -1, -11, 0, -7,
      -8, 0, -11, -11, -8,
      -10, -4, -7, -13, -10,
      -6, -3, -3, -7, -9,
      -7, -14, -11, -10, -13,
      -3, 2, 4, 6, 1,
      4, 12, 11, 12, 13,
      8, 5, 4, 3, 2,
      -1, -10, -14, 0, 5,
      49, 41, -24, -34, 17,
      50, 42, -2, -30, -7,
      19, 19, 1, -19, -17,
      -15, -25, -18, -4, -10,
      -27, -38, -26, 3, 13,
      -3, -20, -18, 3, 14,
      3, -5, -4, -2, -1,
      1, 4, 5, -1, -8,
      -7, 1, 7, 2, -8,
      -11, -2, 5, 2, -4,
      -4, -1, -4, -9, -8,
      -4, -6, -12, -13, -8,
      -5, -7, -9, -8, -5,
      -6, -6, -4, -2, -1,
      -1, -1, -1, -2, -3,
      -1, -1, -3, -6, -6,
      -5, -4, -6, -8, -9,
      -8, -8, -7, -7, -7,
      -7, -6, -4, -3, -3,
      -4, -3, -2, -2, -2,
      -2, -2, -2, -3, -3,
      -4, -4, -4, -4, -5,
      -6, -7, -6, -6, -7,
      -8, -7, -6, -6, -6,
      -6, -5, -4, -3, -3,
      -2, -2, -2, -2, -1,
      0, 1, 0, 0, -1,
      -2, -2, -2, -3, -4,
      -5, -6, -6, -6, -6,
      -6, -6, -7, -7, -6,
      -4, -4, -4, -6, -6,
      -5, -3, -3, -4, -5,
      -5, -4, -3, -3, -4,
      -5, -5, -5, -5, -4,
      -5, -6, -6, -6, -4,
      -3, -4, -4, -4, -3,
      -2, -1, -1, -1, 0,
      -1, -1, 0, 0, 0,
      -1, -2, -2, -2, -2,
      -3, -4, -5, -5, -4,
      -4, -4, -5, -6, -5,
      -5, -4, -4, -4, -4,
      -3, -2, -2, -1, -2,
      -3, -2, -2, -2, -3,
      -4, -4, -3, -3, -4,
      -5, -5, -5, -4, -4,
      -4, -4, -4, -3, -3,
      -3, -2, -1, -1, -1,
      -1, -1, -1, -1, -1,
      0, -1, -1, -2, -3,
      -2, -2, -3, -3, -4,
      -4, -4, -4, -4, -4,
      -4, -4, -4, -3, -3,
      -2, -2, -2, -2, -2,
      0, 0, -1, -2, -2,
      3, 18, 17, -20, -31,
      7, 9, -18, -9, 5,
      -4, -6, 1, -2, -6,
      3, 16, 14, 6, 1,
      -6, -11, -10, -8, -11,
      -14, -6, 1, 0, 0,
      0, -1, 2, 4, -1,
      -4, -2, 0, 0, -3,
      -5, -2, -1, -3, -5,
      -1, 8, 6, -10, -7,
      6, 3, -7, -12, -8,
      -1, -1, -6, -9, -7,
      -5, -3, 1, 1, -2,
      -5, -4, 5, 7, -2,
      -8, -4, 2, 3, -6,
      -11, -6, -2, 0, -2,
      -6, -5, -1, 0, 2,
      0, -4, -4, -2, 1,
      1, -4, -6, -4, -2,
      -2, -5, -6, -1, 3,
      2, 0, -1, 1, 4,
      3, 0, -2, -5, -5,
      -4, -3, -2, 0, 2,
      3, 4, 3, -3, -6,
      -3, -3, -4, -5, -4,
      -1, 1, 4, 5, 3,
      2, 0, -2, -3, -1,
      -1, -1, 0, 0, 1,
      1, -1, -1, 0, -2,
      -5, -5, -5, -5, -6,
      -7, -7, -6, -6, -6,
      -5, -5, -8, -7, -1,
      0, -3, -2, 0, -2,
      -1, 1, 0, -3, -4,
      -2, -1, -2, -2, 3,
      1, -7, -4, 1, 1,
      -3, -8, -6, -2, -2,
      -3, -6, -7, -6, -3,
      0, 1, 1, 0, 0,
      3, 4, 2, -1, -5,
      -1, 5, 0, -6, -8,
      -4, 1, -4, -11, -12,
      -8, -6, -8, -5, 4,
      8, 6, 4, 9, 18,
      17, 7, 5, 15, 18,
      12, 5, 2, 6, 6,
      -3, -6, -6, -11, -13,
      -14, -14, -15, -20, -21,
      -15, -11, -12, -14, -11,
      -4, -1, -3, -3, 1,
      4, 5, 5, 6, 7,
      6, 6, 9, 10, 7,
      5, 5, 5, 5, 0,
      -4, -4, -2, -5, -9,
      -11, -9, -8, -9, -12,
      -11, -9, -8, -8, -7,
      -5, -4, -3, -3, -1,
      1, 1, 0, 0, 2,
      2, 0, -1, -1, 0,
      -1, -4, -4, -2, -3,
      -4, -4, -5, -6, -6,
      -4, -3, -5, -5, -4,
      -3, 0, 3, -1, -4,
      -2, 1, 0, 0, 0,
      6, 17, 28, 37, 41,
      39, 32, 23, 16, 11,
      8, 7, 7, 8, 8,
      0, -10, -19, -29, -40,
      -48, -50, -49, -43, -36,
      -32, -27, -22, -21, -22,
      -21, -18, -13, -8, -2,
      5, 12, 17, 17, 16,
      14, 11, 8, 6, 5,
      6, 6, 5, 4, 1,
      -3, -6, -9, -12, -14,
      -15, -16, -16, -15, -14,
      -14, -15, -17, -18, -17,
      -16, -13, -10, -8, -4,
      -1, 1, 2, 0, -2,
      -3, -4, -4, -3, -4,
      -4, -6, -9, -11, -13,
      -14, -15, -16, -14, -10,
      -10, -11, -10, -10, -10,
      -10, -10, -9, -10, 0,
      0, 15, 43, 39, 18,
      17, 30, 36, 21, 10,
      26, 39, 38, 27, 19,
      21, 1, -24, -32, -30,
      -30, -44, -49, -41, -40,
      -48, -57, -50, -38, -36,
      -38, -36, -27, -18, -16,
      -12, -4, 1, 4, 6,
      12, 14, 10, 9, 11,
      15, 15, 8, 7, 12,
      12, 6, 2, 2, -1,
      -7, -11, -11, -11, -14,
      -19, -22, -23, -24, -27,
      -29, -27, -27, -30, -31,
      -27, -22, -18, -16, -14,
      -13, -14, -14, -12, -8,
      -4, -2, 1, 3, 3,
      1, -1, -4, -6, -7,
      -10, -11, -9, -8, -7,
      -6, -5, -4, -3, -2,
      -1, 0, 13, 28, 30,
      26, 33, 46, 52, 46,
      39, 44, 48, 37, 17,
      3, -7, -18, -34, -40,
      -37, -37, -44, -50, -48,
      -45, -51, -57, -52, -41,
      -35, -35, -33, -25, -19,
      -19, -20, -13, -2, 4,
      6, 9, 15, 18, 16,
      14, 16, 16, 14, 12,
      14, 14, 10, 5, 3,
      3, 2, -3, -6, -7,
      -10, -16, -23, -26, -27,
      -29, -31, -30, -28, -28,
      -29, -29, -26, -23, -21,
      -19, -14, -9, -9, -9,
      -8, -5, -3, -4, -4,
      -2, -1, -1, -2, -3,
      -5, -7, -9, -11, -11,
      -10, -8, -7, -5, -4,
      -2, -1, 0, 5, 39,
      50, 28, 15, 11, 15,
      38, 42, 24, 19, 8,
      -10, -6, -3, -1, 6,
      -11, -36, -39, -34, -25,
      -15, -22, -31, -31, -32,
      -29, -17, -9, -5, -4,
      -11, -10, 0, 9, 16,
      18, 14, 11, 10, 11,
      17, 23, 21, 14, 6,
      2, 5, 10, 7, 1,
      -2, -9, -9, -7, -13,
      -14, -13, -19, -18, -14,
      -16, -10, -9, -12, -8,
      -5, -4, 1, 0, -2,
      1, 0, 1, 4, 2,
      2, 2, 0, 1, 2,
      -1, -4, -6, -7, -6,
      -6, -8, -12, -15, -15,
      -13, -10, -9, -8, -8,
      -9, -9, 0, 0, 6,
      21, 27, 22, 23, 32,
      45, 54, 44, 31, 30,
      37, 37, 18, -5, -19,
      -27, -30, -36, -47, -50,
      -48, -47, -51, -57, -54,
      -49, -41, -35, -33, -29,
      -21, -14, -10, -11, -9,
      -4, 1, 9, 12, 12,
      12, 13, 14, 13, 11,
      10, 9, 8, 7, 4,
      1, -3, -6, -7, -9,
      -10, -12, -14, -15, -18,
      -22, -23, -23, -21, -20,
      -20, -22, -22, -19, -18,
      -17, -16, -13, -9, -5,
      -5, -7, -8, -6, -5,
      -5, -6, -7, -8, -8,
      -8, -10, -12, -13, -14,
      -14, -16, -13, -11, -9,
      -7, -5, -3, 0, 0,
      6, 17, 22, 23, 30,
      37, 45, 50, 47, 43,
      41, 38, 31, 14, -5,
      -18, -27, -31, -36, -43,
      -48, -52, -52, -53, -56,
      -57, -56, -51, -44, -37,
      -30, -26, -23, -18, -15,
      -11, -5, 2, 10, 15,
      16, 16, 15, 16, 17,
      16, 14, 11, 10, 9,
      6, 2, -1, -5, -7,
      -10, -12, -14, -15, -17,
      -21, -24, -25, -25, -24,
      -22, -21, -20, -19, -18,
      -17, -16, -15, -13, -9,
      -7, -6, -6, -7, -7,
      -5, -5, -7, -8, -8,
      -8, -8, -9, -12, -15,
      -17, -17, -15, -13, -11,
      -9, -7, -5, -3, -1,
      0, -4, -4, -3, -3,
      -4, -4, -3, -1, 0,
      -1, -3, -4, -4, -5,
      -5, -2, -1, -6, -9,
      -6, -3, -4, -5, -4,
      -4, -4, -4, -2, 0,
      -1, -4, -7, -7, -6,
      -6, -7, -5, -4, -6,
      -6, -5, -5, -5, -5,
      -3, -1, 0, 0, -3,
      -5, -4, -1, 0, -2,
      -4, -7, -8, -5, -2,
      -3, -6, -8, -8, -8,
      -9, -8, -6, -5, -6,
      -7, -8, -7, -5, -5,
      -5, -3, -3, -3, -4,
      -6, -6, -4, -2, -1,
      0, 0, 1, 2, 1,
      -1, -1, 0, 0, 0,
      -1, -2, -2, -3, -6,
      -8, -10, -11, -10, -10,
      -11, -11, -11, -10, -10,
      -10, -9, -8, -5, -3,
      -2, -2, -2, -2, -2,
      -2, -2, -1, 0, 0,
      -1, -2, -2, -2, -2,
      -3, -3, -3, -2, -1,
      -2, -3, -3, -3, -4,
      -3, -4, -5, -5, -6,
      -6, -6, -7, -7, -6,
      -7, -7, -6, -8, -8,
      -7, -6, -5, -5, -6,
      -7, -7, -6, -4, -4,
      -4, -4, -4, -6, -6,
      -5, -6, -5, -6, -6,
      -5, -5, -6, -8, -10,
      -12, -11, -8, -5, -4,
      -5, -6, -7, -8, -8,
      -7, -6, -6, -5, -6,
      -9, 0, 0, -2, 2,
      15, 25, -8, -32, -21,
      -17, -18, -16, -9, -6,
      -7, -1, 3, 2, -2,
      -3, 1, 4, 3, 0,
      -2, -3, -3, -4, -3,
      2, 0, -4, -4, -3,
      -2, -3, -4, -4, -4,
      -5, -5, -2, -2, -3,
      -5, -5, -4, -3, -2,
      -3, -2, -2, -2, -2,
      -2, 0, 0, -2, -3,
      -4, -3, -3, -3, -4,
      -4, -5, -6, -5, 2,
      17, 14, -10, -14, -8,
      -9, -11, -13, -16, -19,
      -16, -6, 0, -1, -6,
      -6, -1, 2, 0, 0,
      -2, -4, -5, -3, 0,
      3, 3, 1, -2, -1,
      1, 1, 0, -1, -4,
      -7, -9, -6, -2, -4,
      -9, -11, -11, -8, -6,
      -6, -7, -6, -5, -4,
      -1, -1, -4, -6, -7,
      -6, -3, -1, -4, -2,
      5, 1, -5, -3, -5,
      -12, -14, -13, -12, -8,
      -7, -7, -4, -4, -6,
      -2, 2, 2, -1, -4,
      -4, 0, 1, -1, -2,
      -2, -3, -4, -3, -2,
      0, 0, -3, -3, -2,
      4, 5, -5, -14, -14,
      -10, -3, 0, -3, -8,
      -10, -6, -1, 1, -2,
      -5, -6, -4, -1, 0,
      -2, -4, -5, -4, -1,
      0, 0, -2, -3, -3,
      -1, 0, -1, -3, -4,
      -4, -3, -2, -2, -3,
      -4, -4, -4, -3, -3,
      -3, -2, 9, 23, 11,
      -18, -31, -26, -8, 2,
      -1, -8, -11, -7, -2,
      1, 0, -2, -3, -2,
      1, 2, 1, -1, -4,
      -4, -2, 0, 0, -2,
      -6, -6, -3, -1, -1,
      -4, -5, -4, -2, -1,
      -2, -4, -4, -3, -2,
      -1, -1, -3, -4, -4,
      -3, -2, -2, -3, -4,
      -4, -4, -3, -3, -4,
      -4, -4, -3, -1, 0,
      -2, -3, -3, -1, 1,
      0, -2, -4, -4, -3,
      -1, -2, -4, -5, -5,
      -4, -4, -5, -6, -7,
      -6, -5, -6, -6, -5,
      -3, -2, -2, -4, -5,
      -4, -1, 1, 0, -3,
      -5, -4, -3, -2, -2,
      -3, -4, -3, -2, -2,
      -3, -3, -3, -4, -5,
      -6, -5, 2, 14, 13,
      -5, -18, -18, -7, 1,
      -2, -7, -10, -8, -2,
      -1, -3, -4, -4, -3,
      -2, -2, -1, -3, -5,
      -5, -3, -2, -3, -5,
      -5, -4, -1, -2, -4,
      -4, 3, 20, 24, -1,
      -28, -32, -14, 3, 0,
      -13, -19, -13, -2, 3,
      -2, -7, -5, 2, 6,
      4, -3, -5, -2, -1,
      -1, -2, -4, -5, -5,
      -5, -3, -1, -1, -3,
      -3, -1, 1, 2, 1,
      -1, 1, 2, 4, 3,
      1, 1, 1, 1, 0,
      -3, -5, -5, -4, -6,
      -8, -9, -9, -9, -9,
      -10, -10, -9, -8, -6,
      -7, -6, 0, 8, 2,
      -11, -13, -4, 6, 3,
      -6, -9, -4, 3, 4,
      -2, -5, -2, 2, 3,
      0, -4, -3, 0, -1,
      -4, -5, -5, -3, -4,
      -6, -6, -5, -5, -5,
      -7, -8, -6, -5, -6,
      -7, -7, -6, -4, -5,
      -4, -4, -4, -4, -2,
      -2, -2, -2, -2, -2,
      0, 0, 1, 9, 3,
      -13, -13, -5, -3, -5,
      -6, -5, -2, -1, -2,
      -2, -1, -3, -5, -4,
      -2, -1, -1, -3, -6,
      -5, -1, -1, -2, -3,
      -3, -3, -2, -2, -3,
      -3, -2, -2, -4, -3,
      -2, -2, -2, -3, -3,
      -2, -1, -1, -3, -3,
      -3, -3, -2, -3, -4,
      -4, -3, -3, -3, -3,
      -3, -4, -4, -4, -3,
      -3, -3, -1, 5, 2,
      -5, -4, -4, -4, -3,
      -5, -6, -3, -2, -1,
      0, -1, -4, -6, -5,
      -3, -1, -2, -5, -6,
      -3, 0, -1, -4, -4,
      -2, -2, -2, -2, -3,
      -2, -3, -3, -1, -1,
      -3, -4, -1, 3, 1,
      -4, -3, 0, 1, -1,
      -5, -5, -2, -3, -5,
      -4, 0, -1, -4, -3,
      -2, 0, -1, -4, -5,
      -1, 1, -2, -5, -5,
      -4, -3, -4, -6, -6,
      -4, -5, -7, -6, -3,
      -3, -4, -5, -4, -2,
      -3, -5, -4, -2, -1,
      -2, -3, -2, 0, 1,
      0, -1, -1, -1, -1,
      1, 1, 0, -1, -1,
      -2, -3, -3, -4, -5,
      -5, -4, -5, -6, -7,
      -6, -5, -6, -6, -6,
      -6, -5, -4, -3, -3,
      -3, -2, -2, -1, 0,
      -2, -4, -3, -2, -3,
      -3, -3, -3, -2, -3,
      -5, -5, -6, -7, -5,
      -4, -4, -4, -4, -4,
      -2, -1, -3, -2, -2,
      -3, -4, -5, -5, -5,
      -6, -7, -4, -1, 0,
      -2, -2, -2, -2, -2,
      4, 13, 1, -19, -6,
      3, -12, -6, 13, 10,
      -8, -13, -4, -7, -11,
      -1, 3, 2, 6, 2,
      -2, 0, -5, -4, 4,
      0, -8, -5, 0, -1,
      -5, -4, -1, -2, -5,
      -5, -2, 0, -4, -4,
      2, 0, -4, -3, 0,
      0, -3, -3, -1, -1,
      -2, -2, 0, 0, -4,
      -4, 0, 0, -3, -2,
      -1, -1, -3, -4, -1,
      -2, -6, -2, 0, -4,
      -4, -3, -3, 0, -2,
      -4, -1, -2, -4, -2,
      -2, -4, -1, -1, -3,
      -2, -3, -3, -2, -3,
      -2, -1, -4, -4, -2,
      -3, -5, -1, -2, -4,
      -1, -1, -3, -1, -1,
      -4, -3, -3, -2, -1,
      -2, -3, 0, -1, -3,
      -3, -1, -1, -3, -2,
      0, -2, -3, -2, 0,
      -1, -3, -1, 1, -3,
      -6, -1, 0, -5, -4,
      0, -3, -4, -2, -2,
      -2, -2, -1, -1, -3,
      -5, -2, 2, -3, -9,
      -3, 1, -4, -7, -3,
      2, -3, -5, 2, -1,
      -6, -2, -1, -1, -2,
      -3, -2, -2, -3, -5,
      0, -1, -5, -1, -1,
      -3, -4, -2, 0, -1,
      -5, -4, 0, -5, -5,
      0, -2, -5, -4, -5,
      -2, -3, -7, -2, 1,
      2, -5, -5, 2, -2,
      -7, -5, 1, -1, -9,
      -5, 3, 1, -5, -3,
      1, -1, -1, -1, -2,
      -1, -4, -7, -3, 1,
      -5, -4, -1, -5, -1,
      -1, -3, -3, -2, 0,
      -2, -4, 0, -2, -6,
      -3, 1, -1, -3, 1,
      2, -2, 0, 3, 0,
      1, -1, -1, 6, 0,
      -5, 1, 0, -5, -1,
      0, -6, -5, -4, -4,
      -4, -6, -7, -5, -4,
      -7, -6, -4, -7, -6,
      -2, -3, -7, -5, -2,
      -2, -4, -6, 0, -1,
      -5, -1, 1, 0, -2,
      -4, -2, 3, 0, -6,
      -1, 4, 0, -1, -2,
      -1, 0, -2, -3, -3,
      -1, -5, -5, -3, -3,
      -4, -7, -6, -2, -5,
      -5, -5, -7, -2, -2,
      -8, -5, 0, -2, -3,
      -3, -5, 0, -2, -9,
      1, 3, -7, -5, 1,
      0, -2, -3, -5, 0,
      2, -8, -3, 5, -6,
      -6, 2, -3, -3, -2,
      -6, -4, 0, -4, -6,
      -1, -5, -3, 0, -7,
      -6, -2, -5, -5, 2,
      5, -1, -1, 4, 7,
      8, 3, 4, 8, 4,
      3, 9, 6, 0, -1,
      1, 2, -1, -6, -8,
      -7, -9, -11, -10, -10,
      -12, -13, -11, -9, -10,
      -11, -10, -7, -4, -5,
      -7, -3, -1, -2, -2,
      0, 3, 0, -2, 2,
      4, 3, 0, 1, 5,
      5, -1, -1, 2, 1,
      0, -1, 0, 1, -3,
      -5, -2, -2, -6, -7,
      -4, -5, -7, -5, -5,
      -7, -8, -8, -4, -3,
      -9, -7, -2, -5, -5,
      -2, -3, -4, -2, 0,
      3, 1, -6, -3, 6,
      -3, -7, 0, -2, -5,
      -3, 0, 0, -3, -3,
      -2, 5, 12, -7, -19,
      2, 5, -12, -11, 2,
      0, -9, -4, 3, -3,
      -5, 0, 1, -4, -4,
      -1, -2, -4, -3, -2,
      -4, -5, -4, -4, -4,
      -3, -4, -5, -5, -4,
      -4, -4, -5, -4, -4,
      -4, -3, -3, -5, -4,
      -2, -2, -3, -4, -2,
      -2, -3, -3, -1, -3,
      -4, -2, -2, -4, -3,
      -2, -2, -4, -3, -3,
      -4, -4, -3, -4, -4,
      -3, -4, -5, -3, 4,
      13, -8, -19, 8, 3,
      -19, -7, 5, -5, -13,
      0, 4, -7, -4, 4,
      0, -6, 0, 3, -3,
      -2, 0, -2, -4, -2,
      -1, -3, -4, -3, -3,
      -5, -5, -3, -5, -6,
      -5, -5, -6, -6, -5,
      -6, -6, -5, -5, -5,
      -5, -4, -4, -4, -3,
      -3, -3, -2, -2, -3,
      -1, -1, -3, -1, 0,
      -3, -2, -1, -2, -3,
      -2, -1, -3, -2, -1,
      -3, -3, -3, -3, -5,
      -5, -3, -5, -7, -5,
      -4, -7, -6, -3, -5,
      -7, -3, -3, -7, -5,
      -2, -5, -7, -2, -1,
      -7, -5, 2, -1, -7,
      -3, 1, -5, -5, -1,
      -3, -4, -4, -2, -4,
      -5, -2, -5, -7, -2,
      -2, -6, -6, -2, -4,
      -7, -5, -3, -4, -6,
      -4, -3, -8, -6, -2,
      -3, -2, -1, -3, 1,
      5, 2, 3, 6, 3,
      4, 6, 3, 3, 1,
      2, 2, -1, -3, -3,
      -3, -5, -5, -6, -8,
      -9, -10, -10, -9, -11,
      -12, -10, -9, -9, -9,
      -10, -7, -7, -7, -4,
      -3, -5, -3, 0, -1,
      -2, 0, 1, 0, 1,
      2, 1, 0, 1, 2,
      0, -1, 0, 0, -2,
      -2, -2, -5, -4, -3,
      -4, -5, -6, -6, -5,
      -7, -7, -6, -6, -8,
      -6, -4, -6, -7, -6,
      -3, -5, -7, -4, -2,
      -5, -3, -1, -2, -4,
      -1, -1, -5, -5, -1,
      -3, -5, -3, -2, -4,
      -5, -2, -4, -5, -4,
      -5, -5, -6, -6, -5,
      -4, -4, -6, -5, -3,
      -7, -7, -2, 0, 0,
      -1, -1, 3, 8, 3,
      -6, -7, -7, -6, -4,
      -3, -3, -2, -2, -3,
      -3, -2, -2, -1, 0,
      0, 0, 0, 0, 3,
      8, 5, -5, -11, -11,
      -8, -5, 0, 3, 3,
      0, -5, -6, -6, -5,
      -2, 2, 9, 12, 4,
      -6, -12, -13, -10, -3,
      2, 4, 1, -2, -4,
      -6, -7, -6, -1, 3,
      5, 6, 4, 0, -4,
      -5, -5, -4, -2, 0,
      1, 1, 1, -2, -5,
      -6, -7, -5, -2, 2,
      3, 2, 0, -3, -5,
      -6, -4, 0, 4, 6,
      4, 1, -3, -5, -6,
      -4, -1, 0, 1, 1,
      -1, -4, -6, -5, -3,
      0, 1, 1, 0, -2,
      -4, -3, -3, -2, -1,
      -1, 0, 0, -2, -4,
      -4, -3, -2, -2, -2,
      -1, -1, -1, -3, -4,
      -5, -3, -1, 0, 0,
      -1, -2, -3, -3, -2,
      -2, -2, -1, -1, -2,
      -3, -4, -4, -3, -2,
      -1, 0, 0, -1, -3,
      -3, -3, -3, -2, -1,
      -1, -1, -2, -3, -3,
      -4, -3, -2, 0, 0,
      -1, -2, -2, -3, -4,
      -3, -3, -2, -1, -1,
      -2, -2, -3, -4, -4,
      -3, -2, -1, -1, -1,
      -2, -3, -4, -3, -1,
      0, 0, -1, -2, -3,
      -4, -4, -4, -3, -2,
      -1, -1, -1, -1, -2,
      -1, 0, 0, -4, 0,
      14, 16, -7, -17, -14,
      -10, -6, -13, -16, -12,
      -8, -2, -1, 0, 0,
      -2, -3, -3, -2, -1,
      -2, -2, -2, -3, -3,
      -3, 0, 15, 28, -1,
      -32, -24, -12, -6, -5,
      -1, 10, -6, -29, -10,
      4, -8, -19, -26, -18,
      -4, 3, 6, 4, 1,
      -4, -6, 1, 8, 7,
      0, -8, -11, -6, -3,
      -4, -9, -11, -9, -8,
      -6, -2, -4, -7, -8,
      -6, -2, 0, -1, -4,
      -7, -4, 9, 22, 12,
      -10, -10, -8, -13, -15,
      -13, -13, -16, -12, -1,
      6, 6, -2, -7, 8,
      16, 7, 0, -4, -7,
      -8, -8, -6, -10, -14,
      -15, -13, -6, 0, -1,
      -7, -11, -6, 1, 3,
      -3, -9, -8, -5, -1,
      2, 2, -1, -2, -4,
      -6, -4, -3, -7, -12,
      -11, -7, -5, -5, -6,
      -6, -5, -5, -3, -1,
      -1, -5, -8, -9, -5,
      -1, -3, -6, -9, -7,
      -3, -1, 0, -1, -3,
      -5, -4, -3, -3, -4,
      -5, -5, -5, -4, -4,
      -5, -6, -6, -8, -7,
      -6, -8, -8, -5, -4,
      -2, -3, -4, -4, -4,
      -5, -4, -4, -5, -6,
      -7, -6, -3, -2, -3,
      -7, -9, -6, -3, -3,
      -6, -7, -7, -5, -2,
      -2, -3, -5, -6, -8,
      -7, -3, -2, -6, -8,
      -8, -7, -3, -3, -5,
      -6, -6, -6, -6, -6,
      -6, -6, -6, -6, -6,
      0, 0, 0, -5, -5,
      -5, -5, -5, -5, -5,
      -5, -5, -4, -4, -4,
      -4, -4, -4, -4, -4,
      -4, -4, 0, 0, -3,
      -2, -2, -2, 2, 15,
      15, -9, -28, -29, -14,
      6, 11, 3, -11, -17,
      -8, 5, 13, 8, -3,
      -10, -9, 0, 5, 4,
      -3, -10, -10, -5, 1,
      2, -2, -7, -8, -5,
      -1, 1, -2, -5, -6,
      -4, -1, -1, -3, -5,
      -6, -3, -1, 0, -2,
      -4, -4, -3, -1, -1,
      -2, -3, -5, -4, -3,
      -2, -2, -3, -5, -6,
      -4, -2, -1, -2, -4,
      -5, -4, -2, -2, -3,
      -5, -5, -4, -2, 0,
      7, 15, 7, -12, -25,
      -23, -9, 2, 0, -9,
      -14, -6, 17, 31, 15,
      -5, -14, -13, -8, -9,
      -12, -12, -9, -2, 1,
      1, 0, -1, -1, -1,
      -1, -2, -2, -3, -5,
      -5, -3, -1, -1, -5,
      -8, -6, -3, 0, 0,
      1, 2, -7, -11, -6,
      0, 3, -1, -7, -9,
      -7, -2, -1, -2, -5,
      -6, -6, -2, 0, -1,
      -3, -6, -6, -3, 1,
      0, -4, -8, -7, -2,
      1, -1, -7, -9, -5,
      0, 0, -3, -7, -6,
      -2, -1, -2, -4, -5,
      -4, -3, -2, -3, -4,
      -4, -4, -3, -3, -3,
      -2, -2, -2, -1, 6,
      5, -9, -19, -14, -2,
      2, -6, -13, -11, -2,
      5, 3, -5, -7, -3,
      2, 3, -1, -5, -6,
      -6, -5, -3, -2, -3,
      -4, -4, -4, -3, -2,
      -3, -4, -3, 4, 11,
      6, -7, -14, -11, -4,
      -4, -11, -13, -5, 13,
      23, 7, -17, -20, -7,
      3, -1, -14, -17, -11,
      -3, -1, -6, -9, -5,
      1, 8, 8, -2, -7,
      -4, -1, -1, -5, -8,
      -7, -7, -6, -3, -1,
      -2, -6, -8, -6, 0,
      2, -4, -11, -11, -3,
      5, 3, -7, -12, -5,
      6, 8, -1, -9, -7,
      1, 6, 1, -9, -11,
      -6, 0, -1, -6, -9,
      -7, -4, -1, -1, -3,
      -4, -2, -2, -2, -2,
      -2, -3, -4, -5, -4,
      -1, -1, -4, -6, -4,
      -1, -2, -5, -6, -5,
      -3, -2, -2, -5, -6,
      -4, -1, -1, -4, -6,
      -5, -4, -2, -2, -6,
      -7, -4, -2, -3, -5,
      -6, -4, -2, -3, -4,
      -4, -5, -5, -5, -5,
      -3, -2, -3, -4, -5,
      -3, -2, -4, -7, -4,
      -2, -2, -4, -7, -6,
      -2, -2, -5, -5, -5,
      -5, -5, -5, -3, -3,
      -4, -4, -3, -3, -4,
      -4, -3, -1, -3, -5,
      -4, -3, -3, -4, -4,
      -4, -4, -3, -4, -3,
      -3, -5, -6, -5, -3,
      -1, -3, -6, -5, -2,
      0, -1, -5, -7, -4,
      -1, 0, -3, -6, -5,
      -2, 1, 0, -5, -6,
      -4, -1, 0, -4, -6,
      -4, -1, -1, -2, -3,
      -3, -1, -2, -4, -4,
      -3, -1, -2, -5, -7,
      -4, -1, 0, -4, -9,
      -8, -3, 0, -1, -8,
      -12, -8, -2, -1, -6,
      -9, -8, -5, -4, -4,
      -6, -7, -5, -4, -4,
      -4, -4, -5, -5, -5,
      0, 0, -2, 1, 10,
      7, -10, -13, -3, 0,
      -2, -7, -9, -6, -1,
      0, 1, 5, 3, -7,
      -7, 0, 3, 3, -6,
      -16, -11, 0, 0, -6,
      -9, -5, 0, 2, 0,
      -3, 2, 10, 0, -13,
      -4, 6, 1, -8, -14,
      -8, 5, 2, -13, -15,
      -3, -1, -6, -7, -5,
      2, 5, -6, -9, 3,
      9, -3, -13, -7, 5,
      8, -2, -14, -7, 9,
      7, -8, -12, -4, 5,
      5, -6, -10, 0, 3,
      -6, -9, -3, 2, -1,
      -9, -10, 0, 7, 1,
      -6, -2, 5, 4, -7,
      -13, -6, 5, 1, -9,
      -7, 5, 6, -1, -6,
      -6, -4, -7, -10, -4,
      2, 2, -1, -2, 0,
      1, -3, -7, -5, 0,
      -2, -6, -4, -1, -2,
      -2, -3, -5, -6, -4,
      -1, 1, 0, -3, -2,
      0, -4, -5, -2, -5,
      -8, -4, 0, -1, -3,
      -5, -5, -1, -2, -8,
      -6, -1, -1, -4, -4,
      -4, -3, 0, 0, -2,
      0, -2, -5, -3, -3,
      -6, -5, -3, -3, -3,
      -3, -5, -3, -2, -8,
      -7, 1, -1, -6, -3,
      0, -1, -3, -5, -6,
      -2, -2, -6, -3, 2,
      -2, -4, 0, -1, -5,
      -5, -5, -3, 0, -2,
      -3, 1, 1, -2, 1,
      2, -1, -1, 0, -1,
      1, 1, -1, 0, 1,
      0, -1, -2, -4, -3,
      -3, -5, -6, -4, -5,
      -6, -6, -7, -7, -7,
      -7, -6, -5, -6, -6,
      -3, -3, -4, -5, -4,
      -3, -3, -3, -3, -2,
      -2, -3, 0, 0, -4,
      -3, 6, 19, -4, -25,
      -9, -10, -14, -5, -8,
      -7, -6, -3, -1, -7,
      -6, -2, 0, -2, -6,
      -3, 1, -4, -4, 2,
      10, 7, -7, -9, -13,
      -18, -11, 2, 8, -9,
      -12, -2, -9, -12, -8,
      -2, -1, -6, 1, 4,
      -5, -7, -4, -3, -10,
      -11, -2, 1, -4, -3,
      1, 2, -3, -3, 1,
      -1, -7, -6, -2, -6,
      -9, -7, -4, -4, -6,
      -5, -2, -5, -7, -4,
      -1, -4, -3, 6, 14,
      5, -9, -8, -11, -17,
      -10, -7, -9, -8, -2,
      0, -5, -6, -1, 1,
      -1, -4, -3, 0, -5,
      -8, -3, -2, -7, -8,
      -3, -3, -7, -5, -3,
      -5, -5, -3, -3, -6,
      -8, -1, -3, -6, -3,
      -4, -4, -5, -4, -2,
      -4, -4, -2, -2, -5,
      -6, -5, -7, -5, -2,
      -2, -5, -6, -3, -4,
      -6, -1, -4, -4, -5,
      -6, -3, -6, -6, -3,
      -5, -4, -3, -6, -5,
      -3, -3, -6, -6, 0,
      -2, -6, -3, -1, -8,
      -6, 1, -4, -7, -5,
      -3, -4, -5, -3, -2,
      -3, -4, -5, -2, -4,
      -8, -4, -2, -5, -7,
      -5, -1, -2, -8, -6,
      -1, -3, -8, -5, -3,
      -6, -6, -5, -3, -4,
      -7, -4, -1, -4, -9,
      -3, -1, -4, -5, -7,
      -3, -4, -10, -3, -2,
      -5, -2, -3, -3, -7,
      -7, -3, -5, -3, -5,
      -8, 0, 0, -6, -4,
      -4, -4, -4, -8, -5,
      -1, -8, -5, 1, -3,
      -7, -4, 0, -5, -8,
      -1, -1, -7, -5, -5,
      -6, -5, -7, -5, 0,
      -2, -6, -5, -4, -6,
      -7, -3, -4, -4, -3,
      -9, -2, 2, -8, -5,
      -1, -2, -4, -9, -2,
      -2, -11, -1, 3, -3,
      -7, -7, -1, -4, -9,
      -3, 0, -4, -6, -5,
      -5, -4, -6, -5, 1,
      -7, -10, 3, -2, -12,
      -5, 0, -3, -7, -8,
      -1, 1, -10, -8, 0,
      -5, -5, -2, -7, -6,
      -7, -4, -1, -4, -3,
      -7, -1, 1, -10, -7,
      -4, 0, -3, -10, -1,
      -4, -11, -4, -1, -2,
      -7, -5, -1, -5, -7,
      -8, -2, -3, -7, -4,
      -2, -3, -9, -5, 0,
      -2, -7, -6, -1, -4,
      -3, -6, -6, -2, -9,
      -4, 0, -8, -5, -1,
      -7, -3, 0, -12, -2,
      3, -11, 0, 2, -6,
      -4, -4, -4, -5, -6,
      -9, 3, -1, -14, 2,
      -1, -8, -6, -8, 3,
      -7, -17, 2, 6, -9,
      -10, 2, -1, -8, -7,
      -4, 3, -9, -10, 10,
      -4, -17, -3, 2, -4,
      -12, -6, 5, -9, -15,
      0, 0, -10, -11, 0,
      3, -6, -13, -2, 6,
      -13, -6, 4, -5, -10,
      -7, 4, -4, -10, -1,
      -2, -2, -9, -6, -2,
      -10, -6, 2, 0, -11,
      -2, 3, -10, -2, -3,
      -8, 0, -9, -6, 2,
      -10, -5, -1, -7, -1,
      -3, -11, -1, 4, -8,
      -6, -1, -5, -2, -7,
      -6, 4, -10, -11, 1,
      0, -4, -12, -2, 6,
      -9, -10, -1, 0, -4,
      -11, -3, 5, -11, -14,
      6, 2, -11, -9, -3,
      1, -6, 0, 0, -1,
      -2, -3, -4, -2, 1,
      12, 10, -19, -11, 10,
      -12, -18, 1, -2, -14,
      -7, 2, -5, -9, 2,
      2, -8, -4, 4, -3,
      -6, 1, 0, -2, 1,
      -1, -2, 1, 0, -2,
      -1, -1, -2, -5, -6,
      -3, -6, -9, -6, -5,
      -8, -7, -8, -7, -1,
      -1, 4, 11, -8, -11,
      8, -2, -13, -1, -1,
      -10, -13, -8, 8, 25,
      4, -16, 6, 7, -8,
      -6, -5, -8, -7, -5,
      -5, -9, -6, 0, -5,
      -4, 5, -1, -5, 2,
      -4, -11, -4, -4, -8,
      -5, -6, -5, -1, -4,
      -2, 1, -1, 0, -1,
      -4, -1, -3, -6, -1,
      -3, -5, -3, -3, -4,
      -2, -4, -5, 0, -3,
      -9, -7, -6, -9, -3,
      6, -4, -11, 0, -1,
      -8, 1, 2, -7, -6,
      3, 1, -4, 0, 1,
      0, 11, 9, -10, -8,
      2, -9, -15, -5, -7,
      -11, -5, -6, -9, -5,
      -3, -3, -5, -2, -1,
      -5, -1, 1, -4, -1,
      0, -3, -3, -1, -4,
      -2, -1, -4, -5, -4,
      -4, -4, -3, -3, -5,
      -5, -4, -6, -5, -4,
      -6, -4, -2, -4, -5,
      -3, -1, -3, -4, -1,
      -2, -4, -2, -1, -4,
      -4, -1, -3, -3, -1,
      -3, -3, -2, -4, -4,
      -4, -4, -5, -6, -2,
      -5, -7, -2, -3, -5,
      -3, -4, -4, -2, -5,
      -5, 1, -3, -5, 0,
      -1, -5, -4, -1, -2,
      -4, 0, 0, -6, -2,
      0, -7, -4, 0, -6,
      -6, -2, -5, -5, -1,
      -4, -5, -2, -2, -4,
      -6, -4, -2, -5, -4,
      1, -4, -5, -2, -4,
      -2, 0, -6, -4, 1,
      -7, -6, 2, -5, -7,
      -2, -4, -8, -3, 0,
      -7, -5, 2, -5, -8,
      0, -2, -7, -2, 0,
      -7, -3, 2, -6, -7,
      0, -4, -6, -2, 0,
      -2, -6, -2, -2, -4,
      -3, -2, -3, -3, -2,
      -3, -3, -3, -4, -5,
      -3, -3, -3, -3, -5,
      -2, -3, -5, -2, -3,
      -7, -3, 0, -4, -3,
      -2, -4, -5, -3, 0,
      -4, -6, 0, 0, -5,
      -5, -4, -3, -4, -4,
      -3, -3, -1, -3, -4,
      -3, 0, -3, -4, -1,
      -3, -6, -3, -3, -6,
      -5, -3, -3, -4, -3,
      -2, -4, -4, -3, -5,
      -3, -4, -8, -2, -1,
      -6, -5, -2, -2, -5,
      -4, -2, -5, -7, -2,
      0, -4, -3, -2, -3,
      -1, -3, -6, 0, -1,
      -7, 0, 2, -8, -8,
      2, -1, -9, -3, 0,
      -6, -6, 0, -4, -8,
      0, 0, -7, -3, -3,
      -5, -2, -2, -6, -5,
      -1, -4, -5, -4, -2,
      -4, -3, 0, -4, -3,
      0, 0, 0, -3, -3,
      -4, -5, -4, -3, -3,
      -2, -2, -5, -7, -8,
      -7, -5, -5, -5, -5,
      -5, -5, -5, -5, -5,
      -5, -5, -4, -4, -4,
      -3, -3, -3, -3, -3,
      -3, -3, -3, -2, 0,
      -1, -2, -5, -6, -4,
      -3, -1, 0, -1, -2,
      -4, -5, -5, -5, -4,
      -3, -3, -5, -6, -5,
      -7, -7, -6, -4, -2,
      -2, -4, -8, -9, -8,
      -6, -3, -2, -3, -3,
      -2, 0, -2, -5, -4,
      -2, -2, -4, -6, -5,
      -4, -3, -3, -3, -5,
      -8, -9, -10, -8, -7,
      -6, -6, -6, -6, -6,
      -6, -5, -3, -2, -3,
      -4, -4, -2, 0, 3,
      7, 10, 12, 13, 12,
      9, 7, 6, 4, 1,
      -2, -5, -8, -10, -13,
      -16, -18, -19, -18, -17,
      -16, -15, -11, -8, -5,
      -3, -1, 0, 1, 2,
      3, 4, 4, 4, 4,
      2, 0, -3, -5, -6,
      -8, -8, -9, -8, -7,
      -6, -6, -6, -5, -4,
      -2, 0, 2, 4, 5,
      4, 2, 0, -2, -4,
      -7, -8, -9, -9, -8,
      -8, -9, -10, -10, -10,
      -9, -8, -6, -4, -2,
      -2, -2, 0, 0, -3,
      4, 16, 6, -16, -17,
      -9, 0, 0, -17, -25,
      -20, -15, -7, -2, -1,
      -6, -5, 4, 17, 22,
      8, -2, -1, -3, -6,
      -6, -4, -6, -9, -6,
      4, 9, 1, -5, -5,
      -6, -9, -11, -9, -9,
      -9, -9, -7, -2, 0,
      0, 1, 3, 4, 4,
      4, 4, 6, 4, 2,
      1, 1, 1, -1, -3,
      -3, -3, -5, -7, -8,
      -7, -7, -8, -9, -8,
      -6, -6, -6, -5, -4,
      -4, -5, -4, -2, -1,
      -2, -2, -1, 0, -1,
      -2, -1, -1, -2, -3,
      -2, -1, -2, -3, -3,
      -2, -3, -4, -4, -4,
      -5, -7, -5, -2, -3,
      -6, -7, -5, -4, -4,
      -5, -4, -4, -6, -6,
      -5, -4, -3, -5, -5,
      -3, -1, -2, -2, -1,
      -3, -8, -8, -6, -4,
      -4, -5, -5, -5, -5,
      -4, -4, -4, -4, -6,
      -7, -5, -6, -8, -6,
      -3, -4, -6, -6, -4,
      -3, -4, 0, 0, -1,
      -1, -1, 2, 13, 17,
      4, -12, -25, -29, -20,
      -7, 8, 21, 22, 6,
      -13, -25, -24, -10, 4,
      13, 10, 0, -10, -15,
      -10, 0, 10, 13, 7,
      -2, -11, -11, -5, 3,
      9, 8, 2, -5, -9,
      -7, -1, 5, 8, 5,
      0, -6, -8, -6, -1,
      3, 3, -1, -6, -9,
      -9, -6, -2, 0, -2,
      -5, -8, -9, -8, -4,
      -1, 0, -2, -4, -4,
      -1, 1, -3, -6, -7,
      -5, -1, 2, 2, 1,
      -1, -2, -2, -1, 0,
      0, 0, -2, -3, -3,
      -3, -2, -2, -3, -4,
      -4, -4, -3, -3, -3,
      -4, -5, -5, -6, -5,
      -3, -3, -4, -4, -5,
      -5, -4, -3, -2, -1,
      -2, -3, -5, -5, -3,
      0, 1, 2, 4, 5,
      6, 9, 3, -10, -21,
      -27, -21, -11, -2, 2,
      -2, -9, -13, -11, -4,
      6, 11, 8, 1, -7,
      -9, -5, 0, 3, 1,
      -3, -8, -11, -10, -5,
      3, 8, 9, 6, 2,
      0, 3, 9, 12, 11,
      6, 1, -2, -1, 0,
      0, -3, -7, -12, -14,
      -9, -6, -11, -16, -21,
      -20, -15, -9, -4, -1,
      -3, -5, -5, -2, 3,
      8, 8, 5, 1, -1,
      1, 4, 6, 5, 1,
      -2, -3, -4, -3, -1,
      0, -2, -5, -8, -8,
      -6, -5, -5, -6, -7,
      -6, -6, -5, -4, -3,
      -2, -3, -4, -4, -3,
      -2, -1, -1, -3, -4,
      -3, -3, -3, -4, -5,
      -5, -5, -6, -6, -6,
      -6, -5, -4, -4, -3,
      -4, -5, -5, -4, -3,
      -2, 0, 0, -9, -7,
      -4, -3, -4, -4, -4,
      -4, -4, -3, -3, -1,
      0, 0, -2, -6, -8,
      -6, -2, 0, 0, -1,
      -3, -4, -4, -4, -3,
      -3, -4, -4, -4, -4,
      -4, -4, -5, -5, -5,
      -4, -6, -8, -8, -7,
      -7, -6, -5, -5, -6,
      -6, -6, -5, -5, -5,
      -4, -5, -6, -5, -5,
      -5, -4, -1, -1, -2,
      -4, -6, -6, -5, -3,
      -2, -3, -4, -6, -6,
      -4, -4, -5, -5, -6,
      -5, -4, -4, -4, -4,
      -5, -5, -4, -4, -4,
      -3, -2, 1, 4, 7,
      6, 3, 2, 1, -1,
      -2, -4, -5, -5, -5,
      -5, -6, -7, -8, -10,
      -11, -11, -11, -10, -9,
      -8, -6, -4, -4, -3,
      -4, -6, -6, -5, -4,
      -3, -3, -4, -3, -3,
      -3, -2, -1, -1, -3,
      -3, -3, -4, -4, -3,
      -2, -1, 0, 0, 0,
      0, 0, -1, -3, -4,
      -5, -7, -8, -9, -10,
      -10, -10, -9, -8, -8,
      -8, -9, -9, -9, -8,
      -8, -6, -4, -3, -3,
      -3, -3, -3, -2, -3,
      -5, -6, -7, -8, -8,
      -7, -6, -6, -7, -7,
      -8, -8, -5, -4, -5,
      -7, -7, -5, -2, 0,
      0, 0, 8, 12, -7,
      -15, 11, 18, -7, -13,
      -8, -16, -15, -8, -10,
      -7, -5, -8, -4, 1,
      -1, -1, 1, -1, -2,
      -1, 0, 1, 2, 1,
      0, -1, -2, 0, 0,
      -1, 0, 1, -3, -3,
      -2, -2, -1, -1, -3,
      -4, -4, -4, -4, -4,
      -1, 5, 3, -5, -5,
      -3, -6, -5, -2, -4,
      -6, -7, -8, -6, -5,
      -4, -2, 0, -1, -3,
      -4, -3, -1, 1, 0,
      -3, -6, -6, -3, -1,
      2, 3, -4, -7, -2,
      -2, -1, 0, -5, -6,
      -4, -5, -4, -2, -3,
      -5, -5, -6, -7, -7,
      -3, 1, 8, 12, 12,
      7, 3, 5, 7, 10,
      10, 7, 5, 1, -4,
      -4, -3, -3, -5, -10,
      -14, -14, -15, -14, -12,
      -11, -10, -9, -10, -9,
      -5, -2, 0, 1, 1,
      1, 0, 0, 2, 5,
      6, 5, 2, 1, 1,
      1, 1, 2, 2, 0,
      0, 0, -1, 0, 3,
      2, -1, -4, -7, -8,
      -9, -7, -5, -2, 1,
      3, 3, 2, 0, -3,
      -6, -7, -8, -7, -6,
      -4, -1, 0, 1, 1,
      0, -2, -3, -4, -4,
      -4, -3, -2, 0, 1,
      2, 2, 1, 0, -1,
      -2, -3, -3, -3, -2,
      -2, -2, -3, -3, -3,
      -3, -3, -3, -4, -2,
      3, 4, 2, -1, -8,
      -14, -19, -20, -17, -11,
      -3, 3, 8, 11, 10,
      6, 0, -5, -9, -11,
      -10, -7, -3, 1, 5,
      6, 6, 4, 1, -2,
      -4, -6, -6, -6, -4,
      -2, -1, 0, 1, 8,
      6, 3, -4, -13, -19,
      -23, -21, -15, -7, 1,
      7, 11, 11, 8, 3,
      -3, -8, -11, -11, -8,
      -4, 0, 3, 5, 5,
      5, 3, -1, -5, -7,
      -8, -7, -5, -3, 0,
      5, 6, 3, -1, -7,
      -10, -10, -7, -4, -2,
      0, 0, -1, -3, -5,
      -6, -7, -6, -4, -2,
      0, 1, 1, 1, 1,
      0, 0, 0, 0, 2,
      2, 3, 3, 2, 1,
      0, -2, -4, -5, -6,
      -5, -5, -6, -6, -6,
      -5, -3, -3, -4, -4,
      -6, -7, -9, -9, -5,
      -1, 2, 3, 2, -1,
      -5, -8, -11, -11, -9,
      -7, -4, -1, 1, 2,
      1, 0, -2, -3, -3,
      -2, 0, 2, 3, 3,
      3, 2, 0, -2, -4,
      -5, -6, -6, -6, -5,
      -5, -6, -6, -7, -7,
      -7, -6, -6, -5, -4,
      -2, -2, -3, -4, -5,
      -5, -3, -2, 0, 2,
      3, 4, 3, 1, -1,
      -3, -6, -9, -13, -15,
      -15, -8, 5, 17, 23,
      23, 15, 2, -12, -24,
      -29, -27, -19, -9, 0,
      0, -2, -2, -2, -1,
      -1, 3, 12, 7, -9,
      -12, -9, -7, -5, -3,
      -2, -1, -1, -1, -1,
      -1, -1, -1, -1, -1,
      0, 1, 3, 6, 7,
      3, -4, -9, -11, -10,
      -7, -4, 0, 2, 0,
      -2, -2, 0, 3, 3,
      -1, -4, -5, -5, -4,
      -2, 0, -1, -3, -4,
      -4, -5, -5, -4, -3,
      -2, 0, 3, 3, 1,
      1, -1, -3, -3, -2,
      -3, -4, -5, -5, -5,
      -4, -3, -3, -2, 0,
      1, 1, 0, 0, 0,
      0, -1, -1, -2, -1,
      -1, -1, -2, -3, -3,
      -3, -3, -2, -2, -3,
      -4, -3, -2, -1, -2,
      -2, -1, 0, 0, -1,
      -1, -1, -1, -2, -2,
      -2, -2, -3, -3, -3,
      -2, -1, -1, -1, -1,
      -1, -2, -2, -2, -3,
      -3, -2, -1, -1, 0,
      -1, -3, -3, -3, -3,
      -2, -2, -1, -2, -2,
      -2, -2, -1, -2, -3,
      -3, -4, -4, -3, -3,
      -3, -2, -2, -2, -2,
      -2, -3, -4, -4, -4,
      -4, -4, -3, -3, -2,
      -2, -2, -1, -2, -3,
      -4, -5, -5, -4, -4,
      -4, -3, -3, -3, -3,
      -3, -2, -2, -2, -2,
      -2, -2, -2, -1, -1,
      -1, -1, -1, -1, -1,
      0, 0, -3, 1, 18,
      18, -20, -22, 2, -8,
      -11, -6, -10, -4, -2,
      -2, 1, 1, 0, -1,
      -2, -3, -5, -14, -18,
      -7, -4, -4, 6, 6,
      -1, -3, -1, -2, -1,
      1, -3, -7, -9, -7,
      -2, 2, 2, -2, -3,
      -4, -7, -7, -4, 0,
      0, -5, -7, -8, -6,
      -5, -5, -2, -1, -1,
      -1, -4, -5, -1, 8,
      25, 17, -15, -22, -12,
      -12, -15, -17, -15, -12,
      -11, -2, 13, 11, 1,
      4, 5, 4, 2, -1,
      -1, -1, 0, -2, -7,
      -8, -8, -8, -10, -13,
      -12, -7, -5, -6, -6,
      -6, 5, 14, 7, 5,
      4, -2, -4, -10, -14,
      -12, -14, -16, -13, -7,
      -3, -1, 3, 7, 10,
      12, 8, 3, 0, 0,
      -3, -7, -8, -8, -9,
      -10, -8, -5, -2, -3,
      -5, -7, -6, -2, 0,
      2, 3, 2, 0, -4,
      -6, -4, -2, -3, -5,
      -3, -2, -1, -1, -3,
      -3, -4, -5, -6, -7,
      -7, -5, -4, -3, -2,
      -1, -3, -3, -2, -2,
      -3, -4, -5, -6, -5,
      -5, -5, -5, -5, -4,
      -3, -4, -4, -3, -3,
      -3, -2, -4, -5, -6,
      -7, -8, -7, -6, -4,
      -2, -2, -4, -4, -5,
      -7, -7, -5, -5, -7,
      -8, -6, -2, -1, -1,
      -3, -4, -5, -7, -9,
      -7, -5, -5, -6, -5,
      -5, -7, -6, -5, -4,
      -3, -2, -1, 0, -2,
      -3, -3, -3, -1, 5,
      11, 5, -8, -20, -26,
      -19, -4, 15, 29, 26,
      8, -16, -32, -31, -16,
      3, 16, 19, 12, -1,
      -11, -13, -7, 6, 17,
      22, 15, -2, -19, -26,
      -20, -4, 11, 19, 16,
      4, -9, -16, -14, -4,
      6, 13, 11, 4, -5,
      -11, -11, -5, 3, 8,
      8, 4, -3, -8, -8,
      -4, 1, 4, 4, 0,
      -4, -7, -7, -6, -2,
      1, 2, -1, -4, -6,
      -5, -4, -2, 0, 0,
      -1, -3, -4, -4, -4,
      -3, -2, 3, 5, 2,
      -1, -6, -9, -9, -6,
      -3, -1, -1, -3, -5,
      -6, -5, -3, 0, 1,
      1, -1, -3, 0, 5,
      7, 3, -4, -11, -15,
      -14, -9, -1, 2, 2,
      -3, -8, -10, -8, -3,
      0, 1, -1, -3, -3,
      -1, -1, -4, -7, -10,
      -10, -8, -4, 0, 3,
      4, 6, 10, 8, 3,
      -2, -7, -10, -13, -13,
      -11, -9, -7, -5, -3,
      0, 1, 1, -1, -2,
      -1, 3, 3, 0, -5,
      -8, -8, -7, -5, -4,
      -3, -3, -4, -6, -6,
      -4, -1, -1, -2, -4,
      -3, -2, 0, 0, -2,
      -4, -5, -4, -4, -3,
      -2, -2, -2, -4, -7,
      -6, -4, -2, 0, -1,
      -3, -4, -5, -5, -4,
      -1, 1, 1, -1, -5,
      -8, -6, -3, -1, -2,
      -2, -4, -4, -5, -5,
      -3, 1, 7, 5, -5,
      -13, -14, -7, 1, 5,
      4, -1, -9, -13, -13,
      -6, 3, 7, 3, -5,
      -11, -11, -6, 1, 6,
      5, 0, -6, -10, -10,
      -7, -2, 4, 7, 4,
      -2, -6, -7, -4, -1,
      0, -1, -4, -9, -12,
      -11, -6, -1, 3, 2,
      -1, -4, -5, -3, 1,
      3, 2, -1, -4, -7,
      -8, -6, -2, 0, 2,
      0, -6, -13, -13, -9,
      -2, 3, 5, 4, 0,
      -5, -8, -8, -5, 0,
      1, -1, -3, -6, -5,
      -3, -2, 0, 0, 0,
      -1, 1, 2, 0, -2,
      -6, -8, -9, -8, -6,
      -3, -2, -4, -7, -8,
      -7, -4, 0, 1, 0,
      -1, -2, -3, -3, -1,
      1, 1, 0, -2, -6,
      -6, -4, -2, -2, -3,
      -5, -6, -5, -3, -1,
      0, 0, -2, -4, -4,
      -3, -1, 0, 1, -1,
      -4, -5, -4, -3, -2,
      -2, -3, -4, -4, -4,
      -3, -2, -2, 0, 0,
      -2, -2, 5, 15, 9,
      -4, -10, -13, -16, -16,
      -13, -7, -1, 3, 3,
      1, -1, -2, -3, -3,
      -2, -2, -1, 0, 1,
      1, 1, 1, 1, 0,
      -1, -2, -3, -4, -4,
      -5, -5, -5, -4, -3,
      -3, -3, -3, -2, -1,
      -1, -1, -1, -2, -3,
      -3, -3, -2, -2, -3,
      -2, -1, -1, -2, -1,
      0, 0, -2, -4, -4,
      -3, -3, -4, -4, -4,
      -4, -3, -2, -2, -3,
      -4, -5, -5, -4, -2,
      0, 0, -1, -3, -4,
      -3, -3, -3, -3, -3,
      -3, -2, 0, -1, -2,
      -2, -3, -4, -5, -5,
      -5, -5, -5, -3, -1,
      0, 0, 0, -1, -1,
      -2, -3, -4, -3, -2,
      -2, -2, -2, 0, 0,
      -1, -3, -4, -3, -4,
      -5, -5, -5, -3, -2,
      -1, 0, -1, -2, -3,
      -3, -3, -3, -4, -3,
      -1, 0, 0, -1, -1,
      -2, -3, -4, -4, -3,
      -2, -2, -2, -2, -2,
      -2, -2, -3, -4, -4,
      -4, -4, -2, -2, -2,
      -2, -3, -2, -1, -1,
      -2, -3, -4, -4, -4,
      -4, -4, -4, -4, -3,
      -2, -2, -2, -2, -1,
      -2, -3, -4, -5, -5,
      -5, -4, -4, -3, -2,
      -1, 0, 0, -1, -2,
      -4, -5, -4, -4, -3,
      -3, -3, -2, -2, -2,
      -2, -2, -2, -2, -2,
      -2, -3, -3, -3, -2,
      -2, -2, -2, -2, -2,
      -2, -2, -2, -2, -2,
      -3, -3, -3, -2, -2,
      -1, -2, -2, -2, -2,
      -3, -3, -2, -1, -1,
      0, -1, -1, -2, -3,
      -3, -3, -3, -3, -3,
      -2, -2, -3, -2, -2,
      -2, -2, -2, -2, -2,
      -3, -4, -5, -5, -5,
      -5, -3, -3, -2, -2,
      -2, -2, -3, -4, -4,
      -5, -5, -4, -4, -3,
      -2, -1, -2, -2, -3,
      -4, -4, -4, -4, -5,
      -5, -5, -3, -2, -1,
      0, 0, 0, 0, -1,
      9, 25, 8, -25, -17,
      1, -5, -6, -4, -9,
      -7, -3, -2, 3, 5,
      1, -1, -2, -3, -2,
      1, 2, 2, 1, -1,
      -4, -3, 1, 10, 10,
      -6, -11, -6, -7, -4,
      -2, -6, -7, -5, -5,
      -2, 2, 5, 3, -5,
      -7, -4, -1, 0, 2,
      1, -1, -4, -5, -3,
      0, 2, 2, 5, 2,
      -9, -8, -4, -3, 0,
      -2, -6, -5, -6, -5,
      -1, 0, 0, 0, -1,
      -1, -3, -4, -3, -1,
      2, 2, -1, -2, -3,
      -4, -2, 0, 1, 0,
      -2, -4, -6, -4, -1,
      0, 1, 0, -2, -5,
      -6, -6, -5, -1, 2,
      1, 2, 1, -4, -5,
      -2, -1, 1, 1, -4,
      -6, -6, -7, -4, -2,
      0, 0, 0, 0, -2,
      -3, -3, -3, -2, -2,
      -1, -1, -2, -3, -4,
      -3, -1, 0, 0, -2,
      -5, -6, -2, 1, 2,
      1, -2, -3, -4, -4,
      -4, -2, -2, -2, -3,
      -4, -5, -5, -3, 1,
      3, 0, -3, -4, -4,
      -3, -1, 0, 1, 0,
      -2, -4, -4, -4, -2,
      -1, -2, -3, -4, -5,
      -2, 0, -1, -1, -3,
      -5, -5, -4, -2, -1,
      -1, -1, -2, -4, -4,
      -3, -1, 0, -1, -2,
      -3, -4, -4, -3, 0,
      0, -1, -2, -2, -2,
      -4, -3, -2, -1, 0,
      -2, -5, -6, -5, -3,
      0, 1, 2, 2, 0,
      -1, -1, 0, 2, 3,
      4, 4, 3, 1, 0,
      0, 1, 2, 0, 0,
      -5, -4, -2, 4, 7,
      1, -4, -12, -20, -21,
      -20, -14, -5, 2, 9,
      11, 10, 7, 3, -4,
      -12, -17, -20, -17, -12,
      -5, 3, 8, 10, 9,
      4, -2, -8, -11, -10,
      -5, -2, -1, -3, -8,
      -11, -14, -14, -10, -6,
      0, 4, 7, 6, 3,
      -4, -11, -17, -17, -10,
      1, 12, 15, 13, 8,
      3, 2, -2, -7, -11,
      -17, -20, -21, -20, -15,
      -10, -4, 0, 3, 6,
      6, 5, 1, -3, -6,
      -8, -8, -4, 2, 9,
      11, 11, 6, -3, -12,
      -20, -25, -25, -20, -11,
      -2, 7, 14, 15, 11,
      4, -6, -16, -24, -25,
      -19, -10, 0, 9, 13,
      12, 8, 0, -8, -13,
      -16, -14, -9, -3, 2,
      5, 5, 2, -3, -8,
      -11, -13, -11, -9, -5,
      -1, 4, 8, 7, 3,
      -3, -11, -16, -20, -19,
      -14, -8, -1, 3, 8,
      9, 6, 1, -4, -6,
      -6, -4, 0, 3, 5,
      5, 3, -1, -6, -11,
      -15, -16, -16, -14, -11,
      -7, -4, -2, -2, -2,
      -2, -3, -2, -1, 0,
      0, 1, 2, 2, 0,
      -3, -6, -8, -9, -10,
      -11, -9, -8, -6, -4,
      -4, -4, -5, -6, -7,
      -7, -4, -1, 0, 0,
      -1, -2, -4, -6, -7,
      -7, -7, -5, -4, -3,
      -2, -2, -2, -4, -5,
      -7, -7, -7, -6, -6,
      -6, -6, -6, -6, -5,
      -5, -4, -3, -2, -2,
      -3, -4, -5, -5, -5,
      -5, -6, -6, -6, -6,
      -5, -4, -3, -1, 0,
      0, -3, -6, -9, -10,
      -12, -11, -8, -5, -2,
      0, 1, 1, 1, -1,
      -3, -5, -6, -5, -4,
      -3, -3, -4, -5, -6,
      -7, -6, -6, -5, -5,
      -4, -4, -4, -3, -3,
      -3, -3, -5, -6, -6,
      -5, -5, -5, -2, 0,
      1, 1, 1, 0, -1,
      -4, -7, -9, -13, -15,
      -17, -17, -16, -12, -8,
      -2, 1, 4, 4, 2,
      -1, -5, -6, -6, -5,
      -2, 0, 3, 2, -1,
      -5, -8, -11, -12, -11,
      -9, -7, -4, -2, -2,
      -2, -3, -4, -4, -5,
      -5, -4, -4, -2, -2,
      -2, -3, -5, -6, -6,
      -6, -5, -5, -3, -2,
      -2, -2, -4, -6, -7,
      -6, -6, -4, -3, -2,
      -2, -2, -3, -3, -5,
      -6, -6, -5, -5, -5,
      -4, -3, -3, -3, -4,
      -6, -6, -6, -6, -5,
      -4, -4, -4, -4, -4,
      -5, -5, -4, -4, -3,
      -2, -2, -3, -5, -7,
      -8, -9, -9, 0, 0,
      -2, -2, -1, -1, -2,
      -2, -1, -2, -3, -4,
      -5, -6, -9, -10, -10,
      -11, -13, -15, -17, -17,
      -17, -17, -17, -18, -19,
      -19, -19, -18, -18, -18,
      -17, -16, -15, -15, -13,
      -12, -11, -10, -9, -7,
      -6, -7, -7, -7, -6,
      -5, -5, -5, -5, -5,
      -4, -2, -2, -2, -3,
      -4, -5, -5, -5, -6,
      -6, -6, -7, -8, -8,
      -8, -10, -12, -14, -15,
      -15, -15, -16, -17, -17,
      -16, -16, -16, -16, -16,
      -14, -13, -13, -12, -13,
      -13, -12, -11, -9, -9,
      -9, -9, -8, -7, -6,
      -5, -4, -3, -2, 0,
      0, -7, -10, -11, -12,
      -13, -17, -19, -18, -16,
      -16, -17, -18, -16, -14,
      -14, -12, -11, -9, -7,
      -5, -5, -5, -5, -4,
      -2, -2, -2, -3, -3,
      -3, -3, -5, -5, -5,
      -5, -5, -5, -8, -9,
      -8, -6, -5, -5, -6,
      -6, -5, -5, -5, -5,
      -5, -6, -7, -8, -8,
      -8, -9, -10, -10, -11,
      -13, -13, -11, -10, -11,
      -13, -13, -13, -12, -9,
      -8, -9, -9, -9, -7,
      -6, -6, -5, -6, -7,
      -6, -5, -4, -5, -5,
      -5, -4, -4, -4, -4,
      -3, -3, -3, -3, -2,
      -2, -2, -2, -2, -1,
      -1, 0, 2, 4, 4,
      4, 6, 7, 7, 5,
      3, 3, 3, 1, -2,
      -5, -7, -8, -10, -12,
      -14, -15, -16, -18, -18,
      -17, -16, -16, -17, -18,
      -19, -18, -14, -13, -12,
      -12, -11, -9, -7, -7,
      -8, -8, -7, -7, -6,
      -5, -6, -6, -6, -6,
      -6, -6, -5, -4, -4,
      -3, -3, -3, -3, -3,
      -3, -3, -3, -4, -5,
      -6, -6, -6, -7, -8,
      -9, -11, -12, -13, -14,
      -14, -15, -14, -14, -14,
      -13, -13, -12, -10, -9,
      -7, -6, -6, -6, -6,
      -5, -5, -4, -4, -4,
      -3, -3, -3, -2, -2,
      -1, -1, 0, 1, 3,
      6, 9, 9, 9, 8,
      7, 7, 6, 5, 4,
      1, -2, -5, -8, -10,
      -11, -13, -14, -16, -19,
      -19, -19, -18, -16, -14,
      -14, -13, -13, -12, -10,
      -8, -7, -6, -6, -7,
      -7, -7, -6, -6, -6,
      -7, -9, -11, -12, -12,
      -11, -10, -11, -11, -11,
      -9, -7, -5, -3, -1,
      0, 1, 2, 3, 4,
      4, 5, 3, 1, 0,
      -2, -3, -5, -7, -10,
      -12, -14, -14, -15, -15,
      -16, -17, -17, -16, -15,
      -13, -12, -12, -11, -9,
      -7, -5, -3, -3, -2,
      -2, -1, -1, -1, -1,
      -1, -3, 0, 0, 1,
      3, 4, 5, 5, 5,
      5, 4, 3, 2, 1,
      -1, -3, -5, -7, -9,
      -11, -13, -14, -16, -17,
      -18, -18, -18, -19, -19,
      -18, -17, -16, -15, -14,
      -12, -11, -9, -7, -5,
      -4, -3, -2, 0, 1,
      2, 2, 2, 2, 1,
      0, -1, -2, -2, -2,
      -3, -4, -4, -5, -6,
      -6, -7, -7, -9, -9,
      -9, -10, -10, -11, -10,
      -10, -10, -10, -10, -9,
      -9, -8, -8, -8, -8,
      -8, -8, -7, -7, -6,
      -6, -5, -5, -5, -5,
      -4, -5, -5, -5, -4,
      -4, -3, -3, -3, -2,
      -2, -2, -1, -1, 0,
      1, 0, 0, 1, 1,
      1, 0, 0, 0, -1,
      -3, -5, -8, -9, -9,
      -10, -12, -14, -14, -14,
      -15, -16, -18, -19, -19,
      -18, -17, -18, -18, -17,
      -15, -13, -12, -11, -9,
      -7, -7, -7, -7, -6,
      -6, -6, -6, -6, -4,
      -6, -7, -7, -7, -6,
      -6, -5, -5, -5, -5,
      -6, -5, -4, -4, -5,
      -6, -8, -7, -7, -8,
      -8, -7, -8, -11, -11,
      -12, -13, -13, -14, -14,
      -13, -13, -12, -12, -13,
      -13, -11, -9, -9, -8,
      -6, -5, -5, -5, -4,
      -2, -2, -3, -3, -2,
      -2, -2, -1, -1, 0,
      0, 0, 0, 0, 0,
      0, 0, 0, 0, 0,
      0, 0, 0, 0, 0,
      0, 0, 0, 0, 0,
      0, 0, 0, 0, 0,
      0, 0, 0, 0, 0,
      0, 0
    }
  };
