#! /usr/bin/env perl

# Test how DBSettings.pm handles different user names.

use strict;
use warnings;
use utf8;

use lib 'lib';
use RestfulDB::DBSettings qw(get_database_settings);

binmode( STDOUT, "utf8" );

my %env1 = (
    REQUEST_URI => "/~saulius/test/dbase/tbl",
);

my %env2 = (
    REQUEST_URI => '/~saulius/test/dbase.sqlite2/tbl?param1=1&param2=22',
);

my @cases = (
    { env => \%env1, cgi => {}, par => { db_dir => "./db" } },
    { env => \%env1, cgi => {}, par => { db_dir => "./db", level => 2 } },
    { env => \%env1, cgi => {}, par => { db_dir => "./db", level => 1 } },

    { env => \%env2, cgi => {}, par => { db_dir => "./db", level => 2 } },
    { env => \%env2, cgi => {}, par => { db_dir => "./db", level => 1 } },
    { env => \%env2, cgi => {}, par => { db_dir => "./db", level => 2 } },

    { env => \%env1, cgi => {}, par => { db_dir => "./db" } },
    { env => \%env1, cgi => {}, par => { db_dir => "./db", level => 2 } },
    { env => \%env1, cgi => {}, par => { db_dir => "./db", level => 1 } },

    { env => \%env2, cgi => {}, par => { db_dir => "./db", level => 2 } },
    { env => \%env2, cgi => {}, par => { db_dir => "./db", level => 1 } },
    { env => \%env2, cgi => {}, par => { db_dir => "./db", level => 2 } },
);

my @names = (
    "saulius",
    "Saulius Gražulis",
    "Sąžininga Žąsis",

    "Евгений Иванович",
    '/OU=SOLSA/CN=Saulius Grazulis/emailAddress=grazulis@ibt.lt',
    '/C=LT/ST=Vilnius Region/O=VU IBT/OU=xray/' .
    'CN=Saulius Gra\xC5\xBEulis/emailAddress=grazulis@ibt.lt',

    '/OU=SOLSA/CN=Saulius Gražulis/emailAddress=grazulis@ibt.lt',
    '/OU=SOLSA/CN=Saulius Grazulis',
    '/OU=SOLSA/CN=Saulius Gražulis',

    '/OU=xray/CN=\xd0\x95\xd0\xb2\xd0\xb3\xd0\xb5\xd0\xbd\xd0\xb8' .
    '\xd0\xb9\x20\xd0\x98\xd0\xb2\xd0\xb0\xd0\xbd\xd0\xbe\xd0\xb2' .
    '\xd0\xb8\xd1\x87/emailAddress=ei@domain.ru',
    '/OU=xyz/CN=Евгений Иванович/emailAddress=grazulis@ibt.lt',
    '/OU=xray/CN=\xd0\x95\xd0\xb2\xd0\xb3\xd0\xb5\xd0\xbd\xd0\xb8' .
    '\xd0\xb9\x20\xd0\x98\xd0\xb2\xd0\xb0\xd0\xbd\xd0\xbe\xd0\xb2' .
    '\xd0\xb8\xd1\x87',    
);

my $n = 0;
my $separator = "";
for my $case (@cases) {

    print $separator;
    print "test" . ($n+1) . ":\n";
    $separator = "\n";

    $case->{env}{REMOTE_USER} = $names[$n];
    
    my %settings = &get_database_settings( $case->{cgi},
                                           $case->{env},
                                           $case->{par} );

    local $\ = "\n";

    print "Name: '$case->{env}{REMOTE_USER}'";
    
    $case->{settings} = \%settings;
    for my $argument_name (qw(cgi env par settings)) {
        my $hash = $case->{$argument_name};
        print "$argument_name:";
        for my $key ((sort keys %{$hash})) {
            printf "\t%-21s ", $key;
            print "= ", defined $hash->{$key} ?
                ("'" . $hash->{$key} . "'") : 'undef';
        }
    }

    $n++;
};
