// Code generated by go-swagger; DO NOT EDIT.

//
// Copyright 2021 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package restapi

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
)

var (
	// SwaggerJSON embedded version of the swagger document used at generation time
	SwaggerJSON json.RawMessage
	// FlatSwaggerJSON embedded flattened version of the swagger document used at generation time
	FlatSwaggerJSON json.RawMessage
)

func init() {
	SwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/json"
  ],
  "produces": [
    "application/json"
  ],
  "schemes": [
    "http"
  ],
  "swagger": "2.0",
  "info": {
    "description": "Rekor is a cryptographically secure, immutable transparency log for signed software releases.",
    "title": "Rekor",
    "version": "1.0.0"
  },
  "host": "rekor.sigstore.dev",
  "paths": {
    "/api/v1/index/retrieve": {
      "post": {
        "description": "EXPERIMENTAL - this endpoint is offered as best effort only and may be changed or removed in future releases.\nThe results returned from this endpoint may be incomplete.\n",
        "tags": [
          "index"
        ],
        "summary": "Searches index by entry metadata",
        "operationId": "searchIndex",
        "deprecated": true,
        "parameters": [
          {
            "name": "query",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/SearchIndex"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Returns zero or more entry UUIDs from the transparency log based on search query",
            "schema": {
              "type": "array",
              "items": {
                "description": "Entry UUID in transparency log",
                "type": "string",
                "pattern": "^([0-9a-fA-F]{64}|[0-9a-fA-F]{80})$"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadContent"
          },
          "default": {
            "$ref": "#/responses/InternalServerError"
          }
        }
      }
    },
    "/api/v1/log": {
      "get": {
        "description": "Returns the current root hash and size of the merkle tree used to store the log entries.",
        "tags": [
          "tlog"
        ],
        "summary": "Get information about the current state of the transparency log",
        "operationId": "getLogInfo",
        "responses": {
          "200": {
            "description": "A JSON object with the root hash and tree size as properties",
            "schema": {
              "$ref": "#/definitions/LogInfo"
            }
          },
          "default": {
            "$ref": "#/responses/InternalServerError"
          }
        }
      }
    },
    "/api/v1/log/entries": {
      "get": {
        "tags": [
          "entries"
        ],
        "summary": "Retrieves an entry and inclusion proof from the transparency log (if it exists) by index",
        "operationId": "getLogEntryByIndex",
        "parameters": [
          {
            "type": "integer",
            "description": "specifies the index of the entry in the transparency log to be retrieved",
            "name": "logIndex",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "the entry in the transparency log requested along with an inclusion proof",
            "schema": {
              "$ref": "#/definitions/LogEntry"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/InternalServerError"
          }
        }
      },
      "post": {
        "description": "Creates an entry in the transparency log for a detached signature, public key, and content.\n",
        "tags": [
          "entries"
        ],
        "summary": "Creates an entry in the transparency log",
        "operationId": "createLogEntry",
        "parameters": [
          {
            "name": "proposedEntry",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/ProposedEntry"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Returns the entry created in the transparency log",
            "schema": {
              "$ref": "#/definitions/LogEntry"
            },
            "headers": {
              "ETag": {
                "type": "string",
                "description": "UUID of log entry"
              },
              "Location": {
                "type": "string",
                "format": "uri",
                "description": "URI location of log entry"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadContent"
          },
          "409": {
            "$ref": "#/responses/Conflict"
          },
          "default": {
            "$ref": "#/responses/InternalServerError"
          }
        }
      }
    },
    "/api/v1/log/entries/retrieve": {
      "post": {
        "tags": [
          "entries"
        ],
        "summary": "Searches transparency log for one or more log entries",
        "operationId": "searchLogQuery",
        "parameters": [
          {
            "name": "entry",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/SearchLogQuery"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Returns zero or more entries from the transparency log, according to how many were included in request query",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/LogEntry"
              }
            }
          },
          "400": {
            "$ref": "#/responses/BadContent"
          },
          "422": {
            "$ref": "#/responses/UnprocessableEntity"
          },
          "default": {
            "$ref": "#/responses/InternalServerError"
          }
        }
      }
    },
    "/api/v1/log/entries/{entryUUID}": {
      "get": {
        "description": "Returns the entry, root hash, tree size, and a list of hashes that can be used to calculate proof of an entry being included in the transparency log",
        "tags": [
          "entries"
        ],
        "summary": "Get log entry and information required to generate an inclusion proof for the entry in the transparency log",
        "operationId": "getLogEntryByUUID",
        "parameters": [
          {
            "pattern": "^([0-9a-fA-F]{64}|[0-9a-fA-F]{80})$",
            "type": "string",
            "description": "the UUID of the entry for which the inclusion proof information should be returned",
            "name": "entryUUID",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Information needed for a client to compute the inclusion proof",
            "schema": {
              "$ref": "#/definitions/LogEntry"
            }
          },
          "404": {
            "$ref": "#/responses/NotFound"
          },
          "default": {
            "$ref": "#/responses/InternalServerError"
          }
        }
      }
    },
    "/api/v1/log/proof": {
      "get": {
        "description": "Returns a list of hashes for specified tree sizes that can be used to confirm the consistency of the transparency log",
        "tags": [
          "tlog"
        ],
        "summary": "Get information required to generate a consistency proof for the transparency log",
        "operationId": "getLogProof",
        "parameters": [
          {
            "minimum": 1,
            "type": "integer",
            "default": 1,
            "description": "The size of the tree that you wish to prove consistency from (1 means the beginning of the log) Defaults to 1 if not specified\n",
            "name": "firstSize",
            "in": "query"
          },
          {
            "minimum": 1,
            "type": "integer",
            "description": "The size of the tree that you wish to prove consistency to",
            "name": "lastSize",
            "in": "query",
            "required": true
          },
          {
            "pattern": "^[0-9]+$",
            "type": "string",
            "description": "The tree ID of the tree that you wish to prove consistency for",
            "name": "treeID",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "All hashes required to compute the consistency proof",
            "schema": {
              "$ref": "#/definitions/ConsistencyProof"
            }
          },
          "400": {
            "$ref": "#/responses/BadContent"
          },
          "default": {
            "$ref": "#/responses/InternalServerError"
          }
        }
      }
    },
    "/api/v1/log/publicKey": {
      "get": {
        "description": "Returns the public key that can be used to validate the signed tree head",
        "produces": [
          "application/x-pem-file"
        ],
        "tags": [
          "pubkey"
        ],
        "summary": "Retrieve the public key that can be used to validate the signed tree head",
        "operationId": "getPublicKey",
        "parameters": [
          {
            "pattern": "^[0-9]+$",
            "type": "string",
            "description": "The tree ID of the tree you wish to get a public key for",
            "name": "treeID",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "The public key",
            "schema": {
              "type": "string"
            }
          },
          "default": {
            "$ref": "#/responses/InternalServerError"
          }
        }
      }
    }
  },
  "definitions": {
    "ConsistencyProof": {
      "type": "object",
      "required": [
        "rootHash",
        "hashes"
      ],
      "properties": {
        "hashes": {
          "type": "array",
          "items": {
            "description": "SHA256 hash value expressed in hexadecimal format",
            "type": "string",
            "pattern": "^[0-9a-fA-F]{64}$"
          }
        },
        "rootHash": {
          "description": "The hash value stored at the root of the merkle tree at the time the proof was generated",
          "type": "string",
          "pattern": "^[0-9a-fA-F]{64}$"
        }
      }
    },
    "Error": {
      "type": "object",
      "properties": {
        "code": {
          "type": "integer"
        },
        "message": {
          "type": "string"
        }
      }
    },
    "InactiveShardLogInfo": {
      "type": "object",
      "required": [
        "rootHash",
        "treeSize",
        "signedTreeHead",
        "treeID"
      ],
      "properties": {
        "rootHash": {
          "description": "The current hash value stored at the root of the merkle tree",
          "type": "string",
          "pattern": "^[0-9a-fA-F]{64}$"
        },
        "signedTreeHead": {
          "description": "The current signed tree head",
          "type": "string",
          "format": "signedCheckpoint"
        },
        "treeID": {
          "description": "The current treeID",
          "type": "string",
          "pattern": "^[0-9]+$"
        },
        "treeSize": {
          "description": "The current number of nodes in the merkle tree",
          "type": "integer",
          "minimum": 1
        }
      }
    },
    "InclusionProof": {
      "type": "object",
      "required": [
        "logIndex",
        "rootHash",
        "treeSize",
        "hashes",
        "checkpoint"
      ],
      "properties": {
        "checkpoint": {
          "description": "The checkpoint (signed tree head) that the inclusion proof is based on",
          "type": "string",
          "format": "signedCheckpoint"
        },
        "hashes": {
          "description": "A list of hashes required to compute the inclusion proof, sorted in order from leaf to root",
          "type": "array",
          "items": {
            "description": "SHA256 hash value expressed in hexadecimal format",
            "type": "string",
            "pattern": "^[0-9a-fA-F]{64}$"
          }
        },
        "logIndex": {
          "description": "The index of the entry in the transparency log",
          "type": "integer"
        },
        "rootHash": {
          "description": "The hash value stored at the root of the merkle tree at the time the proof was generated",
          "type": "string",
          "pattern": "^[0-9a-fA-F]{64}$"
        },
        "treeSize": {
          "description": "The size of the merkle tree at the time the inclusion proof was generated",
          "type": "integer",
          "minimum": 1
        }
      }
    },
    "LogEntry": {
      "type": "object",
      "additionalProperties": {
        "type": "object",
        "required": [
          "logID",
          "logIndex",
          "body",
          "integratedTime"
        ],
        "properties": {
          "attestation": {
            "type": "object",
            "format": "byte",
            "properties": {
              "data": {
                "format": "byte"
              }
            }
          },
          "body": {
            "type": "object",
            "additionalProperties": true
          },
          "integratedTime": {
            "description": "The time the entry was added to the log as a Unix timestamp in seconds",
            "type": "integer"
          },
          "logID": {
            "description": "This is the SHA256 hash of the DER-encoded public key for the log at the time the entry was included in the log",
            "type": "string",
            "pattern": "^[0-9a-fA-F]{64}$"
          },
          "logIndex": {
            "type": "integer"
          },
          "verification": {
            "type": "object",
            "properties": {
              "inclusionProof": {
                "$ref": "#/definitions/InclusionProof"
              },
              "signedEntryTimestamp": {
                "description": "Signature over the logID, logIndex, body and integratedTime.",
                "type": "string",
                "format": "byte"
              }
            }
          }
        }
      }
    },
    "LogInfo": {
      "type": "object",
      "required": [
        "rootHash",
        "treeSize",
        "signedTreeHead",
        "treeID"
      ],
      "properties": {
        "inactiveShards": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/InactiveShardLogInfo"
          }
        },
        "rootHash": {
          "description": "The current hash value stored at the root of the merkle tree",
          "type": "string",
          "pattern": "^[0-9a-fA-F]{64}$"
        },
        "signedTreeHead": {
          "description": "The current signed tree head",
          "type": "string",
          "format": "signedCheckpoint"
        },
        "treeID": {
          "description": "The current treeID",
          "type": "string",
          "pattern": "^[0-9]+$"
        },
        "treeSize": {
          "description": "The current number of nodes in the merkle tree",
          "type": "integer",
          "minimum": 1
        }
      }
    },
    "ProposedEntry": {
      "type": "object",
      "required": [
        "kind"
      ],
      "properties": {
        "kind": {
          "type": "string"
        }
      },
      "discriminator": "kind"
    },
    "SearchIndex": {
      "type": "object",
      "properties": {
        "email": {
          "type": "string",
          "format": "email"
        },
        "hash": {
          "type": "string",
          "pattern": "^(sha512:)?[0-9a-fA-F]{128}$|^(sha256:)?[0-9a-fA-F]{64}$|^(sha1:)?[0-9a-fA-F]{40}$"
        },
        "operator": {
          "type": "string",
          "enum": [
            "and",
            "or"
          ]
        },
        "publicKey": {
          "type": "object",
          "required": [
            "format"
          ],
          "properties": {
            "content": {
              "type": "string",
              "format": "byte"
            },
            "format": {
              "type": "string",
              "enum": [
                "pgp",
                "x509",
                "minisign",
                "ssh",
                "tuf"
              ]
            }
          }
        }
      }
    },
    "SearchLogQuery": {
      "type": "object",
      "properties": {
        "entries": {
          "type": "array",
          "maxItems": 10,
          "minItems": 1,
          "items": {
            "$ref": "#/definitions/ProposedEntry"
          }
        },
        "entryUUIDs": {
          "type": "array",
          "maxItems": 10,
          "minItems": 1,
          "items": {
            "type": "string",
            "pattern": "^([0-9a-fA-F]{64}|[0-9a-fA-F]{80})$"
          }
        },
        "logIndexes": {
          "type": "array",
          "maxItems": 10,
          "minItems": 1,
          "items": {
            "type": "integer"
          }
        }
      }
    },
    "alpine": {
      "description": "Alpine package",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "type": "object",
              "$ref": "pkg/types/alpine/alpine_schema.json"
            }
          },
          "additionalProperties": false
        }
      ]
    },
    "cose": {
      "description": "COSE object",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "type": "object",
              "$ref": "pkg/types/cose/cose_schema.json"
            }
          },
          "additionalProperties": false
        }
      ]
    },
    "dsse": {
      "description": "DSSE envelope",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "type": "object",
              "$ref": "pkg/types/dsse/dsse_schema.json"
            }
          },
          "additionalProperties": false
        }
      ]
    },
    "hashedrekord": {
      "description": "Hashed Rekord object",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "type": "object",
              "$ref": "pkg/types/hashedrekord/hashedrekord_schema.json"
            }
          },
          "additionalProperties": false
        }
      ]
    },
    "helm": {
      "description": "Helm chart",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "type": "object",
              "$ref": "pkg/types/helm/helm_schema.json"
            }
          }
        }
      ]
    },
    "intoto": {
      "description": "Intoto object",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "type": "object",
              "$ref": "pkg/types/intoto/intoto_schema.json"
            }
          },
          "additionalProperties": false
        }
      ]
    },
    "jar": {
      "description": "Java Archive (JAR)",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "type": "object",
              "$ref": "pkg/types/jar/jar_schema.json"
            }
          },
          "additionalProperties": false
        }
      ]
    },
    "rekord": {
      "description": "Rekord object",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "type": "object",
              "$ref": "pkg/types/rekord/rekord_schema.json"
            }
          },
          "additionalProperties": false
        }
      ]
    },
    "rfc3161": {
      "description": "RFC3161 Timestamp",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "type": "object",
              "$ref": "pkg/types/rfc3161/rfc3161_schema.json"
            }
          },
          "additionalProperties": false
        }
      ]
    },
    "rpm": {
      "description": "RPM package",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "type": "object",
              "$ref": "pkg/types/rpm/rpm_schema.json"
            }
          },
          "additionalProperties": false
        }
      ]
    },
    "tuf": {
      "description": "TUF metadata",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "type": "object",
              "$ref": "pkg/types/tuf/tuf_schema.json"
            }
          },
          "additionalProperties": false
        }
      ]
    }
  },
  "responses": {
    "BadContent": {
      "description": "The content supplied to the server was invalid",
      "schema": {
        "$ref": "#/definitions/Error"
      }
    },
    "Conflict": {
      "description": "The request conflicts with the current state of the transparency log",
      "schema": {
        "$ref": "#/definitions/Error"
      },
      "headers": {
        "Location": {
          "type": "string",
          "format": "uri"
        }
      }
    },
    "InternalServerError": {
      "description": "There was an internal error in the server while processing the request",
      "schema": {
        "$ref": "#/definitions/Error"
      }
    },
    "NotFound": {
      "description": "The content requested could not be found"
    },
    "UnprocessableEntity": {
      "description": "The server understood the request but is unable to process the contained instructions",
      "schema": {
        "$ref": "#/definitions/Error"
      }
    }
  }
}`))
	FlatSwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/json"
  ],
  "produces": [
    "application/json"
  ],
  "schemes": [
    "http"
  ],
  "swagger": "2.0",
  "info": {
    "description": "Rekor is a cryptographically secure, immutable transparency log for signed software releases.",
    "title": "Rekor",
    "version": "1.0.0"
  },
  "host": "rekor.sigstore.dev",
  "paths": {
    "/api/v1/index/retrieve": {
      "post": {
        "description": "EXPERIMENTAL - this endpoint is offered as best effort only and may be changed or removed in future releases.\nThe results returned from this endpoint may be incomplete.\n",
        "tags": [
          "index"
        ],
        "summary": "Searches index by entry metadata",
        "operationId": "searchIndex",
        "deprecated": true,
        "parameters": [
          {
            "name": "query",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/SearchIndex"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Returns zero or more entry UUIDs from the transparency log based on search query",
            "schema": {
              "type": "array",
              "items": {
                "description": "Entry UUID in transparency log",
                "type": "string",
                "pattern": "^([0-9a-fA-F]{64}|[0-9a-fA-F]{80})$"
              }
            }
          },
          "400": {
            "description": "The content supplied to the server was invalid",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "There was an internal error in the server while processing the request",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/api/v1/log": {
      "get": {
        "description": "Returns the current root hash and size of the merkle tree used to store the log entries.",
        "tags": [
          "tlog"
        ],
        "summary": "Get information about the current state of the transparency log",
        "operationId": "getLogInfo",
        "responses": {
          "200": {
            "description": "A JSON object with the root hash and tree size as properties",
            "schema": {
              "$ref": "#/definitions/LogInfo"
            }
          },
          "default": {
            "description": "There was an internal error in the server while processing the request",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/api/v1/log/entries": {
      "get": {
        "tags": [
          "entries"
        ],
        "summary": "Retrieves an entry and inclusion proof from the transparency log (if it exists) by index",
        "operationId": "getLogEntryByIndex",
        "parameters": [
          {
            "minimum": 0,
            "type": "integer",
            "description": "specifies the index of the entry in the transparency log to be retrieved",
            "name": "logIndex",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "the entry in the transparency log requested along with an inclusion proof",
            "schema": {
              "$ref": "#/definitions/LogEntry"
            }
          },
          "404": {
            "description": "The content requested could not be found"
          },
          "default": {
            "description": "There was an internal error in the server while processing the request",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "description": "Creates an entry in the transparency log for a detached signature, public key, and content.\n",
        "tags": [
          "entries"
        ],
        "summary": "Creates an entry in the transparency log",
        "operationId": "createLogEntry",
        "parameters": [
          {
            "name": "proposedEntry",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/ProposedEntry"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Returns the entry created in the transparency log",
            "schema": {
              "$ref": "#/definitions/LogEntry"
            },
            "headers": {
              "ETag": {
                "type": "string",
                "description": "UUID of log entry"
              },
              "Location": {
                "type": "string",
                "format": "uri",
                "description": "URI location of log entry"
              }
            }
          },
          "400": {
            "description": "The content supplied to the server was invalid",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "409": {
            "description": "The request conflicts with the current state of the transparency log",
            "schema": {
              "$ref": "#/definitions/Error"
            },
            "headers": {
              "Location": {
                "type": "string",
                "format": "uri"
              }
            }
          },
          "default": {
            "description": "There was an internal error in the server while processing the request",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/api/v1/log/entries/retrieve": {
      "post": {
        "tags": [
          "entries"
        ],
        "summary": "Searches transparency log for one or more log entries",
        "operationId": "searchLogQuery",
        "parameters": [
          {
            "name": "entry",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/SearchLogQuery"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Returns zero or more entries from the transparency log, according to how many were included in request query",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/LogEntry"
              }
            }
          },
          "400": {
            "description": "The content supplied to the server was invalid",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "422": {
            "description": "The server understood the request but is unable to process the contained instructions",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "There was an internal error in the server while processing the request",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/api/v1/log/entries/{entryUUID}": {
      "get": {
        "description": "Returns the entry, root hash, tree size, and a list of hashes that can be used to calculate proof of an entry being included in the transparency log",
        "tags": [
          "entries"
        ],
        "summary": "Get log entry and information required to generate an inclusion proof for the entry in the transparency log",
        "operationId": "getLogEntryByUUID",
        "parameters": [
          {
            "pattern": "^([0-9a-fA-F]{64}|[0-9a-fA-F]{80})$",
            "type": "string",
            "description": "the UUID of the entry for which the inclusion proof information should be returned",
            "name": "entryUUID",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Information needed for a client to compute the inclusion proof",
            "schema": {
              "$ref": "#/definitions/LogEntry"
            }
          },
          "404": {
            "description": "The content requested could not be found"
          },
          "default": {
            "description": "There was an internal error in the server while processing the request",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/api/v1/log/proof": {
      "get": {
        "description": "Returns a list of hashes for specified tree sizes that can be used to confirm the consistency of the transparency log",
        "tags": [
          "tlog"
        ],
        "summary": "Get information required to generate a consistency proof for the transparency log",
        "operationId": "getLogProof",
        "parameters": [
          {
            "minimum": 1,
            "type": "integer",
            "default": 1,
            "description": "The size of the tree that you wish to prove consistency from (1 means the beginning of the log) Defaults to 1 if not specified\n",
            "name": "firstSize",
            "in": "query"
          },
          {
            "minimum": 1,
            "type": "integer",
            "description": "The size of the tree that you wish to prove consistency to",
            "name": "lastSize",
            "in": "query",
            "required": true
          },
          {
            "pattern": "^[0-9]+$",
            "type": "string",
            "description": "The tree ID of the tree that you wish to prove consistency for",
            "name": "treeID",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "All hashes required to compute the consistency proof",
            "schema": {
              "$ref": "#/definitions/ConsistencyProof"
            }
          },
          "400": {
            "description": "The content supplied to the server was invalid",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "There was an internal error in the server while processing the request",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/api/v1/log/publicKey": {
      "get": {
        "description": "Returns the public key that can be used to validate the signed tree head",
        "produces": [
          "application/x-pem-file"
        ],
        "tags": [
          "pubkey"
        ],
        "summary": "Retrieve the public key that can be used to validate the signed tree head",
        "operationId": "getPublicKey",
        "parameters": [
          {
            "pattern": "^[0-9]+$",
            "type": "string",
            "description": "The tree ID of the tree you wish to get a public key for",
            "name": "treeID",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "The public key",
            "schema": {
              "type": "string"
            }
          },
          "default": {
            "description": "There was an internal error in the server while processing the request",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    }
  },
  "definitions": {
    "AlpineV001SchemaPackage": {
      "description": "Information about the package associated with the entry",
      "type": "object",
      "oneOf": [
        {
          "required": [
            "hash"
          ]
        },
        {
          "required": [
            "content"
          ]
        }
      ],
      "properties": {
        "content": {
          "description": "Specifies the package inline within the document",
          "type": "string",
          "format": "byte",
          "writeOnly": true
        },
        "hash": {
          "description": "Specifies the hash algorithm and value for the package",
          "type": "object",
          "required": [
            "algorithm",
            "value"
          ],
          "properties": {
            "algorithm": {
              "description": "The hashing function used to compute the hash value",
              "type": "string",
              "enum": [
                "sha256"
              ]
            },
            "value": {
              "description": "The hash value for the package",
              "type": "string"
            }
          },
          "readOnly": true
        },
        "pkginfo": {
          "description": "Values of the .PKGINFO key / value pairs",
          "type": "object",
          "additionalProperties": {
            "type": "string"
          },
          "readOnly": true
        }
      }
    },
    "AlpineV001SchemaPackageHash": {
      "description": "Specifies the hash algorithm and value for the package",
      "type": "object",
      "required": [
        "algorithm",
        "value"
      ],
      "properties": {
        "algorithm": {
          "description": "The hashing function used to compute the hash value",
          "type": "string",
          "enum": [
            "sha256"
          ]
        },
        "value": {
          "description": "The hash value for the package",
          "type": "string"
        }
      },
      "readOnly": true
    },
    "AlpineV001SchemaPublicKey": {
      "description": "The public key that can verify the package signature",
      "type": "object",
      "required": [
        "content"
      ],
      "properties": {
        "content": {
          "description": "Specifies the content of the public key inline within the document",
          "type": "string",
          "format": "byte"
        }
      }
    },
    "ConsistencyProof": {
      "type": "object",
      "required": [
        "rootHash",
        "hashes"
      ],
      "properties": {
        "hashes": {
          "type": "array",
          "items": {
            "description": "SHA256 hash value expressed in hexadecimal format",
            "type": "string",
            "pattern": "^[0-9a-fA-F]{64}$"
          }
        },
        "rootHash": {
          "description": "The hash value stored at the root of the merkle tree at the time the proof was generated",
          "type": "string",
          "pattern": "^[0-9a-fA-F]{64}$"
        }
      }
    },
    "CoseV001SchemaData": {
      "description": "Information about the content associated with the entry",
      "type": "object",
      "properties": {
        "aad": {
          "description": "Specifies the additional authenticated data required to verify the signature",
          "type": "string",
          "format": "byte",
          "writeOnly": true
        },
        "envelopeHash": {
          "description": "Specifies the hash algorithm and value for the COSE envelope",
          "type": "object",
          "required": [
            "algorithm",
            "value"
          ],
          "properties": {
            "algorithm": {
              "description": "The hashing function used to compute the hash value",
              "type": "string",
              "enum": [
                "sha256"
              ]
            },
            "value": {
              "description": "The hash value for the envelope",
              "type": "string"
            }
          },
          "readOnly": true
        },
        "payloadHash": {
          "description": "Specifies the hash algorithm and value for the content",
          "type": "object",
          "required": [
            "algorithm",
            "value"
          ],
          "properties": {
            "algorithm": {
              "description": "The hashing function used to compute the hash value",
              "type": "string",
              "enum": [
                "sha256"
              ]
            },
            "value": {
              "description": "The hash value for the content",
              "type": "string"
            }
          },
          "readOnly": true
        }
      }
    },
    "CoseV001SchemaDataEnvelopeHash": {
      "description": "Specifies the hash algorithm and value for the COSE envelope",
      "type": "object",
      "required": [
        "algorithm",
        "value"
      ],
      "properties": {
        "algorithm": {
          "description": "The hashing function used to compute the hash value",
          "type": "string",
          "enum": [
            "sha256"
          ]
        },
        "value": {
          "description": "The hash value for the envelope",
          "type": "string"
        }
      },
      "readOnly": true
    },
    "CoseV001SchemaDataPayloadHash": {
      "description": "Specifies the hash algorithm and value for the content",
      "type": "object",
      "required": [
        "algorithm",
        "value"
      ],
      "properties": {
        "algorithm": {
          "description": "The hashing function used to compute the hash value",
          "type": "string",
          "enum": [
            "sha256"
          ]
        },
        "value": {
          "description": "The hash value for the content",
          "type": "string"
        }
      },
      "readOnly": true
    },
    "DSSEV001SchemaEnvelopeHash": {
      "description": "Specifies the hash algorithm and value encompassing the entire envelope sent to Rekor",
      "type": "object",
      "required": [
        "algorithm",
        "value"
      ],
      "properties": {
        "algorithm": {
          "description": "The hashing function used to compute the hash value",
          "type": "string",
          "enum": [
            "sha256"
          ]
        },
        "value": {
          "description": "The value of the computed digest over the entire envelope",
          "type": "string"
        }
      },
      "readOnly": true
    },
    "DSSEV001SchemaPayloadHash": {
      "description": "Specifies the hash algorithm and value covering the payload within the DSSE envelope",
      "type": "object",
      "required": [
        "algorithm",
        "value"
      ],
      "properties": {
        "algorithm": {
          "description": "The hashing function used to compute the hash value",
          "type": "string",
          "enum": [
            "sha256"
          ]
        },
        "value": {
          "description": "The value of the computed digest over the payload within the envelope",
          "type": "string"
        }
      },
      "readOnly": true
    },
    "DSSEV001SchemaProposedContent": {
      "type": "object",
      "required": [
        "envelope",
        "verifiers"
      ],
      "properties": {
        "envelope": {
          "description": "DSSE envelope specified as a stringified JSON object",
          "type": "string",
          "writeOnly": true
        },
        "verifiers": {
          "description": "collection of all verification material (e.g. public keys or certificates) used to verify signatures over envelope's payload, specified as base64-encoded strings",
          "type": "array",
          "minItems": 1,
          "items": {
            "type": "string",
            "format": "byte"
          },
          "writeOnly": true
        }
      },
      "writeOnly": true
    },
    "DSSEV001SchemaSignaturesItems0": {
      "description": "a signature of the envelope's payload along with the verification material for the signature",
      "type": "object",
      "required": [
        "signature",
        "verifier"
      ],
      "properties": {
        "signature": {
          "description": "base64 encoded signature of the payload",
          "type": "string",
          "pattern": "^(?:[A-Za-z0-9+\\/]{4})*(?:[A-Za-z0-9+\\/]{2}==|[A-Za-z0-9+\\/]{3}=|[A-Za-z0-9+\\/]{4})$"
        },
        "verifier": {
          "description": "verification material that was used to verify the corresponding signature, specified as a base64 encoded string",
          "type": "string",
          "format": "byte"
        }
      }
    },
    "Error": {
      "type": "object",
      "properties": {
        "code": {
          "type": "integer"
        },
        "message": {
          "type": "string"
        }
      }
    },
    "HashedrekordV001SchemaData": {
      "description": "Information about the content associated with the entry",
      "type": "object",
      "properties": {
        "hash": {
          "description": "Specifies the hash algorithm and value for the content",
          "type": "object",
          "required": [
            "algorithm",
            "value"
          ],
          "properties": {
            "algorithm": {
              "description": "The hashing function used to compute the hash value",
              "type": "string",
              "enum": [
                "sha256",
                "sha384",
                "sha512"
              ]
            },
            "value": {
              "description": "The hash value for the content, as represented by a lower case hexadecimal string",
              "type": "string"
            }
          }
        }
      }
    },
    "HashedrekordV001SchemaDataHash": {
      "description": "Specifies the hash algorithm and value for the content",
      "type": "object",
      "required": [
        "algorithm",
        "value"
      ],
      "properties": {
        "algorithm": {
          "description": "The hashing function used to compute the hash value",
          "type": "string",
          "enum": [
            "sha256",
            "sha384",
            "sha512"
          ]
        },
        "value": {
          "description": "The hash value for the content, as represented by a lower case hexadecimal string",
          "type": "string"
        }
      }
    },
    "HashedrekordV001SchemaSignature": {
      "description": "Information about the detached signature associated with the entry",
      "type": "object",
      "properties": {
        "content": {
          "description": "Specifies the content of the signature inline within the document",
          "type": "string",
          "format": "byte"
        },
        "publicKey": {
          "description": "The public key that can verify the signature; this can also be an X509 code signing certificate that contains the raw public key information",
          "type": "object",
          "properties": {
            "content": {
              "description": "Specifies the content of the public key or code signing certificate inline within the document",
              "type": "string",
              "format": "byte"
            }
          }
        }
      }
    },
    "HashedrekordV001SchemaSignaturePublicKey": {
      "description": "The public key that can verify the signature; this can also be an X509 code signing certificate that contains the raw public key information",
      "type": "object",
      "properties": {
        "content": {
          "description": "Specifies the content of the public key or code signing certificate inline within the document",
          "type": "string",
          "format": "byte"
        }
      }
    },
    "HelmV001SchemaChart": {
      "description": "Information about the Helm chart associated with the entry",
      "type": "object",
      "required": [
        "provenance"
      ],
      "properties": {
        "hash": {
          "description": "Specifies the hash algorithm and value for the chart",
          "type": "object",
          "required": [
            "algorithm",
            "value"
          ],
          "properties": {
            "algorithm": {
              "description": "The hashing function used to compute the hash value",
              "type": "string",
              "enum": [
                "sha256"
              ]
            },
            "value": {
              "description": "The hash value for the chart",
              "type": "string"
            }
          },
          "readOnly": true
        },
        "provenance": {
          "description": "The provenance entry associated with the signed Helm Chart",
          "type": "object",
          "oneOf": [
            {
              "required": [
                "signature"
              ]
            },
            {
              "required": [
                "content"
              ]
            }
          ],
          "properties": {
            "content": {
              "description": "Specifies the content of the provenance file inline within the document",
              "type": "string",
              "format": "byte",
              "writeOnly": true
            },
            "signature": {
              "description": "Information about the included signature in the provenance file",
              "type": "object",
              "required": [
                "content"
              ],
              "properties": {
                "content": {
                  "description": "Specifies the signature embedded within the provenance file ",
                  "type": "string",
                  "format": "byte",
                  "readOnly": true
                }
              },
              "readOnly": true
            }
          }
        }
      }
    },
    "HelmV001SchemaChartHash": {
      "description": "Specifies the hash algorithm and value for the chart",
      "type": "object",
      "required": [
        "algorithm",
        "value"
      ],
      "properties": {
        "algorithm": {
          "description": "The hashing function used to compute the hash value",
          "type": "string",
          "enum": [
            "sha256"
          ]
        },
        "value": {
          "description": "The hash value for the chart",
          "type": "string"
        }
      },
      "readOnly": true
    },
    "HelmV001SchemaChartProvenance": {
      "description": "The provenance entry associated with the signed Helm Chart",
      "type": "object",
      "oneOf": [
        {
          "required": [
            "signature"
          ]
        },
        {
          "required": [
            "content"
          ]
        }
      ],
      "properties": {
        "content": {
          "description": "Specifies the content of the provenance file inline within the document",
          "type": "string",
          "format": "byte",
          "writeOnly": true
        },
        "signature": {
          "description": "Information about the included signature in the provenance file",
          "type": "object",
          "required": [
            "content"
          ],
          "properties": {
            "content": {
              "description": "Specifies the signature embedded within the provenance file ",
              "type": "string",
              "format": "byte",
              "readOnly": true
            }
          },
          "readOnly": true
        }
      }
    },
    "HelmV001SchemaChartProvenanceSignature": {
      "description": "Information about the included signature in the provenance file",
      "type": "object",
      "required": [
        "content"
      ],
      "properties": {
        "content": {
          "description": "Specifies the signature embedded within the provenance file ",
          "type": "string",
          "format": "byte",
          "readOnly": true
        }
      },
      "readOnly": true
    },
    "HelmV001SchemaPublicKey": {
      "description": "The public key that can verify the package signature",
      "type": "object",
      "required": [
        "content"
      ],
      "properties": {
        "content": {
          "description": "Specifies the content of the public key inline within the document",
          "type": "string",
          "format": "byte"
        }
      }
    },
    "InactiveShardLogInfo": {
      "type": "object",
      "required": [
        "rootHash",
        "treeSize",
        "signedTreeHead",
        "treeID"
      ],
      "properties": {
        "rootHash": {
          "description": "The current hash value stored at the root of the merkle tree",
          "type": "string",
          "pattern": "^[0-9a-fA-F]{64}$"
        },
        "signedTreeHead": {
          "description": "The current signed tree head",
          "type": "string",
          "format": "signedCheckpoint"
        },
        "treeID": {
          "description": "The current treeID",
          "type": "string",
          "pattern": "^[0-9]+$"
        },
        "treeSize": {
          "description": "The current number of nodes in the merkle tree",
          "type": "integer",
          "minimum": 1
        }
      }
    },
    "InclusionProof": {
      "type": "object",
      "required": [
        "logIndex",
        "rootHash",
        "treeSize",
        "hashes",
        "checkpoint"
      ],
      "properties": {
        "checkpoint": {
          "description": "The checkpoint (signed tree head) that the inclusion proof is based on",
          "type": "string",
          "format": "signedCheckpoint"
        },
        "hashes": {
          "description": "A list of hashes required to compute the inclusion proof, sorted in order from leaf to root",
          "type": "array",
          "items": {
            "description": "SHA256 hash value expressed in hexadecimal format",
            "type": "string",
            "pattern": "^[0-9a-fA-F]{64}$"
          }
        },
        "logIndex": {
          "description": "The index of the entry in the transparency log",
          "type": "integer",
          "minimum": 0
        },
        "rootHash": {
          "description": "The hash value stored at the root of the merkle tree at the time the proof was generated",
          "type": "string",
          "pattern": "^[0-9a-fA-F]{64}$"
        },
        "treeSize": {
          "description": "The size of the merkle tree at the time the inclusion proof was generated",
          "type": "integer",
          "minimum": 1
        }
      }
    },
    "IntotoV001SchemaContent": {
      "type": "object",
      "properties": {
        "envelope": {
          "description": "envelope",
          "type": "string",
          "writeOnly": true
        },
        "hash": {
          "description": "Specifies the hash algorithm and value encompassing the entire signed envelope; this is computed by the rekor server, client-provided values are ignored",
          "type": "object",
          "required": [
            "algorithm",
            "value"
          ],
          "properties": {
            "algorithm": {
              "description": "The hashing function used to compute the hash value",
              "type": "string",
              "enum": [
                "sha256"
              ]
            },
            "value": {
              "description": "The hash value for the archive",
              "type": "string"
            }
          },
          "readOnly": true
        },
        "payloadHash": {
          "description": "Specifies the hash algorithm and value covering the payload within the DSSE envelope; this is computed by the rekor server, client-provided values are ignored",
          "type": "object",
          "required": [
            "algorithm",
            "value"
          ],
          "properties": {
            "algorithm": {
              "description": "The hashing function used to compute the hash value",
              "type": "string",
              "enum": [
                "sha256"
              ]
            },
            "value": {
              "description": "The hash value for the envelope's payload",
              "type": "string"
            }
          },
          "readOnly": true
        }
      }
    },
    "IntotoV001SchemaContentHash": {
      "description": "Specifies the hash algorithm and value encompassing the entire signed envelope; this is computed by the rekor server, client-provided values are ignored",
      "type": "object",
      "required": [
        "algorithm",
        "value"
      ],
      "properties": {
        "algorithm": {
          "description": "The hashing function used to compute the hash value",
          "type": "string",
          "enum": [
            "sha256"
          ]
        },
        "value": {
          "description": "The hash value for the archive",
          "type": "string"
        }
      },
      "readOnly": true
    },
    "IntotoV001SchemaContentPayloadHash": {
      "description": "Specifies the hash algorithm and value covering the payload within the DSSE envelope; this is computed by the rekor server, client-provided values are ignored",
      "type": "object",
      "required": [
        "algorithm",
        "value"
      ],
      "properties": {
        "algorithm": {
          "description": "The hashing function used to compute the hash value",
          "type": "string",
          "enum": [
            "sha256"
          ]
        },
        "value": {
          "description": "The hash value for the envelope's payload",
          "type": "string"
        }
      },
      "readOnly": true
    },
    "IntotoV002SchemaContent": {
      "type": "object",
      "required": [
        "envelope"
      ],
      "properties": {
        "envelope": {
          "description": "dsse envelope",
          "type": "object",
          "required": [
            "payloadType",
            "signatures"
          ],
          "properties": {
            "payload": {
              "description": "payload of the envelope",
              "type": "string",
              "format": "byte",
              "writeOnly": true
            },
            "payloadType": {
              "description": "type describing the payload",
              "type": "string"
            },
            "signatures": {
              "description": "collection of all signatures of the envelope's payload",
              "type": "array",
              "minItems": 1,
              "items": {
                "$ref": "#/definitions/IntotoV002SchemaContentEnvelopeSignaturesItems0"
              }
            }
          }
        },
        "hash": {
          "description": "Specifies the hash algorithm and value encompassing the entire signed envelope",
          "type": "object",
          "required": [
            "algorithm",
            "value"
          ],
          "properties": {
            "algorithm": {
              "description": "The hashing function used to compute the hash value",
              "type": "string",
              "enum": [
                "sha256"
              ]
            },
            "value": {
              "description": "The hash value for the archive",
              "type": "string"
            }
          },
          "readOnly": true
        },
        "payloadHash": {
          "description": "Specifies the hash algorithm and value covering the payload within the DSSE envelope",
          "type": "object",
          "required": [
            "algorithm",
            "value"
          ],
          "properties": {
            "algorithm": {
              "description": "The hashing function used to compute the hash value",
              "type": "string",
              "enum": [
                "sha256"
              ]
            },
            "value": {
              "description": "The hash value of the payload",
              "type": "string"
            }
          },
          "readOnly": true
        }
      }
    },
    "IntotoV002SchemaContentEnvelope": {
      "description": "dsse envelope",
      "type": "object",
      "required": [
        "payloadType",
        "signatures"
      ],
      "properties": {
        "payload": {
          "description": "payload of the envelope",
          "type": "string",
          "format": "byte",
          "writeOnly": true
        },
        "payloadType": {
          "description": "type describing the payload",
          "type": "string"
        },
        "signatures": {
          "description": "collection of all signatures of the envelope's payload",
          "type": "array",
          "minItems": 1,
          "items": {
            "$ref": "#/definitions/IntotoV002SchemaContentEnvelopeSignaturesItems0"
          }
        }
      }
    },
    "IntotoV002SchemaContentEnvelopeSignaturesItems0": {
      "description": "a signature of the envelope's payload along with the public key for the signature",
      "type": "object",
      "required": [
        "sig",
        "publicKey"
      ],
      "properties": {
        "keyid": {
          "description": "optional id of the key used to create the signature",
          "type": "string"
        },
        "publicKey": {
          "description": "public key that corresponds to this signature",
          "type": "string",
          "format": "byte"
        },
        "sig": {
          "description": "signature of the payload",
          "type": "string",
          "format": "byte"
        }
      }
    },
    "IntotoV002SchemaContentHash": {
      "description": "Specifies the hash algorithm and value encompassing the entire signed envelope",
      "type": "object",
      "required": [
        "algorithm",
        "value"
      ],
      "properties": {
        "algorithm": {
          "description": "The hashing function used to compute the hash value",
          "type": "string",
          "enum": [
            "sha256"
          ]
        },
        "value": {
          "description": "The hash value for the archive",
          "type": "string"
        }
      },
      "readOnly": true
    },
    "IntotoV002SchemaContentPayloadHash": {
      "description": "Specifies the hash algorithm and value covering the payload within the DSSE envelope",
      "type": "object",
      "required": [
        "algorithm",
        "value"
      ],
      "properties": {
        "algorithm": {
          "description": "The hashing function used to compute the hash value",
          "type": "string",
          "enum": [
            "sha256"
          ]
        },
        "value": {
          "description": "The hash value of the payload",
          "type": "string"
        }
      },
      "readOnly": true
    },
    "JarV001SchemaArchive": {
      "description": "Information about the archive associated with the entry",
      "type": "object",
      "oneOf": [
        {
          "required": [
            "hash"
          ]
        },
        {
          "required": [
            "content"
          ]
        }
      ],
      "properties": {
        "content": {
          "description": "Specifies the archive inline within the document",
          "type": "string",
          "format": "byte",
          "writeOnly": true
        },
        "hash": {
          "description": "Specifies the hash algorithm and value encompassing the entire signed archive",
          "type": "object",
          "required": [
            "algorithm",
            "value"
          ],
          "properties": {
            "algorithm": {
              "description": "The hashing function used to compute the hash value",
              "type": "string",
              "enum": [
                "sha256"
              ]
            },
            "value": {
              "description": "The hash value for the archive",
              "type": "string"
            }
          }
        }
      }
    },
    "JarV001SchemaArchiveHash": {
      "description": "Specifies the hash algorithm and value encompassing the entire signed archive",
      "type": "object",
      "required": [
        "algorithm",
        "value"
      ],
      "properties": {
        "algorithm": {
          "description": "The hashing function used to compute the hash value",
          "type": "string",
          "enum": [
            "sha256"
          ]
        },
        "value": {
          "description": "The hash value for the archive",
          "type": "string"
        }
      }
    },
    "JarV001SchemaSignature": {
      "description": "Information about the included signature in the JAR file",
      "type": "object",
      "required": [
        "publicKey",
        "content"
      ],
      "properties": {
        "content": {
          "description": "Specifies the PKCS7 signature embedded within the JAR file ",
          "type": "string",
          "format": "byte",
          "readOnly": true
        },
        "publicKey": {
          "description": "The X509 certificate containing the public key JAR which verifies the signature of the JAR",
          "type": "object",
          "required": [
            "content"
          ],
          "properties": {
            "content": {
              "description": "Specifies the content of the X509 certificate containing the public key used to verify the signature",
              "type": "string",
              "format": "byte"
            }
          },
          "readOnly": true
        }
      }
    },
    "JarV001SchemaSignaturePublicKey": {
      "description": "The X509 certificate containing the public key JAR which verifies the signature of the JAR",
      "type": "object",
      "required": [
        "content"
      ],
      "properties": {
        "content": {
          "description": "Specifies the content of the X509 certificate containing the public key used to verify the signature",
          "type": "string",
          "format": "byte"
        }
      },
      "readOnly": true
    },
    "LogEntry": {
      "type": "object",
      "additionalProperties": {
        "$ref": "#/definitions/LogEntryAnon"
      }
    },
    "LogEntryAnon": {
      "type": "object",
      "required": [
        "logID",
        "logIndex",
        "body",
        "integratedTime"
      ],
      "properties": {
        "attestation": {
          "type": "object",
          "format": "byte",
          "properties": {
            "data": {
              "format": "byte"
            }
          }
        },
        "body": {
          "type": "object",
          "additionalProperties": true
        },
        "integratedTime": {
          "description": "The time the entry was added to the log as a Unix timestamp in seconds",
          "type": "integer"
        },
        "logID": {
          "description": "This is the SHA256 hash of the DER-encoded public key for the log at the time the entry was included in the log",
          "type": "string",
          "pattern": "^[0-9a-fA-F]{64}$"
        },
        "logIndex": {
          "type": "integer",
          "minimum": 0
        },
        "verification": {
          "type": "object",
          "properties": {
            "inclusionProof": {
              "$ref": "#/definitions/InclusionProof"
            },
            "signedEntryTimestamp": {
              "description": "Signature over the logID, logIndex, body and integratedTime.",
              "type": "string",
              "format": "byte"
            }
          }
        }
      }
    },
    "LogEntryAnonAttestation": {
      "type": "object",
      "format": "byte",
      "properties": {
        "data": {
          "format": "byte"
        }
      }
    },
    "LogEntryAnonVerification": {
      "type": "object",
      "properties": {
        "inclusionProof": {
          "$ref": "#/definitions/InclusionProof"
        },
        "signedEntryTimestamp": {
          "description": "Signature over the logID, logIndex, body and integratedTime.",
          "type": "string",
          "format": "byte"
        }
      }
    },
    "LogInfo": {
      "type": "object",
      "required": [
        "rootHash",
        "treeSize",
        "signedTreeHead",
        "treeID"
      ],
      "properties": {
        "inactiveShards": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/InactiveShardLogInfo"
          }
        },
        "rootHash": {
          "description": "The current hash value stored at the root of the merkle tree",
          "type": "string",
          "pattern": "^[0-9a-fA-F]{64}$"
        },
        "signedTreeHead": {
          "description": "The current signed tree head",
          "type": "string",
          "format": "signedCheckpoint"
        },
        "treeID": {
          "description": "The current treeID",
          "type": "string",
          "pattern": "^[0-9]+$"
        },
        "treeSize": {
          "description": "The current number of nodes in the merkle tree",
          "type": "integer",
          "minimum": 1
        }
      }
    },
    "ProposedEntry": {
      "type": "object",
      "required": [
        "kind"
      ],
      "properties": {
        "kind": {
          "type": "string"
        }
      },
      "discriminator": "kind"
    },
    "RekordV001SchemaData": {
      "description": "Information about the content associated with the entry",
      "type": "object",
      "oneOf": [
        {
          "required": [
            "hash"
          ]
        },
        {
          "required": [
            "content"
          ]
        }
      ],
      "properties": {
        "content": {
          "description": "Specifies the content inline within the document",
          "type": "string",
          "format": "byte",
          "writeOnly": true
        },
        "hash": {
          "description": "Specifies the hash algorithm and value for the content",
          "type": "object",
          "required": [
            "algorithm",
            "value"
          ],
          "properties": {
            "algorithm": {
              "description": "The hashing function used to compute the hash value",
              "type": "string",
              "enum": [
                "sha256"
              ]
            },
            "value": {
              "description": "The hash value for the content",
              "type": "string"
            }
          },
          "readOnly": true
        }
      }
    },
    "RekordV001SchemaDataHash": {
      "description": "Specifies the hash algorithm and value for the content",
      "type": "object",
      "required": [
        "algorithm",
        "value"
      ],
      "properties": {
        "algorithm": {
          "description": "The hashing function used to compute the hash value",
          "type": "string",
          "enum": [
            "sha256"
          ]
        },
        "value": {
          "description": "The hash value for the content",
          "type": "string"
        }
      },
      "readOnly": true
    },
    "RekordV001SchemaSignature": {
      "description": "Information about the detached signature associated with the entry",
      "type": "object",
      "required": [
        "format",
        "publicKey",
        "content"
      ],
      "properties": {
        "content": {
          "description": "Specifies the content of the signature inline within the document",
          "type": "string",
          "format": "byte"
        },
        "format": {
          "description": "Specifies the format of the signature",
          "type": "string",
          "enum": [
            "pgp",
            "minisign",
            "x509",
            "ssh"
          ]
        },
        "publicKey": {
          "description": "The public key that can verify the signature",
          "type": "object",
          "required": [
            "content"
          ],
          "properties": {
            "content": {
              "description": "Specifies the content of the public key inline within the document",
              "type": "string",
              "format": "byte"
            }
          }
        }
      }
    },
    "RekordV001SchemaSignaturePublicKey": {
      "description": "The public key that can verify the signature",
      "type": "object",
      "required": [
        "content"
      ],
      "properties": {
        "content": {
          "description": "Specifies the content of the public key inline within the document",
          "type": "string",
          "format": "byte"
        }
      }
    },
    "Rfc3161V001SchemaTsr": {
      "description": "Information about the tsr file associated with the entry",
      "type": "object",
      "required": [
        "content"
      ],
      "properties": {
        "content": {
          "description": "Specifies the tsr file content inline within the document",
          "type": "string",
          "format": "byte"
        }
      }
    },
    "RpmV001SchemaPackage": {
      "description": "Information about the package associated with the entry",
      "type": "object",
      "oneOf": [
        {
          "required": [
            "hash"
          ]
        },
        {
          "required": [
            "content"
          ]
        }
      ],
      "properties": {
        "content": {
          "description": "Specifies the package inline within the document",
          "type": "string",
          "format": "byte",
          "writeOnly": true
        },
        "hash": {
          "description": "Specifies the hash algorithm and value for the package",
          "type": "object",
          "required": [
            "algorithm",
            "value"
          ],
          "properties": {
            "algorithm": {
              "description": "The hashing function used to compute the hash value",
              "type": "string",
              "enum": [
                "sha256"
              ]
            },
            "value": {
              "description": "The hash value for the package",
              "type": "string"
            }
          }
        },
        "headers": {
          "description": "Values of the RPM headers",
          "type": "object",
          "additionalProperties": {
            "type": "string"
          },
          "readOnly": true
        }
      }
    },
    "RpmV001SchemaPackageHash": {
      "description": "Specifies the hash algorithm and value for the package",
      "type": "object",
      "required": [
        "algorithm",
        "value"
      ],
      "properties": {
        "algorithm": {
          "description": "The hashing function used to compute the hash value",
          "type": "string",
          "enum": [
            "sha256"
          ]
        },
        "value": {
          "description": "The hash value for the package",
          "type": "string"
        }
      }
    },
    "RpmV001SchemaPublicKey": {
      "description": "The PGP public key that can verify the RPM signature",
      "type": "object",
      "required": [
        "content"
      ],
      "properties": {
        "content": {
          "description": "Specifies the content of the public key inline within the document",
          "type": "string",
          "format": "byte"
        }
      }
    },
    "SearchIndex": {
      "type": "object",
      "properties": {
        "email": {
          "type": "string",
          "format": "email"
        },
        "hash": {
          "type": "string",
          "pattern": "^(sha512:)?[0-9a-fA-F]{128}$|^(sha256:)?[0-9a-fA-F]{64}$|^(sha1:)?[0-9a-fA-F]{40}$"
        },
        "operator": {
          "type": "string",
          "enum": [
            "and",
            "or"
          ]
        },
        "publicKey": {
          "type": "object",
          "required": [
            "format"
          ],
          "properties": {
            "content": {
              "type": "string",
              "format": "byte"
            },
            "format": {
              "type": "string",
              "enum": [
                "pgp",
                "x509",
                "minisign",
                "ssh",
                "tuf"
              ]
            }
          }
        }
      }
    },
    "SearchIndexPublicKey": {
      "type": "object",
      "required": [
        "format"
      ],
      "properties": {
        "content": {
          "type": "string",
          "format": "byte"
        },
        "format": {
          "type": "string",
          "enum": [
            "pgp",
            "x509",
            "minisign",
            "ssh",
            "tuf"
          ]
        }
      }
    },
    "SearchLogQuery": {
      "type": "object",
      "properties": {
        "entries": {
          "type": "array",
          "maxItems": 10,
          "minItems": 1,
          "items": {
            "$ref": "#/definitions/ProposedEntry"
          }
        },
        "entryUUIDs": {
          "type": "array",
          "maxItems": 10,
          "minItems": 1,
          "items": {
            "type": "string",
            "pattern": "^([0-9a-fA-F]{64}|[0-9a-fA-F]{80})$"
          }
        },
        "logIndexes": {
          "type": "array",
          "maxItems": 10,
          "minItems": 1,
          "items": {
            "type": "integer",
            "minimum": 0
          }
        }
      }
    },
    "TUFV001SchemaMetadata": {
      "description": "TUF metadata",
      "type": "object",
      "required": [
        "content"
      ],
      "properties": {
        "content": {
          "description": "Specifies the metadata inline within the document",
          "type": "object",
          "additionalProperties": true
        }
      }
    },
    "TUFV001SchemaRoot": {
      "description": "root metadata containing about the public keys used to sign the manifest",
      "type": "object",
      "required": [
        "content"
      ],
      "properties": {
        "content": {
          "description": "Specifies the metadata inline within the document",
          "type": "object",
          "additionalProperties": true
        }
      }
    },
    "alpine": {
      "description": "Alpine package",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "$ref": "#/definitions/alpineSchema"
            }
          },
          "additionalProperties": false
        }
      ]
    },
    "alpineSchema": {
      "description": "Schema for Alpine package objects",
      "type": "object",
      "title": "Alpine Package Schema",
      "oneOf": [
        {
          "$ref": "#/definitions/alpineV001Schema"
        }
      ],
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/alpine/alpine_schema.json"
    },
    "alpineV001Schema": {
      "description": "Schema for Alpine Package entries",
      "type": "object",
      "title": "Alpine v0.0.1 Schema",
      "required": [
        "publicKey",
        "package"
      ],
      "properties": {
        "package": {
          "description": "Information about the package associated with the entry",
          "type": "object",
          "oneOf": [
            {
              "required": [
                "hash"
              ]
            },
            {
              "required": [
                "content"
              ]
            }
          ],
          "properties": {
            "content": {
              "description": "Specifies the package inline within the document",
              "type": "string",
              "format": "byte",
              "writeOnly": true
            },
            "hash": {
              "description": "Specifies the hash algorithm and value for the package",
              "type": "object",
              "required": [
                "algorithm",
                "value"
              ],
              "properties": {
                "algorithm": {
                  "description": "The hashing function used to compute the hash value",
                  "type": "string",
                  "enum": [
                    "sha256"
                  ]
                },
                "value": {
                  "description": "The hash value for the package",
                  "type": "string"
                }
              },
              "readOnly": true
            },
            "pkginfo": {
              "description": "Values of the .PKGINFO key / value pairs",
              "type": "object",
              "additionalProperties": {
                "type": "string"
              },
              "readOnly": true
            }
          }
        },
        "publicKey": {
          "description": "The public key that can verify the package signature",
          "type": "object",
          "required": [
            "content"
          ],
          "properties": {
            "content": {
              "description": "Specifies the content of the public key inline within the document",
              "type": "string",
              "format": "byte"
            }
          }
        }
      },
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/alpine/alpine_v0_0_1_schema.json"
    },
    "cose": {
      "description": "COSE object",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "$ref": "#/definitions/coseSchema"
            }
          },
          "additionalProperties": false
        }
      ]
    },
    "coseSchema": {
      "description": "COSE for Rekord objects",
      "type": "object",
      "title": "COSE Schema",
      "oneOf": [
        {
          "$ref": "#/definitions/coseV001Schema"
        }
      ],
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/cose/cose_schema.json"
    },
    "coseV001Schema": {
      "description": "Schema for cose object",
      "type": "object",
      "title": "cose v0.0.1 Schema",
      "required": [
        "publicKey"
      ],
      "properties": {
        "data": {
          "description": "Information about the content associated with the entry",
          "type": "object",
          "properties": {
            "aad": {
              "description": "Specifies the additional authenticated data required to verify the signature",
              "type": "string",
              "format": "byte",
              "writeOnly": true
            },
            "envelopeHash": {
              "description": "Specifies the hash algorithm and value for the COSE envelope",
              "type": "object",
              "required": [
                "algorithm",
                "value"
              ],
              "properties": {
                "algorithm": {
                  "description": "The hashing function used to compute the hash value",
                  "type": "string",
                  "enum": [
                    "sha256"
                  ]
                },
                "value": {
                  "description": "The hash value for the envelope",
                  "type": "string"
                }
              },
              "readOnly": true
            },
            "payloadHash": {
              "description": "Specifies the hash algorithm and value for the content",
              "type": "object",
              "required": [
                "algorithm",
                "value"
              ],
              "properties": {
                "algorithm": {
                  "description": "The hashing function used to compute the hash value",
                  "type": "string",
                  "enum": [
                    "sha256"
                  ]
                },
                "value": {
                  "description": "The hash value for the content",
                  "type": "string"
                }
              },
              "readOnly": true
            }
          }
        },
        "message": {
          "description": "The COSE Sign1 Message",
          "type": "string",
          "format": "byte",
          "writeOnly": true
        },
        "publicKey": {
          "description": "The public key that can verify the signature",
          "type": "string",
          "format": "byte"
        }
      },
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/cose/cose_v0_0_1_schema.json"
    },
    "dsse": {
      "description": "DSSE envelope",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "$ref": "#/definitions/dsseSchema"
            }
          },
          "additionalProperties": false
        }
      ]
    },
    "dsseSchema": {
      "description": "log entry schema for dsse envelopes",
      "type": "object",
      "title": "DSSE Schema",
      "oneOf": [
        {
          "$ref": "#/definitions/dsseV001Schema"
        }
      ],
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/dsse/dsse_schema.json"
    },
    "dsseV001Schema": {
      "description": "Schema for DSSE envelopes",
      "type": "object",
      "title": "DSSE v0.0.1 Schema",
      "oneOf": [
        {
          "required": [
            "proposedContent"
          ]
        },
        {
          "required": [
            "signatures",
            "envelopeHash",
            "payloadHash"
          ]
        }
      ],
      "properties": {
        "envelopeHash": {
          "description": "Specifies the hash algorithm and value encompassing the entire envelope sent to Rekor",
          "type": "object",
          "required": [
            "algorithm",
            "value"
          ],
          "properties": {
            "algorithm": {
              "description": "The hashing function used to compute the hash value",
              "type": "string",
              "enum": [
                "sha256"
              ]
            },
            "value": {
              "description": "The value of the computed digest over the entire envelope",
              "type": "string"
            }
          },
          "readOnly": true
        },
        "payloadHash": {
          "description": "Specifies the hash algorithm and value covering the payload within the DSSE envelope",
          "type": "object",
          "required": [
            "algorithm",
            "value"
          ],
          "properties": {
            "algorithm": {
              "description": "The hashing function used to compute the hash value",
              "type": "string",
              "enum": [
                "sha256"
              ]
            },
            "value": {
              "description": "The value of the computed digest over the payload within the envelope",
              "type": "string"
            }
          },
          "readOnly": true
        },
        "proposedContent": {
          "type": "object",
          "required": [
            "envelope",
            "verifiers"
          ],
          "properties": {
            "envelope": {
              "description": "DSSE envelope specified as a stringified JSON object",
              "type": "string",
              "writeOnly": true
            },
            "verifiers": {
              "description": "collection of all verification material (e.g. public keys or certificates) used to verify signatures over envelope's payload, specified as base64-encoded strings",
              "type": "array",
              "minItems": 1,
              "items": {
                "type": "string",
                "format": "byte"
              },
              "writeOnly": true
            }
          },
          "writeOnly": true
        },
        "signatures": {
          "description": "extracted collection of all signatures of the envelope's payload; elements will be sorted by lexicographical order of the base64 encoded signature strings",
          "type": "array",
          "minItems": 1,
          "items": {
            "$ref": "#/definitions/DSSEV001SchemaSignaturesItems0"
          },
          "readOnly": true
        }
      },
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/dsse/dsse_v0_0_1_schema.json"
    },
    "hashedrekord": {
      "description": "Hashed Rekord object",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "$ref": "#/definitions/hashedrekordSchema"
            }
          },
          "additionalProperties": false
        }
      ]
    },
    "hashedrekordSchema": {
      "description": "Schema for Hashedrekord objects",
      "type": "object",
      "title": "Hashedrekord Schema",
      "oneOf": [
        {
          "$ref": "#/definitions/hashedrekordV001Schema"
        }
      ],
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/hashedrekord/hasehedrekord_schema.json"
    },
    "hashedrekordV001Schema": {
      "description": "Schema for Hashed Rekord object",
      "type": "object",
      "title": "Hashed Rekor v0.0.1 Schema",
      "required": [
        "signature",
        "data"
      ],
      "properties": {
        "data": {
          "description": "Information about the content associated with the entry",
          "type": "object",
          "properties": {
            "hash": {
              "description": "Specifies the hash algorithm and value for the content",
              "type": "object",
              "required": [
                "algorithm",
                "value"
              ],
              "properties": {
                "algorithm": {
                  "description": "The hashing function used to compute the hash value",
                  "type": "string",
                  "enum": [
                    "sha256",
                    "sha384",
                    "sha512"
                  ]
                },
                "value": {
                  "description": "The hash value for the content, as represented by a lower case hexadecimal string",
                  "type": "string"
                }
              }
            }
          }
        },
        "signature": {
          "description": "Information about the detached signature associated with the entry",
          "type": "object",
          "properties": {
            "content": {
              "description": "Specifies the content of the signature inline within the document",
              "type": "string",
              "format": "byte"
            },
            "publicKey": {
              "description": "The public key that can verify the signature; this can also be an X509 code signing certificate that contains the raw public key information",
              "type": "object",
              "properties": {
                "content": {
                  "description": "Specifies the content of the public key or code signing certificate inline within the document",
                  "type": "string",
                  "format": "byte"
                }
              }
            }
          }
        }
      },
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/rekord/hashedrekord_v0_0_1_schema.json"
    },
    "helm": {
      "description": "Helm chart",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "$ref": "#/definitions/helmSchema"
            }
          }
        }
      ]
    },
    "helmSchema": {
      "description": "Schema for Helm objects",
      "type": "object",
      "title": "Helm Schema",
      "oneOf": [
        {
          "$ref": "#/definitions/helmV001Schema"
        }
      ],
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/helm/helm_schema.json"
    },
    "helmV001Schema": {
      "description": "Schema for Helm object",
      "type": "object",
      "title": "Helm v0.0.1 Schema",
      "required": [
        "publicKey",
        "chart"
      ],
      "properties": {
        "chart": {
          "description": "Information about the Helm chart associated with the entry",
          "type": "object",
          "required": [
            "provenance"
          ],
          "properties": {
            "hash": {
              "description": "Specifies the hash algorithm and value for the chart",
              "type": "object",
              "required": [
                "algorithm",
                "value"
              ],
              "properties": {
                "algorithm": {
                  "description": "The hashing function used to compute the hash value",
                  "type": "string",
                  "enum": [
                    "sha256"
                  ]
                },
                "value": {
                  "description": "The hash value for the chart",
                  "type": "string"
                }
              },
              "readOnly": true
            },
            "provenance": {
              "description": "The provenance entry associated with the signed Helm Chart",
              "type": "object",
              "oneOf": [
                {
                  "required": [
                    "signature"
                  ]
                },
                {
                  "required": [
                    "content"
                  ]
                }
              ],
              "properties": {
                "content": {
                  "description": "Specifies the content of the provenance file inline within the document",
                  "type": "string",
                  "format": "byte",
                  "writeOnly": true
                },
                "signature": {
                  "description": "Information about the included signature in the provenance file",
                  "type": "object",
                  "required": [
                    "content"
                  ],
                  "properties": {
                    "content": {
                      "description": "Specifies the signature embedded within the provenance file ",
                      "type": "string",
                      "format": "byte",
                      "readOnly": true
                    }
                  },
                  "readOnly": true
                }
              }
            }
          }
        },
        "publicKey": {
          "description": "The public key that can verify the package signature",
          "type": "object",
          "required": [
            "content"
          ],
          "properties": {
            "content": {
              "description": "Specifies the content of the public key inline within the document",
              "type": "string",
              "format": "byte"
            }
          }
        }
      },
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/helm/helm_v0_0_1_schema.json"
    },
    "intoto": {
      "description": "Intoto object",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "$ref": "#/definitions/intotoSchema"
            }
          },
          "additionalProperties": false
        }
      ]
    },
    "intotoSchema": {
      "description": "Intoto for Rekord objects",
      "type": "object",
      "title": "Intoto Schema",
      "oneOf": [
        {
          "$ref": "#/definitions/intotoV001Schema"
        },
        {
          "$ref": "#/definitions/intotoV002Schema"
        }
      ],
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/intoto/intoto_schema.json"
    },
    "intotoV001Schema": {
      "description": "Schema for intoto object",
      "type": "object",
      "title": "intoto v0.0.1 Schema",
      "required": [
        "publicKey",
        "content"
      ],
      "properties": {
        "content": {
          "type": "object",
          "properties": {
            "envelope": {
              "description": "envelope",
              "type": "string",
              "writeOnly": true
            },
            "hash": {
              "description": "Specifies the hash algorithm and value encompassing the entire signed envelope; this is computed by the rekor server, client-provided values are ignored",
              "type": "object",
              "required": [
                "algorithm",
                "value"
              ],
              "properties": {
                "algorithm": {
                  "description": "The hashing function used to compute the hash value",
                  "type": "string",
                  "enum": [
                    "sha256"
                  ]
                },
                "value": {
                  "description": "The hash value for the archive",
                  "type": "string"
                }
              },
              "readOnly": true
            },
            "payloadHash": {
              "description": "Specifies the hash algorithm and value covering the payload within the DSSE envelope; this is computed by the rekor server, client-provided values are ignored",
              "type": "object",
              "required": [
                "algorithm",
                "value"
              ],
              "properties": {
                "algorithm": {
                  "description": "The hashing function used to compute the hash value",
                  "type": "string",
                  "enum": [
                    "sha256"
                  ]
                },
                "value": {
                  "description": "The hash value for the envelope's payload",
                  "type": "string"
                }
              },
              "readOnly": true
            }
          }
        },
        "publicKey": {
          "description": "The public key that can verify the signature",
          "type": "string",
          "format": "byte"
        }
      },
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/intoto/intoto_v0_0_1_schema.json"
    },
    "intotoV002Schema": {
      "description": "Schema for intoto object",
      "type": "object",
      "title": "intoto v0.0.2 Schema",
      "required": [
        "content"
      ],
      "properties": {
        "content": {
          "type": "object",
          "required": [
            "envelope"
          ],
          "properties": {
            "envelope": {
              "description": "dsse envelope",
              "type": "object",
              "required": [
                "payloadType",
                "signatures"
              ],
              "properties": {
                "payload": {
                  "description": "payload of the envelope",
                  "type": "string",
                  "format": "byte",
                  "writeOnly": true
                },
                "payloadType": {
                  "description": "type describing the payload",
                  "type": "string"
                },
                "signatures": {
                  "description": "collection of all signatures of the envelope's payload",
                  "type": "array",
                  "minItems": 1,
                  "items": {
                    "$ref": "#/definitions/IntotoV002SchemaContentEnvelopeSignaturesItems0"
                  }
                }
              }
            },
            "hash": {
              "description": "Specifies the hash algorithm and value encompassing the entire signed envelope",
              "type": "object",
              "required": [
                "algorithm",
                "value"
              ],
              "properties": {
                "algorithm": {
                  "description": "The hashing function used to compute the hash value",
                  "type": "string",
                  "enum": [
                    "sha256"
                  ]
                },
                "value": {
                  "description": "The hash value for the archive",
                  "type": "string"
                }
              },
              "readOnly": true
            },
            "payloadHash": {
              "description": "Specifies the hash algorithm and value covering the payload within the DSSE envelope",
              "type": "object",
              "required": [
                "algorithm",
                "value"
              ],
              "properties": {
                "algorithm": {
                  "description": "The hashing function used to compute the hash value",
                  "type": "string",
                  "enum": [
                    "sha256"
                  ]
                },
                "value": {
                  "description": "The hash value of the payload",
                  "type": "string"
                }
              },
              "readOnly": true
            }
          }
        }
      },
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/intoto/intoto_v0_0_2_schema.json"
    },
    "jar": {
      "description": "Java Archive (JAR)",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "$ref": "#/definitions/jarSchema"
            }
          },
          "additionalProperties": false
        }
      ]
    },
    "jarSchema": {
      "description": "Schema for JAR objects",
      "type": "object",
      "title": "JAR Schema",
      "oneOf": [
        {
          "$ref": "#/definitions/jarV001Schema"
        }
      ],
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/jar/jar_schema.json"
    },
    "jarV001Schema": {
      "description": "Schema for JAR entries",
      "type": "object",
      "title": "JAR v0.0.1 Schema",
      "required": [
        "archive"
      ],
      "properties": {
        "archive": {
          "description": "Information about the archive associated with the entry",
          "type": "object",
          "oneOf": [
            {
              "required": [
                "hash"
              ]
            },
            {
              "required": [
                "content"
              ]
            }
          ],
          "properties": {
            "content": {
              "description": "Specifies the archive inline within the document",
              "type": "string",
              "format": "byte",
              "writeOnly": true
            },
            "hash": {
              "description": "Specifies the hash algorithm and value encompassing the entire signed archive",
              "type": "object",
              "required": [
                "algorithm",
                "value"
              ],
              "properties": {
                "algorithm": {
                  "description": "The hashing function used to compute the hash value",
                  "type": "string",
                  "enum": [
                    "sha256"
                  ]
                },
                "value": {
                  "description": "The hash value for the archive",
                  "type": "string"
                }
              }
            }
          }
        },
        "signature": {
          "description": "Information about the included signature in the JAR file",
          "type": "object",
          "required": [
            "publicKey",
            "content"
          ],
          "properties": {
            "content": {
              "description": "Specifies the PKCS7 signature embedded within the JAR file ",
              "type": "string",
              "format": "byte",
              "readOnly": true
            },
            "publicKey": {
              "description": "The X509 certificate containing the public key JAR which verifies the signature of the JAR",
              "type": "object",
              "required": [
                "content"
              ],
              "properties": {
                "content": {
                  "description": "Specifies the content of the X509 certificate containing the public key used to verify the signature",
                  "type": "string",
                  "format": "byte"
                }
              },
              "readOnly": true
            }
          }
        }
      },
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/jar/jar_v0_0_1_schema.json"
    },
    "rekord": {
      "description": "Rekord object",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "$ref": "#/definitions/rekordSchema"
            }
          },
          "additionalProperties": false
        }
      ]
    },
    "rekordSchema": {
      "description": "Schema for Rekord objects",
      "type": "object",
      "title": "Rekor Schema",
      "oneOf": [
        {
          "$ref": "#/definitions/rekordV001Schema"
        }
      ],
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/rekord/rekord_schema.json"
    },
    "rekordV001Schema": {
      "description": "Schema for Rekord object",
      "type": "object",
      "title": "Rekor v0.0.1 Schema",
      "required": [
        "signature",
        "data"
      ],
      "properties": {
        "data": {
          "description": "Information about the content associated with the entry",
          "type": "object",
          "oneOf": [
            {
              "required": [
                "hash"
              ]
            },
            {
              "required": [
                "content"
              ]
            }
          ],
          "properties": {
            "content": {
              "description": "Specifies the content inline within the document",
              "type": "string",
              "format": "byte",
              "writeOnly": true
            },
            "hash": {
              "description": "Specifies the hash algorithm and value for the content",
              "type": "object",
              "required": [
                "algorithm",
                "value"
              ],
              "properties": {
                "algorithm": {
                  "description": "The hashing function used to compute the hash value",
                  "type": "string",
                  "enum": [
                    "sha256"
                  ]
                },
                "value": {
                  "description": "The hash value for the content",
                  "type": "string"
                }
              },
              "readOnly": true
            }
          }
        },
        "signature": {
          "description": "Information about the detached signature associated with the entry",
          "type": "object",
          "required": [
            "format",
            "publicKey",
            "content"
          ],
          "properties": {
            "content": {
              "description": "Specifies the content of the signature inline within the document",
              "type": "string",
              "format": "byte"
            },
            "format": {
              "description": "Specifies the format of the signature",
              "type": "string",
              "enum": [
                "pgp",
                "minisign",
                "x509",
                "ssh"
              ]
            },
            "publicKey": {
              "description": "The public key that can verify the signature",
              "type": "object",
              "required": [
                "content"
              ],
              "properties": {
                "content": {
                  "description": "Specifies the content of the public key inline within the document",
                  "type": "string",
                  "format": "byte"
                }
              }
            }
          }
        }
      },
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/rekord/rekord_v0_0_1_schema.json"
    },
    "rfc3161": {
      "description": "RFC3161 Timestamp",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "$ref": "#/definitions/rfc3161Schema"
            }
          },
          "additionalProperties": false
        }
      ]
    },
    "rfc3161Schema": {
      "description": "Schema for RFC 3161 timestamp objects",
      "type": "object",
      "title": "Timestamp Schema",
      "oneOf": [
        {
          "$ref": "#/definitions/rfc3161V001Schema"
        }
      ],
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/rfc3161/rfc3161_schema.json"
    },
    "rfc3161V001Schema": {
      "description": "Schema for RFC3161 entries",
      "type": "object",
      "title": "Timestamp v0.0.1 Schema",
      "required": [
        "tsr"
      ],
      "properties": {
        "tsr": {
          "description": "Information about the tsr file associated with the entry",
          "type": "object",
          "required": [
            "content"
          ],
          "properties": {
            "content": {
              "description": "Specifies the tsr file content inline within the document",
              "type": "string",
              "format": "byte"
            }
          }
        }
      },
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/timestamp/timestamp_v0_0_1_schema.json"
    },
    "rpm": {
      "description": "RPM package",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "$ref": "#/definitions/rpmSchema"
            }
          },
          "additionalProperties": false
        }
      ]
    },
    "rpmSchema": {
      "description": "Schema for RPM objects",
      "type": "object",
      "title": "RPM Schema",
      "oneOf": [
        {
          "$ref": "#/definitions/rpmV001Schema"
        }
      ],
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/rpm/rpm_schema.json"
    },
    "rpmV001Schema": {
      "description": "Schema for RPM entries",
      "type": "object",
      "title": "RPM v0.0.1 Schema",
      "required": [
        "publicKey",
        "package"
      ],
      "properties": {
        "package": {
          "description": "Information about the package associated with the entry",
          "type": "object",
          "oneOf": [
            {
              "required": [
                "hash"
              ]
            },
            {
              "required": [
                "content"
              ]
            }
          ],
          "properties": {
            "content": {
              "description": "Specifies the package inline within the document",
              "type": "string",
              "format": "byte",
              "writeOnly": true
            },
            "hash": {
              "description": "Specifies the hash algorithm and value for the package",
              "type": "object",
              "required": [
                "algorithm",
                "value"
              ],
              "properties": {
                "algorithm": {
                  "description": "The hashing function used to compute the hash value",
                  "type": "string",
                  "enum": [
                    "sha256"
                  ]
                },
                "value": {
                  "description": "The hash value for the package",
                  "type": "string"
                }
              }
            },
            "headers": {
              "description": "Values of the RPM headers",
              "type": "object",
              "additionalProperties": {
                "type": "string"
              },
              "readOnly": true
            }
          }
        },
        "publicKey": {
          "description": "The PGP public key that can verify the RPM signature",
          "type": "object",
          "required": [
            "content"
          ],
          "properties": {
            "content": {
              "description": "Specifies the content of the public key inline within the document",
              "type": "string",
              "format": "byte"
            }
          }
        }
      },
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/rpm/rpm_v0_0_1_schema.json"
    },
    "tuf": {
      "description": "TUF metadata",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/ProposedEntry"
        },
        {
          "required": [
            "apiVersion",
            "spec"
          ],
          "properties": {
            "apiVersion": {
              "type": "string",
              "pattern": "^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$"
            },
            "spec": {
              "$ref": "#/definitions/tufSchema"
            }
          },
          "additionalProperties": false
        }
      ]
    },
    "tufSchema": {
      "description": "Schema for TUF metadata objects",
      "type": "object",
      "title": "TUF Schema",
      "oneOf": [
        {
          "$ref": "#/definitions/tufV001Schema"
        }
      ],
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/tuf/tuf_schema.json"
    },
    "tufV001Schema": {
      "description": "Schema for TUF metadata entries",
      "type": "object",
      "title": "TUF v0.0.1 Schema",
      "required": [
        "metadata",
        "root"
      ],
      "properties": {
        "metadata": {
          "description": "TUF metadata",
          "type": "object",
          "required": [
            "content"
          ],
          "properties": {
            "content": {
              "description": "Specifies the metadata inline within the document",
              "type": "object",
              "additionalProperties": true
            }
          }
        },
        "root": {
          "description": "root metadata containing about the public keys used to sign the manifest",
          "type": "object",
          "required": [
            "content"
          ],
          "properties": {
            "content": {
              "description": "Specifies the metadata inline within the document",
              "type": "object",
              "additionalProperties": true
            }
          }
        },
        "spec_version": {
          "description": "TUF specification version",
          "type": "string",
          "readOnly": true
        }
      },
      "$schema": "http://json-schema.org/draft-07/schema",
      "$id": "http://rekor.sigstore.dev/types/tuf/tuf_v0_0_1_schema.json"
    }
  },
  "responses": {
    "BadContent": {
      "description": "The content supplied to the server was invalid",
      "schema": {
        "$ref": "#/definitions/Error"
      }
    },
    "Conflict": {
      "description": "The request conflicts with the current state of the transparency log",
      "schema": {
        "$ref": "#/definitions/Error"
      },
      "headers": {
        "Location": {
          "type": "string",
          "format": "uri"
        }
      }
    },
    "InternalServerError": {
      "description": "There was an internal error in the server while processing the request",
      "schema": {
        "$ref": "#/definitions/Error"
      }
    },
    "NotFound": {
      "description": "The content requested could not be found"
    },
    "UnprocessableEntity": {
      "description": "The server understood the request but is unable to process the contained instructions",
      "schema": {
        "$ref": "#/definitions/Error"
      }
    }
  }
}`))
}
