/* Copyright (c) 1996-2004, Adaptec Corporation
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 * - Neither the name of the Adaptec Corporation nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __RSCENUM_H
#define __RSCENUM_H
/******************************************
 ** FILE: RSCENUM.H
 **
 ** DATE: 6/23/1999
 ******************************************/

/******************************************
 ** STRINGS                              **
 ******************************************/
enum StringNames {
	//     STR_DPT                           = 0,
	//     STR_COPYRIGHT                     = 1,
	//     STR_PROG_TITLE                    = 2,
	//     STR_VERSION                       = 3,
	STR_DPTUTIL,
	STR_RAIDUTIL,
	STR_DPT_UTIL,
	STR_RAID_UTIL,
	STR_DPTUTIL_ALL_CAPS,
	STR_RAIDUTIL_ALL_CAPS,
	STR_DPT_ENGINE,
	STR_ADPT_ENGINE,
	STR_VERSION_DATE,
	STR_FILLIN_DATE,
	STR_FILLIN_VERSION,
	STR_DPTUTIL_SHORT_DESCRIP,
	STR_RAIDUTIL_SHORT_DESCRIP,
	STR_USAGE_PROGRAM_DESC_TITLE,
	STR_USAGE_SW_TITLE, 
	STR_USAGE_SW_CREATE_LOGICAL,
	STR_USAGE_SW_CREATE_LOGICAL2,
	STR_USAGE_SW_IGNORE_NONFATAL_ERRORS,
	STR_USAGE_SW_DELETE_LOGICAL,
	STR_USAGE_SW_CREATE_HOT_SPARE,
	STR_USAGE_SW_DELETE_HOT_SPARE,
	STR_USAGE_SW_ALARM,
	STR_USAGE_SW_ACTION_TASK_CONTROL,
	STR_USAGE_EXPAND_ARRAY,
	STR_USAGE_LOAD_SAVE_CONFIGURATION,
	STR_USAGE_SW_WRITE_CACHING,
	STR_USAGE_SW_RESET_CLEAR_RAID_STORE,
	STR_USAGE_SW_RESET_NVRAM_CONFIG,
	STR_USAGE_SW_LIST_DEVICES_PHYSICAL,
	STR_USAGE_SW_LIST_DEVICES_LOGICAL,
	STR_USAGE_SW_LIST_DEVICES_CONTROLLER,
	STR_USAGE_SW_LIST_DEVICES_SPARE,
	STR_USAGE_SW_LIST_DEVICES_RAID,
	STR_USAGE_SW_LIST_DEVICES_SPEED,
	STR_USAGE_SW_LIST_DEVICES_CACHE,
	STR_USAGE_SW_LIST_DEVICES_VERSION,
	STR_USAGE_SW_LIST_DEVICES_REDIRECT,
	STR_USAGE_SW_LIST_BATTERY,
	STR_USAGE_SW_LIST_DEVICES_ALL,
	STR_USAGE_SW_DISPLAY_INQ_INFO,
	STR_USAGE_SW_QUIET_MODE,
	STR_USAGE_SW_PAGENATION,
	STR_USAGE_SW_SHOW_UTIL_USAGE,
	STR_USAGE_SW_SPECIFY_DPT,
	STR_USAGE_SW_SPECIFY_CTLR,
	STR_USAGE_SW_RAID_LEVEL,
	STR_USAGE_SW_LOGICAL_DRIVE_CAPACITY,
	STR_USAGE_SW_LOGICAL_DRIVE_STRIPE_SIZE,
	STR_USAGE_SW_TASK_RATE,
	STR_USAGE_VIEW_LOG,
	STR_USAGE_FORCE_STATE,
	STR_USAGE_CLUSTER_SUPPORT,
	STR_USAGE_SAMPLE_TITLE,
	STR_USAGE_SAMPLE_QUIET_MODE,
	STR_USAGE_SAMPLE_SHOW_USAGE,
	// begin of defines in rscstrs.h
	STR_USAGE_SAMPLE_CREATE_LOGICAL,
	STR_USAGE_SAMPLE_DELETE_LOGICAL,
	STR_USAGE_SAMPLE_CREATE_HOT_SPARE,
	STR_USAGE_SAMPLE_DELETE_HOT_SPARE,
	STR_USAGE_SAMPLE_LIST_DEVICES,
	STR_USAGE_SAMPLE_DISPLAY_INQUIRY_INFO,
	STR_USAGE_SAMPLE_RESET_NVRAM,
	STR_USAGE_LEGEND_2,
	STR_REBOOT,
	STR_USAGE_SW_FLASH,
	// end of defines in rscstrs.h
	STR_USAGE_SYNTAX,
	STR_USAGE_LEGEND_1,
	STR_ALARM_STATUS_HEADER,
	STR_LIST_DEV_PHYS_HEADER,
	STR_LIST_DEV_ARRAY_HEADER,
	STR_LIST_DEV_STATUS_HEADER,
	STR_LIST_DEV_HOT_SPARE_HEADER,
	//   STR_LIST_DEV_LOG_HEADER,
	STR_LIST_DEV_CTLR_HEADER,
	STR_LIST_BATTERY_HEADER,
	STR_LIST_DEV_VERSION_HEADER,
	STR_LIST_DEV_SET_RATE_HEADER,
	STR_LIST_TAGS_HEADER,
	STR_BUS_SPEED_HEADER,
	STR_LIST_DEV_SPEED_HEADER,
	STR_LIST_TASKS,
	STR_LIST_CACHE_STALE_HEADER,
	STR_LIST_CACHE_HEADER,
	STR_LIST_CLUSTER_HEADER,
	STR_LIST_CLUSTER_FUA_HEADER,
	STR_LIST_HS_SAME_CHANNEL_HEADER,
	STR_LIST_INQUIRY_HEADER,
	STR_LIST_SEGMENT_HEADER,
	STR_LIST_INQUIRY_HEADER_MAP1,
	STR_LIST_INQUIRY_HEADER_MAP2,
	STR_LIST_INQUIRY_HEADER_MAP3,
	STR_LIST_INQUIRY_HEADER_MAP4,
	STR_LIST_INQUIRY_HEADER_MAP5,
	STR_LIST_INQUIRY_HEADER_MAP6,
	STR_LIST_INQUIRY_HEADER_MAP7,
	STR_LIST_INQUIRY_HEADER_MAP8,
	STR_LIST_INQUIRY_HEADER_MAP9,
	STR_LIST_INQUIRY_HEADER_MAP10,
	STR_LIST_INQUIRY_HEADER_MAP11,
	STR_LIST_INQUIRY_HEADER_MAP12,
	STR_LIST_INQUIRY_HEADER_KEY,
	STR_INQ_TITLE,
	STR_NVRAM_RESET,
	STR_OK,
	STR_YES,
	STR_NO,
	STR_ABORT,
	//     STR_RETRY                         = 8,
	//     STR_CONTINUE                      = 9,
	//     STR_CANCEL                        = 10,
	//     STR_ACCEPT                        = 11,
	//     STR_RESET                         = 12,
	//     STR_SKIP                          = 13,
	//     STRT_PREVIOUS                     = 14,
	//     STRT_FILE                         = 15,
	//     STRT_OPTIONS                      = 16,
	//     STRT_INSTALLATION                 = 17,
	//     STRT_COMMUNICATIONS               = 18,
	//     STRT_HELP                         = 19,
	//     STRT_READ_SYS_CONFIG              = 20,
	//     STRT_SET_SYS_CONFIG               = 21,
	//     STRT_LOAD_CONFIG                  = 22,
	//     STRT_SAVE_CONFIG                  = 23,
	//     STRT_EXIT                         = 24,
	//     STRT_SET_HBA_THROTTLE             = 25,
	//     STRT_DISABLE_ALARM                = 26,
	//     STRT_QUIET_BUS                    = 27,
	//     STRT_INITIAL_SETUP                = 28,
	//     STRT_DOS_SETUP                    = 29,
	//     STRT_MAKE_CONNECTION              = 30,
	//     STRT_LEGEND_ICONS                 = 31,
	//     STRT_INDEX                        = 32,
	//     STRT_CONTACT                      = 33,
	//     STRT_SYS_INFO                     = 34,
	//     STRT_ABOUT                        = 35,
	//     STRT_CREATE_RAID                  = 36,
	//     STRT_MODIFY_RAID                  = 37,
	//     STRT_SWITCH_VIEW                  = 38,
	//     STRT_INCLUDE_DRIVE                = 39,
	//     STRT_DONE                         = 40,
	//     STRT_REMOVE_DRIVE                 = 41,
	//     STRT_EXIT_INSTALL                 = 42,
	//     STR_DECIMAL                       = 43,
	//     STR_PROG_EXIT                     = 44,
	STR_FAILED,                        //= 45,
	//     STR_RAID_5_GROUP                  = 46,
	STR_WARNING,                       //= 47,
	//     STR_RAID_0_GROUP                  = 48,
	//     STR_RAID_1_GROUP                  = 49,
	STR_MISSING,                       //= 50,
	STR_REMOVED,
	STR_ADDED,
	//     STR_LOG_SU                        = 51,
	//     STR_HOTSPARE                      = 52,
	//     STR_LSU                           = 53,
	STR_SCSI_PRINTER,
	STR_SCSI_PROCESSOR,
	//     STR_PROCESSOR                     = 56,
	STR_SCSI_WORM,
	STR_SCSI_CD_ROM,
	STR_SCSI_SCANNER,
	STR_SCSI_OPTICAL,
	STR_SCSI_JUKEBOX,
	STR_SCSI_PRO_ROOT,
	STR_SCSI_PRO_CONNECTION,
	//     STR_COMMUN                        = 62,
	STR_UNKNOWN,
	STR_UNCHANGED,
	STR_UNSUPPORTED,
	//     STR_DISK                          = 64,
	//     STR_FLOPTICAL                     = 65,
	//     STR_KB                            = 66,
	STR_MB,
	//     STR_DESCRIPTION                   = 68,
	//     STR_LEGEND_ICONS                  = 69,
	//     STR_LEGEND_FLAGS                  = 70,
	//     STR_HOST_ADAPTER                  = 71,
	//     STR_CHIPSET                       = 72,
	//     STR_RAID_MOD                      = 73,
	//     STR_CACHE_MOD                     = 74,
	//     STR_MEMORY_MOD                    = 75,
	//     STR_CACHE_MEM_MOD                 = 76,
	//     STR_HARD_DRIVE                    = 77,
	//     STR_SETUP_FOR                     = 78,
	//     STR_RAID_GROUP                    = 79,
	//     STR_FAULT_TOL                     = 80,
	//     STR_DRIVE_FT                      = 81,
	//     STR_NO_FT                         = 82,
	//     STR_OPTIMIZATION                  = 83,
	//     STR_OPT_CAPACITY                  = 84,
	//     STR_OPT_PERFORM                   = 85,
	//     STR_CHOSEN_RAID                   = 86,
	STR_STRIPE_SIZE,
	//     STR_OVERRIDE                      = 88,
	//     STR_OVERRIDE_RAID                 = 89,
	//     STR_RAID_LEVEL                    = 90,
	//     STR_NONE                          = 91,
	//     STR_8_KB                          = 92,
	//     STR_16_KB                         = 93,
	//     STR_32_KB                         = 94,
	//     STR_64_KB                         = 95,
	//     STR_128_KB                        = 96,
	//     STR_256_KB                        = 97,
	//     STR_512_KB                        = 98,
	//     STR_1_MB                          = 99,
	//     STR_RAID_DASH                     = 100,
	STR_RAID_HOT_SPARE,
	STR_RAID,
	STR_RAID_0,
	STR_RAID_1,
	STR_RAID_5,
	STR_RAID_10,
	STR_RAID_50,
	//     STR_8_KB_RA                       = 104,
	//     STR_16_KB_RA                      = 105,
	//     STR_32_KB_RA                      = 106,
	//     STR_64_KB_RA                      = 107,
	//     STR_128_KB_RA                     = 108,
	//     STR_256_KB_RA                     = 109,
	//     STR_512_KB_RA                     = 110,
	//     STR_1_MB_RA                       = 111,
	//     STR_NOT_INSTALLED                 = 112,
	//     STR_SYSTEM_INFO                   = 113,
	//     STR_CMOS_SETTINGS                 = 114,
	//     STR_LOGICAL_PARMS                 = 115,
	//     STR_DRIVE                         = 116,
	//     STR_DRIVE_0                       = 117,
	//     STR_DRIVE_1                       = 118,
	//     STR_SROM_VERSION                  = 119,
	//     STR_ENGINE_VERSION                = 120,
	//     STR_DRIVER_NAME                   = 121,
	//     STR_DRIVER_VERSION                = 122,
	//     STR_ADDRESS                       = 123,
	STR_DEVICE,
	STR_NOT_PRESENT,
	//     STR_BASE_MEMORY                   = 125,
	//     STR_EXTEND_MEMORY                 = 126,
	//     STR_HELP                          = 127,
	//     STR_SCANNING_1                    = 128,
	//     STR_SCANNING_2                    = 129,
	//     STR_DOS_SETUP                     = 130,
	//     STR_NO_DOS                        = 131,
	//     STR_NO_CDROM_DRIVERS              = 132,
	//     STR_CHG_CONFIG                    = 133,
	//     STR_TOO_MANY                      = 134,
	//     STR_CHG_AUTOEXEC                  = 135,
	//     STR_NO_CAPACITY                   = 136,
	STR_MANUFACTURER,
	STR_MODEL,
	//     STR_CACHE                         = 138,
	//     STR_FIRMWARE_COLON                = 139,
	//     STR_IRQ                           = 140,
	//     STR_HEX                           = 141,
	//     STR_HBA_INFO                      = 142,
	//     STR_DMA                           = 143,
	//     STR_PRIMARY                       = 144,
	//     STR_SECONDARY                     = 145,
	//     STR_EDGE                          = 146,
	//     STR_LEVEL                         = 147,
	//     STR_BUS_MASTER                    = 148,
	//     STR_8_BIT                         = 149,
	//     STR_16_BIT                        = 150,
	//     STR_SINGLE_END                    = 151,
	//     STR_DIFFERENTIAL                  = 152,
	//     STR_LVD_SINGLE                    = 153,
	STR_FIBRE,
	//     STR_ADDR_HBA                      = 155,
	STR_BUS,
	STR_ID,
	//     STR_LUN                           = 158,
	//     STR_CAPACITY                      = 159,
	//     STR_STATUS                        = 160,
	//     STR_RAID_INFO                     = 161,
	//     STR_SCSI_INFO                     = 162,
	STR_REMOVABLE,
	//     STR_CAPABILITIES                  = 164,
	//     STR_REL_ADDR                      = 165,
	STR_WIDE,
	STR_NARROW,
	//     STR_WIDE_16                       = 166,
	//     STR_WIDE_32                       = 167,
	//     STR_SYNC                          = 168,
	//     STR_LINKED                        = 169,
	//     STR_CMD_Q                         = 170,
	//     STR_SOFT_RESET                    = 171,
	//     STR_ESTIMATED                     = 172,
	//     STR_RAID_LEVEL_COLON              = 173,
	//     STR_TRANSFER                      = 174,
	//     STR_MB_SECOND                     = 175,
	STR_FORMAT,
	//     STRT_MAKE_HOTSPARE                = 177,
	//     STRT_PRINT                        = 178,
	//     STRT_DIAGS                        = 179,
	//     STRT_VIEW_LOG                     = 180,
	//     STRT_REPORTS                      = 181,
	//     STRT_STATISTICS                   = 182,
	//     STRT_MOD_CONFIG                   = 183,
	//     STRT_MOD_AUTOEXEC                 = 184,
	//     STRT_CREATE_BAT                   = 185,
	//     STR_INCOMPLETE                    = 186,
	STR_INCOMPLETE_ENTRY,
	//     STR_NONE_CHOSEN                   = 187,
	//     STR_SCSI_BUS                      = 188,
	//     STR_BRIDGE                        = 189,
	//     STR_REREAD                        = 190,
	//     STR_COPY_FILES                    = 191,
	//     STR_PHYSICAL                      = 192,
	STR_BLOCKS,
	//     STR_SIZE                          = 194,
	//     STR_BYTES                         = 195,
	//     STR_NA                            = 196,
	STR_REV,
	//     STR_MEMBER_OF                     = 198,
	//     STR_CONTROLLER                    = 199,
	//     STR_HOST_BUS                      = 200,
	STR_TYPE,
	//     STR_MB_SEC_MAX                    = 202,
	//     STR_WIDTH                         = 203,
	//     STR_SCSI_ID                       = 204,
	//     STR_FIBRE_ID                      = 205,
	//     STR_ATTACHED_MOD                  = 206,
	//     STR_PHYSICAL_CONFIG               = 207,
	//     STR_LOGICAL_CONFIG                = 208,
	//     STR_CREATING_ARRAY                = 209,
	STR_ARRAY_MODIFY,
	STR_RAID_TYPE,
	//     STR_SELECT_ARRAY_TYPE             = 211,
	//     STR_SCSI_DIAGS                    = 212,
	//     STR_TEST_DURATION                 = 213,
	//     STR_ITERATIONS                    = 214,
	//     STR_CONTINUOUS                    = 215,
	//     STR_TESTS_PERFORMED               = 216,
	//     STR_DEVICE_BUFFER                 = 217,
	//     STR_MEDIA_READ                    = 218,
	//     STR_MEDIA_RW                      = 219,
	//     STR_TARGET_SECTORS                = 220,
	//     STR_ALL_SECTORS                   = 221,
	//     STR_RANDOM_SECTORS                = 222,
	//     STR_STOP_ON_ERROR                 = 223,
	//     STR_PASS                          = 224,
	//     STR_ERRORS                        = 225,
	//     STR_TOTAL_TIME                    = 226,
	//     STRT_RUN_TEST                     = 227,
	//     STRT_STOP_TEST                    = 228,
	//     STR_DIAGPCT                       = 229,
	//     STR_1KB_STAT                      = 230,
	//     STR_2KB_STAT                      = 231,
	//     STR_4KB_STAT                      = 232,
	//     STR_8KB_STAT                      = 233,
	//     STR_16KB_STAT                     = 234,
	//     STR_32KB_STAT                     = 235,
	//     STR_64KB_STAT                     = 236,
	//     STR_128KB_STAT                    = 237,
	//     STR_256KB_STAT                    = 238,
	//     STR_512KB_STAT                    = 239,
	//     STR_1MB_STAT                      = 240,
	//     STR_TOTAL_STAT                    = 241,
	//     STR_FORMAT_WARN                   = 242,
	//     STR_FORMAT_OPTIONS                = 243,
	//     STR_CREATE_DISK                   = 244,
	//     STR_FORMAT_DISKETTE               = 245,
	//     STR_PROTECTED_RAID0               = 246,
	//     STR_PROTECTED_RAID1               = 247,
	//     STR_PROTECTED_RAID5               = 248,
	//     STRT_HOTSPARES                    = 249,
	//     STRT_REMOVE_HOTSPARE              = 250,
	//     STR_CURRENT_MEDIA                 = 251,
	//     STR_NO_MEDIA                      = 252,
	//     STR_NOW_QUIET                     = 253,
	//     STR_EVENT_LOGS                    = 254,
	//     STRT_EVENT_LOG                    = 255,
	//     STR_NAME_COLON                    = 256,
	//     STR_NAME                          = 257,
	//     STRT_BUILD                        = 258,
	//     STR_NAME_ARRAY                    = 259,
	//     STR_CHOOSE_NAME                   = 260,
	//     STR_NAME_USED                     = 261,
	//     STR_DPT_INSTALL                   = 262,
	//     STR_INSTALL_6                     = 263,
	//     STR_INSTALL_11                    = 264,
	//     STR_SCSI_BUSES                    = 265,
	//     STR_NO_CMOS_FLOPPY                = 266,
	//     STR_NO_DRIVERS                    = 267,
	//     STR_CHOOSE_TARGET                 = 268,
	//     STR_INSERT_BLANK                  = 269,
	//     STR_FORMAT_FAILURE                = 270,
	//     STR_WRITING                       = 271,
	//     STR_HDW_ERROR_DESC                = 272,
	//     STR_HDW_ERROR                     = 273,
	//     STR_SET_CONFIG_WARN               = 274,
	//     STR_NO_OS2_DOS_BOX                = 275,
	//     STR_REQ_SMARTROM                  = 276,
	//     STR_OFFER_REBOOT                  = 277,
	//     STR_WHICH_VERSION                 = 278,
	//     STR_SELECT_OS                     = 279,
	//     STR_CHOOSE_OS_FAMILY              = 280,
	//     STR_AVAIL_CONN                    = 281,
	//     STR_UNSAVED                       = 282,
	//     STR_INTERNAL_ERROR                = 283,
	//     STR_IE_CONTACT                    = 284,
	//     STR_SEARCH_ENGINES                = 285,
	//     STR_NUM_STRIPES                   = 286,
	//     STR_COMPONENTS                    = 287,
	//     STRT_VERIFY_ARRAY                 = 288,
	//     STR_DESTINATION                   = 289,
	//     STR_LPT1                          = 290,
	//     STR_LPT2                          = 291,
	//     STR_PRINT_SETTINGS                = 292,
	//     STR_FILE_COLON                    = 293,
	//     STR_APPEND_FILE                   = 294,
	//     STRP_DEVICE_TYPE                  = 295,
	//     STR_PRINTER_NOT_READY             = 296,
	//     STR_HLP_MISSING                   = 297,
	//     STR_NO_SPECIFIC_HELP              = 298,
	//     STRT_CONTINUE_C                   = 299,
	//     STR_NO_RAID_CAP                   = 300,
	//     STR_LOAD_CLASS_DRV                = 301,
	//     STR_CHOOSE_DONE                   = 302,
	STR_PARSE_ERR_INVALID_STRIPE_SIZE,
	STR_PARSE_ERR_INVALID_TASK_RATE,
	STR_PARSE_ERR_INVALID_SPEED,
	STR_PARSE_ERR_UNDEFINED_SWITCH,
	STR_PARSE_ERR_DRIVE_CAPACITY_MUST_BE_INTEGER,
	STR_PARSE_ERR_CTLR_DESGINATIONS_NOT_SUPPORTED,
	STR_PARSE_ERR_SWITCH_MULTIPLY_DEFINED,
	STR_PARSE_ERR_MUST_BE_INTEGER_VALUE,
	STR_PARSE_ERR_NOT_A_VALID_LIST_TYPE,
	STR_PARSE_ERR_MUST_SPECIFY_HBA,
	STR_PARSE_ERR_MUST_SPECIFY_ADDRESS,
	STR_PARSE_ERR_MUST_SPECIFY_ALL_OR_LIST,
	STR_PARSE_ERR_UNIMPLEMENTED_COMMAND,
	STR_PARSE_ERR_INVALID_CMD_OR_OPTION_TO_CMD,
	STR_PARSE_ERR_MUST_SUPPLY_IMAGE,
	STR_PARSE_ERR_MUST_SUPPLY_FILE_NAME,
	STR_PARSE_ERR_MUST_SUPPLY_ASCII_DATA,
	STR_PARSE_ERR_ASCII_DATA_TOO_LONG,
	STR_CMD_PARSER_ERROR,
	STR_CMD_ERR_INVALID_LIST_TYPE,
	STR_CMD_ERR_CANT_FIND_COMPONENT,
	STR_CMD_ERR_CANT_FIND_HBA_INDEX,
	STR_CMD_ERR_CANT_FIND_HBA_INDEX_NVRAM,
	STR_CMD_ERR_COMPONENT_BUSY,
	STR_CMD_ERR_INVALID_FLASH_IMAGE,
	STR_ERR_VALUE_OUT_OF_RANGE,
	STR_ERR_INVALID_FILE,
	STR_ERR_INVALID_RAID_TYPE,
	STR_ERR_NOT_ENOUGH_MEMORY,
	STR_CMD_ERR_CMD_NOT_POSS_ON_RAID,
	STR_CMD_ERR_CMD_NOT_POSS_ON_HBA,
	STR_CMD_ERR_CMD_NOT_POSS_ON_THIS_DEVICE,
	STR_ERR_POSS_BUFFER_CORRUPTION,
	STR_MSG_RTN_COMPLETED,
	STR_MSG_RTN_STARTED,
	STR_MSG_RTN_FAILED,
	STR_MSG_RTN_DATA_OVERFLOW,
	STR_MSG_RTN_DATA_UNDERFLOW,
	STR_MSG_RTN_IGNORED,
	STR_MSG_RTN_DISCONNECT,
	STR_ERR_CONN_LIST_ALLOC,
	STR_ERR_SEMAPHORE_ALLOC,
	STR_ERR_OSD_OPEN_ENGINE,
	STR_ERR_INVALID_IO_METHOD,
	STR_ERR_NO_SMARTROM,
	STR_ERR_ENGINE_INIT,
	STR_ERR_INVALID_CONN_TAG,
	STR_ERR_SEMAPHORE_TIMEOUT,
	STR_ERR_NULL_IO_BUFFER,
	STR_ERR_INVALID_TGT_TAG,
	STR_ERR_DESTROY_SEMAPHORE,
	STR_ERR_MEM_ALLOC,
	STR_ERR_INVALID_DEV_ADDR,
	STR_ERR_DUPLICATE_NAME,
	STR_ERR_GET_CCB,
	STR_ERR_NO_RAID_DEVICES,
	STR_ERR_RESERVE_BLK_SIG,
	STR_ERR_FORMAT_BLK_SIZE,
	STR_ERR_RAID_REFNUM,
	STR_ERR_RAID_COMP_DUPLICATE,
	STR_ERR_RAID_COMP_RESTRICT,
	STR_ERR_RAID_COMP_USED,
	STR_ERR_RAID_COMP_GHOST,
	STR_ERR_RAID_COMP_FAILED,
	STR_ERR_RAID_TOO_FEW,
	STR_ERR_RAID_TOO_MANY,
	STR_ERR_RAID_EVEN,
	STR_ERR_RAID_ODD,
	STR_ERR_RAID_POWER_2_PLUS,
	STR_ERR_RAID_CHAN_COUNT,
	STR_ERR_RAID_MIN_STRIPE,
	STR_ERR_RAID_MAX_STRIPE,
	STR_ERR_RAID_ZERO_STRIPES,
	STR_ERR_RAID_TOO_LARGE,
	STR_ERR_RAID_START_CHAN,
	STR_ERR_RAID_SEQ_CHAN,
	STR_ERR_RAID_DIFF_STRIPES,
	STR_ERR_RAID_DIFF_NUM_STR,
	STR_ERR_RAID_OVER_STRIPE,
	STR_ERR_RAID_COMP_REMOVE,
	STR_ERR_RAID_COMP_EMULATED,
	STR_ERR_RAID_COMP_DEVTYPE,
	STR_ERR_RAID_COMP_NON_512,
	STR_ERR_RAID_DIFF_BLOCKS,
	STR_ERR_RAID_DIFF_CAPACITY,
	STR_ERR_RAID_DIFF_VENDOR,
	STR_ERR_RAID_DIFF_PRODUCT,
	STR_ERR_RAID_DIFF_REVISION,
	STR_ERR_RAID_NOT_SUPPORTED,
	STR_ERR_RAID_INVALID_HBA,
	STR_ERR_RAID_TABLE_REQUIRED,
	STR_ERR_RAID_COMP_TAG,
	STR_ERR_RAID_MAX_ARRAYS,
	STR_ERR_RAID_COMP_SIZE,
	STR_ERR_RAID_FW_LEVEL,
	STR_ERR_INVALID_HBA_ADDR,
	STR_ERR_ISA_ADDR_ONLY,
	STR_ERR_PRIMARY_HBA_EXISTS,
	STR_ERR_NO_MORE_SLOTS,
	STR_ERR_DUP_ISA_ADDR,
	STR_ERR_DUP_EISA_SLOT,
	STR_ERR_PRIMARY_ISA_ADDR,
	STR_ERR_SECONDARY_ISA_ADDR,
	STR_ERR_ABS_NO_MORE_IDS,
	STR_ERR_ABS_NON_ZERO_LUN,
	STR_ERR_ABS_ADDR_LIMITS,
	STR_ERR_ABS_ADDR_OCCUPIED,
	STR_ERR_ABS_NO_MORE_LUNS,   
	STR_ERR_NEW_ARTIFICIAL,     
	STR_ERR_IO_NOT_SUPPORTED,   
	STR_ERR_RW_EXCEEDS_CAPACITY,
	STR_ERR_DATA_IN_OUT,
	STR_ERR_SCSI_CMD_FAILED,
	STR_ERR_ARTIFICIAL_IO,  
	STR_ERR_SCSI_IO,        
	STR_ERR_BLINK_LED_IO,
	STR_ERR_OSD_MEM_ALLOC,
	STR_ERR_FORMATTING,
	STR_ERR_HBA_BUSY,        
	STR_ERR_HBA_INITIALIZING,
	STR_ERR_DEL_OLD_RAID,
	STR_ERR_ENABLE_NEW_RAID,
	STR_ERR_UPDATE_OS_CONFIG,
	STR_ERR_SCSI_ADDR_BOUNDS,  
	STR_ERR_SCSI_ADDR_CONFLICT,
	STR_ERR_CANNOT_DELETE,     
	STR_ERR_FWD_NO_SPACE,
	STR_ERR_FWD_NOT_RESERVED,
	STR_ERR_FWD_NOT_INITIALIZED,
	STR_ERR_FWD_BLK_MISMATCH,   
	STR_ERR_FWD_BLK_OVERFLOW,   
	STR_ERR_RSV_REMOVEABLE,
	STR_ERR_RSV_NOT_DASD,  
	STR_ERR_RSV_NON_ZERO,  
	STR_ERR_RSV_HBA_UNABLE,
	STR_ERR_RSV_OTHER,     
	STR_ERR_SCAN_PHYSICALS,
	STR_ERR_INIT_PHYSICALS,
	STR_ERR_SCAN_LOGICALS,   
	STR_ERR_INIT_LOGICALS,   
	STR_ERR_COMM_XMIT_BUFFER,
	STR_ERR_COMM_RCVE_BUFFER,
	STR_ERR_COMM_DISCONNECTED, 
	STR_ERR_COMM_DATA_OVERFLOW,
	STR_ERRC_T_OPEN,           
	STR_ERRC_T_BIND,           
	STR_ERRC_T_ALLOC,
	STR_ERRC_T_CONNECT,   
	STR_ERRC_T_LISTEN,    
	STR_ERRC_T_ACCEPT,    
	STR_ERRC_COMM_NW_INIT,
	STR_ERRC_COMM_WS_INIT,
	STR_ERRC_SEMAPHORE_TIMEOUT,
	STR_ERRC_CONNECTION_TAG,   
	STR_ERRC_NOT_NULL_TERMED,  
	STR_ERRC_MEM_ALLOC,        
	STR_ERRC_NULL_IO_BUFFER,
	STR_ERRC_INVALID_PASSWORD,
	STR_ERRC_NOT_LOGGED_IN,   
	STR_ERRC_ENGINE_LOAD,    
	STR_ERRC_NOT_SUPPORTED,   
	STR_ERRC_ICRS_ACTIVE,
	STR_ERRC_ICRS_INACTIVE, 
	STR_ERRC_ICRS_REQ_POSTED,   
	STR_ERRC_ICRS_THREAD_START, 
	STR_ERRC_ICRS_START_REQUEST,
	STR_ERRC_ICRS_INIT,
	STR_ERRC_ACCEPTING_ICR,
	STR_ERRC_TX_MSG_SYNC,  
	STR_ERRC_RX_MSG_ACK,   
	STR_ERRC_RX_MSG_HEADER,
	STR_ERRC_TX_MSG_HEADER,
	STR_ERRC_TX_TO_ENG_DATA,  
	STR_ERRC_RX_TO_ENG_DATA,  
	STR_ERRC_RX_STATUS_HEADER,
	STR_ERRC_TX_STATUS_HEADER,
	STR_ERRC_RX_FROM_ENG_DATA,
	STR_ERRC_TX_FROM_ENG_DATA,
	STR_ERRC_FROM_ENG_SIZE,   
	STR_ERRC_TO_ENG_SIZE,     
	STR_ERRC_SERIAL_INIT,     
	STR_ERRC_BAUD_RATE,
	STR_ERRC_COMM_BUSY,
	STR_ERRC_INVALID_PROTOCOL,
	STR_ERRC_PORT_CONFLICT,
	STR_ERRC_MODEM_INIT,      
	STR_ERRC_DIAL_ABORT,
	STR_ERRC_DIAL_TIMEOUT,      
	STR_ERRC_DIAL_BUSY,         
	STR_ERRC_DIAL_BEEPER_OK,    
	STR_ERRC_DIAL_UNEXPECTED_CD,
	STR_ERRC_DIAL_NO_TONE,
	STR_ERRC_DIAL_NO_ANSWER,
	STR_ERRC_DIAL_ERROR,    
	STR_ERRC_NEGOTIATION,   
	STR_ERRC_MSG_TIMEOUT,   
	STR_ERRC_USER_ABORT,
	STR_ERRSPX_RD_PROPERTY,
	STR_ERRSPX_SAP,
	STR_ERRC_SOCKET_ALLOC,
	STR_ERRC_SOCKET_BIND,  
	STR_ERRC_SOCKET_ACCEPT,
	STR_ERRC_SOCKET_CONNECT,
	STR_ERRC_USER_VALIDATION,
	STR_ERR_FLASH_ERASE,       
	STR_ERR_FLASH_SWITCH_MODES,
	STR_ERR_FLASH_WRITE_512,
	STR_ERR_FLASH_ENG_VERIFY,
	STR_ERR_FLASH_INIT_REQ,  
	STR_ERR_EXCLUSION_TIME,  
	STR_ERR_DIAG_SCHEDULED,  
	STR_ERR_DIAG_NOT_ACTIVE,
	STR_ERR_ELOG_NOT_LOADED,
	STR_ERR_ELOG_LOADED,    
	STR_ERR_ELOG_EVENTS,    
	STR_ERR_ELOG_PAUSED,    
	STR_ERR_ELOG_NOT_PAUSED,
	STR_ERR_SLOG_INVALID_TIME,
	STR_ERR_SLOG_STAT_GROUP,           
	STR_ERR_ALMS_ALREADY_LINKED,       
	STR_ERR_ALMS_NOT_LINKED,           
	STR_ERR_ALMS_INVALID_RESOURCE_TYPE,
	STR_ERR_UNKNOWN_ERROR,
	 STR_NO_ERROR,
	 STR_ER,
	 STR_SEL_TIMEOUT,
	 STR_CMD_TIMEOUT,
	 STR_BUS_RESET,
	 STR_POWER_UP,
	 STR_UNX_PHASE,
	 STR_UNX_FREE,
	 STR_BUS_PARITY,
	 STR_SCSI_HUNG,
	 STR_UNX_MESSAGE,
	 STR_BUS_STUCK,
	 STR_AUTO_FAILED,
	 STR_RAM_PARITY,
	 STR_POWER_SUPPLY,
	 STR_COOLING_ELEM,
	 STR_FAN,
	 STR_FAILURE,
	//     STR_ABT_NON_ACT                   = 316,
	//     STR_ABT_ACT                       = 317,
	//     STR_RST_NON_ACT                   = 318,
	//     STR_RST_ACT                       = 319,
	//     STR_RAM_ECC                       = 320,
	//     STR_PCI_PRTY                      = 321,
	//     STR_PCI_MST_ABORT                 = 322,
	//     STR_PCI_TGT_ABORT                 = 323,
	//     STR_PCI_SIG_ABORT                 = 324,
	//     STR_HBAERR_RESERVED_0             = 325,
	//     STR_HBAERR_RESERVED_1             = 326,
	//     STR_HBAERR_RESERVED_2             = 327,
	//     STR_HBAERR_RESERVED_3             = 328,
	//     STR_HBAERR_RESERVED_4             = 329,
	//     STR_HBAERR_RESERVED_5             = 330,
	//     STR_HBAERR_RESERVED_6             = 331,
	//     STR_HBAERR_RESERVED_7             = 332,
	//     STR_HBAERR_RESERVED_8             = 333,
	//     STR_HBAERR_RESERVED_9             = 334,
	 STR_GOOD,                          //= 335,
	 STR_CHECK_COND,                    //= 336,
	 STR_COND_MET,                      //= 337,
	 STR_BUSY,                          //= 338,
	 STR_INTERMEDIATE,                  //= 339,
	 STR_INT_COND_MET,                  //= 340,
	 STR_RESERV_CONFLICT,               //= 341,
	 STR_CMD_TERMINATED,                //= 342,
	STR_QUEUE_FULL,
	STR_QUEUE_FROZEN,

	//     STRT_REBUILD                      = 344,
	////     STR_BUILD                         = 345,
	//     STRT_VERIFY                       = 346,
	 STR_LOG_OVERFLOW,                  //= 347,
	 STR_BAD_SCSI,                      //= 348,
	 STR_REQ_SENSE,                     //= 349,
	 STR_HBA_ERROR,                     //= 350,
	 STR_BLOCK_REASSIGN,                //= 351,
	 STR_RAM_ERR_ADDR,                  //= 352,
	 STR_HBA_TIME_CHG,                  //= 353,
	 STR_OLD,                           //= 354,
	 STR_NEW,                           //= 355,
	 STR_CONFIG_UPDATE,                 //= 356,
	 STR_FIRMWARE,                      //= 357,
	 STR_SOFTWARE,                      //= 358,
	//     STR_DRIVE_CRASH                   = 359,
	 STR_STARTED,                       //= 360,
	 STR_STOPPED,                       //= 361,
	STR_COMPLETED,
	 STR_DATA_INC,                      //= 362,
	 STR_BLOCK,                         //= 363,
	 STR_COUNT,                         //= 364,
	 STR_LOCK,                          //= 365,
	 STR_NO_LOG_ENTRIES,
	 STR_DRIVE_FAILURE,                 //= 367,
	//     STR_RESTART_MAC                   = 368,
	//     STR_CFG_HBA                       = 369,
	//     STR_SCSI_TERMPWR                  = 370,
	//     STR_SCAM                          = 371,
	//     STR_TERMINATION                   = 372,
	 STR_ON,
	 STR_OFF,
	 STR_ON_WRITE_BACK,
	 STR_OFF_WRITE_THRU,
	 STR_WRITE_BACK,
	 STR_WRITE_THRU,
	//     STR_HIGH_ONLY                     = 375,
	//     STR_SCSI_XFER                     = 376,
	//     STR_XFER_RATE                     = 377,
	 STR_ASYNC,
	 STR_5MHZ,
	 STR_8MHZ,
	 STR_10MHZ,
	 STR_20MHZ,
	 STR_40MHZ,
	 STR_80MHZ,
	 STR_FILLIN_MHZ,
	 STR_FILLIN_GHZ,
	 STR_FILLIN_MB_PER_SEC,
	 STR_FILLIN_MV,
	 STR_FILLIN_MA,
	 STR_FILLIN_MAH,
	 STR_FILLIN_HRS,
	//     STR_PCI_BURST                     = 385,
	//     STR_AUTO                          = 386,
	//     STR_32LW                          = 387,
	//     STR_64LW                          = 388,
	//     STR_128LW                         = 389,
	//     STR_EXT_CABLE                     = 390,
	//     STR_ENABLED_5                     = 391,
	//     STR_DISABLED_10                   = 392,
	//     STR_DISABLED_20                   = 393,
	//     STR_BUS_ON_TIME                   = 394,
	STR_CMD_LINE_TASK_RATE_SLOW,
	STR_CMD_LINE_TASK_RATE_MEDSLOW,
	STR_CMD_LINE_TASK_RATE_MED,
	STR_CMD_LINE_TASK_RATE_MEDFAST,
	STR_CMD_LINE_TASK_RATE_FAST,
	STR_CMD_LINE_LOG_SOFT,
	STR_CMD_LINE_LOG_RECOV,
	STR_CMD_LINE_LOG_NONRECOV,
	STR_CMD_LINE_LOG_STATUS,
	STR_CMD_LINE_LOG_DELETE,
	STR_CMD_LINE_LOG_BOARD,
	STR_CMD_LINE_TASK_BUILD,
	STR_CMD_LINE_TASK_REBUILD,
	STR_CMD_LINE_TASK_STOP,
	STR_CMD_LINE_TASK_LIST,
	STR_CMD_LINE_TASK_VERIFY,
	STR_CMD_LINE_TASK_VERIFY_NO_FIX, // HIDDEN!!!!!!
	STR_CMD_LINE_OPTIMAL,
	STR_CMD_LINE_FAIL,
	STR_CMD_LINE_LOAD,
	STR_CMD_LINE_SAVE,
	// note that this contains the singular and plural of each list type.  This is due
	// to the inconsistency in the command-line spec, it specifies some items as singular,
	// some as plural.
	// If your language only needs singular or plural, then set both singular and plural
	// strings to the same value.
	STR_CMD_LINE_PHYSICAL,
	STR_CMD_LINE_PHYSICALS,
	STR_CMD_LINE_LOGICAL,
	STR_CMD_LINE_LOGICALS,
	STR_CMD_LINE_CONTROLLER,
	STR_CMD_LINE_CONTROLLERS,
	STR_CMD_LINE_SPARE,
	STR_CMD_LINE_SPARES,
	STR_CMD_LINE_HOTSPARE,
	STR_CMD_LINE_HOTSPARES,
	STR_CMD_LINE_ARRAY,
	STR_CMD_LINE_ARRAYS,
	STR_CMD_LINE_ALL,
	STR_CMD_LINE_ALL_VENDOR,
	STR_CMD_LINE_SPEED,
	STR_CMD_LINE_REDIRECT,
	STR_CMD_LINE_CACHE,
	STR_CMD_LINE_VERSION,
	STR_CMD_LINE_INQUIRY,
	STR_CMD_LINE_INQUIRY_VENDOR,
	STR_CMD_LINE_BATTERY,
	STR_CMD_LINE_DRIVE,
	STR_CMD_LINE_TAGS,
	STR_CMD_LINE_ARRAYNAME,
	//     STR_IO_ADDR                       = 397,
	//     STR_HBA_ADDR                      = 398,
	//     STR_DMA_CHANNEL                   = 399,
	//     STR_DMA_SPEED                     = 400,
	//     STR_PCI_PARITY                    = 401,
	//     STR_SCSI_CMD_Q                    = 402,
	//     STR_EXT_PCI_REQ                   = 403,
	//     STR_GREEN_MODE                    = 404,
	//     STR_FLOPPY_ENABLED                = 405,
	//     STR_LA17_CRAP                     = 406,
	//     STR_CACHING                       = 407,
	//     STRT_FLASH                        = 408,
	//     STRT_APPLY                        = 409,
	//     STRT_DEFAULTS                     = 410,
	//     STR_10MBS                         = 411,
	//     STR_8MBS                          = 412,
	//     STR_6_6MBS                        = 413,
	//     STR_5_7MBS                        = 414,
	//     STR_5_0MBS                        = 415,
	//     STR_4_4MBS                        = 416,
	//     STR_4_0MBS                        = 417,
	//     STR_3_0MBS                        = 418,
	//     STR_8K                            = 419,
	//     STR_16K                           = 420,
	//     STR_32K                           = 421,
	//     STR_64K                           = 422,
	//     STR_ALL                           = 423,
	//     STR_HBA_CACHING                   = 424,
	//     STR_NO_HBAS                       = 425,
	//     STR_IRQ_12                        = 426,
	//     STR_IRQ_14                        = 427,
	//     STR_IRQ_15                        = 428,
	 STR_DISABLED,                      //= 429,
	//     STR_DRQ_5                         = 430,
	//     STR_DRQ_6                         = 431,
	//     STR_DRQ_7                         = 432,
	//     STR_START_NT_SERVICE              = 433,
	//     STR_VIEW_NT_EVENTS                = 434,
	//     STR_ZAP_INSTRUCT                  = 435,
	//     STR_OUT_OF_RANGE                  = 436,
	//     STR_COLD_BOOT                     = 437,
	//     STR_DRIVES_ASSIGNED               = 438,
	//     STR_AND                           = 439,
	//     STR_ACCESS_DENIED                 = 440,
	//     STR_PASSWORD                      = 441,
	//     STR_ENTER_PASSWORD                = 442,
	//     STR_LOCAL                         = 443,
	//     STR_RAIDBCD_INFO                  = 444,
	//     STR_VERSION_COLON                 = 445,
	//     STR_HARDWARE                      = 446,
	//     STR_IDENTIFIER                    = 447,
	//     STR_REDUNDANT_CONT                = 448,
	//     STR_DATE                          = 449,
	//     STR_STRIPE                        = 450,
	STR_FORMATTING,
	//     STR_RAID1_BUILD                   = 452,
	//     STR_COPY_DIRECTION                = 453,
	//     STR_CHG_DIRECTION                 = 454,
	//     STR_START_COPY                    = 455,
	//     STR_COPY                          = 456,
	//     STR_CLEAR_BOTH                    = 457,
	//     STR_PHYSICAL_MAP                  = 458,
	//     STR_LOGICAL_MAP                   = 459,
	//     STR_ONBOARD                       = 460,
	//     STR_BANK                          = 461,
	//     STRT_ALARM_OFF                    = 462,
	STR_ALARM,
	//     STR_SCSIBCD_INFO                  = 464,
	//     STR_NOT_CONNECTED                 = 465,
	//     STR_NEED_CONNECTION               = 466,
	//     STR_CONNECTION_LOST               = 467,
	//     STR_NO_LONGER_CONNECTED           = 468,
	//     STR_RETURN_TO_AVAILABLE           = 469,
	//     STR_RETURN_TO_PHONEBOOK           = 470,
	//     STR_SET_HBA_THROTTLE              = 471,
	//     STR_FOREGROUND                    = 472,
	//     STR_BACKGROUND                    = 473,
	//     STR_DOS_VERSION                   = 474,
	//     STR_LOADED_HIGH                   = 475,
	//     STR_DPMI_VERSION                  = 476,
	//     STR_MEMORY_EXP                    = 477,
	//     STR_SIMM_MODULE                   = 478,
	STR_SCSI_BRIDGE_CTLR,
	STR_RAID_BRIDGE_CTLR,
	//     STR_NO_DISPLAY                    = 480,
	//     STR_READING_IMAGE                 = 481,
	//     STR_IS_OS                         = 482,
	//     STR_CDD_CANT_HANDLE               = 483,
	//     STR_CDD_READ_ERROR                = 484,
	//     STR_CDD_CORRUPT                   = 485,
	//     STR_FMT_WRITE_PROTECT             = 486,
	//     STR_FMT_NOT_READY                 = 487,
	//     STR_FMT_FAILURE                   = 488,
	//     STR_TRY_AGAIN                     = 489,
	//     STR_WRITING_DISKETTE              = 490,
	//     STR_ERROR_WRITING_DD              = 491,
	//     STR_REPLACE_SMDISK                = 492,
	//     STRT_MAKE_OPTIMAL                 = 493,
	//     STRT_STOP_VERIFY                  = 494,
	//     STRT_STOP_BUILD                   = 495,
	//     STR_DD_INSTRUCTIONS               = 496,
	//     STRT_USING_NO_MOUSE               = 497,
	//     STRT_PULL_DOWNS                   = 498,
	//     STRT_FUNCTION_BTNS                = 499,
	//     STRT_DELETE_ARRAY                 = 500,
	//     STR_PLEASE_WAIT                   = 501,
	//     STR_ALL_DATA_LOST                 = 502,
	//     STR_LOAD_CONFIG_WARN              = 503,
	//     STR_INSTALL_REMOTE                = 504,
	//     STR_CANNOT_DETERMINE              = 505,
	//     STR_PROCESSOR_COLON               = 506,
	//     STR_OPERATING_SYSTEM              = 507,
	 STR_IMPACTED,                      //= 508,
	//     STR_CANNOT_OPEN_FILE              = 509,
	//     STR_FILE_OVERWRITE                = 510,
	//     STR_FILENAME                      = 511,
	//     STR_FILENAME_COLON                = 512,
	//     STR_WARNING_COLON                 = 513,
	//     STR_DEFAULT_SETTINGS              = 514,
	//     STR_DRIVER_ROLLED_IN              = 515,
	//     STR_UPON_RETURN                   = 516,
	//     STR_FOUND_OS_ERRORS               = 517,
	//     STR_OS_CONF_ERRORS                = 518,
	//     STR_BAD_ENGINE_VERSION            = 519,
	//     STR_DIAG_STOP_USER                = 520,
	//     STR_DIAG_RUNNING                  = 521,
	//     STR_DIAG_PAUSED                   = 522,
	//     STR_DIAG_COMPLETED                = 523,
	//     STR_DIAG_STOP_ERROR               = 524,
	//     STR_DIAG_INVALID                  = 525,
	 STR_BLANK,                         //= 526,
	//     STRT_NEW_TEST                     = 527,
	//     STR_BUFFER_READ                   = 528,
	//     STR_BUFFER_RW                     = 529,
	//     STR_VERIFY_INFO                   = 530,
	//     STR_ITERATION_COLON               = 531,
	//     STR_ARRAY_STATS                   = 532,
	//     STR_HD_STATS                      = 533,
	//     STR_READ_STATS                    = 534,
	//     STR_TOTAL_SECTORS                 = 535,
	//     STR_CACHE_HITS                    = 536,
	//     STR_CACHE_MISSES                  = 537,
	//     STR_READ_AHEAD_HITS               = 538,
	//     STR_WRITE_STATS                   = 539,
	//     STR_WRITE_BACKS                   = 540,
	//     STR_WRITE_THRUS                   = 541,
	//     STR_PROP_HEAD_STUFF               = 542,
	//     STR_STRIPES_CROSSED               = 543,
	//     STR_IO_COMMANDS                   = 544,
	//     STR_READS                         = 545,
	//     STR_WRITES                        = 546,
	//     STR_TOTAL                         = 547,
	//     STRT_CLEAR                        = 548,
	//     STR_HBA_STATS                     = 549,
	//     STR_CACHE_STATS                   = 550,
	//     STR_TOTAL_PAGES                   = 551,
	//     STR_USED_PAGES                    = 552,
	//     STR_DIRTY_PAGES                   = 553,
	//     STR_READ_AHEAD_PAGES              = 554,
	//     STR_ECC_FAULT_PAGES               = 555,
	//     STR_COMMANDS                      = 556,
	//     STR_TOTAL_COMMANDS                = 557,
	//     STR_MISALIGNED                    = 558,
	//     STR_SCSI_BUS_RESETS               = 559,
	//     STR_ADD_ADDL_DEVICES              = 560,
	//     STR_ADD_ADDL_DONE                 = 561,
	//     STR_NO_INITIAL                    = 562,
	//     STRT_VIEW_README                  = 563,
	//     STR_OS_SETTINGS                   = 564,
	//     STR_VIEWING_FILE                  = 565,
	 STR_STATUS_CHANGE,                 //= 566,
	//     STR_OLD_COLON                     = 567,
	//     STR_NEW_COLON                     = 568,
	//     STR_LOGGER_NOT_LOADED             = 569,
	//     STR_EVENT_LOGGING_NOTIFICATION    = 570,
	//     STRT_EVENT_LOGGING                = 571,
	//     STR_FIRST_DONE                    = 572,
	//     STR_LOG_LOAD_BAD                  = 573,
	//     STR_COPY_SM_FILES                 = 574,
	//     STR_OVERWRITE_SM_FILES            = 575,
	//     STR_MSCDEX_MSG                    = 576,
	//     STR_CANT_CONNECT                  = 577,
	 STR_BUILDING,                      //= 578,
	 STR_BUILD_PENDING,
	//     STR_FUTURE_DW_CONFIG              = 579,
	//     STR_DW_CONFIG_NOT_DONE            = 580,
	//     STR_FLOPT_TOO_SMALL               = 581,
	//     STR_FLOPT_TOO_BIG                 = 582,
	//     STR_FLOPT_OPTIONS                 = 583,
	//     STR_FORMAT_MEDIA                  = 584,
	//     STR_DOS_FORMAT                    = 585,
	//     STR_FLOPT_BOOTABLE                = 586,
	//     STR_FLOPT_NON_BOOTABLE            = 587,
	//     STR_USE_SYS                       = 588,
	//     STR_EVENT_LOGGING                 = 589,
	//     STR_TIME_INTERVAL                 = 590,
	//     STR_MINUTES_120                   = 591,
	//     STR_RECORD_EVENTS_TO_FILE         = 592,
	//     STR_NOTIFICATION                  = 593,
	//     STR_BROADCAST_TO_USERS            = 594,
	//     STR_LOG_TO_SYSTEM_FILE            = 595,
	//     STR_EMAIL_TO_USERS                = 596,
	//     STR_SEND_TO_DEVICES               = 597,
	//     STR_REDIRECT_SCSI_ID              = 598,
	//     STR_NEW_SCSI_ID                   = 599,
	//     STR_MOD_CREATED_CONFLICT          = 600,
	//     STR_DW_COMPLETE                   = 601,
	//     STR_ORG_CONFIG                    = 602,
	//     STR_ORG_AUTOEXEC                  = 603,
	//     STR_ORG_SYSTEMINI                 = 604,
	//     STRT_REDIRECT                     = 605,
	//     STR_DW_ANYTIME                    = 606,
	//     STRT_VIEW_README2                 = 607,
	//     STR_PROMPT_REF                    = 608,
	//     STR_FLOPT_NO_FORMAT               = 609,
	 STR_OPTIMAL,                       //= 610,
	 STR_CREATED,
	//     STR_MISSING_NO_CONFIG             = 611,
	 STR_CURRENT_CREATE,                //= 612,
	//     STR_MISSING_NO_ATTACH             = 613,
	//     STR_NO_INFORMATION                = 614,
	//     STR_LOG_NOT_REMOTE                = 615,
	//     STRT_STOP_LOGGER                  = 616,
	//     STRT_START_LOGGER                 = 617,
	//     STRT_UNLOAD_LOGGER                = 618,
	//     STR_PP_EMU_ONLY                   = 619,
	//     STR_PP_NO_SMARTROM                = 620,
	//     STR_PP_REQ_ALL_SECONDARY          = 621,
	//     STR_PP_NO_LEVEL                   = 622,
	//     STR_PP_NO_LUNS                    = 623,
	//     STR_PP_EISA_ONLY                  = 624,
	//     STR_PP_NO_ISA_EISA                = 625,
	//     STR_TAPE_DRIVE                    = 626,
	//     STR_PP_NO_SUPPORT                 = 627,
	//     STR_PP_DEV_TOO_MANY               = 628,
	//     STR_PP_DEV_WRONG_ID               = 629,
	//     STR_PP_NO_STRIPING                = 630,
	//     STR_SEND_LOGGER                   = 631,
	STR_DEVICES,
	//     STR_NOTE_THRESHOLD                = 633,
	//     STR_USERS                         = 634,
	STR_RAID_REDIRECT,
	//     STR_REDIRECTED                    = 635,
	//     STR_PP_EISA_SLOTS                 = 636,
	//     STR_PP_TOO_MANY_HBAS              = 637,
	//     STR_PP_UNLESS_RAID                = 638,
	//     STR_PP_HBA_REQ_ADDR               = 639,
	//     STR_PP_BAD_HBA_ADDR               = 640,
	//     STR_PP_1F0_PRIMARY                = 641,
	//     STR_THRESHOLD_1                   = 642,
	//     STR_THRESHOLD_2                   = 643,
	//     STR_THRESHOLD_3                   = 644,
	//     STR_THRESHOLD_4                   = 645,
	//     STR_LOG_INSTRUCTIONS              = 646,
	//     STR_DISPLAY_THRESHOLD             = 647,
	//     STRT_CLEAR_LOG                    = 648,
	//     STR_PROCESSOR_EXEP                = 649,
	//     STR_FIRMWARE_EXEP                 = 650,
	//     STR_POWER_UP_FAIL                 = 651,
	//     STR_FIRMWARE_ERROR                = 652,
	//     STR_BLINKLED                      = 653,
	//     STR_BLINK_80                      = 654,
	//     STR_BLINK_81                      = 655,
	//     STR_BLINK_82                      = 656,
	//     STR_BLINK_83                      = 657,
	//     STR_BLINK_84                      = 658,
	//     STR_BLINK_86                      = 659,
	//     STR_BLINK_87                      = 660,
	//     STR_BLINK_RESET_STUCK             = 661,
	//     STR_BLINK_71                      = 662,
	//     STR_BLINK_72                      = 663,
	//     STR_BLINK_73                      = 664,
	//     STR_BLINK_74                      = 665,
	////     STR_BLINK_UNDEF                   = 666,
	////     STR_BLINK_HWERR                   = 667,
	////     STR_BLINK_0X12                    = 668,
	////     STR_BLINK_0X15                    = 669,
	////     STR_BLINK_0X16                    = 670,
	////     STR_BLINK_0X17                    = 671,
	////     STR_BLINK_PCIXFERERR              = 672,
	////     STR_BLINK_PCIPARERR               = 673,
	////     STR_BLINK_PCICFGERR               = 674,
	////     STR_BLINK_ECCMISMATCH             = 675,
	////     STR_BLINK_MEMPM3XXX               = 676,
	////     STR_BLINK_MEMPM2XXX               = 677,
	////     STR_BLINK_DOMMISMATCH             = 678,
	////     STR_BLINK_DOMINVALID              = 679,
	////     STR_BLINK_UNSUPP_SG               = 680,
	////     STR_BLINK_NVRAM_CLR               = 681,
	////     STR_BLINK_CACHE_INV               = 682,
	////     STR_BLINK_CACHE_MIS               = 683,
	////     STR_BLINK_CACHE_OUT               = 684,
	////     STR_BLINK_HW_FAIL1                = 685,
	////     STR_BLINK_HW_FAIL2                = 686,
	////     STR_BLINK_HW_FAIL3                = 687,
	////     STR_BLINK_HW_UNKNOWN              = 688,
	////     STR_BLINK_OS_TASK_FAIL            = 689,
	////     STR_BLINK_OS_HISR_FAIL            = 690,
	////     STR_BLINK_OS_QUECR_FAIL           = 691,
	////     STR_BLINK_OS_SEM_FAIL             = 692,
	////     STR_BLINK_OS_LISR_FAIL            = 693,
	////     STR_BLINK_OS_QUEUE_FAIL           = 694,
	////     STR_BLINK_OS_ERR_LOOP             = 695,
	////     STR_BLINK_OS_GEN_ERR              = 696,
	//     STR_COULD_NOT_CREATE              = 697,
	//     STR_STAT_INVALID                  = 698,
	 STR_STAT_1,                        //= 699,
	 STR_STAT_2,                        //= 700,
	 STR_STAT_3,                        //= 701,
	 STR_STAT_4,                        //= 702,
	 STR_STAT_5,                        //= 703,
	 STR_STAT_6,                        //= 704,
	 STR_STAT_7,                        //= 705,
	 STR_STAT_8,                        //= 706,
	 STR_STAT_9,                        //= 707,
	 STR_STAT_10,                       //= 708,
	 STR_STAT_11,                       //= 709,
	 STR_STAT_12,                       //= 710,
	 STR_STAT_13,                       //= 711,
	 STR_STAT_14,                       //= 712,
	 STR_STAT_15,                       //= 713,
	 STR_STAT_16,                       //= 714,
	 STR_STAT_17,                       //= 715,
	 STR_STAT_18,                       //= 716,
	 STR_STAT_19,                       //= 717,
	 STR_STAT_20,                       //= 718,
	 STR_STAT_21,                       //= 719,
	 STR_STAT_22,                       //= 720,
	 STR_STAT_23,                       //= 721,
	 STR_STAT_24,                       //= 722,
	 STR_STAT_25,                       //= 723,
	 STR_STAT_26,                       //= 724,
	 STR_STAT_27,                       //= 725,
	 STR_PARAMETER_MISMATCH,
	 STR_REPLACED_FORMAT,
	 STR_DRIVE_FAILED,
	 STR_STAT_31,                       //= 729,
	 STR_STAT_32,                       //= 730,
	 STR_STAT_33,                       //= 731,
	 STR_STAT_34,                       //= 732,
	 STR_STAT_35,                       //= 733,
	//     STR_OSS_OS2                       = 734,
	//     STR_OSS_UNIX                      = 735,
	//     STR_OSS_NETWARE_286               = 736,
	//     STR_OSS_NETWARE_386               = 737,
	//     STR_OSS_SCO_UNIX                  = 738,
	//     STR_PROC_8086                     = 739,
	//     STR_PROC_80286                    = 740,
	//     STR_PROC_80386                    = 741,
	//     STR_PROC_80486                    = 742,
	//     STR_PROC_PENTIUM                  = 743,
	//     STR_PROC_PENTIUM_PRO              = 744,
	//     STR_NEW_ARRAY_NO_COVERAGE         = 745,
	//     STR_HS_NO_PROTECT                 = 746,
	//     STR_HS_SOME_PROTECT               = 747,
	//     STR_WINDOWS_PATH                  = 748,
	//     STR_INT24_WRITE_PROTECT           = 749,
	//     STR_INT24_UNKNOWN_UNIT            = 750,
	//     STR_INT24_NOT_READY               = 751,
	//     STR_INT24_GENERIC                 = 752,
	//     STR_INT24_DATA_ERROR              = 753,
	//     STR_INT24_SEEK_ERROR              = 754,
	//     STR_INT24_UNKNOWN_MEDIA_TYPE      = 755,
	//     STR_INT24_SECTOR_NOT_FOUND        = 756,
	//     STR_PRINT_NO_FILENAME             = 757,
	//     STR_PRINT_TO_CONSOLE              = 758,
	STR_SYS_CONSOLE,
	//     STR_NO_SPACE_FOR_RAID_TABLE       = 759,
	//     STR_HBA_NO_RAID_MODULE            = 760,
	//     STR_NO_WINDOWS_IN_PATH            = 761,
	//     STR_FORMAT_UNSUCCESSFUL           = 762,
	//     STR_PRINTED_BY                    = 763,
	//     STR_TEXT_MISSING                  = 764,
	//     STR_TEXT_IMPACTED                 = 765,
	//     STR_TEXT_WARNING                  = 766,
	//     STR_TEXT_FAILED                   = 767,
	//     STR_TEXT_BUILDING                 = 768,
	 STR_SENSE_0,                       //= 769,
	 STR_SENSE_1,                       //= 770,
	 STR_SENSE_2,                       //= 771,
	 STR_SENSE_3,                       //= 772,
	 STR_SENSE_4,                       //= 773,
	 STR_SENSE_5,                       //= 774,
	 STR_SENSE_6,                       //= 775,
	 STR_SENSE_7,                       //= 776,
	 STR_SENSE_8,                       //= 777,
	 STR_SENSE_9,                       //= 778,
	 STR_SENSE_A,                       //= 779,
	 STR_SENSE_B,                       //= 780,
	 STR_SENSE_C,                       //= 781,
	 STR_SENSE_D,                       //= 782,
	 STR_SENSE_E,                       //= 783,
	 STR_SENSE_F,                       //= 784,
	STR_ISA,
	STR_EISA,
	STR_PCI,
	 STR_VERIFY2,                        //= 788,
	 STR_STAT_DEGRADED,                 //= 789,
	 STR_STAT_RECONSTRUCT,              //= 790,
	 STR_STAT_EXPAND,                   //= 791,
	 STR_STAT_DEAD,                     //= 792,
	 STR_ARRAY_WARNING,                 //= 793,
	 STR_NON_ARRAYED,                   //= 794,
	 STR_NON_EXISTANT,                  //= 795,
	 STR_FAILED_DRIVE,                  //= 796,
	 STR_REPLACED_DRIVE,                //= 797,
	 STR_DRIVE_WARNING,                 //= 798,
	 STR_PARAM_MISMATCH,                //= 799,
	 STR_FORMAT_UNIT,                   //= 800,
	 STR_UNINITIALIZED_HYPH,            //= 801,
	 STR_DRIVE_VERIFY,                  //= 802,
	//     STR_DUMMY_CDD                     = 803,
	//     STR_DPTDDL_PATH                   = 804,
	//     STR_DPT_DEVICE_ENTRY              = 805,
	 STR_SCSI_BUS_ECC_ERR,              //= 806,
	 STR_CORRECTABLE,                   //= 807,
	 STR_NONCORRECTABLE,                //= 808,
	//     STR_CORRECTED                     = 809,
	 STR_PARITY,                        //= 810,
	 STR_ECC,                           //= 811,
	 STR_SS_COMP_FAILED,                //= 812,
	 STR_SS_FULLY_FUNC,                 //= 813,
	//     STR_ALL_IDS_IN_USE                = 814,
	//     STR_CURRENT_ADDR                  = 815,
	//     STR_NEW_SCSI_ADDR                 = 816,
	//     STRT_SEARCH_AGAIN                 = 817,
	//     STR_DPT_ENGINE                    = 818,
	//     STR_DSM_INCOMPATIBLE              = 819,
	//     STR_NOT_COMPATIBLE                = 820,
	//     STRT_GLOSSARY                     = 821,
	//     STRT_BACK                         = 822,
	//     STR_OS_MISMATCH                   = 823,
	//     STRT_PRINTER_SETUP                = 824,
	//     STR_LOAD_CONFIG                   = 825,
	//     STR_SAVE_CONFIG                   = 826,
	STR_HOST_CMD_REC,                  //= 827,
	STR_HOST_CMD_SENT,                 //= 828,
	//     STR_ARRAY_DIAGS                   = 829,
	//     STR_ECC_ENABLED                   = 830,
	//     STR_ENABLE_DPT_ECC                = 831,
	//     STR_SLOT                          = 832,
	//     STR_DRIVER_NO_STRIPE              = 833,
	//     STR_STRIPE_CHANGE                 = 834,
	//     STR_CANNOT_FIND_SERVER            = 835,
	//     STR_COMM_ENGINE                   = 836,
	//     STR_INCOMPATIBLE_COMM             = 837,
	//     STR_IMAGE_WRONG_SIZE              = 838,
	//     STR_ONE_FLOPPY_RIGHT_SIZE         = 839,
	//     STR_IMAGE_SIZE_MISMATCH           = 840,
	STR_FILE_NOT_MATCH_HBA,
	//     STR_INVALID_IMAGE_FILE            = 841,
	//     STR_WRITE_ERROR                   = 842,
	//     STR_ZAPPED                        = 843,
	//     STR_OST_DOS                       = 844,
	//     STR_OST_WINDOWS                   = 845,
	//     STR_OST_WINDOWS95                 = 846,
	//     STR_OST_WINDOWS_NT                = 847,
	//     STR_OST_MSOS2                     = 848,
	//     STR_OST_IBMOS2                    = 849,
	//     STR_OST_NOVELL                    = 850,
	//     STR_OST_SCO                       = 851,
	//     STR_OST_USL                       = 852,
	//     STR_OST_SVR42                     = 853,
	//     STR_OST_UNIXWARE                  = 854,
	//     STR_OST_SOLARIS                   = 855,
	//     STR_OST_INTERACTIVE               = 856,
	//     STR_OST_ATT_UNIX                  = 857,
	//     STR_OST_NEXT                      = 858,
	//     STR_OST_UNIX                      = 859,
	//     STR_OST_VINES                     = 860,
	//     STR_OST_PICK                      = 861,
	//     STR_OST_THEOS                     = 862,
	//     STR_OST_LINUX                     = 863,
	//     STR_OST_BSDI                      = 864,
	//     STR_OST_FREEBSD                   = 865,
	//     STR_OST_AIX                       = 866,
	//     STR_OST_NETBSD                    = 867,
	//     STR_OST_OTHER                     = 868,
	//     STR_OS_DOS                        = 869,
	//     STR_OS_DOS5                       = 870,
	//     STR_OS_DRDOS                      = 871,
	//     STR_OS_CONDOS                     = 872,
	//     STR_OS_ZENITH                     = 873,
	//     STR_OS_PCMOS                      = 874,
	//     STR_OS_OS2MMS                     = 875,
	//     STR_OS_OS2MIBM                    = 876,
	//     STR_OS_OS2L                       = 877,
	//     STR_OS_OS220                      = 878,
	//     STR_OS_OS221                      = 879,
	//     STR_OS_OS221_AND_UP               = 880,
	//     STR_OS_OS2OTHER                   = 881,
	//     STR_OS_NW311                      = 882,
	//     STR_OS_NW40                       = 883,
	//     STR_OS_NW21X                      = 884,
	//     STR_OS_NW22                       = 885,
	//     STR_OS_NW20                       = 886,
	//     STR_OS_CONSENSYS                  = 887,
	//     STR_OS_IF_SVR4                    = 888,
	//     STR_OS_MICROPORT                  = 889,
	//     STR_OS_UHC                        = 890,
	//     STR_OS_SCO_UNIX_320               = 891,
	//     STR_OS_SCO_UNIX_322               = 892,
	//     STR_OS_SCO_UNIX_324               = 893,
	//     STR_OS_SCO_UNIX_3242              = 894,
	//     STR_OS_SCO_XENIX                  = 895,
	//     STR_OS_INT_UNIX_1X                = 896,
	//     STR_OS_INT_UNIX_2X                = 897,
	//     STR_OS_INT_UNIX_3X                = 898,
	//     STR_OS_ESIX                       = 899,
	//     STR_OS_INTEL_UNIX                 = 900,
	//     STR_OS_MICROPORT_286              = 901,
	//     STR_OS_MICROPORT_386              = 902,
	//     STR_OS_VINES_411                  = 903,
	//     STR_OS_VINES_55                   = 904,
	//     STR_OS_VINES_6X                   = 905,
	//     STR_OS_VINES_7X                   = 906,
	//     STR_OS_MAGIX                      = 907,
	//     STR_OS_PICK22                     = 908,
	//     STR_OS_PICK21                     = 909,
	//     STR_OS_QNX                        = 910,
	//     STR_OS_WYSE                       = 911,
	//     STR_OS_INT13                      = 912,
	//     STR_OS_WD1003                     = 913,
	//     STR_OS_NOTLISTED                  = 914,
	//     STR_YOUR_CHOSEN_OS                = 915,
	//     STR_OST_OLIVETTI                  = 916,
	//     STR_OS_NEXT                       = 917,
	//     STR_OS_NEXT33                     = 918,
	//     STR_OS_UNIXWARE1X                 = 919,
	//     STR_OS_UNIXWARE2X                 = 920,
	//     STR_OS_LINUX                      = 921,
	//     STR_OS_BSDI                       = 922,
	//     STR_OS_FREEBSD                    = 923,
	//     STR_OS_AIX                        = 924,
	//     STR_OS_NETBSD                     = 925,
	//     STR_OS_DGUNIX                     = 926,
	//     STR_OS_MACOS                      = 927,
	//     STR_QUIET_TITLE                   = 928,
	//     STR_QUIET_DESCRIP                 = 929,
	//     STR_SCSI_II                       = 930,
	//     STRT_CREATE_DISK                  = 931,
	//     STR_BAD_EXCLUSION                 = 932,
	//     STR_PRIORITY                      = 933,
	//     STR_EX_PERIOD                     = 934,
	//     STR_START_COLON                   = 935,
	//     STR_END_COLON                     = 936,
	 STR_ENABLED,
	 STR_CURRENT_SENSOR,
	 STR_VOLT_SENSOR,
	 STR_TEMP_SENSOR,
	 STR_ENCL_TEMPERATURE_SENSOR,
	 STR_NORMAL_TEMP_RESTORED,
	 STR_TEMP_NORMAL,
	 STR_HIGH_TEMP,
	 STR_LOW_TEMP,
	 STR_DETECTED,
	 STR_VERY_HIGH_TEMP,
	 STR_TEMP_OUT_OF_RANGE,
	 STR_LOW_VOLTAGE,
	 STR_NORMAL_VOLTAGE,
	 STR_HIGH_VOLTAGE,
	 STR_DIAGNOSTIC,
	 STR_STOPPED_DDS,
	 STR_STOPPED_FAIL,
	 STR_STOPPED_LIMIT,
	 STR_STOPPED_USER,
	 STR_STOPPED_COMPLETE,
	 STR_SMART_THRESHOLD,
	 STR_DRIVE_PREDICTION,
	 STR_SPINUP_CRITERION,
	 STR_SEEK_CRITERION,
	 STR_SCHEDULED,
	 STR_QUERIED,
	 STR_CANCELED,
	 STR_EX_PERIOD_SET,
	 STR_DEBUG_EVENT,
	 STR_LOG_TIME,
	 STR_LOG_LEVEL,
	//     STR_WRAP_OFF                      = 961,
	//     STR_LOG_SEPARATOR                 = 962,
	//     STR_SAVE_CHANGES                  = 963,
	//     STR_MUST_REBOOT                   = 964,
	//     STR_DEV_CONFIG                    = 965,
	//     STR_READ_CACHING                  = 966,
	//     STRT_DISCONNECT                   = 967,
	//     STRT_FAIL                         = 968,
	//     STR_START_DURING_EX               = 969,
	//     STR_STOP_BUILD_BAD                = 970,
	//     STR_STOP_GEN5_BUILD_BAD           = 971,
	//     STR_BOTH_FAILED                   = 972,
	//     STRT_CONFIGURE                    = 973,
	//     STR_SECTORS_COLON                 = 974,
	//     STR_BYTES_SECTOR_LOGICAL          = 975,
	//     STR_BYTES_SECTOR                  = 976,
	//     STR_SCSI_3                        = 977,
	//     STR_SMART                         = 978,
	////     STR_REBUILD                       = 979,
	STR_SAFTE,
	STR_SES,
	//     STR_SAFTE_ENCL                    = 981,
	//     STR_CE_ENOENT                     = 982,
	//     STR_CE_EMFILE                     = 983,
	//     STR_CE_EACCES                     = 984,
	//     STR_CE_EINVACC                    = 985,
	//     STR_CF_NOSPACE                    = 986,
	//     STR_CF_OTHER                      = 987,
	//     STR_CF_NOOPEN_SRC                 = 988,
	//     STR_WIN_INSTALL                   = 989,
	//     STR_UNCONF_EISA                   = 990,
	//     STR_WIN32_NODASD                  = 991,
	//     STR_FLASH_NEEDED                  = 992,
	//     STR_VALID_FLASH_FILE              = 993,
	//     STR_SUCCESSFUL_FLASH              = 994,
	//     STR_FLASH_DL_ERROR                = 995,
	//     STR_VERIFY_FLASH                  = 996,
	//     STR_FLASH_FIRMWARE                = 997,
	//     STR_FLASH_BIOS                    = 998,
	//     STR_FLASH_SMOR                    = 999,
	//     STR_BATTERY_MISSING               = 1000,
	//     STR_BATTERY_PRESENT               = 1001,
	STR_BATT_STAT_CHANGE,
	//     STR_NORMAL                        = 1002,
	//     STR_LOW                           = 1003,
	//     STR_HIGH                          = 1004,
	//     STR_VOLTAGE                       = 1005,
	//     STR_SERIALNUM                     = 1006,
	//     STR_STANDARD_CONNECTIONS          = 1007,
	//     STR_CUSTOM_CONNECTIONS            = 1008,
	//     STR_PROTOCOL_TCPIP                = 1009,
	//     STR_PROTOCOL_SPX                  = 1010,
	//     STR_PROTOCOL_SERIAL               = 1011,
	//     STR_PROTOCOL_MODEM                = 1012,
	//     STR_MODEM                         = 1013,
	//     STR_CONNECTION_INFORMATION        = 1014,
	//     STRT_ADDRESS                      = 1015,
	//     STRT_USERNAME                     = 1016,
	//     STRT_PASSWORD                     = 1017,
	//     STR_PHONEBOOK                     = 1018,
	//     STRT_PHONEBOOK                    = 1019,
	//     STRT_DISPLAY_ICON                 = 1020,
	//     STRT_PROTOCOL                     = 1021,
	//     STRT_SERVERNAME                   = 1022,
	//     STRT_ADD                          = 1023,
	//     STRT_EDIT                         = 1024,
	//     STRT_SAVE                         = 1025,
	//     STRT_DELETE                       = 1026,
	//     STRT_CONNECT                      = 1027,
	//     STRT_CLOSE                        = 1028,
	//     STR_CHOOSE_ICON                   = 1029,
	//     STRT_CHOOSE_ICON                  = 1030,
	//     STRT_ICONS                        = 1031,
	//     STR_SX4000                        = 1032,
	//     STR_TERMINATOR                    = 1033,
	//     STR_RAID_CTLR                     = 1034,
	//     STR_SES_ENCL                      = 1035,
	//     STR_SAFTE_SES                     = 1036,
	//     STR_XFER                          = 1037,
	//     STR_FCAL                          = 1038,
	//     STR_FIBRE_CHANNEL                 = 1039,
	//     STR_132                           = 1040,
	//     STR_264                           = 1041,
	//     STR_64BIT_SLOT                    = 1042,
	//     STR_32BIT_SLOT                    = 1043,
	//     STR_EVENT_VIEWER                  = 1044,
	//     STR_TAPI                          = 1045,
	//     STR_LOG_DESKTOP                   = 1046,
	//     STR_BROADCAST_TO_MACHINE          = 1047,
	//     STR_LOG_COMPUTERS                 = 1048,
	STR_FAILED_HOTSPARE,
	//     STRT_EXPAND_RAID                  = 1050,
	 STR_ULTRA,
	 STR_ULTRA2,
	 STR_ULTRA3,
	 STR_ULTRA160,
	 STR_ULTRA320,
	//     STR_NRAM_CACHE_NOTE               = 1052,
	//     STR_CACHE_INHIBIT_COMMANDS        = 1053,
	//     STR_CACHE_ADVISORY                = 1054,
	//     STR_CACHE_MANDATORY               = 1055,
	//     STR_CACHE_SYNC_COMMANDS           = 1056,
	//     STR_CACHE_SIZE                    = 1057,
	//     STR_CACHE_VIRTUAL                 = 1058,
	//     STR_CACHE_PHYSICAL                = 1059,
	//     STR_CACHE_CONTROL                 = 1060,
	//     STR_CACHE_WRITE                   = 1061,
	//     STR_CACHE_WRITE_BACK              = 1062,
	//     STR_CACHE_WRITE_THROUGH           = 1063,
	STR_CACHE_DISABLED,
	//     STR_TRACE_HOST_COMMANDS           = 1064,
	//     STR_TRACE_SCSI_COMMANDS           = 1065,
	STR_NO_BATTERY,
	STR_BAD_BATTERY,
	//     STR_BBU_WND_TITLE                 = 1066,
	//     STR_BBU_NOT_DETECTED              = 1067,
	//     STR_BBU_CHECK_CONNECTIONS         = 1068,
	//     STR_BBU_STATUS                    = 1069,
	STR_BBU_STARTING,
	STR_BBU_OPERATIONAL,
	//     STR_BBU_BACKUP                    = 1070,
	//     STR_BBU_CAP_WARNINGS              = 1071,
	//     STR_BBU_AUTO_WT                   = 1072,
	STR_BBU_PRED_FAILURE,
	//     STR_BBU_INIT_CAL_BUTTON           = 1074,
	//     STR_BBU_MAINT_CAL_BUTTON          = 1075,
	//     STR_BBU_DEFAULT_BUTTON            = 1076,
	//     STR_BBU_INIT_DLG_TITLE            = 1077,
	//     STR_BBU_INIT_DLG_MSG              = 1078,
	//     STR_BBU_MAINT_DLG_TITLE           = 1079,
	//     STR_BBU_MAINT_DLG_MSG             = 1080,
	//     STR_BBU_GEN_ERROR_MSG             = 1081,
	//     STR_BBU_GEN_ERROR_TITLE           = 1082,
	STR_BBU_FULL,
	STR_BBU_CHARGING,
	STR_BBU_DISCHARGING,
	STR_RECHARGING,
	STR_BBU_BAD,
	STR_BBU_INIT_CHARGE,
	STR_BBU_INIT_DISCHARGE,
	STR_BBU_INIT_RECHARGE,
	STR_BBU_MAINT_DISCHARGE,
	STR_BBU_MAINT_CHARGE,
	STR_TRICKLE_CHRGING,
	STR_MAINT_CALIB,
	STR_INIT_CALIB,
	//     STR_BBU_MAINT_CAL_CHARGE          = 1091,
	//     STR_BBU_AUTO_WT_MESSAGE           = 1092,
	//     STR_MB_SEC_XFER                   = 1093,
	//     STR_IN_MAINT_WT_MODE              = 1094,
	//     STR_IN_FORCED_WT_MODE             = 1095,
	//     STR_NO_MAINT_PERFORMED            = 1096,
	//     STR_BBU_AUTO_PRED_MSG             = 1097,
	//     STR_AUTO_WT_WARNING               = 1098,
	//     STR_ADVANCED                      = 1099,
	//     STR_DIRECTORY_FILE                = 1100,
	//     STR_SUCCESSFUL_FLASH_REMOTE       = 1101,
	//     NUM_STRINGS                       = 1102
	STR_DEGRADED,                    //= 1103
	STR_RECONSTRUCT,                 //= 1104
	STR_EXPAND,                      //= 1105
	STR_DEAD,                        //= 1106
	  STR_ARRAY_WARNING2,              //= 1107
	  STR_VERIFY, 		               //= 1108
	  STR_NON_EXIST,                   //= 1109
	  STR_UNINITIALIZED,               //= 1110
	  STR_REPLACED_DRIVE2,             //= 1111
	  STR_DRIVE_WARNING2,              //= 1112
	  STR_PARAM_MISMATCH2,             //= 1113
	  STR_FORMAT_UNIT2,                //= 1114
	  STR_SES_ENCL,
	  STR_SAFTE_ENCL,
	  STR_DEC_ENCL,
	  STR_NILE_ENCL,
	  STR_COMMUNICATION_LOST,
	  STR_SES_ENCL_FOUND,
	  STR_DOOR_LOCK,
	  STR_AUD_ALARM,
	  STR_SES_ENCL_SELECTION_TIMEOUT,
	  STR_SES_ENCL_HARDWARE_ERROR,
	  STR_SES_ENCL_ERROR_LIMIT,
	  STR_CPU_REGISTER_DUMP,
	  STR_BLINKLED_EVENT,
	  STR_RU_SURE_TO_ZAP,
	  STR_CHAR_Y,
	  STR_DRIVE_IS_BUSY,
	  STR_SUCCESS_RESYNC_SUCCESS,
	  STR_SUCCESS_RESYNC_NOT_SUPPORTED,
	  STR_SUCCESS_RESYNC_FAILED,
	  STR_UART_HBA_NUM,
	  STR_HBA_NUM_NOT_FOUND,
	  STR_ERR_UART_HBA_NUM,
	  STR_UART_WRITTEN_TO_FILE,
	  STR_NO_UART_DATA,
	  STR_MUST_REBUILD_RAID1,
	  STR_STR_OVER_PENDING,
	  STR_READ_CACHE,
	  STR_WRITE_CACHE,
	  STR_OFF_DUE2_MAINT_OPER,
	  STR_OFF_DUE2_BATTERY_COND,
	  STR_ERR_NO_CHANGE,
	  STR_RESYNC_SUCCESS_NO_REBOOT,
	  STR_RESYNC_NOT_SUPPORTED_REBOOT,
	  STR_RESYNC_FAILED_REBOOT,
	  STR_MUST_BE_ROOT,
	  STR_PRESS_ENTER2_CONT,
	  STR_INT_NOT_EXPECTD_USE,
	  STR_LOGICAL_VIEW,
	  STR_PHYSICAL_VIEW,
	  STR_DRIVE_NOT_OPT_CANT_CHG,
	STR_UNCHANGED_OPTIMAL,
	STR_RAID_NOT_FAIL_CANT_CHG,
	STR_UNCHANGED_FAILED,
	STR_NVRAM,
	STR_SCAN_TYPE_SIZE,
	STR_SCAN_TYPE_SIZE_DATE_VERSION,
	STR_CTLR_NOT_FOUND,
	STR_FLASH_COMPLETE,
	STR_FLASH_ERR_MSG,
	STR_VERIFYING_ERR_MSG,
	STR_WARN_ONLY_NT_2000,
	STR_EVENT_LOG_CLEARED,
	STR_FOR_CHANNEL,
	STR_DOUBLE_COMP_FAIL,
	STR_THE_SERVER,
	STR_COULD_NOT,
	STR_A_HEARTBEAT,
	STR_SLASH_CLEAR,
	STR_FINISHED,
	STR_ERROR,
	STR_SWAP_SIG_DETECTED,
	STR_COMP_MALFUNC,
	STR_COMP_OPERATIONAL,
	STR_DIRTY_DATA,
	STR_CRC_FAILURE,
	STR_LOCAL_PARAM_FAILURE,
	STR_LOCAL_SIG_FAILURE,
	STR_CACHE_SIG_FAILURE,
	STR_LSU_DEV_ID_ZERO,
	STR_NO_CACHE,
	STR_INVALID_PCB,
	STR_PCB_NO_LSU,
	STR_PCB_COUNT,
	STR_DIRTY_BLOCK_COUNT,
	STR_LSU_INVALID_DEV_ID,
	STR_LSU_INVALID_TYPE,
	STR_LSU_PARENT_DEV_ID,
	STR_LSU_CAPACITY,
	STR_LSU_MAGIC_NBR,
	STR_VOLTS_HIGH,
	STR_VOLT_RESTORED,
	STR_VOLTS_LOW,
	STR_TERM_POWER,
	STR_BAD_DATA_BLOCK,
	STR_BAD_PARITY_BLOCK,
	STR_BAD_DATA_LIST_FULL_BLOCK,
	STR_BAD_PARITY_LIST_FULL_BLOCK,
	STR_WRITE_BACK_FAIL_BLOCK,
	STR_FOR,
	STR_GLOBAL_CACHE_STATE_CHG,
	STR_CAUSE_OF_BUS_RESET,
	STR_HOST_CMD_BUS_RESET,
	STR_WATCHDOG_BUS_RESET,
	STR_BUS_RESET_ON_CHAN,
	STR_FIBRE_LOOP_CHAN_FROM,
	STR_DOWN_TO_UP,
	STR_UP_TO_DOWN,
	STR_ACCESS_FIBRE_FAILED_FILLIN,
	STR_UNKNOWN_FLAGS_FIBRE_LOOP,
	STR_BATTERY_CALIB_COUNT,
	STR_CHAN_FILLIN_WAS,
	STR_TAKEN_OFFLINE,
	STR_LEFT_OFFLINE,
	STR_ISP_PROC_DIAG_CHK_FAILED,
	STR_EXCESS_REINIT_ISP_SUB,
	STR_EXCESS_INBOUND_RESETS,
	STR_ISP_UNABLE_RESET_SFBUS,
	STR_ISP_RECV_UNRECOV_PCIBUS_FAULT,
	STR_ISP_FAILED_INIT,
	STR_UNKNOWN_REASON_CODE,
	STR_DOWN_SPEED_DOMAIN_VALID,
	STR_NOT_SCSI_DEV_DOMAIN_VALID,
	STR_ERR_IN_LOG_MSG,
	STR_UNKNOWN_EVENT,
	STR_SUCCESS,
	STR_REQ_ABORTED,
	STR_UNABLE_TO_ABORT,
	STR_COMPLETE_WITH_ERROR,
	STR_ADAPTER_BUSY,
	STR_REQUEST_INVALID,
	STR_PATH_INVALID,
	STR_UNABLE_TO_TERMINATE,
	STR_MR_MSG_RECVD,
	STR_PARITY_ERR_FAILURE,
	STR_AUTOSENSE_FAILED,
	STR_NO_ADAPTER,
	STR_DATA_OVERRUN,
	STR_SEQ_FAILURE,
	STR_REQ_LEN_ERROR,
	STR_PROVIDE_FAILURE,
	STR_BDR_MSG_SENT,
	STR_REQ_TERM,
	STR_IDE_MSG_SENT,
	STR_RESOURCE_UNAVAIL,
	STR_UNACKED_EVENT,
	STR_MSG_RECVD,
	STR_INVALID_CDB,
	STR_LUN_INVALID,
	STR_SCSI_TID_INVALID,
	STR_FUNC_UNAVAIL,
	STR_NO_NEXUS,
	STR_SCSI_IID_INVALID,
	STR_CDB_RECVD,
	STR_LUN_ALREADY_AVAIL,
	STR_UNKNOWN_ERR_CODE,
	STR_INVALID_HBA_TIME,
	STR_UNSPECIFIED,
	STR_ENCL_SERV_CTLR_ELEC,
	STR_SCC_CTLR_ELEC,
	STR_NONVOLATILE_CACHE,
	STR_UNINTERRUPTABLE,
	STR_DISPLAY,
	STR_KEY_PAD_ENTRY_DEV,
	STR_SCSI_PORT_XCEIVER,
	STR_LANGUAGE,
	STR_COMM_PORT,
	STR_SCSI_TGT_PORT,
	STR_SCSI_INIT_PORT,
	STR_SIMPLE_SUBENCL,
	STR_CRITICAL,
	STR_NONCRITICAL,
	STR_UNRECOVERABLE,
	STR_NOT_INSTALLED,
	STR_UNAVAILABLE,
	STR_MAIN,
	STR_SUB,
	STR_PARENT_ARRAY_BUILDING,
	STR_PARENT_BUILDING,
	STR_PARENT_EXPANDING,
	STR_NO_INFO_AVAIL,
	STR_MIRROR_MSG1,
	STR_MIRROR_MSG2,
	STR_MIRROR_MSG3,
	STR_MIRROR_MSG4,
	STR_MIRROR_MSG5,
	STR_CFG_FILE_LOADED,
	STR_CFG_FILE_SAVED,
	STR_ENG_CONN_FAILED,
	STR_COLON_OPEN,
	STR_COLON_COMPAT_NBR,
	STR_COLON_SCAN_FAILED,
	STR_HBA,
	STR_SCSI_DASD,
	STR_SCSI_SASD,
	STR_NO_ITEMS_FOUND,
	STR_NO_HOTSPARE_AVAIL,
	STR_RBLD_DRV_TOO_SMALL,
	STR_ATA33,
	STR_ATA45,
	STR_ATA66,
	STR_ATA100,
	STR_ATA133,
	STR_ATA,
	STR_SATA1500,
	STR_SATA3000,
	STR_SATA6000,
	STR_SATA,
	STR_REMMODEZERO,
	STR_RESCONFLICT,
	STR_CLSTR_FEAT_DISABLE,   
	STR_ERR_TWO_TB_RAID,
	STR_ERR_INVALID_SEGMENT_OFFSET,
	STR_ERR_INVALID_SEGMENT_SIZE,
	STR_RAID_JBOD,
	STR_NO_SEGMENT_CONFIG,
	STR_LIST_DEV_CTLR_HEADER_NO_CACHE,
	STR_LIST_DEV_VERSION_HEADER_NO_CACHE,
	STR_ERR_NAME_TOO_LONG,
	STR_ERR_NO_ARRAY_NAME,
	STR_ERR_NAME_ALREADY_USED, 
	STR_ARRAY_NAME_CHANGED,
	STR_LIST_ARRAYNAME_HEADER
};


#endif	// __RSCENUM_H


