% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete.R
\name{vec_detect_complete}
\alias{vec_detect_complete}
\title{Complete}
\usage{
vec_detect_complete(x)
}
\arguments{
\item{x}{A vector}
}
\value{
A logical vector with the same size as \code{x}.
}
\description{
\code{vec_detect_complete()} detects "complete" observations. An observation is
considered complete if it is non-missing. For most vectors, this implies that
\code{vec_detect_complete(x) == !vec_detect_missing(x)}.

For data frames and matrices, a row is only considered complete if all
elements of that row are non-missing. To compare, \code{!vec_detect_missing(x)}
detects rows that are partially complete (they have at least one non-missing
value).
}
\details{
A \link[=new_rcrd]{record} type vector is similar to a data frame, and is only
considered complete if all fields are non-missing.
}
\examples{
x <- c(1, 2, NA, 4, NA)

# For most vectors, this is identical to `!vec_detect_missing(x)`
vec_detect_complete(x)
!vec_detect_missing(x)

df <- data_frame(
  x = x,
  y = c("a", "b", NA, "d", "e")
)

# This returns `TRUE` where all elements of the row are non-missing.
# Compare that with `!vec_detect_missing()`, which detects rows that have at
# least one non-missing value.
df2 <- df
df2$all_non_missing <- vec_detect_complete(df)
df2$any_non_missing <- !vec_detect_missing(df)
df2
}
\seealso{
\code{\link[stats:complete.cases]{stats::complete.cases()}}
}
