% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_namespace.R
\name{namespaces}
\alias{namespaces}
\alias{new_namespace_env}
\alias{new_pkg_environment}
\alias{register_namespace}
\alias{unregister_namespace}
\alias{is_namespace_registered}
\title{Create namespace environments}
\usage{
new_namespace_env(name, path = file.path(tempdir()),
  import = "methods")

new_pkg_environment(name = "test package environment", ...,
  register = FALSE)

register_namespace(ns)

unregister_namespace(ns)

is_namespace_registered(ns)
}
\arguments{
\item{name}{The name of the environment}

\item{path}{An optional path.}

\item{import}{Package to include in the imports.}

\item{...}{Arguments passed on to \code{new_namespace_env}
\describe{
  \item{name}{The name of the environment}
  \item{path}{An optional path.}
  \item{import}{Package to include in the imports.}
}}

\item{register}{Should the package namespace be registered?}

\item{ns}{a namespace environment or a character name of a namespace.}
}
\description{
Create and manipulate namespace and test package environments.
}
\section{Functions}{
\itemize{
\item \code{new_namespace_env}: Create a new namespace environment

\item \code{new_pkg_environment}: Create a package environment.
All package environments are namespaces but not all
namespaces qualify as package environments.

\item \code{register_namespace}: Register a namespace

\item \code{unregister_namespace}: Remove a namespace from the registry

\item \code{is_namespace_registered}: Check if a namespace is registered
}}

\examples{
ns <- new_namespace_env('my namespace')
isNamespace(ns)
environmentName(ns)
packageName(ns) # not a package

pkg <- new_pkg_environment("myPackage")
isNamespace(pkg)
environmentName(pkg)
packageName(pkg)             # now a package
is_namespace_registered(pkg) # but not registered
\dontrun{
asNamespace("myPackage")     # so this WILL NOT work.
}

register_namespace(pkg)
is_namespace_registered(pkg) # now registered
asNamespace("myPackage")     # so this WILL work.

unregister_namespace(pkg)
is_namespace_registered(pkg) # now unregistered
isNamespace(pkg)             # but still a namespace

}
