% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connections.R
\name{conn_create_unix_socket}
\alias{conn_create_unix_socket}
\alias{conn_connect_unix_socket}
\alias{conn_accept_unix_socket}
\alias{conn_unix_socket_state}
\title{Unix domain sockets}
\usage{
conn_create_unix_socket(filename = NULL, encoding = "")

conn_connect_unix_socket(filename, encoding = "")

conn_accept_unix_socket(con)

conn_unix_socket_state(con)
}
\arguments{
\item{filename}{File name of the socket. On Windows it the name of the
pipe within the \verb{\\\\?\\pipe\\} namespace, either the full name, or the
part after that prefix. If \code{NULL}, then a random name
is used, on Unix in the R temporary directory: \code{\link[base:tempfile]{base::tempdir()}}.}

\item{encoding}{Encoding to assume when reading from the socket.}

\item{con}{Connection. An error is thrown if not a socket connection.}
}
\value{
A new socket connection.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Cross platform point-to-point inter-process communication with
Unix=domain sockets, implemented via named pipes on Windows.
These connection are always bidirectional, i.e. you can read from them
and also write to them.
}
\details{
\code{conn_create_unix_socket()} creates a server socket. The new socket
is listening at \code{filename}. See \code{filename} above.

\code{conn_connect_unix_socket()} creates a client socket and connects it to
a server socket.

\code{conn_accept_unix_socket()} accepts a client connection at a server
socket.

\code{conn_unix_socket_state()} returns the state of the socket. Currently it
can return: \code{"listening"}, \code{"connected_server"}, \code{"connected_client"}.
It is possible that other states (e.g. for a closed socket) will be added
in the future.
\subsection{Notes}{
\itemize{
\item \code{\link[=poll]{poll()}} works on sockets, but only polls for data to read, and
currently ignores the write-end of the socket.
\item \code{\link[=poll]{poll()}} also works for accepting client connections. It will return
\code{"connect"}is a client connection is available for a server socket.
After this you can call \code{conn_accept_unix_socket()} to accept the
client connection.
}
}
}
\seealso{
\href{https://processx.r-lib.org/dev/articles/internals.html}{processx internals}
}
