% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assignment_linter.R
\name{assignment_linter}
\alias{assignment_linter}
\title{Assignment linter}
\usage{
assignment_linter(
  operator = c("<-", "<<-"),
  allow_cascading_assign = NULL,
  allow_right_assign = NULL,
  allow_trailing = TRUE,
  allow_pipe_assign = NULL
)
}
\arguments{
\item{operator}{Character vector of valid assignment operators. Defaults to allowing \verb{<-} and \verb{<<-}; other valid
options are \code{=}, \verb{->}, \verb{->>}, \verb{\%<>\%}; use \code{"any"} to denote "allow all operators", in which case this linter only
considers \code{allow_trailing} for generating lints.}

\item{allow_cascading_assign, allow_right_assign, allow_pipe_assign}{(Defunct)}

\item{allow_trailing}{Logical, default \code{TRUE}. If \code{FALSE} then assignments aren't allowed at end of lines.}
}
\description{
Check that the specified operator is used for assignment.
}
\examples{
# will produce lints
lint(
  text = "x = mean(x)",
  linters = assignment_linter()
)

code_lines <- "1 -> x\n2 ->> y"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = assignment_linter()
)

lint(
  text = "x \%<>\% as.character()",
  linters = assignment_linter()
)

lint(
  text = "x <- 1",
  linters = assignment_linter(operator = "=")
)

# okay
lint(
  text = "x <- mean(x)",
  linters = assignment_linter()
)

code_lines <- "x <- 1\ny <<- 2"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = assignment_linter()
)

# customizing using arguments
code_lines <- "1 -> x\n2 ->> y"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = assignment_linter(operator = "->")
)

lint(
  text = "x <<- 1",
  linters = assignment_linter(operator = "<-")
)

writeLines("foo(bar = \n 1)")
lint(
  text = "foo(bar = \n 1)",
  linters = assignment_linter(allow_trailing = FALSE)
)

lint(
  text = "x \%<>\% as.character()",
  linters = assignment_linter(operator = "\%<>\%")
)

lint(
  text = "x = 1",
  linters = assignment_linter(operator = "=")
)

}
\seealso{
\itemize{
\item \link{linters} for a complete list of linters available in lintr.
\item \url{https://style.tidyverse.org/syntax.html#assignment-1}
\item \url{https://style.tidyverse.org/pipes.html#assignment-2}
}
}
\section{Tags}{
\link[=configurable_linters]{configurable}, \link[=consistency_linters]{consistency}, \link[=default_linters]{default}, \link[=style_linters]{style}
}
