% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h5writeAttr.R
\name{h5_writeAttribute}
\alias{h5_writeAttribute}
\alias{h5writeAttribute}
\alias{h5writeAttribute.array}
\title{Write an R object as an HDF5 attribute}
\usage{
h5writeAttribute(
  attr,
  h5obj,
  name,
  h5loc,
  encoding = NULL,
  variableLengthString = FALSE,
  asScalar = FALSE,
  checkForNA = TRUE
)

\method{h5writeAttribute}{array}(
  attr,
  h5obj,
  name,
  h5loc,
  encoding = NULL,
  variableLengthString = FALSE,
  asScalar = FALSE,
  checkForNA = TRUE
)
}
\arguments{
\item{attr}{The R object to be written as an HDF5 attribute.}

\item{h5obj}{Normally an object of class \linkS4class{H5IdComponent} representing a
H5 object identifier (file, group, or dataset). See
\code{\link{H5Fcreate}}, \code{\link{H5Fopen}}, \code{\link{H5Gcreate}},
\code{\link{H5Gopen}}, \code{\link{H5Dcreate}}, or \code{\link{H5Dopen}} to
create an object of this kind.  This argument can also be given the path to
an HDF5 file.}

\item{name}{The name of the attribute to be written.}

\item{h5loc}{The location of the group or dataset within a file to which the
attribute should be attached. This argument is only used if the
\code{h5obj} argument is the path to an HDF5 file, otherwise it is ignored.}

\item{encoding}{The encoding of the string data type. Valid options are
"ASCII" and "UTF-8".}

\item{variableLengthString}{Whether character vectors should be written as
variable-length strings into the attributes.}

\item{asScalar}{Whether length-1 \code{attr} should be written into a scalar
dataspace.}

\item{checkForNA}{Whether a \code{attr} should be checked for \code{NA}
values before being written.  This only applies of \code{attr} is of type
logical.  Testing for \code{NA} values can be slow if the object to be
written is large, so if you are sure no such values will be present this
argument can be used to disable the testing.}
}
\description{
Write an R object as an HDF5 attribute
}
