% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colWeightedSds.R, R/colWeightedVars.R,
%   R/rowWeightedSds.R, R/rowWeightedVars.R
\name{colWeightedSds,DelayedMatrix-method}
\alias{colWeightedSds,DelayedMatrix-method}
\alias{colWeightedVars,DelayedMatrix-method}
\alias{rowWeightedSds,DelayedMatrix-method}
\alias{rowWeightedVars,DelayedMatrix-method}
\title{Calculates the weighted standard deviation for each row (column) of a
matrix-like object}
\usage{
\S4method{colWeightedSds}{DelayedMatrix}(
  x,
  w = NULL,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...
)

\S4method{colWeightedVars}{DelayedMatrix}(
  x,
  w = NULL,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...
)

\S4method{rowWeightedSds}{DelayedMatrix}(
  x,
  w = NULL,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...
)

\S4method{rowWeightedVars}{DelayedMatrix}(
  x,
  w = NULL,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...
)
}
\arguments{
\item{x}{A NxK \linkS4class{DelayedMatrix}.}

\item{w}{A \code{\link{numeric}} vector of length K (N) that specifies by
how much each element is weighted.}

\item{rows}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, \code{\link{NA}}s
are excluded first, otherwise not.}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}

\item{...}{Additional arguments passed to specific methods.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the weighted standard deviation for each row (column) of a
matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowWeightedSds}
/ \code{matrixStats::colWeightedSds}.
}
\examples{
# A DelayedMatrix with a 'SolidRleArraySeed' seed
dm_Rle <- RleArray(Rle(c(rep(1L, 5),
                         as.integer((0:4) ^ 2),
                         seq(-5L, -1L, 1L))),
                   dim = c(5, 3))

colWeightedSds(dm_Rle, w = 1 / rowMeans2(dm_Rle))

# Specifying weights inversely proportional to rowwise means
colWeightedVars(dm_Rle, w = 1 / rowMeans2(dm_Rle))

# Specifying weights inversely proportional to columnwise means
rowWeightedSds(dm_Rle, w = 1 / colMeans2(dm_Rle))

# Specifying weights inversely proportional to columnwise means
rowWeightedVars(dm_Rle, w = 1 / colMeans2(dm_Rle))
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:weightedVar]{rowWeightedSds}()} and
\code{matrixStats::\link[matrixStats:weightedVar]{colWeightedSds}()}
which are used when the input is a \code{matrix} or \code{numeric} vector.
\item See also \link[MatrixGenerics]{rowSds} for the corresponding unweighted function.
}
}
\author{
Peter Hickey

Peter Hickey
}
