"""
This is a file transcribed from Table 12 of the journal article below.
The authors note that
* H is from Rowland and Taylor (JPC 1996, 100, 7384) 10.1021/jp953141+
* Be, B, Al, Ca, Ge, Rb, Sr, Sb, Cs, Ba, Bi, Po At, Rn, Fr, Ra are new from the present work
* remainder from Bondi (JPC 1964, 68, 441) 10.1021/j100785a001

File Authors: QCElemental Authors
"""

# fmt: off
mantina_2009_vanderwaals_radii = {
    'title':
    'Consistent van der Waals Radii for the Whole Main Group',
    'date':
    '2009-04-21',
    'doi':
    'DOI: 10.1021/jp8111556',
    'url':
    'https://pubs.acs.org/doi/10.1021/jp8111556',
    'access_data':
    '2019-08-08 19:00:00',
    'units':
    'angstrom',
    'vanderwaals_radii': [
        ('H',  '1.10'),
        ('He', '1.40'),

        ('Li', '1.81'),
        ('Be', '1.53'),
        ('B',  '1.92'),
        ('C',  '1.70'),
        ('N',  '1.55'),
        ('O',  '1.52'),
        ('F',  '1.47'),
        ('Ne', '1.54'),

        ('Na', '2.27'),
        ('Mg', '1.73'),
        ('Al', '1.84'),
        ('Si', '2.10'),
        ('P',  '1.80'),
        ('S',  '1.80'),
        ('Cl', '1.75'),
        ('Ar', '1.88'),

        ('K',  '2.75'),
        ('Ca', '2.31'),
        ('Ga', '1.87'),
        ('Ge', '2.11'),
        ('As', '1.85'),
        ('Se', '1.90'),
        ('Br', '1.83'),
        ('Kr', '2.02'),

        ('Rb', '3.03'),
        ('Sr', '2.49'),
        ('In', '1.93'),
        ('Sn', '2.17'),
        ('Sb', '2.06'),
        ('Te', '2.06'),
        ('I',  '1.98'),
        ('Xe', '2.16'),

        ('Cs', '3.43'),
        ('Ba', '2.68'),
        ('Tl', '1.96'),
        ('Pb', '2.02'),
        ('Bi', '2.07'),
        ('Po', '1.97'),
        ('At', '2.02'),
        ('Rn', '2.20'),

        ('Fr', '3.48'),
        ('Ra', '2.83'),
    ]
}
