#ifndef __drvSVG_h
#define __drvSVG_h

/* 
   drvsvg.h : This file is part of pstoedit
   Class declaration for a SVG output driver with no additional attributes
   and methods (minimal interface)

   Copyright (C)  2000 - 2024 Wolfgang Glunz, wglunz35_AT_pstoedit.net

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "drvbase.h"

class drvSVG : public drvbase {

public:

	derivedConstructor(drvSVG);
	~drvSVG();
	class DriverOptions : public ProgramOptions {
	public:

		OptionT < bool, BoolTrueExtractor> localDTD;
		OptionT < bool, BoolTrueExtractor> standalone;
		OptionT < bool, BoolTrueExtractor> withDTD;
		OptionT < bool, BoolTrueExtractor> withgrouping;
		OptionT < bool, BoolTrueExtractor> nogroupedpath;
		OptionT < bool, BoolTrueExtractor> noviewbox;
		// OptionT < bool, BoolTrueExtractor> withnamespace;
		OptionT < bool, BoolTrueExtractor> texmode;
		OptionT < bool, BoolTrueExtractor> imagetofile;
		OptionT < bool, BoolTrueExtractor> notextrendering;
		OptionT < int,  IntValueExtractor> border_p;
		OptionT < RSString, RSStringValueExtractor> titlestring;
	
		DriverOptions():
			localDTD(true,"-localdtd","",0,"use local DTD",0,false),
			standalone(true,"-standalone","",0,"create stand-alone type svg",0,false),
			withDTD(true,"-withdtd","",0,"write DTD",0,false),
			withgrouping(true,"-withgrouping","",0,"write also ordinary save/restores as SVG group",0,false),
			nogroupedpath(true,"-nogroupedpath","",0,"do not write a group around paths",0,false),
			noviewbox(true,"-noviewbox","",0,"do not write a view box",0,false),
			// now done always - See Herbert Klein's mail
			// - withnamespace(true,"-withnamespace","",0,"write xmlns declaration into output file",0,false),
			texmode(true,"-texmode","",0,"\\TeX\\, mode",0,false),
			imagetofile(true,"-imagetofile","",0,"write raster images to separate files instead of embedding them",0,false),
			notextrendering(true,"-notextrendering","",0,"do not write textrendering attribute",0,false),
			border_p(true,"-border","number",0,"additional border to draw around bare bounding box (in percent of width and height)",0,0),
			titlestring(true,"-title", "string", 0, "text to use as title for the generated document" ,0,(const char*)"generated by pstoedit")
			{
			ADD(localDTD );
			ADD(standalone );
			ADD(withDTD );
			ADD(withgrouping );
			ADD(nogroupedpath );
			ADD(noviewbox );
			// ADD(withnamespace);
			ADD(texmode );
			ADD(imagetofile );
			ADD(notextrendering );
			ADD(border_p );
			ADD(titlestring);
		}
	}*options;

#include "drvfuncs.h"
	virtual void show_rectangle(const float llx, const float lly, const float urx, const float ury) override;
	virtual void show_text(const TextInfo & textinfo) override;

public:
	virtual void show_image(const PSImage & imageinfo) override; 
	virtual bool textIsWorthToPrint(const RSString& thetext) const override; 

	virtual void ClipPath(cliptype clipmode) override;
	virtual void Save() override;
	virtual void Restore() override;

private:
	void print_coords();
	// unsigned int  imgcount;
	unsigned long clippathid;
	float		  border;			// percentage of width and height to be added to BB to form the viewbox
    bool		  xaml;
};
//lint -esym(1712,drvSVG) // no default ctor

#endif
