#
# Copyright (C) 2005-2020 Centre National d'Etudes Spatiales (CNES)
#
# This file is part of Orfeo Toolbox
#
#     https://www.orfeo-toolbox.org/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

set(DOCUMENTATION "Anomalies are composed of a set of isolated pixels with
anomalous signatures (when compared to the image background) which represents a very
small piece of the full image, and they only occur in the image with low
probabilities. This module contains classes related to well-known approaches for anomaly
detection which have shown success for multispectral and hyperspectral images
(for example Local-RX detector).")

otb_module(OTBAnomalyDetection
  DEPENDS
    OTBITK
    OTBFunctor
  TEST_DEPENDS
    OTBTestKernel
    OTBImageIO
    OTBImageBase

  DESCRIPTION
    "${DOCUMENTATION}"
)
