/*
Copyright The ORAS Authors.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package manifest

import (
	"encoding/json"
	"errors"
)

var (
	// ErrMediaTypeNotFound is returned when the media type is not specified.
	ErrMediaTypeNotFound = errors.New(`media type is not specified`)
	// ErrInvalidJSON is returned when the json file is malformed.
	ErrInvalidJSON = errors.New("not a valid json file")
)

// ExtractMediaType parses the media type field of bytes content in json format.
func ExtractMediaType(content []byte) (string, error) {
	var manifest struct {
		MediaType string `json:"mediaType"`
	}
	if err := json.Unmarshal(content, &manifest); err != nil {
		return "", ErrInvalidJSON
	}
	if manifest.MediaType == "" {
		return "", ErrMediaTypeNotFound
	}
	return manifest.MediaType, nil
}
