// Copyright (c) 2012 Ecma International.  All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
es5id: 15.2.3.7-6-a-213
description: >
    Object.defineProperties - 'O' is an Array, 'name' is an array
    index property, the [[Value]] field of 'desc' is +0, and the
    [[Value]] attribute value of 'name' is -0  (15.4.5.1 step 4.c)
includes: [propertyHelper.js]
---*/

var arr = [];

Object.defineProperty(arr, "0", {
  value: -0
});

try {
  Object.defineProperties(arr, {
    "0": {
      value: +0
    }
  });
  $ERROR("Expected an exception.");
} catch (e) {
  verifyEqualTo(arr, "0", -0);

  verifyNotWritable(arr, "0");

  verifyNotEnumerable(arr, "0");

  verifyNotConfigurable(arr, "0");

  if (!(e instanceof TypeError)) {
    $ERROR("Expected TypeError, got " + e);
  }

}

reportCompare(0, 0);
