# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.algorithm import Algorithm


class ResizingWindowToImageFilter(Algorithm):
    r"""
    ResizingWindowToImageFilter - Use a Window as input to image
    pipeline
    
    Superclass: Algorithm
    
    ResizingWindowToImageFilter provides methods needed to read the
    data in a Window and use it as input to the imaging pipeline. This
    is useful for saving an image to a file for example. The window can
    be read as either RGB or RGBA pixels;  in addition, the depth buffer
    can also be read.   RGB and RGBA pixels are of type unsigned char,
    while Z-Buffer data is returned as floats.  Use this filter to
    convert render_windows or image_windows to an image format.
    
    ote In contrast to the WindowToImageFilter, this allows also for
    non-integral values to be used as scaling factors for the generated
    image. Also, it provides a size_limit parameter which enables to
    control when the algorithm will switch to using tiling for generating
    a large image instead of rendering the entire result at once.
    
    @warning
    A Window doesn't behave like other parts of the VTK pipeline: its
    modification time doesn't get updated when an image is rendered.  As
    a result, naive use of ResizingWindowToImageFilter will produce an
    image of the first image that the window rendered, but which is never
    updated on subsequent window updates.  This behavior is unexpected
    and in general undesirable.
    
    @warning
    To force an update of the output image, call
    ResizingWindowToImageFilter's Modified method after rendering to
    the window.
    
    @sa
    RendererSource RendererPointCloudSource Window
    RenderLargeImage WindowToImageFilter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkResizingWindowToImageFilter, obj, update, **traits)
    
    input_buffer_type = tvtk_base.RevPrefixMap({'rgb': 3, 'rgba': 4, 'z_buffer': 5}, default_value='rgb', desc=\
        r"""
        Set/get the window buffer from which data will be read.  Choices
        include VTK_RGB (read the color image from the window), VTK_RGBA
        (same, but include the alpha channel), and VTK_ZBUFFER (depth
        buffer, returned as a float array). Initial value is VTK_RGB.
        """
    )

    def _input_buffer_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInputBufferType,
                        self.input_buffer_type_)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    def _set_input(self, arg):
        old_val = self._get_input()
        self._wrap_call(self._vtk_obj.SetInput,
                        deref_vtk(arg))
        self.trait_property_changed('input', old_val, arg)
    input = traits.Property(_get_input, _set_input, desc=\
        r"""
        Returns which renderer is being used as the source for the pixel
        data. Initial value is 0.
        """
    )

    size = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int", value=(0, 0), cols=2, desc=\
        r"""
        
        """
    )

    def _size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSize,
                        self.size)

    size_limit = traits.Int(4000, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _size_limit_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSizeLimit,
                        self.size_limit)

    def _get_output(self):
        return wrap_vtk(self._vtk_obj.GetOutput())
    output = traits.Property(_get_output,
                             desc="Output of this source, i.e. the result of `get_output()`.")
    
    def get_output(self):
        """
        get_output(self) -> ImageData
        C++: ImageData *get_output()
        Get the output data object for a port on this algorithm.
        """
        return wrap_vtk(self._vtk_obj.GetOutput())

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('input_buffer_type', 'GetInputBufferType'), ('size', 'GetSize'),
    ('size_limit', 'GetSizeLimit'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'input_buffer_type', 'progress_text', 'size',
    'size_limit'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ResizingWindowToImageFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ResizingWindowToImageFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], ['input_buffer_type'], ['size', 'size_limit']),
            title='Edit ResizingWindowToImageFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ResizingWindowToImageFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

