# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.importer import Importer


class GLTFImporter(Importer):
    r"""
    GLTFImporter - Import a GLTF file.
    
    Superclass: Importer
    
    GLTFImporter is a concrete subclass of Importer that reads glTF
    2.0 files.
    
    The GL Transmission Format (glTF) is an API-neutral runtime asset
    delivery format. A glTF asset is represented by:
    - A JSON-formatted file (.gltf) containing a full scene description:
      node hierarchy, materials, cameras, as well as descriptor
      information for meshes, animations, and other constructs
    - Binary files (.bin) containing geometry and animation data, and
      other buffer-based data
    - Image files (.jpg, .png) for textures
    
    This importer supports all physically-based rendering material
    features, with the exception of alpha masking and mirrored texture
    wrapping, which are not supported.
    
    This importer does not support materials that use multiple sets of
    texture coordinates. Only the first set will be used in this case.
    
    This importer does not support animations, morphing and skinning. If
    you would like to use animations, morphing or skinning, please
    consider using GLTFReader.
    
    This importer only supports assets that use the 2.x version of the
    glTF specification.
    
    For the full glTF specification, see:
    https://github.com/khronos_group/glTF/tree/master/specification/2.0
    
    Note: array sizes should not exceed INT_MAX
    
    Supported extensions:
    - KHR_lights_punctual : The importer supports the KHR_lights_punctual
    extension except for this feature:
    - VTK does not support changing the falloff of the cone with
      innercone_angle and outercone_angle. The importer uses outercone_angle
    and ignores innercone_angle as specified for this situation.
    
    @sa
    Importer GLTFReader
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGLTFImporter, obj, update, **traits)
    
    def get_camera(self, *args):
        """
        get_camera(self, id:int) -> SmartPointer_I9vtkCameraE
        C++: SmartPointer<vtkCamera> get_camera(unsigned int id)
        glTF defines multiple camera objects, but no default behavior for
        which camera should be used. The importer will by default apply
        the asset's first camera. This accessor lets you use the asset's
        other cameras.
        """
        ret = self._wrap_call(self._vtk_obj.GetCamera, *args)
        return wrap_vtk(ret)

    def set_camera(self, *args):
        """
        set_camera(self, camIndex:int) -> None
        
        Enable a specific camera. If a negative index is provided, no
        camera from the importer is used.
        """
        ret = self._wrap_call(self._vtk_obj.SetCamera, *args)
        return ret

    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Specify the name of the file to read.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('file_name', 'GetFileName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'file_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GLTFImporter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GLTFImporter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['file_name']),
            title='Edit GLTFImporter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GLTFImporter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

