// SPDX-License-Identifier: GPL-2.0-or-later
/*
 * Copyright (c) 2025 Rockchip Electronics Co., Ltd.
 * Author: Finley Xiao <finley.xiao@rock-chips.com>
 */

#include <linux/module.h>
#include <linux/of.h>
#include <dt-bindings/reset/rockchip,rk3506-cru.h>
#include "clk.h"

/* 0xFF9A0000 + 0x0A00 */
#define RK3506_CRU_RESET_OFFSET(id, reg, bit) [id] = (0 + reg * 16 + bit)

/* mapping table for reset ID to register offset */
static const int rk3506_register_offset[] = {
	/* CRU-->SOFTRST_CON00 */
	RK3506_CRU_RESET_OFFSET(SRST_NCOREPORESET0_AC, 0, 0),
	RK3506_CRU_RESET_OFFSET(SRST_NCOREPORESET1_AC, 0, 1),
	RK3506_CRU_RESET_OFFSET(SRST_NCOREPORESET2_AC, 0, 2),
	RK3506_CRU_RESET_OFFSET(SRST_NCORESET0_AC, 0, 4),
	RK3506_CRU_RESET_OFFSET(SRST_NCORESET1_AC, 0, 5),
	RK3506_CRU_RESET_OFFSET(SRST_NCORESET2_AC, 0, 6),
	RK3506_CRU_RESET_OFFSET(SRST_NL2RESET_AC, 0, 8),
	RK3506_CRU_RESET_OFFSET(SRST_A_CORE_BIU_AC, 0, 9),
	RK3506_CRU_RESET_OFFSET(SRST_H_M0_AC, 0, 10),

	/* CRU-->SOFTRST_CON02 */
	RK3506_CRU_RESET_OFFSET(SRST_NDBGRESET, 2, 10),
	RK3506_CRU_RESET_OFFSET(SRST_P_CORE_BIU, 2, 14),
	RK3506_CRU_RESET_OFFSET(SRST_PMU, 2, 15),

	/* CRU-->SOFTRST_CON03 */
	RK3506_CRU_RESET_OFFSET(SRST_P_DBG, 3, 1),
	RK3506_CRU_RESET_OFFSET(SRST_POT_DBG, 3, 2),
	RK3506_CRU_RESET_OFFSET(SRST_P_CORE_GRF, 3, 4),
	RK3506_CRU_RESET_OFFSET(SRST_CORE_EMA_DETECT, 3, 6),
	RK3506_CRU_RESET_OFFSET(SRST_REF_PVTPLL_CORE, 3, 7),
	RK3506_CRU_RESET_OFFSET(SRST_P_GPIO1, 3, 8),
	RK3506_CRU_RESET_OFFSET(SRST_DB_GPIO1, 3, 9),

	/* CRU-->SOFTRST_CON04 */
	RK3506_CRU_RESET_OFFSET(SRST_A_CORE_PERI_BIU, 4, 3),
	RK3506_CRU_RESET_OFFSET(SRST_A_DSMC, 4, 5),
	RK3506_CRU_RESET_OFFSET(SRST_P_DSMC, 4, 6),
	RK3506_CRU_RESET_OFFSET(SRST_FLEXBUS, 4, 7),
	RK3506_CRU_RESET_OFFSET(SRST_A_FLEXBUS, 4, 9),
	RK3506_CRU_RESET_OFFSET(SRST_H_FLEXBUS, 4, 10),
	RK3506_CRU_RESET_OFFSET(SRST_A_DSMC_SLV, 4, 11),
	RK3506_CRU_RESET_OFFSET(SRST_H_DSMC_SLV, 4, 12),
	RK3506_CRU_RESET_OFFSET(SRST_DSMC_SLV, 4, 13),

	/* CRU-->SOFTRST_CON05 */
	RK3506_CRU_RESET_OFFSET(SRST_A_BUS_BIU, 5, 3),
	RK3506_CRU_RESET_OFFSET(SRST_H_BUS_BIU, 5, 4),
	RK3506_CRU_RESET_OFFSET(SRST_P_BUS_BIU, 5, 5),
	RK3506_CRU_RESET_OFFSET(SRST_A_SYSRAM, 5, 6),
	RK3506_CRU_RESET_OFFSET(SRST_H_SYSRAM, 5, 7),
	RK3506_CRU_RESET_OFFSET(SRST_A_DMAC0, 5, 8),
	RK3506_CRU_RESET_OFFSET(SRST_A_DMAC1, 5, 9),
	RK3506_CRU_RESET_OFFSET(SRST_H_M0, 5, 10),
	RK3506_CRU_RESET_OFFSET(SRST_M0_JTAG, 5, 11),
	RK3506_CRU_RESET_OFFSET(SRST_H_CRYPTO, 5, 15),

	/* CRU-->SOFTRST_CON06 */
	RK3506_CRU_RESET_OFFSET(SRST_H_RNG, 6, 0),
	RK3506_CRU_RESET_OFFSET(SRST_P_BUS_GRF, 6, 1),
	RK3506_CRU_RESET_OFFSET(SRST_P_TIMER0, 6, 2),
	RK3506_CRU_RESET_OFFSET(SRST_TIMER0_CH0, 6, 3),
	RK3506_CRU_RESET_OFFSET(SRST_TIMER0_CH1, 6, 4),
	RK3506_CRU_RESET_OFFSET(SRST_TIMER0_CH2, 6, 5),
	RK3506_CRU_RESET_OFFSET(SRST_TIMER0_CH3, 6, 6),
	RK3506_CRU_RESET_OFFSET(SRST_TIMER0_CH4, 6, 7),
	RK3506_CRU_RESET_OFFSET(SRST_TIMER0_CH5, 6, 8),
	RK3506_CRU_RESET_OFFSET(SRST_P_WDT0, 6, 9),
	RK3506_CRU_RESET_OFFSET(SRST_T_WDT0, 6, 10),
	RK3506_CRU_RESET_OFFSET(SRST_P_WDT1, 6, 11),
	RK3506_CRU_RESET_OFFSET(SRST_T_WDT1, 6, 12),
	RK3506_CRU_RESET_OFFSET(SRST_P_MAILBOX, 6, 13),
	RK3506_CRU_RESET_OFFSET(SRST_P_INTMUX, 6, 14),
	RK3506_CRU_RESET_OFFSET(SRST_P_SPINLOCK, 6, 15),

	/* CRU-->SOFTRST_CON07 */
	RK3506_CRU_RESET_OFFSET(SRST_P_DDRC, 7, 0),
	RK3506_CRU_RESET_OFFSET(SRST_H_DDRPHY, 7, 1),
	RK3506_CRU_RESET_OFFSET(SRST_P_DDRMON, 7, 2),
	RK3506_CRU_RESET_OFFSET(SRST_DDRMON_OSC, 7, 3),
	RK3506_CRU_RESET_OFFSET(SRST_P_DDR_LPC, 7, 4),
	RK3506_CRU_RESET_OFFSET(SRST_H_USBOTG0, 7, 5),
	RK3506_CRU_RESET_OFFSET(SRST_USBOTG0_ADP, 7, 7),
	RK3506_CRU_RESET_OFFSET(SRST_H_USBOTG1, 7, 8),
	RK3506_CRU_RESET_OFFSET(SRST_USBOTG1_ADP, 7, 10),
	RK3506_CRU_RESET_OFFSET(SRST_P_USBPHY, 7, 11),
	RK3506_CRU_RESET_OFFSET(SRST_USBPHY_POR, 7, 12),
	RK3506_CRU_RESET_OFFSET(SRST_USBPHY_OTG0, 7, 13),
	RK3506_CRU_RESET_OFFSET(SRST_USBPHY_OTG1, 7, 14),

	/* CRU-->SOFTRST_CON08 */
	RK3506_CRU_RESET_OFFSET(SRST_A_DMA2DDR, 8, 0),
	RK3506_CRU_RESET_OFFSET(SRST_P_DMA2DDR, 8, 1),

	/* CRU-->SOFTRST_CON09 */
	RK3506_CRU_RESET_OFFSET(SRST_USBOTG0_UTMI, 9, 0),
	RK3506_CRU_RESET_OFFSET(SRST_USBOTG1_UTMI, 9, 1),

	/* CRU-->SOFTRST_CON10 */
	RK3506_CRU_RESET_OFFSET(SRST_A_DDRC_0, 10, 0),
	RK3506_CRU_RESET_OFFSET(SRST_A_DDRC_1, 10, 1),
	RK3506_CRU_RESET_OFFSET(SRST_A_DDR_BIU, 10, 2),
	RK3506_CRU_RESET_OFFSET(SRST_DDRC, 10, 3),
	RK3506_CRU_RESET_OFFSET(SRST_DDRMON, 10, 4),

	/* CRU-->SOFTRST_CON11 */
	RK3506_CRU_RESET_OFFSET(SRST_H_LSPERI_BIU, 11, 2),
	RK3506_CRU_RESET_OFFSET(SRST_P_UART0, 11, 4),
	RK3506_CRU_RESET_OFFSET(SRST_P_UART1, 11, 5),
	RK3506_CRU_RESET_OFFSET(SRST_P_UART2, 11, 6),
	RK3506_CRU_RESET_OFFSET(SRST_P_UART3, 11, 7),
	RK3506_CRU_RESET_OFFSET(SRST_P_UART4, 11, 8),
	RK3506_CRU_RESET_OFFSET(SRST_UART0, 11, 9),
	RK3506_CRU_RESET_OFFSET(SRST_UART1, 11, 10),
	RK3506_CRU_RESET_OFFSET(SRST_UART2, 11, 11),
	RK3506_CRU_RESET_OFFSET(SRST_UART3, 11, 12),
	RK3506_CRU_RESET_OFFSET(SRST_UART4, 11, 13),
	RK3506_CRU_RESET_OFFSET(SRST_P_I2C0, 11, 14),
	RK3506_CRU_RESET_OFFSET(SRST_I2C0, 11, 15),

	/* CRU-->SOFTRST_CON12 */
	RK3506_CRU_RESET_OFFSET(SRST_P_I2C1, 12, 0),
	RK3506_CRU_RESET_OFFSET(SRST_I2C1, 12, 1),
	RK3506_CRU_RESET_OFFSET(SRST_P_I2C2, 12, 2),
	RK3506_CRU_RESET_OFFSET(SRST_I2C2, 12, 3),
	RK3506_CRU_RESET_OFFSET(SRST_P_PWM1, 12, 4),
	RK3506_CRU_RESET_OFFSET(SRST_PWM1, 12, 5),
	RK3506_CRU_RESET_OFFSET(SRST_P_SPI0, 12, 10),
	RK3506_CRU_RESET_OFFSET(SRST_SPI0, 12, 11),
	RK3506_CRU_RESET_OFFSET(SRST_P_SPI1, 12, 12),
	RK3506_CRU_RESET_OFFSET(SRST_SPI1, 12, 13),
	RK3506_CRU_RESET_OFFSET(SRST_P_GPIO2, 12, 14),
	RK3506_CRU_RESET_OFFSET(SRST_DB_GPIO2, 12, 15),

	/* CRU-->SOFTRST_CON13 */
	RK3506_CRU_RESET_OFFSET(SRST_P_GPIO3, 13, 0),
	RK3506_CRU_RESET_OFFSET(SRST_DB_GPIO3, 13, 1),
	RK3506_CRU_RESET_OFFSET(SRST_P_GPIO4, 13, 2),
	RK3506_CRU_RESET_OFFSET(SRST_DB_GPIO4, 13, 3),
	RK3506_CRU_RESET_OFFSET(SRST_H_CAN0, 13, 4),
	RK3506_CRU_RESET_OFFSET(SRST_CAN0, 13, 5),
	RK3506_CRU_RESET_OFFSET(SRST_H_CAN1, 13, 6),
	RK3506_CRU_RESET_OFFSET(SRST_CAN1, 13, 7),
	RK3506_CRU_RESET_OFFSET(SRST_H_PDM, 13, 8),
	RK3506_CRU_RESET_OFFSET(SRST_M_PDM, 13, 9),
	RK3506_CRU_RESET_OFFSET(SRST_PDM, 13, 10),
	RK3506_CRU_RESET_OFFSET(SRST_SPDIFTX, 13, 11),
	RK3506_CRU_RESET_OFFSET(SRST_H_SPDIFTX, 13, 12),
	RK3506_CRU_RESET_OFFSET(SRST_H_SPDIFRX, 13, 13),
	RK3506_CRU_RESET_OFFSET(SRST_SPDIFRX, 13, 14),
	RK3506_CRU_RESET_OFFSET(SRST_M_SAI0, 13, 15),

	/* CRU-->SOFTRST_CON14 */
	RK3506_CRU_RESET_OFFSET(SRST_H_SAI0, 14, 0),
	RK3506_CRU_RESET_OFFSET(SRST_M_SAI1, 14, 2),
	RK3506_CRU_RESET_OFFSET(SRST_H_SAI1, 14, 3),
	RK3506_CRU_RESET_OFFSET(SRST_H_ASRC0, 14, 5),
	RK3506_CRU_RESET_OFFSET(SRST_ASRC0, 14, 6),
	RK3506_CRU_RESET_OFFSET(SRST_H_ASRC1, 14, 7),
	RK3506_CRU_RESET_OFFSET(SRST_ASRC1, 14, 8),

	/* CRU-->SOFTRST_CON17 */
	RK3506_CRU_RESET_OFFSET(SRST_H_HSPERI_BIU, 17, 4),
	RK3506_CRU_RESET_OFFSET(SRST_H_SDMMC, 17, 7),
	RK3506_CRU_RESET_OFFSET(SRST_H_FSPI, 17, 8),
	RK3506_CRU_RESET_OFFSET(SRST_S_FSPI, 17, 9),
	RK3506_CRU_RESET_OFFSET(SRST_P_SPI2, 17, 10),
	RK3506_CRU_RESET_OFFSET(SRST_A_MAC0, 17, 11),
	RK3506_CRU_RESET_OFFSET(SRST_A_MAC1, 17, 12),

	/* CRU-->SOFTRST_CON18 */
	RK3506_CRU_RESET_OFFSET(SRST_M_SAI2, 18, 2),
	RK3506_CRU_RESET_OFFSET(SRST_H_SAI2, 18, 3),
	RK3506_CRU_RESET_OFFSET(SRST_H_SAI3, 18, 6),
	RK3506_CRU_RESET_OFFSET(SRST_M_SAI3, 18, 7),
	RK3506_CRU_RESET_OFFSET(SRST_H_SAI4, 18, 10),
	RK3506_CRU_RESET_OFFSET(SRST_M_SAI4, 18, 11),
	RK3506_CRU_RESET_OFFSET(SRST_H_DSM, 18, 12),
	RK3506_CRU_RESET_OFFSET(SRST_M_DSM, 18, 13),
	RK3506_CRU_RESET_OFFSET(SRST_P_AUDIO_ADC, 18, 14),
	RK3506_CRU_RESET_OFFSET(SRST_M_AUDIO_ADC, 18, 15),

	/* CRU-->SOFTRST_CON19 */
	RK3506_CRU_RESET_OFFSET(SRST_P_SARADC, 19, 0),
	RK3506_CRU_RESET_OFFSET(SRST_SARADC, 19, 1),
	RK3506_CRU_RESET_OFFSET(SRST_SARADC_PHY, 19, 2),
	RK3506_CRU_RESET_OFFSET(SRST_P_OTPC_NS, 19, 3),
	RK3506_CRU_RESET_OFFSET(SRST_SBPI_OTPC_NS, 19, 4),
	RK3506_CRU_RESET_OFFSET(SRST_USER_OTPC_NS, 19, 5),
	RK3506_CRU_RESET_OFFSET(SRST_P_UART5, 19, 6),
	RK3506_CRU_RESET_OFFSET(SRST_UART5, 19, 7),
	RK3506_CRU_RESET_OFFSET(SRST_P_GPIO234_IOC, 19, 8),

	/* CRU-->SOFTRST_CON21 */
	RK3506_CRU_RESET_OFFSET(SRST_A_VIO_BIU, 21, 3),
	RK3506_CRU_RESET_OFFSET(SRST_H_VIO_BIU, 21, 4),
	RK3506_CRU_RESET_OFFSET(SRST_H_RGA, 21, 6),
	RK3506_CRU_RESET_OFFSET(SRST_A_RGA, 21, 7),
	RK3506_CRU_RESET_OFFSET(SRST_CORE_RGA, 21, 8),
	RK3506_CRU_RESET_OFFSET(SRST_A_VOP, 21, 9),
	RK3506_CRU_RESET_OFFSET(SRST_H_VOP, 21, 10),
	RK3506_CRU_RESET_OFFSET(SRST_VOP, 21, 11),
	RK3506_CRU_RESET_OFFSET(SRST_P_DPHY, 21, 12),
	RK3506_CRU_RESET_OFFSET(SRST_P_DSI_HOST, 21, 13),
	RK3506_CRU_RESET_OFFSET(SRST_P_TSADC, 21, 14),
	RK3506_CRU_RESET_OFFSET(SRST_TSADC, 21, 15),

	/* CRU-->SOFTRST_CON22 */
	RK3506_CRU_RESET_OFFSET(SRST_P_GPIO1_IOC, 22, 1),
};

void rk3506_rst_init(struct device_node *np, void __iomem *reg_base)
{
	rockchip_register_softrst_lut(np,
				      rk3506_register_offset,
				      ARRAY_SIZE(rk3506_register_offset),
				      reg_base + RK3506_SOFTRST_CON(0),
				      ROCKCHIP_SOFTRST_HIWORD_MASK);
}
