//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/netapp/armnetapp/v5"
	"net/http"
	"net/url"
	"regexp"
)

// ResourceServer is a fake server for instances of the armnetapp.ResourceClient type.
type ResourceServer struct {
	// CheckFilePathAvailability is the fake for method ResourceClient.CheckFilePathAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckFilePathAvailability func(ctx context.Context, location string, body armnetapp.FilePathAvailabilityRequest, options *armnetapp.ResourceClientCheckFilePathAvailabilityOptions) (resp azfake.Responder[armnetapp.ResourceClientCheckFilePathAvailabilityResponse], errResp azfake.ErrorResponder)

	// CheckNameAvailability is the fake for method ResourceClient.CheckNameAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckNameAvailability func(ctx context.Context, location string, body armnetapp.ResourceNameAvailabilityRequest, options *armnetapp.ResourceClientCheckNameAvailabilityOptions) (resp azfake.Responder[armnetapp.ResourceClientCheckNameAvailabilityResponse], errResp azfake.ErrorResponder)

	// CheckQuotaAvailability is the fake for method ResourceClient.CheckQuotaAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckQuotaAvailability func(ctx context.Context, location string, body armnetapp.QuotaAvailabilityRequest, options *armnetapp.ResourceClientCheckQuotaAvailabilityOptions) (resp azfake.Responder[armnetapp.ResourceClientCheckQuotaAvailabilityResponse], errResp azfake.ErrorResponder)

	// QueryNetworkSiblingSet is the fake for method ResourceClient.QueryNetworkSiblingSet
	// HTTP status codes to indicate success: http.StatusOK
	QueryNetworkSiblingSet func(ctx context.Context, location string, body armnetapp.QueryNetworkSiblingSetRequest, options *armnetapp.ResourceClientQueryNetworkSiblingSetOptions) (resp azfake.Responder[armnetapp.ResourceClientQueryNetworkSiblingSetResponse], errResp azfake.ErrorResponder)

	// QueryRegionInfo is the fake for method ResourceClient.QueryRegionInfo
	// HTTP status codes to indicate success: http.StatusOK
	QueryRegionInfo func(ctx context.Context, location string, options *armnetapp.ResourceClientQueryRegionInfoOptions) (resp azfake.Responder[armnetapp.ResourceClientQueryRegionInfoResponse], errResp azfake.ErrorResponder)

	// BeginUpdateNetworkSiblingSet is the fake for method ResourceClient.BeginUpdateNetworkSiblingSet
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateNetworkSiblingSet func(ctx context.Context, location string, body armnetapp.UpdateNetworkSiblingSetRequest, options *armnetapp.ResourceClientBeginUpdateNetworkSiblingSetOptions) (resp azfake.PollerResponder[armnetapp.ResourceClientUpdateNetworkSiblingSetResponse], errResp azfake.ErrorResponder)
}

// NewResourceServerTransport creates a new instance of ResourceServerTransport with the provided implementation.
// The returned ResourceServerTransport instance is connected to an instance of armnetapp.ResourceClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewResourceServerTransport(srv *ResourceServer) *ResourceServerTransport {
	return &ResourceServerTransport{
		srv:                          srv,
		beginUpdateNetworkSiblingSet: newTracker[azfake.PollerResponder[armnetapp.ResourceClientUpdateNetworkSiblingSetResponse]](),
	}
}

// ResourceServerTransport connects instances of armnetapp.ResourceClient to instances of ResourceServer.
// Don't use this type directly, use NewResourceServerTransport instead.
type ResourceServerTransport struct {
	srv                          *ResourceServer
	beginUpdateNetworkSiblingSet *tracker[azfake.PollerResponder[armnetapp.ResourceClientUpdateNetworkSiblingSetResponse]]
}

// Do implements the policy.Transporter interface for ResourceServerTransport.
func (r *ResourceServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ResourceClient.CheckFilePathAvailability":
		resp, err = r.dispatchCheckFilePathAvailability(req)
	case "ResourceClient.CheckNameAvailability":
		resp, err = r.dispatchCheckNameAvailability(req)
	case "ResourceClient.CheckQuotaAvailability":
		resp, err = r.dispatchCheckQuotaAvailability(req)
	case "ResourceClient.QueryNetworkSiblingSet":
		resp, err = r.dispatchQueryNetworkSiblingSet(req)
	case "ResourceClient.QueryRegionInfo":
		resp, err = r.dispatchQueryRegionInfo(req)
	case "ResourceClient.BeginUpdateNetworkSiblingSet":
		resp, err = r.dispatchBeginUpdateNetworkSiblingSet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ResourceServerTransport) dispatchCheckFilePathAvailability(req *http.Request) (*http.Response, error) {
	if r.srv.CheckFilePathAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckFilePathAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/checkFilePathAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armnetapp.FilePathAvailabilityRequest](req)
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.CheckFilePathAvailability(req.Context(), locationParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckAvailabilityResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchCheckNameAvailability(req *http.Request) (*http.Response, error) {
	if r.srv.CheckNameAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckNameAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/checkNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armnetapp.ResourceNameAvailabilityRequest](req)
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.CheckNameAvailability(req.Context(), locationParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckAvailabilityResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchCheckQuotaAvailability(req *http.Request) (*http.Response, error) {
	if r.srv.CheckQuotaAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckQuotaAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/checkQuotaAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armnetapp.QuotaAvailabilityRequest](req)
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.CheckQuotaAvailability(req.Context(), locationParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckAvailabilityResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchQueryNetworkSiblingSet(req *http.Request) (*http.Response, error) {
	if r.srv.QueryNetworkSiblingSet == nil {
		return nil, &nonRetriableError{errors.New("fake for method QueryNetworkSiblingSet not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryNetworkSiblingSet`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armnetapp.QueryNetworkSiblingSetRequest](req)
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.QueryNetworkSiblingSet(req.Context(), locationParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NetworkSiblingSet, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchQueryRegionInfo(req *http.Request) (*http.Response, error) {
	if r.srv.QueryRegionInfo == nil {
		return nil, &nonRetriableError{errors.New("fake for method QueryRegionInfo not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/regionInfo`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.QueryRegionInfo(req.Context(), locationParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RegionInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceServerTransport) dispatchBeginUpdateNetworkSiblingSet(req *http.Request) (*http.Response, error) {
	if r.srv.BeginUpdateNetworkSiblingSet == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateNetworkSiblingSet not implemented")}
	}
	beginUpdateNetworkSiblingSet := r.beginUpdateNetworkSiblingSet.get(req)
	if beginUpdateNetworkSiblingSet == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/updateNetworkSiblingSet`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetapp.UpdateNetworkSiblingSetRequest](req)
		if err != nil {
			return nil, err
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginUpdateNetworkSiblingSet(req.Context(), locationParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateNetworkSiblingSet = &respr
		r.beginUpdateNetworkSiblingSet.add(req, beginUpdateNetworkSiblingSet)
	}

	resp, err := server.PollerResponderNext(beginUpdateNetworkSiblingSet, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginUpdateNetworkSiblingSet.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateNetworkSiblingSet) {
		r.beginUpdateNetworkSiblingSet.remove(req)
	}

	return resp, nil
}
