//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/delegatednetwork/armdelegatednetwork"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// DelegatedSubnetServiceServer is a fake server for instances of the armdelegatednetwork.DelegatedSubnetServiceClient type.
type DelegatedSubnetServiceServer struct {
	// BeginDeleteDetails is the fake for method DelegatedSubnetServiceClient.BeginDeleteDetails
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeleteDetails func(ctx context.Context, resourceGroupName string, resourceName string, options *armdelegatednetwork.DelegatedSubnetServiceClientBeginDeleteDetailsOptions) (resp azfake.PollerResponder[armdelegatednetwork.DelegatedSubnetServiceClientDeleteDetailsResponse], errResp azfake.ErrorResponder)

	// GetDetails is the fake for method DelegatedSubnetServiceClient.GetDetails
	// HTTP status codes to indicate success: http.StatusOK
	GetDetails func(ctx context.Context, resourceGroupName string, resourceName string, options *armdelegatednetwork.DelegatedSubnetServiceClientGetDetailsOptions) (resp azfake.Responder[armdelegatednetwork.DelegatedSubnetServiceClientGetDetailsResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method DelegatedSubnetServiceClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armdelegatednetwork.DelegatedSubnetServiceClientListByResourceGroupOptions) (resp azfake.PagerResponder[armdelegatednetwork.DelegatedSubnetServiceClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method DelegatedSubnetServiceClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armdelegatednetwork.DelegatedSubnetServiceClientListBySubscriptionOptions) (resp azfake.PagerResponder[armdelegatednetwork.DelegatedSubnetServiceClientListBySubscriptionResponse])

	// BeginPatchDetails is the fake for method DelegatedSubnetServiceClient.BeginPatchDetails
	// HTTP status codes to indicate success: http.StatusOK
	BeginPatchDetails func(ctx context.Context, resourceGroupName string, resourceName string, parameters armdelegatednetwork.ResourceUpdateParameters, options *armdelegatednetwork.DelegatedSubnetServiceClientBeginPatchDetailsOptions) (resp azfake.PollerResponder[armdelegatednetwork.DelegatedSubnetServiceClientPatchDetailsResponse], errResp azfake.ErrorResponder)

	// BeginPutDetails is the fake for method DelegatedSubnetServiceClient.BeginPutDetails
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginPutDetails func(ctx context.Context, resourceGroupName string, resourceName string, parameters armdelegatednetwork.DelegatedSubnet, options *armdelegatednetwork.DelegatedSubnetServiceClientBeginPutDetailsOptions) (resp azfake.PollerResponder[armdelegatednetwork.DelegatedSubnetServiceClientPutDetailsResponse], errResp azfake.ErrorResponder)
}

// NewDelegatedSubnetServiceServerTransport creates a new instance of DelegatedSubnetServiceServerTransport with the provided implementation.
// The returned DelegatedSubnetServiceServerTransport instance is connected to an instance of armdelegatednetwork.DelegatedSubnetServiceClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDelegatedSubnetServiceServerTransport(srv *DelegatedSubnetServiceServer) *DelegatedSubnetServiceServerTransport {
	return &DelegatedSubnetServiceServerTransport{
		srv:                         srv,
		beginDeleteDetails:          newTracker[azfake.PollerResponder[armdelegatednetwork.DelegatedSubnetServiceClientDeleteDetailsResponse]](),
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armdelegatednetwork.DelegatedSubnetServiceClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:  newTracker[azfake.PagerResponder[armdelegatednetwork.DelegatedSubnetServiceClientListBySubscriptionResponse]](),
		beginPatchDetails:           newTracker[azfake.PollerResponder[armdelegatednetwork.DelegatedSubnetServiceClientPatchDetailsResponse]](),
		beginPutDetails:             newTracker[azfake.PollerResponder[armdelegatednetwork.DelegatedSubnetServiceClientPutDetailsResponse]](),
	}
}

// DelegatedSubnetServiceServerTransport connects instances of armdelegatednetwork.DelegatedSubnetServiceClient to instances of DelegatedSubnetServiceServer.
// Don't use this type directly, use NewDelegatedSubnetServiceServerTransport instead.
type DelegatedSubnetServiceServerTransport struct {
	srv                         *DelegatedSubnetServiceServer
	beginDeleteDetails          *tracker[azfake.PollerResponder[armdelegatednetwork.DelegatedSubnetServiceClientDeleteDetailsResponse]]
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armdelegatednetwork.DelegatedSubnetServiceClientListByResourceGroupResponse]]
	newListBySubscriptionPager  *tracker[azfake.PagerResponder[armdelegatednetwork.DelegatedSubnetServiceClientListBySubscriptionResponse]]
	beginPatchDetails           *tracker[azfake.PollerResponder[armdelegatednetwork.DelegatedSubnetServiceClientPatchDetailsResponse]]
	beginPutDetails             *tracker[azfake.PollerResponder[armdelegatednetwork.DelegatedSubnetServiceClientPutDetailsResponse]]
}

// Do implements the policy.Transporter interface for DelegatedSubnetServiceServerTransport.
func (d *DelegatedSubnetServiceServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DelegatedSubnetServiceClient.BeginDeleteDetails":
		resp, err = d.dispatchBeginDeleteDetails(req)
	case "DelegatedSubnetServiceClient.GetDetails":
		resp, err = d.dispatchGetDetails(req)
	case "DelegatedSubnetServiceClient.NewListByResourceGroupPager":
		resp, err = d.dispatchNewListByResourceGroupPager(req)
	case "DelegatedSubnetServiceClient.NewListBySubscriptionPager":
		resp, err = d.dispatchNewListBySubscriptionPager(req)
	case "DelegatedSubnetServiceClient.BeginPatchDetails":
		resp, err = d.dispatchBeginPatchDetails(req)
	case "DelegatedSubnetServiceClient.BeginPutDetails":
		resp, err = d.dispatchBeginPutDetails(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DelegatedSubnetServiceServerTransport) dispatchBeginDeleteDetails(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDeleteDetails == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteDetails not implemented")}
	}
	beginDeleteDetails := d.beginDeleteDetails.get(req)
	if beginDeleteDetails == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DelegatedNetwork/delegatedSubnets/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		forceDeleteUnescaped, err := url.QueryUnescape(qp.Get("forceDelete"))
		if err != nil {
			return nil, err
		}
		forceDeleteParam, err := parseOptional(forceDeleteUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armdelegatednetwork.DelegatedSubnetServiceClientBeginDeleteDetailsOptions
		if forceDeleteParam != nil {
			options = &armdelegatednetwork.DelegatedSubnetServiceClientBeginDeleteDetailsOptions{
				ForceDelete: forceDeleteParam,
			}
		}
		respr, errRespr := d.srv.BeginDeleteDetails(req.Context(), resourceGroupNameParam, resourceNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteDetails = &respr
		d.beginDeleteDetails.add(req, beginDeleteDetails)
	}

	resp, err := server.PollerResponderNext(beginDeleteDetails, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDeleteDetails.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteDetails) {
		d.beginDeleteDetails.remove(req)
	}

	return resp, nil
}

func (d *DelegatedSubnetServiceServerTransport) dispatchGetDetails(req *http.Request) (*http.Response, error) {
	if d.srv.GetDetails == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDetails not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DelegatedNetwork/delegatedSubnets/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetDetails(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DelegatedSubnet, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DelegatedSubnetServiceServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := d.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DelegatedNetwork/delegatedSubnets`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		d.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armdelegatednetwork.DelegatedSubnetServiceClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		d.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (d *DelegatedSubnetServiceServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := d.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DelegatedNetwork/delegatedSubnets`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := d.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		d.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armdelegatednetwork.DelegatedSubnetServiceClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		d.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (d *DelegatedSubnetServiceServerTransport) dispatchBeginPatchDetails(req *http.Request) (*http.Response, error) {
	if d.srv.BeginPatchDetails == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPatchDetails not implemented")}
	}
	beginPatchDetails := d.beginPatchDetails.get(req)
	if beginPatchDetails == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DelegatedNetwork/delegatedSubnets/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdelegatednetwork.ResourceUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginPatchDetails(req.Context(), resourceGroupNameParam, resourceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPatchDetails = &respr
		d.beginPatchDetails.add(req, beginPatchDetails)
	}

	resp, err := server.PollerResponderNext(beginPatchDetails, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.beginPatchDetails.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPatchDetails) {
		d.beginPatchDetails.remove(req)
	}

	return resp, nil
}

func (d *DelegatedSubnetServiceServerTransport) dispatchBeginPutDetails(req *http.Request) (*http.Response, error) {
	if d.srv.BeginPutDetails == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPutDetails not implemented")}
	}
	beginPutDetails := d.beginPutDetails.get(req)
	if beginPutDetails == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DelegatedNetwork/delegatedSubnets/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdelegatednetwork.DelegatedSubnet](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginPutDetails(req.Context(), resourceGroupNameParam, resourceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPutDetails = &respr
		d.beginPutDetails.add(req, beginPutDetails)
	}

	resp, err := server.PollerResponderNext(beginPutDetails, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		d.beginPutDetails.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPutDetails) {
		d.beginPutDetails.remove(req)
	}

	return resp, nil
}
