//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cdn/armcdn/v2"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// CustomDomainsServer is a fake server for instances of the armcdn.CustomDomainsClient type.
type CustomDomainsServer struct {
	// BeginCreate is the fake for method CustomDomainsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreate func(ctx context.Context, resourceGroupName string, profileName string, endpointName string, customDomainName string, customDomainProperties armcdn.CustomDomainParameters, options *armcdn.CustomDomainsClientBeginCreateOptions) (resp azfake.PollerResponder[armcdn.CustomDomainsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method CustomDomainsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, profileName string, endpointName string, customDomainName string, options *armcdn.CustomDomainsClientBeginDeleteOptions) (resp azfake.PollerResponder[armcdn.CustomDomainsClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDisableCustomHTTPS is the fake for method CustomDomainsClient.BeginDisableCustomHTTPS
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDisableCustomHTTPS func(ctx context.Context, resourceGroupName string, profileName string, endpointName string, customDomainName string, options *armcdn.CustomDomainsClientBeginDisableCustomHTTPSOptions) (resp azfake.PollerResponder[armcdn.CustomDomainsClientDisableCustomHTTPSResponse], errResp azfake.ErrorResponder)

	// BeginEnableCustomHTTPS is the fake for method CustomDomainsClient.BeginEnableCustomHTTPS
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginEnableCustomHTTPS func(ctx context.Context, resourceGroupName string, profileName string, endpointName string, customDomainName string, options *armcdn.CustomDomainsClientBeginEnableCustomHTTPSOptions) (resp azfake.PollerResponder[armcdn.CustomDomainsClientEnableCustomHTTPSResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method CustomDomainsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, profileName string, endpointName string, customDomainName string, options *armcdn.CustomDomainsClientGetOptions) (resp azfake.Responder[armcdn.CustomDomainsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByEndpointPager is the fake for method CustomDomainsClient.NewListByEndpointPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByEndpointPager func(resourceGroupName string, profileName string, endpointName string, options *armcdn.CustomDomainsClientListByEndpointOptions) (resp azfake.PagerResponder[armcdn.CustomDomainsClientListByEndpointResponse])
}

// NewCustomDomainsServerTransport creates a new instance of CustomDomainsServerTransport with the provided implementation.
// The returned CustomDomainsServerTransport instance is connected to an instance of armcdn.CustomDomainsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCustomDomainsServerTransport(srv *CustomDomainsServer) *CustomDomainsServerTransport {
	return &CustomDomainsServerTransport{
		srv:                     srv,
		beginCreate:             newTracker[azfake.PollerResponder[armcdn.CustomDomainsClientCreateResponse]](),
		beginDelete:             newTracker[azfake.PollerResponder[armcdn.CustomDomainsClientDeleteResponse]](),
		beginDisableCustomHTTPS: newTracker[azfake.PollerResponder[armcdn.CustomDomainsClientDisableCustomHTTPSResponse]](),
		beginEnableCustomHTTPS:  newTracker[azfake.PollerResponder[armcdn.CustomDomainsClientEnableCustomHTTPSResponse]](),
		newListByEndpointPager:  newTracker[azfake.PagerResponder[armcdn.CustomDomainsClientListByEndpointResponse]](),
	}
}

// CustomDomainsServerTransport connects instances of armcdn.CustomDomainsClient to instances of CustomDomainsServer.
// Don't use this type directly, use NewCustomDomainsServerTransport instead.
type CustomDomainsServerTransport struct {
	srv                     *CustomDomainsServer
	beginCreate             *tracker[azfake.PollerResponder[armcdn.CustomDomainsClientCreateResponse]]
	beginDelete             *tracker[azfake.PollerResponder[armcdn.CustomDomainsClientDeleteResponse]]
	beginDisableCustomHTTPS *tracker[azfake.PollerResponder[armcdn.CustomDomainsClientDisableCustomHTTPSResponse]]
	beginEnableCustomHTTPS  *tracker[azfake.PollerResponder[armcdn.CustomDomainsClientEnableCustomHTTPSResponse]]
	newListByEndpointPager  *tracker[azfake.PagerResponder[armcdn.CustomDomainsClientListByEndpointResponse]]
}

// Do implements the policy.Transporter interface for CustomDomainsServerTransport.
func (c *CustomDomainsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CustomDomainsClient.BeginCreate":
		resp, err = c.dispatchBeginCreate(req)
	case "CustomDomainsClient.BeginDelete":
		resp, err = c.dispatchBeginDelete(req)
	case "CustomDomainsClient.BeginDisableCustomHTTPS":
		resp, err = c.dispatchBeginDisableCustomHTTPS(req)
	case "CustomDomainsClient.BeginEnableCustomHTTPS":
		resp, err = c.dispatchBeginEnableCustomHTTPS(req)
	case "CustomDomainsClient.Get":
		resp, err = c.dispatchGet(req)
	case "CustomDomainsClient.NewListByEndpointPager":
		resp, err = c.dispatchNewListByEndpointPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CustomDomainsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := c.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/endpoints/(?P<endpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customDomains/(?P<customDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcdn.CustomDomainParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
		if err != nil {
			return nil, err
		}
		endpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("endpointName")])
		if err != nil {
			return nil, err
		}
		customDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("customDomainName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreate(req.Context(), resourceGroupNameParam, profileNameParam, endpointNameParam, customDomainNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		c.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		c.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		c.beginCreate.remove(req)
	}

	return resp, nil
}

func (c *CustomDomainsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := c.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/endpoints/(?P<endpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customDomains/(?P<customDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
		if err != nil {
			return nil, err
		}
		endpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("endpointName")])
		if err != nil {
			return nil, err
		}
		customDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("customDomainName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDelete(req.Context(), resourceGroupNameParam, profileNameParam, endpointNameParam, customDomainNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		c.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		c.beginDelete.remove(req)
	}

	return resp, nil
}

func (c *CustomDomainsServerTransport) dispatchBeginDisableCustomHTTPS(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDisableCustomHTTPS == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDisableCustomHTTPS not implemented")}
	}
	beginDisableCustomHTTPS := c.beginDisableCustomHTTPS.get(req)
	if beginDisableCustomHTTPS == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/endpoints/(?P<endpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customDomains/(?P<customDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/disableCustomHttps`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
		if err != nil {
			return nil, err
		}
		endpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("endpointName")])
		if err != nil {
			return nil, err
		}
		customDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("customDomainName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDisableCustomHTTPS(req.Context(), resourceGroupNameParam, profileNameParam, endpointNameParam, customDomainNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDisableCustomHTTPS = &respr
		c.beginDisableCustomHTTPS.add(req, beginDisableCustomHTTPS)
	}

	resp, err := server.PollerResponderNext(beginDisableCustomHTTPS, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginDisableCustomHTTPS.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDisableCustomHTTPS) {
		c.beginDisableCustomHTTPS.remove(req)
	}

	return resp, nil
}

func (c *CustomDomainsServerTransport) dispatchBeginEnableCustomHTTPS(req *http.Request) (*http.Response, error) {
	if c.srv.BeginEnableCustomHTTPS == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginEnableCustomHTTPS not implemented")}
	}
	beginEnableCustomHTTPS := c.beginEnableCustomHTTPS.get(req)
	if beginEnableCustomHTTPS == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/endpoints/(?P<endpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customDomains/(?P<customDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/enableCustomHttps`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		raw, err := readRequestBody(req)
		if err != nil {
			return nil, err
		}
		body, err := unmarshalCustomDomainHTTPSParametersClassification(raw)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
		if err != nil {
			return nil, err
		}
		endpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("endpointName")])
		if err != nil {
			return nil, err
		}
		customDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("customDomainName")])
		if err != nil {
			return nil, err
		}
		var options *armcdn.CustomDomainsClientBeginEnableCustomHTTPSOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armcdn.CustomDomainsClientBeginEnableCustomHTTPSOptions{
				CustomDomainHTTPSParameters: body,
			}
		}
		respr, errRespr := c.srv.BeginEnableCustomHTTPS(req.Context(), resourceGroupNameParam, profileNameParam, endpointNameParam, customDomainNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginEnableCustomHTTPS = &respr
		c.beginEnableCustomHTTPS.add(req, beginEnableCustomHTTPS)
	}

	resp, err := server.PollerResponderNext(beginEnableCustomHTTPS, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginEnableCustomHTTPS.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginEnableCustomHTTPS) {
		c.beginEnableCustomHTTPS.remove(req)
	}

	return resp, nil
}

func (c *CustomDomainsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/endpoints/(?P<endpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customDomains/(?P<customDomainName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
	if err != nil {
		return nil, err
	}
	endpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("endpointName")])
	if err != nil {
		return nil, err
	}
	customDomainNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("customDomainName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, profileNameParam, endpointNameParam, customDomainNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CustomDomain, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CustomDomainsServerTransport) dispatchNewListByEndpointPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByEndpointPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByEndpointPager not implemented")}
	}
	newListByEndpointPager := c.newListByEndpointPager.get(req)
	if newListByEndpointPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/endpoints/(?P<endpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customDomains`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
		if err != nil {
			return nil, err
		}
		endpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("endpointName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListByEndpointPager(resourceGroupNameParam, profileNameParam, endpointNameParam, nil)
		newListByEndpointPager = &resp
		c.newListByEndpointPager.add(req, newListByEndpointPager)
		server.PagerResponderInjectNextLinks(newListByEndpointPager, req, func(page *armcdn.CustomDomainsClientListByEndpointResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByEndpointPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByEndpointPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByEndpointPager) {
		c.newListByEndpointPager.remove(req)
	}
	return resp, nil
}
