//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappservice_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appservice/armappservice/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/Diagnostics_ListAppServiceCertificateOrderDetectorResponse.json
func ExampleCertificateOrdersDiagnosticsClient_NewListAppServiceCertificateOrderDetectorResponsePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewCertificateOrdersDiagnosticsClient().NewListAppServiceCertificateOrderDetectorResponsePager("Sample-WestUSResourceGroup", "SampleCertificateOrderName", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DetectorResponseCollection = armappservice.DetectorResponseCollection{
		// 	Value: []*armappservice.DetectorResponse{
		// 		{
		// 			Name: to.Ptr("CertsImport"),
		// 			Type: to.Ptr("Microsoft.Web/certificateOrders/detectors"),
		// 			ID: to.Ptr("/subscriptions/5700fc96-77b4-4f8d-afce-c353d8c443bd/resourceGroups/Sample-WestUSResourceGroup/providers/Microsoft.CertificateRegistration/certificateOrders/SampleCertificateOrderName/detectors/CertsImport"),
		// 			Properties: &armappservice.DetectorResponseProperties{
		// 				Dataset: []*armappservice.DiagnosticData{
		// 				},
		// 				Metadata: &armappservice.DetectorInfo{
		// 					Name: to.Ptr("Certificates Import/Upload"),
		// 					Author: to.Ptr(""),
		// 					ID: to.Ptr("CertsImport"),
		// 				},
		// 				Status: &armappservice.Status{
		// 					StatusID: to.Ptr(armappservice.InsightStatusNone),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.CertificateRegistration/stable/2023-01-01/examples/Diagnostics_GetAppServiceCertificateOrderDetectorResponse.json
func ExampleCertificateOrdersDiagnosticsClient_GetAppServiceCertificateOrderDetectorResponse() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCertificateOrdersDiagnosticsClient().GetAppServiceCertificateOrderDetectorResponse(ctx, "Sample-WestUSResourceGroup", "SampleCertificateOrderName", "AutoRenewStatus", &armappservice.CertificateOrdersDiagnosticsClientGetAppServiceCertificateOrderDetectorResponseOptions{StartTime: nil,
		EndTime:   nil,
		TimeGrain: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DetectorResponse = armappservice.DetectorResponse{
	// 	Name: to.Ptr("AutoRenewStatus"),
	// 	ID: to.Ptr("/subscriptions/5700fc96-77b4-4f8d-afce-c353d8c443bd/resourceGroups/Sample-WestUSResourceGroup/providers/Microsoft.CertificateRegistration/certificateOrders/SampleCertificateOrderName/detectors/AutoRenewStatus"),
	// 	Properties: &armappservice.DetectorResponseProperties{
	// 		Dataset: []*armappservice.DiagnosticData{
	// 			{
	// 				RenderingProperties: &armappservice.Rendering{
	// 					Type: to.Ptr(armappservice.RenderingTypeInsights),
	// 				},
	// 				Table: &armappservice.DataTableResponseObject{
	// 					Columns: []*armappservice.DataTableResponseColumn{
	// 						{
	// 							ColumnName: to.Ptr("Status"),
	// 							DataType: to.Ptr("String"),
	// 						},
	// 						{
	// 							ColumnName: to.Ptr("Message"),
	// 							DataType: to.Ptr("String"),
	// 						},
	// 						{
	// 							ColumnName: to.Ptr("Data.Name"),
	// 							DataType: to.Ptr("String"),
	// 						},
	// 						{
	// 							ColumnName: to.Ptr("Data.Value"),
	// 							DataType: to.Ptr("String"),
	// 						},
	// 						{
	// 							ColumnName: to.Ptr("Expanded"),
	// 							DataType: to.Ptr("String"),
	// 						},
	// 						{
	// 							ColumnName: to.Ptr("Solutions"),
	// 							DataType: to.Ptr("String"),
	// 					}},
	// 					Rows: [][]*string{
	// 						[]*string{
	// 							to.Ptr("Info"),
	// 							to.Ptr("App Service Certificate name SampleCertificateOrderName"),
	// 							to.Ptr("Certificate for"),
	// 							to.Ptr("<b>*.mysampledomain.com</b>"),
	// 							to.Ptr("False"),
	// 							to.Ptr("null")},
	// 							[]*string{
	// 								to.Ptr("Info"),
	// 								to.Ptr("App Service Certificate name SampleCertificateOrderName"),
	// 								to.Ptr("Certificate Status"),
	// 								to.Ptr("<b>Issued</b>"),
	// 								to.Ptr("False"),
	// 								to.Ptr("null")}},
	// 								TableName: to.Ptr(""),
	// 							},
	// 					}},
	// 					Metadata: &armappservice.DetectorInfo{
	// 						Name: to.Ptr("AutoRenewStatus"),
	// 						Type: to.Ptr(armappservice.DetectorTypeDetector),
	// 						Description: to.Ptr("Check auto renew status"),
	// 						ID: to.Ptr("AutoRenewStatus"),
	// 						Score: to.Ptr[float32](0),
	// 						SupportTopicList: []*armappservice.SupportTopic{
	// 						},
	// 					},
	// 				},
	// 			}
}
