// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Contains information about the comma-separated value (CSV) file to select from.
type CSVInput struct {

	// A single character used to indicate that a row should be ignored when the
	// character is present at the start of that row.
	Comments *string

	// A value used to separate individual fields from each other within a record.
	FieldDelimiter *string

	// Describes the first line of input. Valid values are None , Ignore , and Use .
	FileHeaderInfo FileHeaderInfo

	// A value used as an escape character where the field delimiter is part of the
	// value.
	QuoteCharacter *string

	// A single character used for escaping the quotation-mark character inside an
	// already escaped value.
	QuoteEscapeCharacter *string

	// A value used to separate individual records from each other.
	RecordDelimiter *string

	noSmithyDocumentSerde
}

// Contains information about the comma-separated value (CSV) file that the job
// results are stored in.
type CSVOutput struct {

	// A value used to separate individual fields from each other within a record.
	FieldDelimiter *string

	// A value used as an escape character where the field delimiter is part of the
	// value.
	QuoteCharacter *string

	// A single character used for escaping the quotation-mark character inside an
	// already escaped value.
	QuoteEscapeCharacter *string

	// A value that indicates whether all output fields should be contained within
	// quotation marks.
	QuoteFields QuoteFields

	// A value used to separate individual records from each other.
	RecordDelimiter *string

	noSmithyDocumentSerde
}

// Data retrieval policy.
type DataRetrievalPolicy struct {

	// The policy rule. Although this is a list type, currently there must be only one
	// rule, which contains a Strategy field and optionally a BytesPerHour field.
	Rules []DataRetrievalRule

	noSmithyDocumentSerde
}

// Data retrieval policy rule.
type DataRetrievalRule struct {

	// The maximum number of bytes that can be retrieved in an hour.
	//
	// This field is required only if the value of the Strategy field is BytesPerHour .
	// Your PUT operation will be rejected if the Strategy field is not set to
	// BytesPerHour and you set this field.
	BytesPerHour *int64

	// The type of data retrieval policy to set.
	//
	// Valid values: BytesPerHour|FreeTier|None
	Strategy *string

	noSmithyDocumentSerde
}

// Contains the Amazon S3 Glacier response to your request.
type DescribeVaultOutput struct {

	// The Universal Coordinated Time (UTC) date when the vault was created. This
	// value should be a string in the ISO 8601 date format, for example
	// 2012-03-20T17:03:43.221Z .
	CreationDate *string

	// The Universal Coordinated Time (UTC) date when Amazon S3 Glacier completed the
	// last vault inventory. This value should be a string in the ISO 8601 date format,
	// for example 2012-03-20T17:03:43.221Z .
	LastInventoryDate *string

	// The number of archives in the vault as of the last inventory date. This field
	// will return null if an inventory has not yet run on the vault, for example if
	// you just created the vault.
	NumberOfArchives int64

	// Total size, in bytes, of the archives in the vault as of the last inventory
	// date. This field will return null if an inventory has not yet run on the vault,
	// for example if you just created the vault.
	SizeInBytes int64

	// The Amazon Resource Name (ARN) of the vault.
	VaultARN *string

	// The name of the vault.
	VaultName *string

	noSmithyDocumentSerde
}

// Contains information about the encryption used to store the job results in
// Amazon S3.
type Encryption struct {

	// The server-side encryption algorithm used when storing job results in Amazon
	// S3, for example AES256 or aws:kms .
	EncryptionType EncryptionType

	// Optional. If the encryption type is aws:kms , you can use this value to specify
	// the encryption context for the job results.
	KMSContext *string

	// The AWS KMS key ID to use for object encryption. All GET and PUT requests for
	// an object protected by AWS KMS fail if not made by using Secure Sockets Layer
	// (SSL) or Signature Version 4.
	KMSKeyId *string

	noSmithyDocumentSerde
}

// Contains the description of an Amazon S3 Glacier job.
type GlacierJobDescription struct {

	// The job type. This value is either ArchiveRetrieval , InventoryRetrieval , or
	// Select .
	Action ActionCode

	// The archive ID requested for a select job or archive retrieval. Otherwise, this
	// field is null.
	ArchiveId *string

	// The SHA256 tree hash of the entire archive for an archive retrieval. For
	// inventory retrieval or select jobs, this field is null.
	ArchiveSHA256TreeHash *string

	// For an archive retrieval job, this value is the size in bytes of the archive
	// being requested for download. For an inventory retrieval or select job, this
	// value is null.
	ArchiveSizeInBytes *int64

	// The job status. When a job is completed, you get the job's output using Get Job
	// Output (GET output).
	Completed bool

	// The UTC time that the job request completed. While the job is in progress, the
	// value is null.
	CompletionDate *string

	// The UTC date when the job was created. This value is a string representation of
	// ISO 8601 date format, for example "2012-03-20T17:03:43.221Z" .
	CreationDate *string

	// Parameters used for range inventory retrieval.
	InventoryRetrievalParameters *InventoryRetrievalJobDescription

	// For an inventory retrieval job, this value is the size in bytes of the
	// inventory requested for download. For an archive retrieval or select job, this
	// value is null.
	InventorySizeInBytes *int64

	// The job description provided when initiating the job.
	JobDescription *string

	// An opaque string that identifies an Amazon S3 Glacier job.
	JobId *string

	// Contains the job output location.
	JobOutputPath *string

	// Contains the location where the data from the select job is stored.
	OutputLocation *OutputLocation

	// The retrieved byte range for archive retrieval jobs in the form
	// StartByteValue-EndByteValue. If no range was specified in the archive retrieval,
	// then the whole archive is retrieved. In this case, StartByteValue equals 0 and
	// EndByteValue equals the size of the archive minus 1. For inventory retrieval or
	// select jobs, this field is null.
	RetrievalByteRange *string

	// For an archive retrieval job, this value is the checksum of the archive.
	// Otherwise, this value is null.
	//
	// The SHA256 tree hash value for the requested range of an archive. If the
	// InitiateJob request for an archive specified a tree-hash aligned range, then
	// this field returns a value.
	//
	// If the whole archive is retrieved, this value is the same as the
	// ArchiveSHA256TreeHash value.
	//
	// This field is null for the following:
	//
	//   - Archive retrieval jobs that specify a range that is not tree-hash aligned
	//
	//   - Archival jobs that specify a range that is equal to the whole archive, when
	//   the job status is InProgress
	//
	//   - Inventory jobs
	//
	//   - Select jobs
	SHA256TreeHash *string

	// An Amazon SNS topic that receives notification.
	SNSTopic *string

	// Contains the parameters used for a select.
	SelectParameters *SelectParameters

	// The status code can be InProgress , Succeeded , or Failed , and indicates the
	// status of the job.
	StatusCode StatusCode

	// A friendly message that describes the job status.
	StatusMessage *string

	// The tier to use for a select or an archive retrieval. Valid values are Expedited
	// , Standard , or Bulk . Standard is the default.
	Tier *string

	// The Amazon Resource Name (ARN) of the vault from which an archive retrieval was
	// requested.
	VaultARN *string

	noSmithyDocumentSerde
}

// Contains information about a grant.
type Grant struct {

	// The grantee.
	Grantee *Grantee

	// Specifies the permission given to the grantee.
	Permission Permission

	noSmithyDocumentSerde
}

// Contains information about the grantee.
type Grantee struct {

	// Type of grantee
	//
	// This member is required.
	Type Type

	// Screen name of the grantee.
	DisplayName *string

	// Email address of the grantee.
	EmailAddress *string

	// The canonical user ID of the grantee.
	ID *string

	// URI of the grantee group.
	URI *string

	noSmithyDocumentSerde
}

// Describes how the archive is serialized.
type InputSerialization struct {

	// Describes the serialization of a CSV-encoded object.
	Csv *CSVInput

	noSmithyDocumentSerde
}

// Describes the options for a range inventory retrieval job.
type InventoryRetrievalJobDescription struct {

	// The end of the date range in UTC for vault inventory retrieval that includes
	// archives created before this date. This value should be a string in the ISO 8601
	// date format, for example 2013-03-20T17:03:43Z .
	EndDate *string

	// The output format for the vault inventory list, which is set by the InitiateJob
	// request when initiating a job to retrieve a vault inventory. Valid values are
	// CSV and JSON .
	Format *string

	// The maximum number of inventory items returned per vault inventory retrieval
	// request. This limit is set when initiating the job with the a InitiateJob
	// request.
	Limit *string

	// An opaque string that represents where to continue pagination of the vault
	// inventory retrieval results. You use the marker in a new InitiateJob request to
	// obtain additional inventory items. If there are no more inventory items, this
	// value is null . For more information, see [Range Inventory Retrieval].
	//
	// [Range Inventory Retrieval]: https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html#api-initiate-job-post-vault-inventory-list-filtering
	Marker *string

	// The start of the date range in Universal Coordinated Time (UTC) for vault
	// inventory retrieval that includes archives created on or after this date. This
	// value should be a string in the ISO 8601 date format, for example
	// 2013-03-20T17:03:43Z .
	StartDate *string

	noSmithyDocumentSerde
}

// Provides options for specifying a range inventory retrieval job.
type InventoryRetrievalJobInput struct {

	// The end of the date range in UTC for vault inventory retrieval that includes
	// archives created before this date. This value should be a string in the ISO 8601
	// date format, for example 2013-03-20T17:03:43Z .
	EndDate *string

	// Specifies the maximum number of inventory items returned per vault inventory
	// retrieval request. Valid values are greater than or equal to 1.
	Limit *string

	// An opaque string that represents where to continue pagination of the vault
	// inventory retrieval results. You use the marker in a new InitiateJob request to
	// obtain additional inventory items. If there are no more inventory items, this
	// value is null .
	Marker *string

	// The start of the date range in UTC for vault inventory retrieval that includes
	// archives created on or after this date. This value should be a string in the ISO
	// 8601 date format, for example 2013-03-20T17:03:43Z .
	StartDate *string

	noSmithyDocumentSerde
}

// Provides options for defining a job.
type JobParameters struct {

	// The ID of the archive that you want to retrieve. This field is required only if
	// Type is set to select or archive-retrieval code>. An error occurs if you specify
	// this request parameter for an inventory retrieval job request.
	ArchiveId *string

	// The optional description for the job. The description must be less than or
	// equal to 1,024 bytes. The allowable characters are 7-bit ASCII without control
	// codes-specifically, ASCII values 32-126 decimal or 0x20-0x7E hexadecimal.
	Description *string

	// When initiating a job to retrieve a vault inventory, you can optionally add
	// this parameter to your request to specify the output format. If you are
	// initiating an inventory job and do not specify a Format field, JSON is the
	// default format. Valid values are "CSV" and "JSON".
	Format *string

	// Input parameters used for range inventory retrieval.
	InventoryRetrievalParameters *InventoryRetrievalJobInput

	// Contains information about the location where the select job results are stored.
	OutputLocation *OutputLocation

	// The byte range to retrieve for an archive retrieval. in the form
	// "StartByteValue-EndByteValue" If not specified, the whole archive is retrieved.
	// If specified, the byte range must be megabyte (1024*1024) aligned which means
	// that StartByteValue must be divisible by 1 MB and EndByteValue plus 1 must be
	// divisible by 1 MB or be the end of the archive specified as the archive byte
	// size value minus 1. If RetrievalByteRange is not megabyte aligned, this
	// operation returns a 400 response.
	//
	// An error occurs if you specify this field for an inventory retrieval job
	// request.
	RetrievalByteRange *string

	// The Amazon SNS topic ARN to which Amazon S3 Glacier sends a notification when
	// the job is completed and the output is ready for you to download. The specified
	// topic publishes the notification to its subscribers. The SNS topic must exist.
	SNSTopic *string

	// Contains the parameters that define a job.
	SelectParameters *SelectParameters

	// The tier to use for a select or an archive retrieval job. Valid values are
	// Expedited , Standard , or Bulk . Standard is the default.
	Tier *string

	// The job type. You can initiate a job to perform a select query on an archive,
	// retrieve an archive, or get an inventory of a vault. Valid values are "select",
	// "archive-retrieval" and "inventory-retrieval".
	Type *string

	noSmithyDocumentSerde
}

// Contains information about the location where the select job results are stored.
type OutputLocation struct {

	// Describes an S3 location that will receive the results of the job request.
	S3 *S3Location

	noSmithyDocumentSerde
}

// Describes how the select output is serialized.
type OutputSerialization struct {

	// Describes the serialization of CSV-encoded query results.
	Csv *CSVOutput

	noSmithyDocumentSerde
}

// A list of the part sizes of the multipart upload.
type PartListElement struct {

	// The byte range of a part, inclusive of the upper value of the range.
	RangeInBytes *string

	// The SHA256 tree hash value that Amazon S3 Glacier calculated for the part. This
	// field is never null .
	SHA256TreeHash *string

	noSmithyDocumentSerde
}

// The definition for a provisioned capacity unit.
type ProvisionedCapacityDescription struct {

	// The ID that identifies the provisioned capacity unit.
	CapacityId *string

	// The date that the provisioned capacity unit expires, in Universal Coordinated
	// Time (UTC).
	ExpirationDate *string

	// The date that the provisioned capacity unit was purchased, in Universal
	// Coordinated Time (UTC).
	StartDate *string

	noSmithyDocumentSerde
}

// Contains information about the location in Amazon S3 where the select job
// results are stored.
type S3Location struct {

	// A list of grants that control access to the staged results.
	AccessControlList []Grant

	// The name of the Amazon S3 bucket where the job results are stored.
	BucketName *string

	// The canned access control list (ACL) to apply to the job results.
	CannedACL CannedACL

	// Contains information about the encryption used to store the job results in
	// Amazon S3.
	Encryption *Encryption

	// The prefix that is prepended to the results for this request.
	Prefix *string

	// The storage class used to store the job results.
	StorageClass StorageClass

	// The tag-set that is applied to the job results.
	Tagging map[string]string

	// A map of metadata to store with the job results in Amazon S3.
	UserMetadata map[string]string

	noSmithyDocumentSerde
}

// Contains information about the parameters used for a select.
type SelectParameters struct {

	// The expression that is used to select the object.
	Expression *string

	// The type of the provided expression, for example SQL .
	ExpressionType ExpressionType

	// Describes the serialization format of the object.
	InputSerialization *InputSerialization

	// Describes how the results of the select job are serialized.
	OutputSerialization *OutputSerialization

	noSmithyDocumentSerde
}

// A list of in-progress multipart uploads for a vault.
type UploadListElement struct {

	// The description of the archive that was specified in the Initiate Multipart
	// Upload request.
	ArchiveDescription *string

	// The UTC time at which the multipart upload was initiated.
	CreationDate *string

	// The ID of a multipart upload.
	MultipartUploadId *string

	// The part size, in bytes, specified in the Initiate Multipart Upload request.
	// This is the size of all the parts in the upload except the last part, which may
	// be smaller than this size.
	PartSizeInBytes int64

	// The Amazon Resource Name (ARN) of the vault that contains the archive.
	VaultARN *string

	noSmithyDocumentSerde
}

// Contains the vault access policy.
type VaultAccessPolicy struct {

	// The vault access policy.
	Policy *string

	noSmithyDocumentSerde
}

// Contains the vault lock policy.
type VaultLockPolicy struct {

	// The vault lock policy.
	Policy *string

	noSmithyDocumentSerde
}

// Represents a vault's notification configuration.
type VaultNotificationConfig struct {

	// A list of one or more events for which Amazon S3 Glacier will send a
	// notification to the specified Amazon SNS topic.
	Events []string

	// The Amazon Simple Notification Service (Amazon SNS) topic Amazon Resource Name
	// (ARN).
	SNSTopic *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
